<!-- Action Sheet -->
<div id="custom_bg"
    class="z-50 fixed sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto bottom-0 left-0 right-0 shadow-lg transform translate-y-full transition-transform duration-300 rounded-t-2xl"
    :class="{ 'translate-y-full': !showQRCode, 'translate-y-0': showQRCode }">
    <div class="p-4">
        <div class="flex justify-between">
            <h3 class="text-lg font-bold text-slate-800 dark:text-slate-300 flex items-center">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M3.75 4.875c0-.621.504-1.125 1.125-1.125h4.5c.621 0 1.125.504 1.125 1.125v4.5c0 .621-.504 1.125-1.125 1.125h-4.5A1.125 1.125 0 0 1 3.75 9.375v-4.5ZM3.75 14.625c0-.621.504-1.125 1.125-1.125h4.5c.621 0 1.125.504 1.125 1.125v4.5c0 .621-.504 1.125-1.125 1.125h-4.5a1.125 1.125 0 0 1-1.125-1.125v-4.5ZM13.5 4.875c0-.621.504-1.125 1.125-1.125h4.5c.621 0 1.125.504 1.125 1.125v4.5c0 .621-.504 1.125-1.125 1.125h-4.5A1.125 1.125 0 0 1 13.5 9.375v-4.5Z" />
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M6.75 6.75h.75v.75h-.75v-.75ZM6.75 16.5h.75v.75h-.75v-.75ZM16.5 6.75h.75v.75h-.75v-.75ZM13.5 13.5h.75v.75h-.75v-.75ZM13.5 19.5h.75v.75h-.75v-.75ZM19.5 13.5h.75v.75h-.75v-.75ZM19.5 19.5h.75v.75h-.75v-.75ZM16.5 16.5h.75v.75h-.75v-.75Z" />
                </svg>&nbsp;&nbsp;
                Scan QR Code
            </h3>

            <button @click="showQRCode=!showQRCode" class="text-gray-500">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>

        <!-- Alpine Component -->
        <div x-data="{
            link: '<?php echo e($current_url); ?>',
            showToast: false,
            async copyLink() {
                try {
                    if (!navigator?.clipboard?.writeText) {
                        console.error('Clipboard API not available');
                        return;
                    }
                    await navigator.clipboard.writeText(this.link);
                    this.showToast = true;
                    setTimeout(() => this.showToast = false, 2000);
                } catch (e) {
                    console.error('Copy failed:', e);
                }
            }
        }" class="mt-4 space-y-3">

            <p class="mt-4 text-base text-slate-800 dark:text-slate-300 text-center">
                Share this link with others to showcase your digital business card.
            </p>

            <div class="qr-code flex justify-center mt-5 mx-auto" style="width: 80% !important;">
                <?php echo QrCode::format('svg')->generate($current_url); ?>

            </div>

            <div class="w-10/12 mx-auto">
                <h2 class="text-xl font-semibold tracking-tight text-center">
                    Scan or Copy Card Link
                </h2>

                <div class="mt-6 max-w-md gap-x-4">
                    <h3 class="text-base text-center cursor-pointer"
                        style="color: <?php echo e($color_settings_link); ?> !important;" @click="copyLink()">
                        <?php echo e('@' . $username); ?>

                    </h3>

                    <button type="button"
                        style="color: <?php echo e($color_settings_custom_button_text); ?> !important; background-color: <?php echo e($color_settings_custom_button); ?> !important;"
                        @click="copyLink()"
                        class="mt-5 flex mx-auto rounded-md px-3.5 py-2.5 text-sm font-semibold shadow-xs">
                        <?php if (isset($component)) { $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c = $attributes; } ?>
<?php $component = BladeUI\Icons\Components\Svg::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('fas-copy'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\BladeUI\Icons\Components\Svg::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-4']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $attributes = $__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__attributesOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c)): ?>
<?php $component = $__componentOriginal643fe1b47aec0b76658e1a0200b34b2c; ?>
<?php unset($__componentOriginal643fe1b47aec0b76658e1a0200b34b2c); ?>
<?php endif; ?>&nbsp;&nbsp;Copy Link
                    </button>
                </div>
            </div>

            <div x-show="showToast" x-transition:enter="transition transform ease-out duration-300"
                x-transition:enter-start="opacity-0 translate-y-2" x-transition:enter-end="opacity-100 translate-y-0"
                x-transition:leave="transition transform ease-in duration-200"
                x-transition:leave-start="opacity-100 translate-y-0" x-transition:leave-end="opacity-0 translate-y-2"
                class="fixed bottom-20 left-1/2 transform -translate-x-1/2 bg-green-500 text-white text-sm font-semibold px-4 py-2 rounded-md shadow-lg">
                Copied to clipboard.
            </div>

        </div>

    </div>
</div>
<?php /**PATH /Users/giojitsu_mma/Documents/Sites/10kcards.site/resources/views/components/qr-code-modal.blade.php ENDPATH**/ ?>