<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="description" content="<?php echo e(isset($bio) ? $bio : ''); ?>">

    <!-- Open Graph -->
    <meta property="og:title" content="<?php echo e($title); ?>" />
    <meta property="og:description" content="<?php echo e(isset($bio) ? $bio : ''); ?>" />
    <meta property="og:image"
        content="<?php echo e(isset($favicon) ? url($favicon) : (isset($thumbnail) ? url($thumbnail) : '')); ?>" />
    <meta property="og:image:width" content="1200" />
    <meta property="og:image:height" content="630" />
    <meta property="og:url"
        content="<?php echo e(isset($site_url) && isset($username) ? $site_url . $username : url()->current()); ?>" />
    <meta property="og:type" content="website" />

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="<?php echo e($title); ?>" />
    <meta name="twitter:description" content="<?php echo e(isset($bio) ? $bio : ''); ?>" />
    <meta name="twitter:image"
        content="<?php echo e(isset($favicon) ? url($favicon) : (isset($thumbnail) ? url($thumbnail) : '')); ?>" />

    <meta name="keywords" content="digital business card, video business card, business card">
    <meta name="robots" content="index, follow">
    <title><?php echo e($title); ?></title>
    <link rel="icon" type="image/x-icon"
        href="<?php echo e(isset($favicon) ? asset($favicon) . '?w=300&q=70' : asset($thumbnail) . '?w=300&q=70'); ?>">
    <link rel="apple-touch-icon" sizes="180x180"
        href="<?php echo e(isset($favicon) ? asset($favicon) . '?w=300&q=70' : asset($thumbnail) . '?w=300&q=70'); ?>">
    <link rel="apple-touch-icon" sizes="120x120"
        href="<?php echo e(isset($favicon) ? asset($favicon) . '?w=300&q=70' : asset($thumbnail) . '?w=300&q=70'); ?>">
    <link rel="apple-touch-icon" sizes="152x152"
        href="<?php echo e(isset($favicon) ? asset($favicon) . '?w=300&q=70' : asset($thumbnail) . '?w=300&q=70'); ?>">


    
    
    
    <meta name="mobile-web-app-capable" content="yes">

    

    
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    
    <!-- Add Cropper.js CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.6.2/cropper.css">
    <link href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" rel="stylesheet" />

    <link href="https://unpkg.com/filepond/dist/filepond.min.css" rel="stylesheet">
    <link href="https://unpkg.com/filepond-plugin-image-preview/dist/filepond-plugin-image-preview.min.css"
        rel="stylesheet">

    <?php echo app('Illuminate\Foundation\Vite')('resources/css/app.css'); ?>
    <style>
        iframe[src*="tiktok.com"] {
            width: 100% !important;
            height: 100% !important;
            max-width: none !important;
            min-width: 0 !important;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-fadeIn {
            animation: fadeIn 0.3s ease-in-out;
        }

        [x-cloak] {
            display: none !important;
        }

        /* #empty-cart {
            display: none !important;
        } */

        /* Circle button look (when closed) */
        #languageSwitcher {
            font-size: 1.2rem;
            padding: 0;
            appearance: none;
            overflow: hidden;
            -webkit-appearance: none;
            /* Safari */
            -moz-appearance: none;
        }

        /* When dropdown opens → expand for text */
        #languageSwitcher:focus {
            width: auto;
            padding: 0.4rem 1rem;
        }

        /* Safari only */
        @supports (-webkit-touch-callout: none) and (not (translate: none)) {
            #languageButton {
                padding: 0.5rem;
            }
        }

        /* Chrome / Chromium (and most non-Safari browsers) */
        @supports (-webkit-appearance: none) and (not (-webkit-touch-callout: none)) {
            #languageButton {
                padding-left: 0.625rem;
                padding-right: 0.625rem;
                padding-top: 0.4rem;
                padding-bottom: 0.4rem;
            }
        }

        body>.skiptranslate {
            display: none;
        }

        /* Hide Google Translate tooltip UIs */
        #goog-gt-tt,
        .goog-te-balloon-frame,
        .goog-te-banner-frame {
            display: none !important;
        }

        body {
            top: 0 !important;
        }

        /* New Chrome/Translate UI uses obfuscated classes starting with VIpgJd- */
        div[class^="VIpgJd-"],
        div[class*=" VIpgJd-"] {
            /* the actual popup container is a DIV */
            display: none !important;
        }

        /* Remove highlight underline/box on translated text */
        .goog-text-highlight {
            background: none !important;
            box-shadow: none !important;
            border: 0 !important;
        }

        /* Kill Google Translate hover highlight background */
        span[class^="VIpgJd-"],
        span[class*=" VIpgJd-"] {
            background: none !important;
            color: inherit !important;
            box-shadow: none !important;
            border: none !important;
            cursor: inherit !important;
        }

        /* body {
            top: 0px !important;
        } */

        /* Background Color Settings */
        <?php if(isset($color_settings_card_light)): ?>
            @media (prefers-color-scheme: light) {
                #custom_bg {
                    background-color: <?php echo e($color_settings_card_light); ?> !important;
                }
            }
        <?php endif; ?>

        <?php if(isset($color_settings_card_dark)): ?>
            @media (prefers-color-scheme: dark) {
                #custom_bg {
                    background-color: <?php echo e($color_settings_card_dark); ?> !important;
                }
            }
        <?php endif; ?>

        /* Text Color Settings */
        <?php if(isset($color_settings_text_light)): ?>
            @media (prefers-color-scheme: light) {
                #custom_bg {
                    color: <?php echo e($color_settings_text_light); ?> !important;
                }

                #driving_direction_modal {
                    color: <?php echo e($color_settings_text_light); ?> !important;
                }
            }
        <?php endif; ?>

        <?php if(isset($color_settings_text_dark)): ?>
            @media (prefers-color-scheme: dark) {
                #custom_bg {
                    color: <?php echo e($color_settings_text_dark); ?> !important;
                }

                #driving_direction_modal {
                    color: <?php echo e($color_settings_text_dark); ?> !important;
                }
            }
        <?php endif; ?>

        <?php if(isset($color_settings_profile_pic_border)): ?>
            .swiper-pagination-bullet-active {
                background-color: <?php echo e($color_settings_profile_pic_border); ?> !important;
            }

            /* .swiper-pagination-bullet {
                background: #fff !important;
            } */
        <?php endif; ?>

        /* .profile .cropper-crop-box,
        .profile .cropper-view-box {
            border-radius: 50% !important;
            ;
        } */

        .cropper-view-box {
            box-shadow: 0 0 0 1px #39f;
            outline: 0;
        }

        .cropper-face {
            background-color: inherit !important;
        }

        .cropper-dashed,
        .cropper-point.point-se,
        .cropper-point.point-sw,
        .cropper-point.point-nw,
        .cropper-point.point-ne,
        .cropper-line {
            display: none !important;
        }

        .cropper-view-box {
            outline: inherit !important;
        }
    </style>
</head>

<body class="bg-slate-200 dark:bg-zinc-950" x-data="{
    addButton: false,
    actionSheet: false,
    addSocial: false,
    social_soundcloud: false,
    social_apple_podcasts: false,
    social_spotify: false,
    social_discord: false,
    social_skool: false,
    social_clubhouse: false,
    social_fanbase: false,
    social_snapchat: false,
    social_pinterest: false,
    social_linkedin: false,
    social_facebook: false,
    social_x: false,
    social_instagram: false,
    social_tiktok: false,
    social_youtube: false,
    social_threads: false,
    button_link: false,
    button_podcast: false,
    button_vcf: false,
    button_help: false,
    button_exchange: false,
    button_feedback: false,
    button_bio: false,
    button_shop: false,
    button_services: false,
    button_events: false,
    button_sales: false,
    button_team: false,
    button_driving: false,
    button_zoom_replay: false,
    button_reviews: false,
    button_community: false,
    button_email: false,
    button_phone: false,
    button_sms: false,
    button_whatsapp: false,
    button_zalo: false,
    button_wechat: false,
    button_amazon_shop: false,
    button_telegram: false,
    button_zoom: false,
    button_cashapp: false,
    button_payment_other: false,
    button_chime: false,
    button_square: false,
    button_paypal_link: false,
    button_paypal_email: false,
    button_credit: false,
    button_zelle: false,
    button_apple_pay: false,
    button_venmo: false,

    button_google_map: false,
    button_apple_map: false,
    button_waze: false,
    button_trusted_network: false,
    button_payments: false,
    button_form: false,
    selected_button: '',
    selected_social: '',
    editSocial: false,
    editButton: false,
    openUploadModal: false,
    openUploadThumbnailModal: false,
    openUploadCoverModal: false,
    openProductUploadModal: false,
    openGalleryUploadModal: false,
    openEventUploadModal: false,
    openPhysicalCardUploadModal: false,
    openPhysicalCardBackUploadModal: false,
    openSalesImageUploadModal: false,
    openVideoThumbnailUploadModal: false,
    openServiceUploadModal: false,
    openRegisterUploadPicModal: false,
    openAdUploadModal: false,
    openProductCollectionBanner: false,
    showQRCode: false,
    openPaymentLinkModal: false,
    openDrivingDirectionModal: false,
    openCommunitiesModal: false,
    showSwitchActiveCardModal: false,
    showFeedbackModal: false,
    showRequestAddTrustedNetworkModal: false,
    showRequestAddTrustedNetworkModalLoggedOut: false,
    showProfilePicLayoutModal: false,
    showCopyReferCodeModal: false,
    showColorPicker: false,
    payment_value: '',
    selected_color_setting: '',
    color_settings_custom_button: false,
    color_settings_custom_button_text: false,
    color_settings_link: false,
    color_settings_profile_pic_border: false,
    color_settings_card_light: false,
    color_settings_card_dark: false,
    color_settings_text_light: false,
    color_settings_text_dark: false,
}">

    

    <?php if(session()->has('error')): ?>
        <div class="p-4 mb-4 text-sm text-white text-center rounded bg-red-500">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>

    <?php if(session()->has('success')): ?>
        <div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 5000)" x-transition
            class="p-4 mb-4 text-sm text-white text-center rounded bg-green-500">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <?php if(session()->has('info')): ?>
        <div x-data="{ show: true }" x-show="show" x-init="setTimeout(() => show = false, 5000)" x-transition
            class="p-4 mb-4 text-sm text-white text-center rounded bg-yellow-500">
            <?php echo e(session('info')); ?>

        </div>
    <?php endif; ?>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openUploadThumbnailModal }" @click="openUploadThumbnailModal=!openUploadThumbnailModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openUploadCoverModal }" @click="openUploadCoverModal=!openUploadCoverModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openRegisterUploadPicModal }"
        @click="openRegisterUploadPicModal=!openRegisterUploadPicModal">
    </div>

    <!-- Overlay (Initially hidden) -->
    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openUploadModal }" @click="openUploadModal=!openUploadModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openProductUploadModal }" @click="openProductUploadModal=!openProductUploadModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openGalleryUploadModal }" @click="openGalleryUploadModal=!openGalleryUploadModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openVideoThumbnailUploadModal }"
        @click="openVideoThumbnailUploadModal=!openVideoThumbnailUploadModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openEventUploadModal }" @click="openEventUploadModal=!openEventUploadModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openPhysicalCardUploadModal }"
        @click="openPhysicalCardUploadModal=!openPhysicalCardUploadModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openPhysicalCardBackUploadModal }"
        @click="openPhysicalCardBackUploadModal=!openPhysicalCardBackUploadModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openSalesImageUploadModal }"
        @click="openSalesImageUploadModal=!openSalesImageUploadModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openServiceUploadModal }" @click="openServiceUploadModal=!openServiceUploadModal">
    </div>

    
    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openAdUploadModal }" @click="openAdUploadModal=!openAdUploadModal">
    </div>

    
    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openProductCollectionBanner }"
        @click="openProductCollectionBanner=!openProductCollectionBanner">
    </div>

    
    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !showQRCode }" @click="showQRCode=!showQRCode">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !actionSheet }" @click="actionSheet=!actionSheet">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !editButton }"
        @click="editButton=!editButton;button_link=false;button_podcast=false;button_community=false;button_email=false;button_phone=false;button_sms=false;button_whatsapp=false;button_zalo=false;button_wechat=false;button_amazon_shop=false;button_telegram=false;button_zoom=false;button_cashapp=false;button_payment_other=false;button_chime=false;button_square=false;button_paypal_link=false;button_paypal_email=false;button_credit=false;button_zelle=false;button_apple_pay=false;button_venmo=false;button_vcf=false;button_help=false;button_exchange=false;button_feedback=false;button_bio=false;button_shop=false;button_services=false;button_events=false;button_sales=false;button_team=false;button_waze=false;button_apple_map=false;button_google_map=false;button_driving=false;button_zoom_replay=false;button_reviews=false;button_trusted_network=false;button_payments=false;button_form=false;">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !editSocial }"
        @click="editSocial=!editSocial;social_linkedin=false;social_facebook=false;social_x=false;social_instagram=false;social_tiktok=false;social_youtube=false;social_threads=false;social_clubhouse=false;social_snapchat=false;social_fanbase=false;social_pinterest=false;social_soundcloud=false;social_apple_podcasts=false;social_spotify=false;social_discord=false;social_skool=false;">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden" :class="{ 'hidden': !addButton }"
        @click="addButton=!addButton;button_link=false;button_podcast=false;button_community=false;button_email=false;button_phone=false;button_sms=false;button_whatsapp=false;button_zalo=false;button_wechat=false;button_amazon_shop=false;button_telegram=false;button_zoom=false;button_cashapp=false;button_payment_other=false;button_chime=false;button_square=false;button_paypal_link=false;button_paypal_email=false;button_credit=false;button_zelle=false;button_apple_pay=false;button_venmo=false;button_waze=false;button_apple_map=false;button_google_map=false;">
    </div>

    <div id="overlayaddSocial" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !addSocial }"
        @click="addSocial=!addSocial;social_linkedin=false;social_facebook=false;social_x=false;social_instagram=false;social_tiktok=false;social_youtube=false;social_threads=false;social_clubhouse=false;social_snapchat=false;social_fanbase=false;social_pinterest=false;social_soundcloud=false;social_apple_podcasts=false;social_spotify=false;social_discord=false;social_skool=false;">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openPaymentLinkModal }"
        @click="openPaymentLinkModal=!openPaymentLinkModal;button_zelle=false;button_paypal_email=false;button_apple_pay=false;payment_value=''"">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openDrivingDirectionModal }"
        @click="openDrivingDirectionModal=!openDrivingDirectionModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !openCommunitiesModal }" @click="openCommunitiesModal=!openCommunitiesModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !showSwitchActiveCardModal }"
        @click="showSwitchActiveCardModal=!showSwitchActiveCardModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !showFeedbackModal }" @click="showFeedbackModal=!showFeedbackModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !showRequestAddTrustedNetworkModal }"
        @click="showRequestAddTrustedNetworkModal=!showRequestAddTrustedNetworkModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !showRequestAddTrustedNetworkModalLoggedOut }"
        @click="showRequestAddTrustedNetworkModalLoggedOut=!showRequestAddTrustedNetworkModalLoggedOut">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !showProfilePicLayoutModal }"
        @click="showProfilePicLayoutModal=!showProfilePicLayoutModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !showCopyReferCodeModal }" @click="showCopyReferCodeModal=!showCopyReferCodeModal">
    </div>

    <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden"
        :class="{ 'hidden': !showColorPicker }"
        @click="showColorPicker=!showColorPicker;selected_color_setting='';color_settings_custom_button=false;color_settings_custom_button_text=false;color_settings_link=false;color_settings_profile_pic_border=false;color_settings_card_light=false;color_settings_card_dark=false;color_settings_text_light=false;color_settings_text_dark=false;">
    </div>

    <?php echo e($slot); ?>


    <?php if(auth()->guard()->check()): ?>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('driving-direction-modal', ['username' => ''.e(auth()->user()->username).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('footer', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('upload-image-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-2', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('upload-product-collection-banner-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-3', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('upload-ad-image-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-4', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('upload-product-image-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-5', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('upload-gallery-image-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-6', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('upload-event-image-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-7', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('upload-sales-image-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-8', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('upload-video-thumbnail-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-9', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('upload-service-image-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-10', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('thumbnail-image-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-11', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('cover-image-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-12', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('profile-picture-layout', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-13', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('action-sheet', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-14', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('feedback-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-15', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('copy-refer-code-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-16', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('social-action-sheet', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-17', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('social-edit', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-18', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

        
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('button-action-sheet', ['routeName' => Route::currentRouteName()]);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-19', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('button-edit-action-sheet', ['routeName' => Route::currentRouteName()]);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-20', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

    <?php endif; ?>

    
    <?php if(isset($username)): ?>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('add-to-trusted-network-logged-out', ['username' => ''.e($username).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-21', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('payment-link-view-modal', ['username' => ''.e($username).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-22', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    <?php endif; ?>

    <?php if(isset($username) && auth()->user()): ?>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('request-add-to-trusted-network', ['username' => ''.e($username).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-23', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    <?php endif; ?>

    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('register-profile-picture', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-24', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('upload-physical-card-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-25', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('upload-physical-card-back-modal', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-26', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>

    <?php if(isset($username)): ?>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('qr-code-modal', ['username' => ''.e($username).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-27', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('driving-direction-modal', ['username' => ''.e($username).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-28', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('communities-view-modal', ['username' => ''.e($username).'']);

$__html = app('livewire')->mount($__name, $__params, 'lw-3958545262-29', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    <?php endif; ?>

    
    

    <!-- Livewire Scripts -->
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scriptConfig(); ?>

    

    <!-- Hidden Google Translate element (required for widget to work) -->
    <div id="google_translate_element" class="sr-only"></div>

    <script type="text/javascript">
        function googleTranslateElementInit() {
            new google.translate.TranslateElement({
                pageLanguage: 'en',
                includedLanguages: 'en,es,tr,fr,ar,he,iw', // added iw for Hebrew compatibility
                autoDisplay: false
            }, 'google_translate_element');
        }

        function setTranslateCookie(lang) {
            const gLang = (lang === 'he') ? 'iw' : lang; // map 'he' to 'iw' for Google
            const val = `/en/${gLang}`;
            const exp = new Date(Date.now() + 365 * 24 * 60 * 60 * 1000).toUTCString();
            document.cookie = `googtrans=${val};expires=${exp};path=/`;
            if (location.hostname.includes('.')) {
                document.cookie = `googtrans=${val};expires=${exp};path=/;domain=.${location.hostname}`;
            }
        }

        function clearTranslateCookie() {
            document.cookie = "googtrans=;expires=Thu, 01 Jan 1970 00:00:00 UTC;path=/";
            if (location.hostname.includes('.')) {
                document.cookie = `googtrans=;expires=Thu, 01 Jan 1970 00:00:00 UTC;path=/;domain=.${location.hostname}`;
            }
        }

        function applyLang(lang) {
            const sel = document.querySelector('select.goog-te-combo');
            if (sel && sel.value !== lang) {
                sel.value = lang;
                sel.dispatchEvent(new Event('change'));
            }
        }

        function applyLangWithRetry(lang, attempt = 0) {
            if (attempt > 10) return;
            const sel = document.querySelector('select.goog-te-combo');
            if (sel) {
                applyLang(lang);
            } else {
                setTimeout(() => applyLangWithRetry(lang, attempt + 1), 200);
            }
        }

        function translateTo(lang) {
            localStorage.setItem("<?php echo e($app_name); ?>_preferredLang", lang);
            if (lang === 'en') {
                clearTranslateCookie();
                document.documentElement.setAttribute('dir', 'ltr');
            } else {
                setTranslateCookie(lang);

                // Force RTL for Hebrew & Arabic
                /* if (['he', 'iw', 'ar'].includes(lang)) {
                    document.documentElement.setAttribute('dir', 'rtl');
                } else {
                    document.documentElement.setAttribute('dir', 'ltr');
                } */
            }
            applyLangWithRetry(lang);
        }

        document.addEventListener("DOMContentLoaded", () => {
            const button = document.getElementById("languageButton");
            const modal = document.getElementById("languageModal");
            const closeModal = document.getElementById("closeModal");

            // Load saved language
            let lang = localStorage.getItem("<?php echo e($app_name); ?>_preferredLang") || "en";
            translateTo(lang);

            // Open modal
            button.addEventListener("click", () => {
                modal.classList.remove("hidden");
            });

            // Close modal
            closeModal.addEventListener("click", () => {
                modal.classList.add("hidden");
            });

            // Select language
            document.querySelectorAll(".lang-option").forEach(opt => {
                opt.addEventListener("click", () => {
                    const lang = opt.dataset.lang;
                    translateTo(lang);
                    localStorage.setItem("<?php echo e($app_name); ?>_preferredLang", lang);
                    modal.classList.add("hidden");
                    location.reload();
                });
            });
        });
    </script>

    <script src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit" async defer></script>

    <script>
        (() => {
            // Clean up Google Translate wrapper spans
            const unwrapTranslateSpans = (root = document) => {
                const spans = root.querySelectorAll('span[class^="VIpgJd-"], span[class*=" VIpgJd-"]');
                spans.forEach(el => {
                    const parent = el.parentNode;
                    if (!parent) return;
                    while (el.firstChild) parent.insertBefore(el.firstChild, el);
                    parent.removeChild(el);
                });
                root.querySelectorAll('[title]').forEach(el => {
                    if (!/\bgoog\b/i.test(el.className)) el.removeAttribute('title');
                });
            };

            document.addEventListener('DOMContentLoaded', () => {
                unwrapTranslateSpans();

                const mo = new MutationObserver(muts => {
                    for (const m of muts) {
                        if (m.addedNodes && m.addedNodes.length) {
                            m.addedNodes.forEach(n => n.nodeType === 1 && unwrapTranslateSpans(n));
                        }
                        if (m.type === 'attributes' && m.attributeName === 'class')
                            unwrapTranslateSpans(m.target);
                    }
                });
                mo.observe(document.documentElement, {
                    childList: true,
                    subtree: true,
                    attributes: true,
                    attributeFilter: ['class']
                });

                const waitSel = setInterval(() => {
                    const sel = document.querySelector('select.goog-te-combo');
                    if (sel) {
                        sel.addEventListener('change', () => setTimeout(unwrapTranslateSpans, 300));
                        clearInterval(waitSel);
                    }
                }, 200);
            });
        })();
    </script>

    
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.6.2/cropper.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js" defer></script>

    <script src="https://cdn.jsdelivr.net/npm/heic2any@0.0.3/dist/heic2any.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/@jaames/iro@5"></script>
    <script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>

    <script src="<?php echo e(asset('js/custom-icon.js')); ?>"></script>
    <script src="<?php echo e(asset('js/cart.js')); ?>" defer></script>

    <?php echo app('Illuminate\Foundation\Vite')('resources/js/app.js'); ?>
    
    
    
    
    <?php echo $__env->yieldPushContent('scripts'); ?>

    <script>
        function multiSelect({
            options,
            selected
        }) {
            return {
                open: false,
                options,
                selected,

                get selectedItems() {
                    return this.options.filter(o => this.selected.includes(o.id))
                },

                toggle() {
                    this.open = !this.open
                },

                close() {
                    this.open = false
                },

                toggleItem(id) {
                    if (this.selected.includes(id)) {
                        this.selected = this.selected.filter(i => i !== id)
                    } else {
                        this.selected.push(id)
                    }
                },

                remove(id) {
                    this.selected = this.selected.filter(i => i !== id)
                },
            }
        }
    </script>

    <!-- FIREBASE COMPAT LIBRARIES -->
    <script src="https://www.gstatic.com/firebasejs/10.9.0/firebase-app-compat.js"></script>
    <script src="https://www.gstatic.com/firebasejs/10.9.0/firebase-messaging-compat.js"></script>

    <?php
        $activeSubCard = null;

        if (auth()->check()) {
            $activeSubCard = \App\Models\SubCard::where('user_id', auth()->id())
                ->where('active_card', true)
                ->first();
        }
    ?>

    <?php
        $isLoggedIn = auth()->check();
        $activeSubCardId = $activeSubCard ? $activeSubCard->id : null;
        $userId = auth()->check() ? auth()->id() : null;
    ?>

    <script>
        document.addEventListener('DOMContentLoaded', async () => {
            const toggle = document.getElementById('pushToggle');
            const knob = document.getElementById('pushKnob');

            const IS_LOGGED_IN = <?php echo json_encode($isLoggedIn, 15, 512) ?>;
            const VAPID_PUBLIC_KEY = <?php echo json_encode(env('VAPID_PUBLIC_KEY'), 15, 512) ?>;
            const APP_PAGE_ID = <?php echo json_encode($activeSubCardId, 15, 512) ?>;
            const APP_USER_ID = <?php echo json_encode($activeSubCardId ? null : $userId, 15, 512) ?>;

            function setOn() {
                toggle.classList.remove('bg-gray-200');
                toggle.classList.add('bg-green-400');
                knob.classList.remove('translate-x-0');
                knob.classList.add('translate-x-3.5');
            }

            function setOff() {
                toggle.classList.remove('bg-green-400');
                toggle.classList.add('bg-gray-200');
                knob.classList.remove('translate-x-3.5');
                knob.classList.add('translate-x-0');
            }

            if (Notification.permission === "granted") setOn();

            toggle.addEventListener('click', async () => {
                if (!IS_LOGGED_IN) {
                    alert("Please login to enable notifications");
                    return;
                }

                if (Notification.permission !== "granted") {
                    const permission = await Notification.requestPermission();
                    if (permission !== "granted") {
                        alert("Notifications denied");
                        return;
                    }
                }

                const registration = await navigator.serviceWorker.register("/service-worker.js");
                let subscription = await registration.pushManager.getSubscription();

                if (!subscription) {
                    subscription = await registration.pushManager.subscribe({
                        userVisibleOnly: true,
                        applicationServerKey: VAPID_PUBLIC_KEY
                    });

                    Livewire.emit('saveSubscription', {
                        subscription: subscription.toJSON(),
                        user_id: APP_USER_ID,
                        page_id: APP_PAGE_ID
                    });

                    setOn();
                    alert("✅ Notifications Enabled!");
                } else {
                    await subscription.unsubscribe();
                    Livewire.emit('deleteSubscription', {
                        endpoint: subscription.endpoint,
                        user_id: APP_USER_ID,
                        page_id: APP_PAGE_ID
                    });

                    setOff();
                    alert("❌ Notifications Disabled!");
                }
            });

            window.addEventListener('push-saved', () => console.log("Push subscription saved in DB"));
            window.addEventListener('push-deleted', () => console.log("Push subscription deleted from DB"));
        });
    </script>

</body>

</html>
<?php /**PATH /Users/giojitsu_mma/Documents/Sites/10kcards.site/resources/views/components/layouts/app.blade.php ENDPATH**/ ?>