<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\UpgradeCheckoutController;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use Illuminate\Http\Request;
use App\Settings\CardDefaultsSetting;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\SubCard;
use App\Models\UserFcmToken;

use App\Livewire\Dashboard;

use App\Livewire\ButtonPage;
use App\Livewire\AddButton;

use App\Livewire\SocialPage;
use App\Livewire\AddSocial;
use App\Livewire\Card;

use App\Livewire\DisplayProducts;
use App\Livewire\ProductInfoPage;

use App\Livewire\DisplayServices;
use App\Livewire\ServiceInfoPage;

use App\Livewire\Profile;
use App\Livewire\ProfileEdit;

use App\Livewire\ProductPage;
use App\Livewire\ProductEdit;
use App\Livewire\AddProduct;
use App\Livewire\AddProductImages;
use App\Livewire\EditProductImage;
use App\Livewire\AddProductVideos;
use App\Livewire\EditProductVideo;

use App\Livewire\ServicePage;
use App\Livewire\AddService;
use App\Livewire\ServiceEdit;

use App\Livewire\VideoPage;
use App\Livewire\AddVideo;
use App\Livewire\VideoEdit;

use App\Livewire\SettingsPage;
use App\Livewire\CardCustomization;
use App\Livewire\CustomizationPage;
use App\Livewire\ChangePassword;
use App\Livewire\VisibilityPage;

use App\Livewire\PaymentLinksPage;
use App\Livewire\AddPaymentLink;

use App\Livewire\ContactPointsPage;
use App\Livewire\AddContactPoint;

use App\Livewire\AddNewPage;

use App\Livewire\AnalyticsPage;

use App\Livewire\BioPage;

use App\Livewire\AllLinksPage;

//welcome page new
use App\Livewire\WelcomePage;

//Ads
use App\Livewire\AddAd;
use App\Livewire\AdPage;
use App\Livewire\AdEdit;

//network
use App\Livewire\AddNetworkManually;
use App\Livewire\NetworkPage;
use App\Livewire\ContactPageSubmitted;

//register
use App\Livewire\RegisterPage;
use App\Livewire\SearchCard;

//images
use App\Livewire\ImageManager;
use App\Livewire\AddImages;
use App\Livewire\ImageEdit;

//lets connect
use App\Livewire\LetsConnectForm;

//exchange contacts
use App\Livewire\ExchangeContact;

//Feedback form
use App\Livewire\FeedbackForm;

//customize colors
use App\Livewire\CustomizeColors;
use App\Livewire\ManageTheme;

//register new
use App\Livewire\RegisterNew;

//Email verification
use App\Livewire\EmailVerified;

//Card Plan
use App\Livewire\SelectCardPlan;
use App\Livewire\RegistrationSuccess;

//Subscription
use App\Livewire\SubscriptionPage;

//Upgrade Card
use App\Livewire\UpgradeCardPlan;

use App\Livewire\UpgradeSuccess;

use App\Livewire\AddPaymentMethod;
use App\Livewire\ReferralPage;
use App\Livewire\ReferredPageInfo;

use App\Livewire\ForgotPassword;
use App\Livewire\ResetPassword;

//events
use App\Livewire\EventPage;
use App\Livewire\AddEvent;
use App\Livewire\DisplayEvents;
use App\Livewire\EventInfoPage;
use App\Livewire\EventEdit;

//Sales Page
use App\Livewire\SalesPage;
use App\Livewire\AddSalesPage;
use App\Livewire\EditSalesPage;

use App\Livewire\AddSalesVideo;
use App\Livewire\EditSalesVideo;

use App\Livewire\AddSalesImage;
use App\Livewire\EditSalesImage;

use App\Livewire\DisplaySalesPage;
use App\Livewire\SalesPageContent;

use App\Livewire\CashCarry;
use App\Livewire\CashCarryVideo;

use App\Livewire\DirectionLinksPage;
use App\Livewire\AddDirectionLink;

use App\Livewire\CommunityLinksPage;
use App\Livewire\AddCommunityLink;
use App\Livewire\EditCommunityLink;
use App\Livewire\CommunitiesViewModal;
use App\Livewire\EditDirectionLink;
use App\Livewire\SalesPageCart;
use App\Livewire\SubscriptionCart;
use App\Livewire\MembersPage;

use App\Livewire\DisplayTeamPage;
use App\Livewire\AllTeamsPage;
use App\Livewire\AddNewTeam;
use App\Livewire\EditTeamPage;
use App\Livewire\SearchMember;

use App\Livewire\AddProductCategory;
use App\Livewire\EditProductCategory;

use App\Livewire\AddProductCollection;
use App\Livewire\EditProductCollection;
use App\Livewire\DisplayProductCollection;

use App\Livewire\PresentationPage;

use App\Livewire\SendCard;

use App\Livewire\PresentationPageDashboard;
use App\Livewire\AddPresentationPage;
use App\Livewire\EditPresentationPage;

use App\Livewire\ProductSubscriptionPage;
use App\Livewire\AddSubscriptionProduct;
use App\Livewire\EditSubscriptionProduct;

use App\Livewire\SubscriptionInfoPage;

use App\Livewire\EditFreeAds;
use App\Livewire\LayoutPage;
use App\Livewire\ProductCategoryPage;
use App\Livewire\ProductCollectionPage;

use App\Livewire\DisplayZoomReplays;
use App\Livewire\DisplayReviews;

use App\Livewire\DisplayTrustedNetwork;
use App\Livewire\ZoomReplaysPage;
use App\Livewire\AddZoomReplay;
use App\Livewire\EditZoomReplay;

use App\Livewire\AddReviewVideos;
use App\Livewire\TestimonialPage;
use App\Livewire\EditReviewVideo;

use App\Livewire\TrustedNetworkDashboard;
use App\Livewire\SearchTrustedNetwork;

use App\Livewire\UpgradeCheckoutManual;

use App\Livewire\PricingPage;
use App\Livewire\NotificationsPage;

use App\Livewire\PartnershipProgramSelection;
use App\Livewire\PartnershipCheckoutManual;
use App\Livewire\PartnershipDashboard;

use App\Livewire\PaymentPage;
use App\Livewire\NotificationSettingsPage;

use App\Livewire\FormPage;
use App\Livewire\FormDashboard;
use App\Livewire\FormCreatePage;
use App\Livewire\FormEditPage;
use App\Livewire\ViewFormSubmissionPage;
use App\Livewire\MoreVideosPage;

Route::get('/send-card', SendCard::class)->name('sendcard.show');
// -------------------- WELCOME --------------------
// Route::get('/', [AuthController::class, 'welcome'])->middleware('guest')->name('welcome');

// Route::get('/', WelcomePage::class)->name('welcome')->middleware('guest');

// Route::get('/', WelcomePage::class, function () {
//     $user = auth()->user();

//     if ($user && $user->is_admin) {
//         return redirect('/admin');
//     }

//     return redirect('/dashboard');
// })->name('welcome');


Route::get('/', function () {
    $user = auth()->user();

    if ($user) {
        if ($user->is_admin) {
            return redirect()->to('/admin');
        }

        // logged in but NOT admin
        return redirect()->to('/dashboard');
    }

    // normal users see WelcomePage
    return app()->call(WelcomePage::class);
})->name('welcome');

// -------------------- LOGIN --------------------
Route::get('/login', [AuthController::class, 'login'])->name('login')->middleware('guest');
// Route::get('/login?trusted-network={user_id}', [AuthController::class, 'trustednetwork'])->name('login.trustednetwork')->middleware('guest');
// Route::get('/login', [AuthController::class, 'trustednetwork'])
//     ->name('login.trustednetwork')
//     ->middleware('guest');
Route::post('/login', [AuthController::class, 'authenticate'])->name('login.authenticate')->middleware('guest');
Route::get('/forgot-password', ForgotPassword::class)->name('password.request')->middleware('guest');
// Show the reset password form
Route::get('/reset-password/{token}', ResetPassword::class)
    ->middleware('guest')
    ->name('password.reset');

// -------------------- LOGOUT --------------------
Route::post('/logout', [AuthController::class, 'logout'])->name('logout')->middleware('auth');

//incase someone put /logout on the url, redirect them to welcome page
Route::get('/logout', function () {
    return view('welcome');
});

Route::middleware(['auth'])->group(function () {
    Route::get('/notifications', NotificationsPage::class)
        ->name('notifications.index');
});

// -------------------- REGISTER --------------------
// Route::get('/register', RegisterPage::class)->name('register')->middleware('guest');
// Route::get('/register', RegisterNew::class)->name('register')->middleware('guest');

// -------------------- EMAIL VERIFICATION --------------------
Route::get('/email/verify', EmailVerified::class)->name('verification.notice')->middleware('auth');
// Route::get('/email/verify', function () {
//     return view('auth.verify-email');
// })->middleware('auth')->name('verification.notice');

// Route::get('/email/verify/{id}/{hash}', function (EmailVerificationRequest $request) {
//     $request->fulfill();
//     return redirect('/plan/select');
// })->middleware(['auth', 'signed'])->name('verification.verify');

Route::get('/email/verify/{id}/{hash}', function (EmailVerificationRequest $request) {
    $request->fulfill();

    // Update user_type if applicable
    $user = Auth::user();

    if ($user && $user->user_type !== 'Free') {
        $user->update(['user_type' => 'Free']);
    }

    return redirect('/dashboard');
})->middleware(['auth', 'signed'])->name('verification.verify');

Route::post('/email/verification-notification', function (Request $request) {
    $request->user()->sendEmailVerificationNotification();
    return back()->with('message', 'Verification link sent!');
})->middleware(['auth', 'throttle:6,1'])->name('verification.send');


// -------------------- AFFILIATE --------------------
Route::get('/register', RegisterNew::class)->name('register')->middleware('guest');
// Route::get('/register?trusted-network={user_id}', RegisterNew::class)->name('registertrustednetwork')->middleware('guest');
Route::get('/register?ref={username}', RegisterNew::class)->name('affiliate')->middleware('guest');
Route::get('/register?trusted-network={username}', RegisterNew::class)->name('trustednetwork.register')->middleware('guest');
// Route::get('/register?ref={username}', RegisterPage::class)->name('affiliate')->middleware('guest');

// -------------------- DASHBOARD --------------------
Route::get('/dashboard', Dashboard::class)->name('dashboard.index')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');

// Route::get('/dashboard/network', function () {
//     return view('pages.network');
// })->name('dashboard.network')->middleware('auth', CheckActiveUser::class);

// -------------------- SOCIALS  --------------------
Route::get('/dashboard/social', SocialPage::class)->name('dashboard.social')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
// Route::get('/social/add', AddSocial::class)->name('social.index')->middleware('auth', 'maintenance', 'is_admin', 'is_active');
Route::get('/social/add', AddSocial::class)->name('social.index')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');

// -------------------- BUTTONS  --------------------
Route::get('/dashboard/button', ButtonPage::class)->name('dashboard.button')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active');
Route::get('/button/add', AddButton::class)->name('button.index')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active');

// -------------------- PROFILE  --------------------
Route::get('/dashboard/profile', Profile::class)->name('dashboard.profile')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/profile/edit', ProfileEdit::class)->name('profile.edit')->middleware('auth', 'verified',  'maintenance', 'is_admin', 'is_active');

// -------------------- SUBSCRIPTIONS  --------------------
Route::get('/dashboard/subscriptions', ProductSubscriptionPage::class)->name('dashboard.subscriptions')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');

Route::get('/subscriptions/add', AddSubscriptionProduct::class)->name('subscriptions.add')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');

Route::get('/subscriptions/edit/{id}', EditSubscriptionProduct::class)->name('subscriptions.edit')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');

// -------------------- PRODUCTS  --------------------
Route::get('/dashboard/product', ProductPage::class)->name('dashboard.product')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/product/add', AddProduct::class)->name('product.add')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');
Route::get('/product/edit/{id}', ProductEdit::class)->name('product.edit')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active');

Route::get('/product/{product_id}/image/add', AddProductImages::class)->name('product-image.add')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active');

Route::get('/product/{product_id}/video/add', AddProductVideos::class)->name('product-video.add')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active');

Route::get('/product/{product_id}/video/edit/{id}', EditProductVideo::class)->name('product-video.edit')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active');

Route::get('/product/{product_id}/image/edit/{id}', EditProductImage::class)->name('product-image.edit')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active');

// -------------------- PRODUCT CATEGORY  --------------------
Route::get('/dashboard/product-categories', ProductCategoryPage::class)->name('dashboard.productcategory')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/category/add', AddProductCategory::class)->name('category.add')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');
Route::get('/category/edit/{id}', EditProductCategory::class)->name('category.edit')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');

// -------------------- PRODUCT COLLECTION  --------------------
Route::get('/dashboard/product-collections', ProductCollectionPage::class)->name('dashboard.productcollection')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/collection/add', AddProductCollection::class)->name('collection.add')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');
Route::get('/collection/edit/{id}', EditProductCollection::class)->name('collection.edit')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');

// -------------------- SALES PAGE  --------------------
// Route::get('/dashboard/sales', SalesPage::class)->name('dashboard.sales')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
// Route::get('/sales/add', AddSalesPage::class)->name('sales.add')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');
// Route::get('/sales/edit/{id}', EditSalesPage::class)->name('sales.edit')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active');

// Route::get('/{username}/sales', DisplaySalesPage::class)->name('card.sales');

// Route::get('/{username}/sales/{sales}', SalesPageContent::class)->name('sales.content');

// Route::get('/{username}/sales/{sales}/cash-and-carry/{sales_images}', CashCarry::class)->name('image.cashandcarry');

// Route::get('/{username}/sales/{sales}/cash-and-carry-video/{sales_videos}', CashCarryVideo::class)->name('video.cashandcarry');

// Route::get('/{username}/sales/{id}', ProductInfoPage::class)->name('product.show');

// -------------------- SALES VIDEO PAGE  --------------------
// Route::get('/sales/{sales}/video/add', AddSalesVideo::class)
//     ->name('salesvideo.add')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');

// Route::get('/sales/video/edit/{video}', EditSalesVideo::class)
//     ->name('salesvideo.edit')
//     ->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');

// -------------------- SALES IMAGE PAGE  --------------------
// Route::get('/sales/{sales}/image/add', AddSalesImage::class)
//     ->name('salesimage.add')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');

// Route::get('/sales/image/edit/{image}', EditSalesImage::class)
//     ->name('salesimage.edit')
//     ->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');

// -------------------- EVENTS  --------------------
Route::get('/dashboard/event', EventPage::class)->name('dashboard.event')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/event/add', AddEvent::class)->name('event.add')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');
Route::get('/event/edit/{id}', EventEdit::class)->name('event.edit')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active');

// -------------------- SERVICES  --------------------
Route::get('/dashboard/service', ServicePage::class)->name('dashboard.service')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/service/add', AddService::class)->name('service.add')->middleware('auth',  'verified', 'maintenance', 'is_admin', 'is_active');
Route::get('/service/edit/{id}', ServiceEdit::class)->name('service.edit')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active');

// -------------------- VIDEO  --------------------
Route::get('/dashboard/video', VideoPage::class)->name('dashboard.video')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/video/add', AddVideo::class)->name('video.add')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/video/edit/{id}', VideoEdit::class)->name('video.edit')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');

// -------------------- TESTIMONIALS  --------------------
Route::get('/dashboard/testimonial', TestimonialPage::class)->name('dashboard.testimonial')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/testimonial/add', AddReviewVideos::class)->name('testimonial.add')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/testimonial/edit/{id}', EditReviewVideo::class)->name('testimonial.edit')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');

// -------------------- TRUSTED NETWORK  --------------------
Route::get('/dashboard/trusted-network', TrustedNetworkDashboard::class)->name('dashboard.trustednetwork')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/trusted-network/search/', SearchTrustedNetwork::class)->name('trustednetwork.search')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');

// -------------------- SETTINGS  --------------------
Route::get('/dashboard/settings', SettingsPage::class)->name('settings.index')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');

Route::get('/customize/customization', CustomizationPage::class)->name('customization.index')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active');
Route::get('/customization/card-customization', CardCustomization::class)->name('card-customization.index')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active');

Route::get('/settings/visibility', VisibilityPage::class)->name('settings.visibility')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active');

// -------------------- SETTINGS  --------------------
Route::get('/settings/notifications', NotificationSettingsPage::class)->name('settings.notifications')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active');

// -------------------- LAYOUT  --------------------
Route::get('/dashboard/layout', LayoutPage::class)->name('dashboard.layout')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');

// -------------------- COLORS  --------------------
Route::get('/appearance/colors', CustomizeColors::class)->name('customize.colors')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');

// -------------------- THEMES  --------------------
Route::get('/appearance/themes', ManageTheme::class)->name('customize.themes')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');

// -------------------- CHANGE PASS  --------------------
Route::get('/settings/change-password', ChangePassword::class)->name('password.index')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');
// Route::get('/change-password', ChangePassword::class)->name('password.index')->middleware('auth', 'is_admin', 'maintenance', 'is_active', 'is_footer');

// -------------------- PAYMENT LINKS  --------------------
Route::get('/dashboard/payments', PaymentLinksPage::class)->name('payments.index')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active', 'is_footer');
Route::get('/payments/add', AddPaymentLink::class)->name('payments.add')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active', 'is_footer');

// -------------------- COMMUNITIES LINKS  --------------------
Route::get('/dashboard/communities', CommunityLinksPage::class)->name('communities.index')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active', 'is_footer');
Route::get('/communities/add', AddCommunityLink::class)->name('communities.add')->middleware('auth',  'verified', 'is_admin', 'maintenance', 'is_active', 'is_footer');
Route::get('/communities/edit/{id}', EditCommunityLink::class)->name('communities.edit')->middleware('auth',  'verified', 'is_admin', 'maintenance', 'is_active', 'is_footer');


// -------------------- ZOOM REPLAYS  --------------------
Route::get('/dashboard/replays', ZoomReplaysPage::class)->name('zoomreplay.index')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active', 'is_footer');
Route::get('/replays/add', AddZoomReplay::class)->name('zoomreplay.add')->middleware('auth',  'verified', 'is_admin', 'maintenance', 'is_active', 'is_footer');
Route::get('/replays/edit/{id}', EditZoomReplay::class)->name('zoomreplay.edit')->middleware('auth',  'verified', 'is_admin', 'maintenance', 'is_active', 'is_footer');

// Route::get('{username}/community', CommunitiesViewModal::class)->name('card.community');

// -------------------- CONTACT POINTS  --------------------
Route::get('/dashboard/contacts', ContactPointsPage::class)->name('contacts.index')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');
Route::get('/contacts/add', AddContactPoint::class)->name('contacts.add')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');

Route::get('/dashboard/card/add', AddNewPage::class)->name('card.add')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active');

// -------------------- DIRECTION LINKS  --------------------
Route::get('/dashboard/directions', DirectionLinksPage::class)->name('directions.index')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');
// Route::get('/dashboard/communities', CommunityLinksPage::class)->name('directions.index')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active', 'is_footer');
Route::get('/directions/add', AddDirectionLink::class)->name('directions.add')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');
Route::get('/directions/edit/{id}', EditDirectionLink::class)->name('directions.edit')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');

// -------------------- ANALYTICS  --------------------
Route::get('/dashboard/analytics', AnalyticsPage::class)->name('dashboard.analytics')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');

// -------------------- ALL LINKS  --------------------
Route::get('/dashboard/links', AllLinksPage::class)->name('dashboard.links')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');

// -------------------- AD MANAGEMENT  --------------------
Route::get('/dashboard/ads', AdPage::class)->name('dashboard.ads')->middleware('auth', 'maintenance',  'verified',  'is_admin', 'is_active');
Route::get('/ads/add', AddAd::class)->name('ads.add')->middleware('auth', 'maintenance', 'is_admin',  'verified',  'is_active');
Route::get('/ads/edit/{id}', AdEdit::class)->name('ads.edit')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');

// -------------------- AD MANAGEMENT  --------------------
Route::get('/dashboard/free-ads', EditFreeAds::class)->name('dashboard.freeads')->middleware('auth', 'maintenance',  'verified',  'is_admin', 'is_active');

// -------------------- NETWORK  --------------------
Route::get('/dashboard/network', NetworkPage::class)->name('dashboard.network')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active', 'can_manage_network');
Route::get('/network/add', AddNetworkManually::class)->name('network.add')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active', 'can_manage_network');
Route::get('/network/contact/{id}', ContactPageSubmitted::class)->name('contact.view')->middleware('auth', 'verified',  'maintenance', 'is_admin', 'is_active', 'can_manage_network');

// -------------------- FORMS   --------------------
Route::get('/dashboard/forms', FormDashboard::class)->name('dashboard.form')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/form/edit/{id}', FormEditPage::class)->name('form.edit')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active');
Route::get('/form/create/', FormCreatePage::class)->name('form.add')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active');
Route::get('/submission/{id}', ViewFormSubmissionPage::class)->name('submission.show')->middleware('auth', 'verified',  'maintenance', 'is_admin', 'is_active', 'can_manage_network');

// -------------------- MEMBERS  --------------------
Route::get('/dashboard/member', MembersPage::class)->name('dashboard.member')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');

Route::get('/member/search/{team_id}', SearchMember::class)->name('member.search')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');

// Route::get('/network/add', AddNetworkManually::class)->name('network.add')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active', 'can_manage_network');
// Route::get('/network/contact/{id}', ContactPageSubmitted::class)->name('contact.view')->middleware('auth', 'verified',  'maintenance', 'is_admin', 'is_active', 'can_manage_network');

// -------------------- TRUSTED NETWORK  --------------------
Route::get('/dashboard/teams', AllTeamsPage::class)->name('dashboard.team')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');

Route::get('/team/add', AddNewTeam::class)->name('team.add')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');

Route::get('/team/edit/{id}', EditTeamPage::class)->name('team.edit')->middleware('auth', 'verified', 'maintenance', 'is_admin', 'is_active');

// -------------------- REFERRALS  --------------------
Route::get('/dashboard/referrals', ReferralPage::class)->name('dashboard.referrals')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active', 'can_manage_network');
Route::get('/referrals/{user_id}', ReferredPageInfo::class)->name('referrals.info')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active', 'can_manage_network');

// -------------------- SEARCH  --------------------
Route::get('/dashboard/search', SearchCard::class)->name('dashboard.search')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');

// -------------------- IMAGES  --------------------
Route::get('/dashboard/images', ImageManager::class)->name('dashboard.images')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/image/add', AddImages::class)->name('image.add')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');
Route::get('/image/edit/{id}', ImageEdit::class)->name('image.edit')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active');

// -------------------- SELECT PLAN  --------------------
Route::get('/plan/select', SelectCardPlan::class)->name('plan.index')->middleware('auth', 'have_user_type', 'verified',  'is_admin', 'maintenance', 'is_active');

// -------------------- CHECKOUT  --------------------
// Route::get('/plan/checkout/{price_id}/{selected_plan}', CheckoutController::class)->name('checkout')->middleware('auth', 'verified', 'is_admin', 'maintenance', 'is_active');
Route::get('/plan/checkout', CheckoutController::class)->name('checkout')->middleware('auth', 'is_admin', 'maintenance', 'is_active');

// -------------------- REGISTRATION SUCCESS  --------------------
Route::get('/registration/success', RegistrationSuccess::class)->name('registration.success')->middleware('auth', 'is_admin', 'maintenance', 'is_active');


// -------------------- SUBSCRIPTION  --------------------
Route::get('/dashboard/subscription', SubscriptionPage::class)->name('dashboard.subscription')->middleware('auth',  'verified',  'maintenance', 'is_admin', 'is_active');

// -------------------- UPGRADE PLAN  --------------------
Route::get('/upgrade/select', UpgradeCardPlan::class)->name('upgrade.index')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active');

Route::get('/dashboard/partnership/', PartnershipDashboard::class)->name('partnership.index')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active');

Route::get('/partnership/select', PartnershipProgramSelection::class)->name('partnership.upgrade')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active');

Route::get('/partnership/checkout', PartnershipCheckoutManual::class)->name('partnership.checkout')->middleware('auth', 'is_admin', 'maintenance', 'is_active');

// Route::get('/partnership/checkout', function () {
//     $default = app(CardDefaultsSetting::class);

//     if ($default->manual_capture_mode == true) {
//         return app()->call(PartnershipCheckoutManual::class);
//     }
// })->name('partnership.checkout')->middleware('auth', 'verified',  'is_admin', 'maintenance', 'is_active');

// -------------------- UPGRADE CHECKOUT  --------------------
// Route::get('/upgrade/checkout', UpgradeCheckoutController::class)->name('checkout.upgrade')->middleware('auth', 'is_admin', 'maintenance', 'is_active');

Route::get('/upgrade/checkout', function () {
    $default = app(CardDefaultsSetting::class);

    if ($default->manual_capture_mode == true) {
        return app()->call(UpgradeCheckoutManual::class);
    }

    return app()->call(UpgradeCheckoutController::class);
})->name('checkout.upgrade')->middleware('auth', 'is_admin', 'maintenance', 'is_active');


// -------------------- UPGRADE SUCCESS  --------------------
Route::get('/upgrade/success', UpgradeSuccess::class)->name('upgrade.success')->middleware('auth', 'is_admin', 'maintenance', 'is_active');

// -------------------- UPGRADE SUCCESS  --------------------
Route::get('/subscription/portal', [SubscriptionController::class, 'portal'])->name('subscription.portal')->middleware('auth', 'is_admin', 'maintenance', 'is_active');

Route::post('/subscription/resume', [SubscriptionController::class, 'resume'])->name('subscription.resume')->middleware('auth', 'is_admin', 'maintenance', 'is_active');

Route::post('/subscription/cancel', [SubscriptionController::class, 'cancel'])->name('subscription.cancel')->middleware('auth', 'is_admin', 'maintenance', 'is_active');

Route::get('/subscription/invoice', [SubscriptionController::class, 'invoice'])->name('subscription.invoice')->middleware('auth', 'is_admin', 'maintenance', 'is_active');

Route::get('/dashboard/pages', PresentationPageDashboard::class)->name('dashboard.pages')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');

Route::get('/pages/add', AddPresentationPage::class)->name('pages.add')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');

Route::get('/pages/edit/{id}', EditPresentationPage::class)->name('pages.edit')->middleware('auth',  'verified',  'is_admin', 'maintenance', 'is_active');

Route::get('/pricing', PricingPage::class)->name('pricing.show');

Route::get('/{username}/page/{slug}', PresentationPage::class)->name('page.show');

Route::get('/{username}/trusted-network', DisplayTrustedNetwork::class)->name('card.trustednetwork');

Route::get('/{username}/products', DisplayProducts::class)->name('card.products');
Route::get('/{username}/products/{id}', ProductInfoPage::class)->name('product.show');
Route::get('/{username}/subscription/{id}', SubscriptionInfoPage::class)->name('subscription.show');

Route::get('/{username}/services', DisplayServices::class)->name('card.services');
Route::get('/{username}/services/{id}', ServiceInfoPage::class)->name('service.show');

Route::get('/{username}/events', DisplayEvents::class)->name('card.events');
Route::get('/{username}/events/{slug}', EventInfoPage::class)->name('events.show');

// -------------------- FORMS  --------------------
Route::get('/{username}/form/{slug}', FormPage::class)->name('form.show');

// -------------------- ZOOM REPLAYS  --------------------
Route::get('/{username}/zoom-replays/', DisplayZoomReplays::class)->name('card.zoomreplay');

// -------------------- TESTIMONIALS  --------------------
Route::get('/{username}/testimonials', DisplayReviews::class)->name('card.reviews');

// -------------------- BIO  --------------------
Route::get('/{username}/bio', BioPage::class)->name('bio.show');

// -------------------- MORE VIDEOS  --------------------
Route::get('/{username}/more-videos', MoreVideosPage::class)->name('morevideos.show');

// -------------------- LETS CONNECT  --------------------
Route::get('/{username}/connect', LetsConnectForm::class)->name('card.connect');
Route::get('/{username}/feedback', FeedbackForm::class)->name('card.feedback');

// -------------------- EXCHANGE CONTACTS  --------------------
Route::get('/{username}/exchange', ExchangeContact::class)->name('card.exchange');

Route::get('/{username}/collection/{collection_id}', DisplayProductCollection::class)->name('card.collection');

Route::get('/{username}/cart/', SalesPageCart::class)->name('sales.cart');

Route::get('/{username}/subscription_cart/', SubscriptionCart::class)->name('subscription.cart');

// -------------------- TEAMS  --------------------
Route::get('/{username}/team/{team_id}', DisplayTeamPage::class)->name('card.team');

// -------------------- PAYMENTS  --------------------
Route::get('/{username}/pay/', PaymentPage::class)->name('card.pay');

// Route::post('/save-fcm-token', function () {
//     $userId = request('user_id');
//     $token = request('token');

//     if (! $userId || ! $token) {
//         return response()->json(['success' => false, 'message' => 'Missing data']);
//     }

//     // Only check uniqueness by token, not token + user
//     UserFcmToken::updateOrCreate(
//         ['token' => $token],
//         ['user_id' => $userId, 'updated_at' => now()]
//     );

//     return response()->json([
//         'success' => true,
//         'user_id' => $userId,
//         'token_saved' => $token
//     ]);
// });

Route::get('/get-page-ids/{username}', function ($username) {
    $user = \App\Models\User::where('username', $username)->first();
    if ($user) {
        return response()->json(['user_id' => $user->id, 'page_id' => null]);
    }

    $subcard = \App\Models\SubCard::where('username', $username)->first();
    if ($subcard) {
        return response()->json(['user_id' => null, 'page_id' => $subcard->id]);
    }

    return response()->json(['user_id' => null, 'page_id' => null]);
});

// Route::post('/save-fcm-token', function (Request $request) {
//     $userId = $request->input('user_id');
//     $pageId = $request->input('page_id');
//     $token = $request->input('token');

//     if (! $token) {
//         return response()->json([
//             'success' => false,
//             'message' => 'Missing token'
//         ]);
//     }

//     // Ensure at least one identifier exists
//     if (! $userId && ! $pageId) {
//         return response()->json([
//             'success' => false,
//             'message' => 'Missing user_id or page_id'
//         ]);
//     }

//     // Only check uniqueness by token
//     $data = [
//         'user_id' => $userId,
//         'page_id' => $pageId,
//         'updated_at' => now(),
//     ];

//     UserFcmToken::updateOrCreate(
//         ['token' => $token],
//         $data
//     );

//     return response()->json([
//         'success' => true,
//         'user_id' => $userId,
//         'page_id' => $pageId,
//         'token_saved' => $token
//     ]);
// });

Route::get('/{username}', Card::class)
    ->name('card.show');
