<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="{{ $site_name }}" />
    <meta property="og:description"
        content="{{ isset($site_desc) ? $site_desc : 'The modern approach to business cards. Leave a lasting impression on your clients with the new way to present yourself.' }}" />
    <meta property="og:image" content="{{ asset($thumbnail) }}" />
    <meta property="og:url" content="{{ $site_url }}" />
    <meta property="og:type" content="website" />

    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="{{ asset($thumbnail) }}" />
    <meta name="twitter:title" content="{{ $site_name }}" />
    <meta name="twitter:description" content="{{ isset($bio) ? $bio : '' }}" />
    <meta name="twitter:image" content="{{ asset($thumbnail) }}" />

    <link rel="icon" type="image/x-icon" href="{{ asset($thumbnail) }}">
    <meta name="description"
        content="{{ isset($site_desc) ? $site_desc : 'The modern approach to business cards. Leave a lasting impression on your clients with the new way to present yourself.' }}">
    <meta name="keywords" content="digital business card, video business card, business card">
    <meta name="robots" content="index, follow">
    {{-- <title>Welcome to {{ $site_name }}</title> --}}
    <title>{{ $site_name }}</title>

    @vite('resources/css/app.css')
</head>

<body class="bg-slate-200 dark:bg-zinc-950 my-5 relative">

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-4 mb-20">
        {{-- <p class="rounded-full bg-gray-300 py-1 px-2 text-[8px] text-black mx-auto w-fit">Prototype
            v0.1</p> --}}
        {{-- <img src="{{ $mockup ? Storage::url($mockup) : asset('img/mockup.png') }}"
            class="w-6/12 sm:w-8/12 floating-animation mx-auto"> --}}

        <img src="{{ $mockup ? asset($mockup) : asset('img/mockup.png') }}"
            class="w-6/12 sm:w-8/12 floating-animation mx-auto">


        <h1 class="text-5xl text-center text-slate-800 dark:text-slate-300 px-2 pt-5 font-bold heading-gradient">Connect
            {{ $mockup }} Smarter,
            Not Harder.</h1>
        <p class="text-slate-800 dark:text-slate-400 text-lg text-center py-2 px-3 sm:px-5">Effortless sharing,
            eco-friendly, and always up-to-date – <span class="font-semibold">{{ $site_name }}</span> makes
            networking
            smarter, faster, and more efficient.</p>

        {{-- <div class="flex justify-center items-center gap-2 mb-5">
            <img src="{{ asset('img/reviews-circle.png') }}" class="w-20">

            <div>
                <div class="text-yellow-400 flex">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                        <path fill-rule="evenodd"
                            d="M10.788 3.21c.448-1.077 1.976-1.077 2.424 0l2.082 5.006 5.404.434c1.164.093 1.636 1.545.749 2.305l-4.117 3.527 1.257 5.273c.271 1.136-.964 2.033-1.96 1.425L12 18.354 7.373 21.18c-.996.608-2.231-.29-1.96-1.425l1.257-5.273-4.117-3.527c-.887-.76-.415-2.212.749-2.305l5.404-.434 2.082-5.005Z"
                            clip-rule="evenodd" />
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                        <path fill-rule="evenodd"
                            d="M10.788 3.21c.448-1.077 1.976-1.077 2.424 0l2.082 5.006 5.404.434c1.164.093 1.636 1.545.749 2.305l-4.117 3.527 1.257 5.273c.271 1.136-.964 2.033-1.96 1.425L12 18.354 7.373 21.18c-.996.608-2.231-.29-1.96-1.425l1.257-5.273-4.117-3.527c-.887-.76-.415-2.212.749-2.305l5.404-.434 2.082-5.005Z"
                            clip-rule="evenodd" />
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                        <path fill-rule="evenodd"
                            d="M10.788 3.21c.448-1.077 1.976-1.077 2.424 0l2.082 5.006 5.404.434c1.164.093 1.636 1.545.749 2.305l-4.117 3.527 1.257 5.273c.271 1.136-.964 2.033-1.96 1.425L12 18.354 7.373 21.18c-.996.608-2.231-.29-1.96-1.425l1.257-5.273-4.117-3.527c-.887-.76-.415-2.212.749-2.305l5.404-.434 2.082-5.005Z"
                            clip-rule="evenodd" />
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                        <path fill-rule="evenodd"
                            d="M10.788 3.21c.448-1.077 1.976-1.077 2.424 0l2.082 5.006 5.404.434c1.164.093 1.636 1.545.749 2.305l-4.117 3.527 1.257 5.273c.271 1.136-.964 2.033-1.96 1.425L12 18.354 7.373 21.18c-.996.608-2.231-.29-1.96-1.425l1.257-5.273-4.117-3.527c-.887-.76-.415-2.212.749-2.305l5.404-.434 2.082-5.005Z"
                            clip-rule="evenodd" />
                    </svg>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-6">
                        <path fill-rule="evenodd"
                            d="M10.788 3.21c.448-1.077 1.976-1.077 2.424 0l2.082 5.006 5.404.434c1.164.093 1.636 1.545.749 2.305l-4.117 3.527 1.257 5.273c.271 1.136-.964 2.033-1.96 1.425L12 18.354 7.373 21.18c-.996.608-2.231-.29-1.96-1.425l1.257-5.273-4.117-3.527c-.887-.76-.415-2.212.749-2.305l5.404-.434 2.082-5.005Z"
                            clip-rule="evenodd" />
                    </svg>
                </div>
                <p class="text-slate-900 dark:text-slate-400 text-xs">from 1000+ reviews</p>
            </div>
        </div> --}}

        <!-- SECTION 4 | Bottom Nav Bar -->
        <div
            class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto p-5 bg-slate-200 dark:bg-zinc-950">
            <!-- <div class="fixed bottom-0 w-full sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto py-2 bg-white dark:bg-zinc-900 rounded-2xl"> -->
            <a href="{{ route('register') }}"
                class="block hover:shadow-lg text-center mx-auto font-bold text-sm rounded-lg bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 px-4 py-3 w-full">
                Sign Up
            </a>

            <p class="mt-2 text-center text-sm text-slate-800 dark:text-slate-400">
                Already have a card?
                <a href="{{ route('login') }}" class="font-medium text-yellow-600 hover:text-yellow-500">Sign in</a>.
            </p>
        </div>



        {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
            integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
            crossorigin="anonymous" referrerpolicy="no-referrer"></script>
        <script src="js/custom.js"></script> --}}
    </div>

</body>

</html>
