<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Dashboard Page --}}
            <div class="flex items-center col-span-1">
                {{-- <a href="{{ route('dashboard.search', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-magnifying-glass class="size-4" />
                </a> --}}

                @if (auth()->user()->user_type != 'Free')
                    <a wire:navigate href="{{ route('dashboard.links') }}"
                        class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                        <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                            </svg>
                        </span>
                    </a>
                @endif
            </div>
            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="m15.75 10.5 4.72-4.72a.75.75 0 0 1 1.28.53v11.38a.75.75 0 0 1-1.28.53l-4.72-4.72M4.5 18.75h9a2.25 2.25 0 0 0 2.25-2.25v-9a2.25 2.25 0 0 0-2.25-2.25h-9A2.25 2.25 0 0 0 2.25 7.5v9a2.25 2.25 0 0 0 2.25 2.25Z" />
                </svg>

                &nbsp;&nbsp;Videos
            </p>

            <div class="flex items-center col-span-1 place-content-end">
                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a> --}}

                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-xs font-semibold shadow-xs flex bg-white text-black items-center">
                    View&nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" />
                </a> --}}

                <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>
        </div>

        @if ($videos && $user_type == 'Platinum' && $this->videos->count() < 5)
            <div class="grid grid-cols-3 mt-5 gap-4">

                <div class="h-fit col-span-2">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Add New
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">Add a new video link</p>
                </div>

                <div class="flex items-center col-span-1 place-content-end">
                    <a wire:navigate href="{{ route('video.add') }}"
                        class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="size-6">
                                <path fill-rule="evenodd"
                                    d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                    clip-rule="evenodd" />
                            </svg>
                        </span>
                    </a>
                </div>
            </div>
        @endif
    </div>

    @if (!$videos)
        <div class="flex justify-center my-20">
            <a wire:navigate href="{{ route('video.add') }}"
                class="flex items-center mx-auto bg-blue-500 text-white px-3.5 py-1.5 text-base rounded-md">Add
                Video(s) &nbsp;
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-4">
                    <path fill-rule="evenodd"
                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                        clip-rule="evenodd" />
                </svg>
            </a>

        </div>
    @endif


    @if ($videos)
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

            {{-- <div class="grid grid-cols-2 gap-4 mb-5">
                    <!-- Add to Contact -->
                    <div class="ml-5 flex items-center">
                        <h1 class="text-lg md:text-xl font-medium text-center text-slate-800 dark:text-slate-300">Active
                            Links
                        </h1>
                    </div>

                    <div class="mr-5 flex justify-end items-center">
                        <span class="rounded-full text-gray-600">
                            <!-- Enabled: "bg-indigo-600", Not Enabled: "bg-gray-200" -->
                            <button type="button"
                                class="flex w-8 flex-none cursor-pointer rounded-full bg-green-400 p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <!-- <span class="sr-only">Agree to policies</span> -->
                                <!-- Enabled: "translate-x-3.5", Not Enabled: "translate-x-0" -->
                                <span aria-hidden="true"
                                    class="size-4 translate-x-3.5 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>
                </div> --}}

            {{-- Display all sortable socials here --}}
            <p class="text-slate-600 dark:text-slate-500 text-sm text-center mb-10">Drag the element to rearrange.</p>
            <livewire:sortable-video />
        </div>
    @endif
</div>
