<div>

    <!-- Overlay (Initially hidden) -->
    {{-- <div id="overlay" class="fixed inset-0 bg-gray-900 bg-opacity-50 z-20 hidden toggleSocialActionSheet"></div> --}}

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.profile') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900">
                        <x-bi-chevron-left class="size-4" />
                    </span>
                </a>
            </div>

            <p
                class="col-span-3 flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold ">

                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M16.5 10.5V6.75a4.5 4.5 0 1 0-9 0v3.75m-.75 11.25h10.5a2.25 2.25 0 0 0 2.25-2.25v-6.75a2.25 2.25 0 0 0-2.25-2.25H6.75a2.25 2.25 0 0 0-2.25 2.25v6.75a2.25 2.25 0 0 0 2.25 2.25Z" />
                </svg>

                &nbsp;&nbsp;Settings
            </p>

            <div class="flex items-center col-span-1 place-content-end">
                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a> --}}

                <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>
        </div>

    </div>

    {{-- <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

        <div class="grid grid-cols-5 mx-2">
            <div class="col-span-1">
                <div class="relative">
                    <img src="{{ asset($user->profile_pic ?: '/img/profile-placeholder.jpg') }}"
                        class="rounded-full p-2 w-full z-0">
                    @if (in_array(auth()->user()->user_type, ['Gold', 'Platinum']))
                        <span @click="showSwitchActiveCardModal=!showSwitchActiveCardModal"
                            class="absolute bottom-0 right-0 mr-5 mb-2 translate-x-1/4 translate-y-1/4 inline-flex bg-zinc-100 text-slate-600 dark:text-slate-500 text-sm rounded-full dark:bg-white p-2 shadow-lg z-10">
                            <x-heroicon-s-arrows-right-left class="size-3" />
                        </span>
                    @endif
                </div>
            </div>
            <div class="col-span-4 flex flex-col justify-center mx-2">
                <p class="truncate text-sm/6 font-semibold text-gray-900 dark:text-slate-300">
                    {{ isset($card_title) ? $card_title : $user->firstname . ' ' . $user->lastname }}
                </p>
                <p class="rounded-full w-fit bg-yellow-400 py-1 px-2 mt-0.5 text-[9px] text-black">
                    {{ '@' . $user['username'] }}
                </p>
            </div>
        </div>

    </div> --}}

    <livewire:switch-card-component />

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-2 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl">

        <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5">

            <!-- Edit Profile -->
            <li>
                <a wire:navigate href="{{ route('profile.edit') }}" class="flex justify-between gap-x-6 sm:py-3">
                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                stroke-width="1.5" stroke="currentColor" class="size-5">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="m16.862 4.487 1.687-1.688a1.875 1.875 0 1 1 2.652 2.652L10.582 16.07a4.5 4.5 0 0 1-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 0 1 1.13-1.897l8.932-8.931Zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0 1 15.75 21H5.25A2.25 2.25 0 0 1 3 18.75V8.25A2.25 2.25 0 0 1 5.25 6H10" />
                            </svg>
                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Profile</p>
                        </div>
                    </div>
                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                        <span class="rounded-full text-gray-600 p-2">
                            <x-bi-chevron-right class="size-4" />
                        </span>
                    </div>
                </a>
            </li>

            <!-- Customization -->
            @if (auth()->user()->user_type != 'Free')
                <li>
                    <a wire:navigate href="{{ route('customization.index') }}"
                        class="flex justify-between gap-x-6 sm:py-3">
                        <div class="flex min-w-0 gap-x-4 items-center">
                            <span class="rounded-full dark:bg-white bg-slate-200 p-2">

                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="1.5" stroke="currentColor" class="size-5">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M9.53 16.122a3 3 0 0 0-5.78 1.128 2.25 2.25 0 0 1-2.4 2.245 4.5 4.5 0 0 0 8.4-2.245c0-.399-.078-.78-.22-1.128Zm0 0a15.998 15.998 0 0 0 3.388-1.62m-5.043-.025a15.994 15.994 0 0 1 1.622-3.395m3.42 3.42a15.995 15.995 0 0 0 4.764-4.648l3.876-5.814a1.151 1.151 0 0 0-1.597-1.597L14.146 6.32a15.996 15.996 0 0 0-4.649 4.763m3.42 3.42a6.776 6.776 0 0 0-3.42-3.42" />
                                </svg>

                            </span>
                            <div class="min-w-0 flex-auto">
                                <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Customize</p>
                            </div>
                        </div>
                        <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                            <span class="rounded-full text-gray-600 p-2">
                                <x-bi-chevron-right class="size-4" />
                            </span>
                        </div>
                    </a>
                </li>
            @endif

            <!-- Change Password -->
            <li>
                <a wire:navigate href="{{ route('password.index') }}" class="flex justify-between gap-x-6 sm:py-3">
                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                            <x-heroicon-o-lock-closed class="size-5" />
                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Change Password </p>
                        </div>
                    </div>
                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                        <span class="rounded-full text-gray-600 p-2">
                            <x-bi-chevron-right class="size-4" />
                        </span>
                    </div>
                </a>
            </li>

            <li>
                <a wire:navigate href="{{ route('settings.visibility') }}" class="flex justify-between gap-x-6 sm:py-3">
                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                            <x-heroicon-o-eye class="size-5" />
                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Visibility</p>
                        </div>
                    </div>
                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                        <span class="rounded-full text-gray-600 p-2">
                            <x-bi-chevron-right class="size-4" />
                        </span>
                    </div>
                    {{-- <div class="shrink-0 sm:flex sm:flex-col sm:items-end justify-center">
                        <span
                            class="inline-flex items-center rounded-full bg-yellow-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-yellow-700 ring-1 ring-pink-700/10 ring-inset">
                            New&nbsp;<x-heroicon-s-sparkles class="size-3" />
                        </span>
                    </div> --}}
                </a>
            </li>

            <li>
                <a href="{{ route('settings.notifications') }}" class="flex justify-between gap-x-6 sm:py-3">
                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                            <x-heroicon-o-bell-alert class="size-5" />
                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Notifications</p>
                        </div>
                    </div>
                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                        <span class="rounded-full text-gray-600 p-2">
                            <x-bi-chevron-right class="size-4" />
                        </span>
                    </div>
                </a>
            </li>

        </ul>

    </div>

</div>
