<div>

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">
        <div class="grid grid-cols-5 gap-4">
            {{-- Search button available only for Basic -> Platinum users --}}
            <div class="flex items-center col-span-1">
                @if (auth()->user()->user_type != 'Free')
                    <a href="{{ route('dashboard.search', $user['username']) }}"
                        class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                        <x-heroicon-o-magnifying-glass class="size-4" />
                    </a>
                @endif
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M17.982 18.725A7.488 7.488 0 0 0 12 15.75a7.488 7.488 0 0 0-5.982 2.975m11.963 0a9 9 0 1 0-11.963 0m11.963 0A8.966 8.966 0 0 1 12 21a8.966 8.966 0 0 1-5.982-2.275M15 9.75a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                </svg>

                &nbsp;&nbsp;Profile
            </p>

            <div class="flex items-center col-span-1 place-content-end">
                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a> --}}

                <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>
        </div>
    </div>

    <livewire:switch-card-component />

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        {{-- <div class="mx-auto">
            <livewire:profile-photo-field :model="auth()->user()" />
        </div> --}}
        <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5 py-2">

            <li>
                <a wire:navigate href="{{ route('card.show', $user['username']) }}"
                    class="flex justify-between gap-x-6 sm:py-3">
                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                            <x-heroicon-o-arrow-top-right-on-square class="size-5" />
                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">View Card</p>
                        </div>
                    </div>

                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                        <span class="rounded-full text-gray-600 p-2">
                            <x-bi-chevron-right class="size-4" />
                        </span>
                    </div>
                </a>
            </li>

            @if (in_array(auth()->user()->user_type, ['Sponsored', 'Influencer', 'Gold', 'Platinum']))
                @php
                    $maxCard = 0;
                    $availableSlot = 0;
                    $verbiage = ' Slots';

                    if (auth()->user()->user_type === 'Gold') {
                        $maxCard = 3;
                    }

                    if (auth()->user()->user_type === 'Platinum') {
                        $maxCard = 12;
                    }

                    if (in_array(auth()->user()->user_type, ['Sponsored', 'Influencer'])) {
                        $maxCard = 1;
                    }

                    $availableSlot = $maxCard - $subcards_count;

                    if ($availableSlot <= 1) {
                        $verbiage = ' Slot';
                    }

                    $availableSlot .= $verbiage;
                @endphp

                @if ($availableSlot >= 1)
                    <li>
                        <a wire:navigate href="{{ route('card.add') }}" class="flex justify-between gap-x-6 sm:py-3">
                            <div class="flex min-w-0 gap-x-4 items-center">
                                <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                                    <x-heroicon-o-plus class="size-5" />
                                </span>
                                <div class="min-w-0 flex-auto">
                                    <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Add New
                                        Card
                                    </p>
                                </div>
                            </div>

                            {{-- @if ($availableSlot > 0) --}}
                            <div class="shrink-0 sm:flex sm:flex-col sm:items-end justify-center">
                                <span
                                    class="inline-flex items-center rounded-full bg-yellow-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-yellow-700 ring-1 ring-pink-700/10 ring-inset">{{ $availableSlot }}
                                </span>
                            </div>

                        </a>
                    </li>
                @endif
            @endif

            <!-- Settings -->
            <li>
                <a wire:navigate href="{{ route('settings.index') }}" class="flex justify-between gap-x-6 sm:py-3">
                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">

                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                stroke-width="1.5" stroke="currentColor" class="size-5">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M9.594 3.94c.09-.542.56-.94 1.11-.94h2.593c.55 0 1.02.398 1.11.94l.213 1.281c.063.374.313.686.645.87.074.04.147.083.22.127.325.196.72.257 1.075.124l1.217-.456a1.125 1.125 0 0 1 1.37.49l1.296 2.247a1.125 1.125 0 0 1-.26 1.431l-1.003.827c-.293.241-.438.613-.43.992a7.723 7.723 0 0 1 0 .255c-.008.378.137.75.43.991l1.004.827c.424.35.534.955.26 1.43l-1.298 2.247a1.125 1.125 0 0 1-1.369.491l-1.217-.456c-.355-.133-.75-.072-1.076.124a6.47 6.47 0 0 1-.22.128c-.331.183-.581.495-.644.869l-.213 1.281c-.09.543-.56.94-1.11.94h-2.594c-.55 0-1.019-.398-1.11-.94l-.213-1.281c-.062-.374-.312-.686-.644-.87a6.52 6.52 0 0 1-.22-.127c-.325-.196-.72-.257-1.076-.124l-1.217.456a1.125 1.125 0 0 1-1.369-.49l-1.297-2.247a1.125 1.125 0 0 1 .26-1.431l1.004-.827c.292-.24.437-.613.43-.991a6.932 6.932 0 0 1 0-.255c.007-.38-.138-.751-.43-.992l-1.004-.827a1.125 1.125 0 0 1-.26-1.43l1.297-2.247a1.125 1.125 0 0 1 1.37-.491l1.216.456c.356.133.751.072 1.076-.124.072-.044.146-.086.22-.128.332-.183.582-.495.644-.869l.214-1.28Z" />
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M15 12a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                            </svg>

                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Settings</p>
                        </div>
                    </div>
                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                        <span class="rounded-full text-gray-600 p-2">
                            <x-bi-chevron-right class="size-4" />
                        </span>
                    </div>
                </a>
            </li>

            {{-- @if (($affiliate_functionality === true && (in_array(auth()->user()->user_type, ['Sponsored', 'Influencer', 'Gold', 'Platinum']) && !auth()->user()->onTrial())) || !in_array($user->access, ['Month', 'Year'])) --}}

            @if (
                $affiliate_functionality === true &&
                    (in_array(auth()->user()->user_type, ['Sponsored', 'Influencer', 'Gold', 'Platinum']) &&
                        !auth()->user()->onTrial() &&
                        !in_array($user->access, ['Month', 'Year'])))
                <li>
                    <a href="{{ route('dashboard.referrals') }}" class="flex justify-between gap-x-6 sm:py-3">
                        <div class="flex min-w-0 gap-x-4 items-center">
                            <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                                <x-heroicon-o-currency-dollar class="size-5" />
                            </span>
                            <div class="min-w-0 flex-auto">
                                <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Referrals</p>
                            </div>
                        </div>
                        <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                            <span class="rounded-full text-gray-600 p-2">
                                <x-bi-chevron-right class="size-4" />
                                {{-- <span
                                    class="inline-flex items-center rounded-full bg-yellow-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-yellow-700 ring-1 ring-pink-700/10 ring-inset">
                                    New&nbsp;<x-heroicon-s-sparkles class="size-3" />
                                </span> --}}
                            </span>
                        </div>
                    </a>
                </li>

                <li class="flex justify-between gap-x-6 sm:py-3 cursor-pointer"
                    @click="showCopyReferCodeModal=!showCopyReferCodeModal">

                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                            <x-heroicon-o-link class="size-5" />
                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Referral Link</p>
                        </div>
                    </div>
                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                        <span class="rounded-full text-gray-600 p-2">
                            <x-bi-chevron-right class="size-4" />
                        </span>
                    </div>
                </li>
            @endif

            @if (
                $affiliate_functionality === true &&
                    ($checkifactive > 0 &&
                        in_array(auth()->user()->user_type, ['Sponsored', 'Influencer', 'Gold', 'Platinum']) &&
                        !auth()->user()->onTrial()) &&
                    !in_array($user->access, ['Month', 'Year']))
                <li>
                    <a href="{{ route('partnership.index') }}" class="flex justify-between gap-x-6 sm:py-3">
                        <div class="flex min-w-0 gap-x-4 items-center">
                            <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                                <x-heroicon-o-users class="size-5" />
                            </span>
                            <div class="min-w-0 flex-auto">
                                <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Partnership Program
                                </p>
                            </div>
                        </div>
                        <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                            <span class="rounded-full text-gray-600 p-2">
                                {{-- <x-bi-chevron-right class="size-4" /> --}}
                                {{-- <span
                                    class="inline-flex items-center rounded-full bg-yellow-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-yellow-700 ring-1 ring-pink-700/10 ring-inset">
                                    Soon&nbsp;<x-heroicon-s-sparkles class="size-3" />
                                </span> --}}
                                <span
                                    class="inline-flex items-center rounded-full bg-yellow-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-yellow-700 ring-1 ring-pink-700/10 ring-inset">
                                    New&nbsp;<x-heroicon-s-sparkles class="size-3" />
                                </span>

                            </span>
                        </div>
                    </a>
                </li>
            @endif

            @if ($checkifactive > 0)
                {{-- @if ($checkifactive > 0 && !auth()->user()->subscribed()) --}}
                {{-- Upgrade --}}
                {{-- @if (in_array(auth()->user()->user_type, ['Free', 'Basic', 'Gold', 'Sponsored', 'Influencer'])) --}}

                @if (
                    ($platinum_enabled && in_array(auth()->user()->user_type, ['Free', 'Basic', 'Gold', 'Sponsored', 'Influencer'])) ||
                        (!$platinum_enabled && in_array(auth()->user()->user_type, ['Free', 'Basic', 'Sponsored', 'Influencer'])))
                    <li>
                        <a href="{{ route('upgrade.index') }}" class="flex justify-between gap-x-6 sm:py-3">
                            <div class="flex min-w-0 gap-x-4 items-center">
                                <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                                    <x-heroicon-o-bolt class="size-5" />
                                </span>
                                <div class="min-w-0 flex-auto">
                                    <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Upgrade</p>
                                </div>
                            </div>
                            {{-- <div class="shrink-0 sm:flex sm:flex-col justify-center sm:items-end">
                                <span class="rounded-full text-gray-600">
                                    <span
                                        class="inline-flex items-center rounded-full bg-yellow-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-yellow-700 ring-1 ring-pink-700/10 ring-inset">
                                        New&nbsp;<x-heroicon-s-sparkles class="size-3" />
                                    </span>
                                </span>
                            </div> --}}

                            <div class="shrink-0 sm:flex sm:flex-col justify-center sm:items-end">
                                <span class="rounded-full text-gray-600 p-2">
                                    <x-bi-chevron-right class="size-4" />
                                </span>
                            </div>
                        </a>
                    </li>
                @endif

                {{-- Subscription --}}
                <li>
                    <a href="{{ route('dashboard.subscription') }}" class="flex justify-between gap-x-6 sm:py-3">
                        <div class="flex min-w-0 gap-x-4 items-center">
                            <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                                <x-heroicon-o-star class="size-5" />
                            </span>
                            <div class="min-w-0 flex-auto">
                                <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Subscription</p>
                            </div>
                        </div>
                        <div class="shrink-0 sm:flex sm:flex-col justify-center sm:items-end">

                            {{-- <x-bi-chevron-right class="size-4" /> --}}
                            {{-- <span
                                class="inline-flex items-center rounded-full bg-yellow-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-yellow-700 ring-1 ring-pink-700/10 ring-inset">
                                New&nbsp;<x-heroicon-s-sparkles class="size-3" />
                            </span> --}}

                            <span class="rounded-full text-gray-600 p-2">
                                <x-bi-chevron-right class="size-4" />
                            </span>
                        </div>
                    </a>
                </li>
            @endif

            <!-- Logout -->
            <li class="flex justify-between gap-x-6 sm:py-3">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <form class="logoutForm" action="{{ route('logout') }}" method="POST">
                        @csrf
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2 flex items-center">
                            <button type="submit">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="1.5" stroke="currentColor" class="size-5">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M15.75 9V5.25A2.25 2.25 0 0 0 13.5 3h-6a2.25 2.25 0 0 0-2.25 2.25v13.5A2.25 2.25 0 0 0 7.5 21h6a2.25 2.25 0 0 0 2.25-2.25V15m3 0 3-3m0 0-3-3m3 3H9" />
                                </svg>
                            </button>
                        </span>
                    </form>

                    <div class="min-w-0 flex-auto">
                        <form class="logoutForm" action="{{ route('logout') }}" method="POST">
                            @csrf
                            <button type="submit"
                                class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Logout</button>
                        </form>
                    </div>
                </div>
                <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                    <span class="rounded-full text-gray-600 p-2">
                        <form class="logoutForm" action="{{ route('logout') }}" method="POST">
                            @csrf
                            <button type="submit">
                                <x-bi-chevron-right class="size-4" />
                            </button>
                        </form>
                    </span>
                </div>
            </li>

        </ul>

    </div>

</div>
