<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                @if ($user->firstname && $user->lastname && $user->phone && $user->job_title)
                    <a wire:navigate href="{{ route('settings.index') }}"
                        class="rounded-full bg-white p-2 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                stroke="currentColor" class="size-4">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                            </svg>
                        </span>
                    </a>
                @endif
            </div>

            <p
                class="col-span-3 flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold ">

                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M17.982 18.725A7.488 7.488 0 0 0 12 15.75a7.488 7.488 0 0 0-5.982 2.975m11.963 0a9 9 0 1 0-11.963 0m11.963 0A8.966 8.966 0 0 1 12 21a8.966 8.966 0 0 1-5.982-2.275M15 9.75a3 3 0 1 1-6 0 3 3 0 0 1 6 0Z" />
                </svg>

                &nbsp;&nbsp;Edit Profile
            </p>
            <div class="flex items-center col-span-1 place-content-end">
                @if ($user->firstname && $user->lastname && $user->phone && $user->job_title)
                    {{-- <a href="{{ route('card.show', $user['username']) }}"
                        class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                        View Card
                        <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                    </a> --}}

                    <a href="{{ route('card.show', $user['username']) }}"
                        class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                        View Card
                        {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                    </a>
                @endif
            </div>
        </div>

    </div>


    {{-- Profile Photo --}}
    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

        <div class="px-5 pb-5">
            <div class="flex items-center mb-2">
                <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Profile Picture
                </h2>&nbsp;&nbsp;
            </div>
            <div class="grid grid-cols-4 gap-x-6 gap-y-8">

                <div class="col-span-full">
                    <livewire:profile-photo-field :model="auth()->user()" />
                </div>
            </div>
        </div>
    </div>

    {{-- Cover Photo --}}
    @if (auth()->user()->user_type != 'Free')
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5 pb-5">
                <div class="flex items-center mb-2">
                    <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Cover Photo (1080×600px)
                    </h2>&nbsp;&nbsp;
                </div>
                <div class="grid grid-cols-4 gap-x-6 gap-y-8">

                    <div class="col-span-full">

                        @if (empty($this->check_cover))
                            <div @click="openUploadCoverModal=!openUploadCoverModal"
                                class="flex justify-center text-slate-800 dark:text-slate-300 pt-10 cursor-pointer">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="1.5" stroke="currentColor"
                                    class="size-16 text-lg font-bold cursor-pointer">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M3 16.5v2.25A2.25 2.25 0 0 0 5.25 21h13.5A2.25 2.25 0 0 0 21 18.75V16.5m-13.5-9L12 3m0 0 4.5 4.5M12 3v13.5" />
                                </svg>
                            </div>

                            <p class="text-gray-900 dark:text-gray-400 text-center mt-5 text-sm/6">Upload Cover Photo
                            <p>
                            @else
                                <livewire:cover-image-field :model="auth()->user()" />
                                @error('thumbnail')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if (auth()->user()->user_type != 'Free')
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5 pb-5">

                <div class="flex items-center">
                    <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Profile Picture Layout
                    </h2>
                    {{-- &nbsp;&nbsp;

                    <span
                        class="flex items-center rounded-full bg-yellow-100 px-1.5 py-0.5 text-[10px] font-medium text-yellow-700 ring-1 ring-pink-700/10 ring-inset">
                        New&nbsp;<x-heroicon-s-sparkles class="size-3" />
                    </span> --}}
                </div>

                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Style</label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span
                            class="cursor-pointer inline-flex items-center rounded-md bg-gray-100 px-2 py-1 text-xs font-medium text-gray-600 ring-1 ring-gray-500/10 ring-inset"
                            @click="showProfilePicLayoutModal=!showProfilePicLayoutModal">
                            @if ($set_layout == 'default')
                                Default
                            @elseif ($set_layout == 'rounded')
                                Rounded
                            @elseif ($set_layout == 'default_cover')
                                With Cover
                            @elseif ($set_layout == 'full_width')
                                Full Width
                            @else
                                Cover Only
                            @endif
                        </span>
                    </div>
                </div>

            </div>

        </div>
    @endif

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-10 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        {{-- <div class="mx-auto">
            <livewire:profile-photo-field :model="auth()->user()" />
        </div> --}}

        <div class="px-5">
            <form wire:submit.prevent="updateUserProfile()">
                <div class="space-y-12">

                    <div class="border-b border-gray-900/10  dark:border-gray-400 pb-12">
                        <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Account Information</h2>
                        {{-- <p class="mt-1 text-sm/6 text-gray-600">Please provide the necessary details for account
                            registration to complete the process and set up your account.</p> --}}

                        <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">
                            <div class="col-span-full">
                                <label for="username"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Username</label>
                                <div class="mt-2">
                                    <div
                                        class="flex  items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('username') border border-red-600 @enderror">
                                        <div
                                            class="shrink-0 text-base font-medium text-gray-500 select-none sm:text-sm/6">
                                            {{ $site_url }}</div>
                                        <input type="text" wire:model="username"
                                            class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                            placeholder="username" value="{{ old('username', $user['username']) }}">
                                    </div>
                                </div>
                                @error('username')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                    </div>

                    <div class="border-b border-gray-900/10 dark:border-gray-400 pb-12">
                        <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Personal Information
                        </h2>

                        <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">
                            {{-- @if ($maincard_active) --}}
                            <div class="col-span-full sm:col-span-2">
                                <label for="firstname"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">First
                                    name</label>
                                <div class="mt-2">
                                    <input type="text" wire:model="firstname"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('firstname') border border-red-600 @enderror"
                                        value="{{ old('firstname', $user['firstname']) }}">
                                </div>

                                @error('firstname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="lastname"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Last
                                    name</label>
                                <div class="mt-2">
                                    <input type="text" wire:model="lastname"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('lastname') border border-red-600 @enderror"
                                        value="{{ old('lastname', $user['lastname']) }}">
                                </div>

                                @error('lastname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                            {{-- @endif --}}
                            <div class="col-span-full" x-data="() => ({
                                maxChars: 200,
                                text: `{{ addslashes(old('job_title', $user['job_title'] ?? '')) }}`,
                                currentChar: 0,
                                updateCount() {
                                    this.currentChar = this.text.length;
                                },
                                init() {
                                    this.currentChar = this.text.length;
                                }
                            })">
                                <label for="job_title"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Job Title
                                </label>
                                <div class="mt-2">
                                    <input wire:model="job_title" x-model="text" x-on:input="updateCount"
                                        :maxlength="maxChars"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('job_title') border border-red-600 @enderror"
                                        value="{{ old('job_title', $user['job_title']) }}">
                                </div>
                                <p class="mt-3 text-sm/6 text-gray-600">Write your job title/description.
                                    (<span x-text="`${currentChar}/${maxChars}`"
                                        class="text-sm/6 text-gray-600"></span>)
                                </p>

                                @error('job_title')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="company"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Company
                                </label>
                                <div class="mt-2">
                                    <input wire:model="company" type="text"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('company') border border-red-600 @enderror"
                                        value="{{ old('company', $user['company']) }}" placeholder="(Optional)">
                                </div>

                                @error('company')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="company_website"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Company
                                    Website
                                </label>
                                <div class="mt-2">
                                    <input wire:model="company_website" type="text"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('company_website') border border-red-600 @enderror"
                                        value="{{ old('company_website', $user['company_website']) }}"
                                        placeholder="(Optional)">
                                </div>

                                @error('company_website')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror

                                @if (session('company_website'))
                                    <p class="mt-1 text-sm/6 text-red-600">
                                        {{ session('company_website') }}
                                    </p>
                                @endif
                            </div>

                            <div class="col-span-full" x-data="() => ({
                                maxChars: 200,
                                text: `{{ addslashes(old('bio', $user['bio'] ?? '')) }}`,
                                currentChar: 0,
                                updateCount() {
                                    this.currentChar = this.text.length;
                                },
                                init() {
                                    this.currentChar = this.text.length;
                                }
                            })">
                                <label for="bio"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Short
                                    Bio</label>
                                <div class="mt-2">
                                    <textarea wire:model="bio" rows="3" x-model="text" x-on:input="updateCount" :maxlength="maxChars"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6"
                                        placeholder="(Optional)">{{ old('bio', $user['bio']) }}</textarea>
                                </div>
                                <p class="mt-3 text-sm/6 text-gray-600">Write a few sentences about yourself.
                                    (<span x-text="`${currentChar}/${maxChars}`"
                                        class="text-sm/6 text-gray-600"></span>)
                                </p>

                            </div>

                            {{-- @if (in_array($user_type, ['Gold', 'Platinum']))
                                <div class="col-span-full" x-data="() => ({
                                    maxChars: 5000,
                                    text: `{{ addslashes(old('bio_long', $user['bio_long'] ?? '')) }}`,
                                    currentChar: 0,
                                    updateCount() {
                                        this.currentChar = this.text.length;
                                    },
                                    init() {
                                        this.currentChar = this.text.length;
                                    }
                                })">
                                    <label for="bio_long"
                                        class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Long
                                        Bio (Will be displayed in Bio Page)</label>
                                    <div class="mt-2">
                                        <textarea wire:model="bio_long" rows="3" x-model="text" x-on:input="updateCount" :maxlength="maxChars"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6"
                                            placeholder="(Optional)">{{ old('bio_long', $user['bio_long']) }}</textarea>
                                    </div>
                                    <p class="mt-3 text-sm/6 text-gray-600">Write your bio.
                                        (<span x-text="`${currentChar}/${maxChars}`"
                                            class="text-sm/6 text-gray-600"></span>)
                                    </p>

                                </div>
                            @endif --}}

                            @if (in_array($user_type, ['Gold', 'Platinum']))
                                <div class="col-span-full" x-data="richTextEditor()">
                                    <label for="bio_long"
                                        class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">
                                        Long Bio (Will be displayed in Bio Page)
                                    </label>
                                    <div class="mt-2" wire:ignore>
                                        <textarea wire:model="bio_long" x-ref="editor" rows="3" @change="updateCount" :maxlength="maxChars"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6"
                                            placeholder="(Optional)">{{ old('bio_long', $user['bio_long']) }}</textarea>
                                    </div>

                                    <p class="mt-3 text-sm/6 text-gray-600">
                                        Write your bio.
                                        (<span x-text="`${charCount}/${maxChars}`"></span>)
                                    </p>
                                </div>
                            @endif


                            <div class="col-span-full">
                                <label for="phone"
                                    class="block text-sm/6 font-semibold text-gray-900 dark:text-gray-400">Phone
                                    number</label>
                                <div class="mt-2">
                                    <input wire:model="phone" type="tel"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('phone') border border-red-600 @enderror"
                                        placeholder="1234567890" value="{{ old('phone', $user['phone']) }}">
                                </div>

                                @error('phone')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            @if ($maincard_active)
                                <div class="col-span-full sm:col-span-2">
                                    <label for="country"
                                        class="block text-sm/6 font-medium text-gray-900">Country</label>
                                    <div class="mt-2 grid grid-cols-1">
                                        <select id="country" wire:model.live="country" wire:key="country-select"
                                            class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-gray-100 py-1.5 pr-8 pl-3 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('country') border border-red-600 @enderror">
                                            <option value="">Select Country</option>
                                            <option value="United States">United States</option>
                                            <option value="Philippines">Philippines</option>
                                            <option value="Afghanistan">Afghanistan</option>
                                            <option value="Albania">Albania</option>
                                            <option value="Algeria">Algeria</option>
                                            <option value="Andorra">Andorra</option>
                                            <option value="Angola">Angola</option>
                                            <option value="Antigua and Barbuda">Antigua and Barbuda</option>
                                            <option value="Argentina">Argentina</option>
                                            <option value="Armenia">Armenia</option>
                                            <option value="Australia">Australia</option>
                                            <option value="Austria">Austria</option>
                                            <option value="Azerbaijan">Azerbaijan</option>
                                            <option value="Bahamas">Bahamas</option>
                                            <option value="Bahrain">Bahrain</option>
                                            <option value="Bangladesh">Bangladesh</option>
                                            <option value="Barbados">Barbados</option>
                                            <option value="Belarus">Belarus</option>
                                            <option value="Belgium">Belgium</option>
                                            <option value="Belize">Belize</option>
                                            <option value="Benin">Benin</option>
                                            <option value="Bhutan">Bhutan</option>
                                            <option value="Bolivia">Bolivia</option>
                                            <option value="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
                                            <option value="Botswana">Botswana</option>
                                            <option value="Brazil">Brazil</option>
                                            <option value="Brunei">Brunei</option>
                                            <option value="Bulgaria">Bulgaria</option>
                                            <option value="Burkina Faso">Burkina Faso</option>
                                            <option value="Burundi">Burundi</option>
                                            <option value="Cabo Verde">Cabo Verde</option>
                                            <option value="Cambodia">Cambodia</option>
                                            <option value="Cameroon">Cameroon</option>
                                            <option value="Canada">Canada</option>
                                            <option value="Central African Republic">Central African Republic</option>
                                            <option value="Chad">Chad</option>
                                            <option value="Chile">Chile</option>
                                            <option value="China">China</option>
                                            <option value="Colombia">Colombia</option>
                                            <option value="Comoros">Comoros</option>
                                            <option value="Congo (Congo-Brazzaville)">Congo (Congo-Brazzaville)
                                            </option>
                                            <option value="Congo (Congo-Kinshasa)">Congo (Congo-Kinshasa)</option>
                                            <option value="Costa Rica">Costa Rica</option>
                                            <option value="Croatia">Croatia</option>
                                            <option value="Cuba">Cuba</option>
                                            <option value="Cyprus">Cyprus</option>
                                            <option value="Czech Republic">Czech Republic</option>
                                            <option value="Denmark">Denmark</option>
                                            <option value="Djibouti">Djibouti</option>
                                            <option value="Dominica">Dominica</option>
                                            <option value="Dominican Republic">Dominican Republic</option>
                                            <option value="Ecuador">Ecuador</option>
                                            <option value="Egypt">Egypt</option>
                                            <option value="El Salvador">El Salvador</option>
                                            <option value="Equatorial Guinea">Equatorial Guinea</option>
                                            <option value="Eritrea">Eritrea</option>
                                            <option value="Estonia">Estonia</option>
                                            <option value="Eswatini">Eswatini</option>
                                            <option value="Ethiopia">Ethiopia</option>
                                            <option value="Fiji">Fiji</option>
                                            <option value="Finland">Finland</option>
                                            <option value="France">France</option>
                                            <option value="Gabon">Gabon</option>
                                            <option value="Gambia">Gambia</option>
                                            <option value="Georgia">Georgia</option>
                                            <option value="Germany">Germany</option>
                                            <option value="Ghana">Ghana</option>
                                            <option value="Greece">Greece</option>
                                            <option value="Grenada">Grenada</option>
                                            <option value="Guatemala">Guatemala</option>
                                            <option value="Guinea">Guinea</option>
                                            <option value="Guinea-Bissau">Guinea-Bissau</option>
                                            <option value="Guyana">Guyana</option>
                                            <option value="Haiti">Haiti</option>
                                            <option value="Honduras">Honduras</option>
                                            <option value="Hungary">Hungary</option>
                                            <option value="Iceland">Iceland</option>
                                            <option value="India">India</option>
                                            <option value="Indonesia">Indonesia</option>
                                            <option value="Iran">Iran</option>
                                            <option value="Iraq">Iraq</option>
                                            <option value="Ireland">Ireland</option>
                                            <option value="Israel">Israel</option>
                                            <option value="Italy">Italy</option>
                                            <option value="Jamaica">Jamaica</option>
                                            <option value="Japan">Japan</option>
                                            <option value="Jordan">Jordan</option>
                                            <option value="Kazakhstan">Kazakhstan</option>
                                            <option value="Kenya">Kenya</option>
                                            <option value="Kiribati">Kiribati</option>
                                            <option value="Korea, North">Korea, North</option>
                                            <option value="Korea, South">Korea, South</option>
                                            <option value="Kuwait">Kuwait</option>
                                            <option value="Kyrgyzstan">Kyrgyzstan</option>
                                            <option value="Laos">Laos</option>
                                            <option value="Latvia">Latvia</option>
                                            <option value="Lebanon">Lebanon</option>
                                            <option value="Lesotho">Lesotho</option>
                                            <option value="Liberia">Liberia</option>
                                            <option value="Libya">Libya</option>
                                            <option value="Liechtenstein">Liechtenstein</option>
                                            <option value="Lithuania">Lithuania</option>
                                            <option value="Luxembourg">Luxembourg</option>
                                            <option value="Madagascar">Madagascar</option>
                                            <option value="Malawi">Malawi</option>
                                            <option value="Malaysia">Malaysia</option>
                                            <option value="Maldives">Maldives</option>
                                            <option value="Mali">Mali</option>
                                            <option value="Malta">Malta</option>
                                            <option value="Marshall Islands">Marshall Islands</option>
                                            <option value="Mauritania">Mauritania</option>
                                            <option value="Mauritius">Mauritius</option>
                                            <option value="Mexico">Mexico</option>
                                            <option value="Micronesia">Micronesia</option>
                                            <option value="Moldova">Moldova</option>
                                            <option value="Monaco">Monaco</option>
                                            <option value="Mongolia">Mongolia</option>
                                            <option value="Montenegro">Montenegro</option>
                                            <option value="Morocco">Morocco</option>
                                            <option value="Mozambique">Mozambique</option>
                                            <option value="Myanmar (Burma)">Myanmar (Burma)</option>
                                            <option value="Namibia">Namibia</option>
                                            <option value="Nauru">Nauru</option>
                                            <option value="Nepal">Nepal</option>
                                            <option value="Netherlands">Netherlands</option>
                                            <option value="New Zealand">New Zealand</option>
                                            <option value="Nicaragua">Nicaragua</option>
                                            <option value="Niger">Niger</option>
                                            <option value="Nigeria">Nigeria</option>
                                            <option value="North Macedonia">North Macedonia</option>
                                            <option value="Norway">Norway</option>
                                            <option value="Oman">Oman</option>
                                            <option value="Pakistan">Pakistan</option>
                                            <option value="Palau">Palau</option>
                                            <option value="Panama">Panama</option>
                                            <option value="Papua New Guinea">Papua New Guinea</option>
                                            <option value="Paraguay">Paraguay</option>
                                            <option value="Peru">Peru</option>
                                            <option value="Poland">Poland</option>
                                            <option value="Portugal">Portugal</option>
                                            <option value="Qatar">Qatar</option>
                                            <option value="Romania">Romania</option>
                                            <option value="Russia">Russia</option>
                                            <option value="Rwanda">Rwanda</option>
                                            <option value="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
                                            <option value="Saint Lucia">Saint Lucia</option>
                                            <option value="Saint Vincent and the Grenadines">Saint Vincent and the
                                                Grenadines</option>
                                            <option value="Samoa">Samoa</option>
                                            <option value="San Marino">San Marino</option>
                                            <option value="Sao Tome and Principe">Sao Tome and Principe</option>
                                            <option value="Saudi Arabia">Saudi Arabia</option>
                                            <option value="Senegal">Senegal</option>
                                            <option value="Serbia">Serbia</option>
                                            <option value="Seychelles">Seychelles</option>
                                            <option value="Sierra Leone">Sierra Leone</option>
                                            <option value="Singapore">Singapore</option>
                                            <option value="Slovakia">Slovakia</option>
                                            <option value="Slovenia">Slovenia</option>
                                            <option value="Solomon Islands">Solomon Islands</option>
                                            <option value="Somalia">Somalia</option>
                                            <option value="South Africa">South Africa</option>
                                            <option value="South Sudan">South Sudan</option>
                                            <option value="Spain">Spain</option>
                                            <option value="Sri Lanka">Sri Lanka</option>
                                            <option value="Sudan">Sudan</option>
                                            <option value="Suriname">Suriname</option>
                                            <option value="Sweden">Sweden</option>
                                            <option value="Switzerland">Switzerland</option>
                                            <option value="Syria">Syria</option>
                                            <option value="Taiwan">Taiwan</option>
                                            <option value="Tajikistan">Tajikistan</option>
                                            <option value="Tanzania">Tanzania</option>
                                            <option value="Thailand">Thailand</option>
                                            <option value="Timor-Leste">Timor-Leste</option>
                                            <option value="Togo">Togo</option>
                                            <option value="Tonga">Tonga</option>
                                            <option value="Trinidad and Tobago">Trinidad and Tobago</option>
                                            <option value="Tunisia">Tunisia</option>
                                            <option value="Turkey">Turkey</option>
                                            <option value="Turkmenistan">Turkmenistan</option>
                                            <option value="Tuvalu">Tuvalu</option>
                                            <option value="Uganda">Uganda</option>
                                            <option value="Ukraine">Ukraine</option>
                                            <option value="United Arab Emirates">United Arab Emirates</option>
                                            <option value="United Kingdom">United Kingdom</option>
                                            <option value="Uruguay">Uruguay</option>
                                            <option value="Uzbekistan">Uzbekistan</option>
                                            <option value="Vanuatu">Vanuatu</option>
                                            <option value="Vatican City">Vatican City</option>
                                            <option value="Venezuela">Venezuela</option>
                                            <option value="Vietnam">Vietnam</option>
                                            <option value="Yemen">Yemen</option>
                                            <option value="Zambia">Zambia</option>
                                            <option value="Zimbabwe">Zimbabwe</option>
                                        </select>

                                        <svg class="pointer-events-none col-start-1 row-start-1 mr-2 size-5 self-center justify-self-end text-gray-500 sm:size-4"
                                            viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"
                                            data-slot="icon">
                                            <path fill-rule="evenodd"
                                                d="M4.22 6.22a.75.75 0 0 1 1.06 0L8 8.94l2.72-2.72a.75.75 0 1 1 1.06 1.06l-3.25 3.25a.75.75 0 0 1-1.06 0L4.22 7.28a.75.75 0 0 1 0-1.06Z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </div>

                                    @error('country')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="col-span-full sm:col-span-2">
                                    <label for="state"
                                        class="block text-sm/6 font-medium text-gray-900">State</label>
                                    <div class="mt-2 grid grid-cols-1">
                                        <select id="state" wire:model="state" wire:key="state-select"
                                            @if (empty($availableStates)) disabled @endif
                                            class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-gray-100 py-1.5 pr-8 pl-3 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('state') border border-red-600 @enderror">
                                            <option value="">Select State</option>
                                            @foreach ($availableStates as $stateName => $value)
                                                <option value="{{ $stateName }}" {{-- @if ($stateName === $state) selected @endif --}}>
                                                    {{ $stateName }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <svg class="pointer-events-none col-start-1 row-start-1 mr-2 size-5 self-center justify-self-end text-gray-500 sm:size-4"
                                            viewBox="0 0 16 16" fill="currentColor" aria-hidden="true"
                                            data-slot="icon">
                                            <path fill-rule="evenodd"
                                                d="M4.22 6.22a.75.75 0 0 1 1.06 0L8 8.94l2.72-2.72a.75.75 0 1 1 1.06 1.06l-3.25 3.25a.75.75 0 0 1-1.06 0L4.22 7.28a.75.75 0 0 1 0-1.06Z"
                                                clip-rule="evenodd" />
                                        </svg>
                                    </div>

                                    @error('state')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            @endif

                        </div>
                    </div>

                </div>


                <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                    <button type="submit"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">Update
                        Profile</button>
                </div>
            </form>
        </div>


    </div>
