<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">

                @if (auth()->user()->user_type != 'Free')
                    <a wire:navigate href="{{ route('dashboard.links') }}"
                        class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                        <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                            </svg>
                        </span>
                    </a>
                @endif
            </div>
            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M15.75 10.5V6a3.75 3.75 0 1 0-7.5 0v4.5m11.356-1.993 1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 0 1-1.12-1.243l1.264-12A1.125 1.125 0 0 1 5.513 7.5h12.974c.576 0 1.059.435 1.119 1.007ZM8.625 10.5a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm7.5 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z" />
                </svg>

                &nbsp;&nbsp;Products
            </p>

            <div class="flex items-center col-span-1 place-content-end">
                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a> --}}

                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-xs font-semibold shadow-xs flex bg-white text-black items-center">
                    View&nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" />
                </a> --}}

                <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>
        </div>

    </div>

    {{-- Products --}}
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">
        @if ($products)
            <div class="grid grid-cols-3 mt-5 gap-4">

                <div class="h-fit col-span-2">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Product
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">A single item for sale with its own details,
                        images, and price.</p>
                </div>

                <div class="flex items-center col-span-1 place-content-end">
                    <a wire:navigate href="{{ route('product.add') }}"
                        class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="size-6">
                                <path fill-rule="evenodd"
                                    d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                    clip-rule="evenodd" />
                            </svg>
                        </span>
                    </a>
                </div>
            </div>
        @endif
    </div>

    @if (!$products)
        <div class="flex justify-center my-20">
            <a wire:navigate href="{{ route('product.add') }}"
                class="flex items-center mx-auto bg-blue-500 text-white px-3.5 py-1.5 text-base rounded-md">Add
                Product(s) &nbsp;
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-4">
                    <path fill-rule="evenodd"
                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                        clip-rule="evenodd" />
                </svg>
            </a>

        </div>
    @endif

    @if ($products)
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">
            <p class="text-slate-600 dark:text-slate-500 text-sm text-center mb-10">Drag the element to rearrange.</p>
            {{-- Display Sortable product here --}}
            <livewire:sortable-product />
        </div>
    @endif
</div>
