<div x-data="{ submitting: false, isOnDeal: @entangle('is_on_deal'), type: @entangle('type'), deal_type: @entangle('deal_type') }" x-on:set-submitting.window="submitting = $event.detail.value">
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.product') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M15.75 10.5V6a3.75 3.75 0 1 0-7.5 0v4.5m11.356-1.993 1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 0 1-1.12-1.243l1.264-12A1.125 1.125 0 0 1 5.513 7.5h12.974c.576 0 1.059.435 1.119 1.007ZM8.625 10.5a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm7.5 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z" />
                </svg>
                &nbsp;&nbsp;Update Product
            </p>
        </div>
    </div>

    {{-- Video Gallery --}}

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 sm:py-10 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

        @if ($product_videos < 3)
            <div class="grid grid-cols-3 gap-4 px-5 @if ($product_videos > 0) mb-10 @endif">
                <div class="h-fit col-span-2">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Add New Video
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">Add new video(s) for the product page. Max of
                        3 videos.
                    </p>
                </div>

                <div class="flex items-center col-span-1 place-content-end">
                    <a wire:navigate href="{{ route('product-video.add', $productId) }}"
                        class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="size-6">
                                <path fill-rule="evenodd"
                                    d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                    clip-rule="evenodd" />
                            </svg>
                        </span>
                    </a>
                </div>
            </div>
        @endif

        @if ($product_videos > 1)
            {{-- Display all sortable sales here --}}
            <p class="text-slate-600 dark:text-slate-500 text-sm text-center mb-10">Drag the element to rearrange.
            </p>
        @endif

        @if ($product_videos > 0)
            <livewire:sortable-sales-video :product_id="$productId" />
        @endif
    </div>

    {{-- Image Gallery --}}
    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 sm:py-10 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

        @if ($product_images < 10)
            <div class="grid grid-cols-3 gap-4 px-5 @if ($product_images > 0) mb-10 @endif">
                <div class="h-fit col-span-2">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Add New Image
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">Add new image(s) for the product page. Max
                        of 10 images.
                    </p>
                </div>

                <div class="flex items-center col-span-1 place-content-end">
                    <a wire:navigate href="{{ route('product-image.add', $productId) }}"
                        class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="size-6">
                                <path fill-rule="evenodd"
                                    d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                    clip-rule="evenodd" />
                            </svg>
                        </span>
                    </a>
                </div>
            </div>
        @endif

        @if ($product_images > 1)
            {{-- Display all sortable sales here --}}
            <p class="text-slate-600 dark:text-slate-500 text-sm text-center mb-10">Drag the element to rearrange.
            </p>
        @endif

        @if ($product_images > 0)
            <livewire:sortable-sales-image :product_id="$productId" />
        @endif

    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        <form wire:submit.prevent="updateProduct()" class="px-5" @submit="submitting=true">
            <div class="space-y-12">

                <div class="border-b border-gray-900/10  dark:border-gray-400 pb-12">

                    <div class="grid gap-x-6 gap-y-8">
                        <div>
                            <livewire:product-image-field featured_image="{{ $featured_image }}" />
                            @error('featured_image')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Product Name --}}
                        <div class="col-span-full">
                            <label for="product_name"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Product
                                Name</label>
                            <div class="mt-2">
                                <div
                                    class="flex  items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('product_name') border border-red-600 @enderror">

                                    <input type="text" wire:model="product_name"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        placeholder="Boxing Gloves"
                                        value="{{ old('product_name', $product['product_name']) }}">
                                </div>
                            </div>
                            @error('product_name')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Product Type --}}
                        <div class="col-span-full">
                            <label for="type"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Product
                                Type</label>
                            <div class="mt-2">
                                <select x-model="type"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6">
                                    <option value="physical">Physical</option>
                                    <option value="digital">Digital</option>
                                </select>
                            </div>
                        </div>

                        {{-- Stock --}}
                        <div class="col-span-full">
                            <label for="stock"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Stock
                            </label>
                            <div class="mt-2">
                                <div
                                    class="flex items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('stock') border border-red-600 @enderror">

                                    <input type="number" value="1" min="1" max="999"
                                        wire:model="stock"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        value="{{ old('stock') }}">
                                </div>
                            </div>
                            @error('stock')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="price"
                                class="block text-sm/6 font-semibold text-gray-900 dark:text-gray-400">Product
                                Price</label>
                            <div class="mt-2">
                                <input wire:model="price" type="text"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('price') border border-red-600 @enderror"
                                    placeholder="$100" value="{{ old('price', $product['price']) }}">
                            </div>

                            @error('price')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="is_on_deal" class="text-sm/6 font-medium text-gray-900 dark:text-gray-400">Is
                                on Sale </label>
                            <span class="rounded-full text-gray-600">
                                <button type="button" id="is_on_deal" @click="isOnDeal=!isOnDeal"
                                    class="mt-2 flex w-8 flex-none cursor-pointer rounded-full"
                                    :class="isOnDeal ? 'bg-green-400' : 'bg-gray-200'" role="switch"
                                    aria-checked="false" aria-labelledby="switch-1-label">
                                    <span aria-hidden="true"
                                        class="size-4 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"
                                        :class="isOnDeal ? 'translate-x-3.5' : 'translate-x-0'"></span>
                                </button>
                            </span>
                        </div>

                        <div x-show="isOnDeal" class="col-span-full space-y-4">
                            {{-- <label class="block text-sm font-medium text-gray-900 dark:text-gray-400">
                                Sale Duration
                            </label> --}}

                            {{-- Sale Start --}}
                            <div class="col-span-full">
                                <label for="deal_starts_at"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Sale Starts
                                    At</label>
                                <div class="mt-2">
                                    <div
                                        class="flex items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('deal_starts_at') border border-red-600 @enderror">
                                        <input type="date" wire:model="deal_starts_at" :disabled="!isOnDeal"
                                            min="{{ now()->toDateString() }}"
                                            class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md">
                                    </div>
                                </div>
                                @error('deal_starts_at')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            {{-- Sale End --}}
                            <div class="col-span-full">
                                <label for="deal_ends_at"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Sale Ends
                                    At</label>
                                <div class="mt-2">
                                    <div
                                        class="flex items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('deal_ends_at') border border-red-600 @enderror">
                                        <input type="date" wire:model="deal_ends_at" :disabled="!isOnDeal"
                                            min="{{ now()->addDay()->toDateString() }}"
                                            class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md">
                                    </div>
                                </div>
                                @error('deal_ends_at')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>


                            {{-- Deal Type --}}
                            <div class="col-span-full">
                                <label for="deal_type"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Deal
                                    Type</label>
                                <div class="mt-2">
                                    <select x-model="deal_type" :disabled="!isOnDeal"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6">
                                        <option value="price">Deal Price</option>
                                        <option value="discount">Discount Percentage</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-span-full" x-show="deal_type === 'price'">
                                <label for="deal_price"
                                    class="block text-sm/6 font-semibold text-gray-900 dark:text-gray-400">Deal
                                    Price</label>
                                <div class="mt-2">
                                    <input wire:model="deal_price" type="text" :disabled="!isOnDeal"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('deal_price') border border-red-600 @enderror">
                                </div>

                                @error('deal_price')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full" x-show="deal_type === 'discount'">
                                <label for="discount_percentage"
                                    class="block text-sm/6 font-semibold text-gray-900 dark:text-gray-400">Discount
                                    (%)</label>
                                <div class="mt-2">
                                    <input wire:model="discount_percentage" type="text" :disabled="!isOnDeal"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('discount_percentage') border border-red-600 @enderror">
                                </div>

                                @error('discount_percentage')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <div class="col-span-full">
                            <label for="shop_online_button"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Shop Button Text
                            </label>
                            <div class="mt-2">
                                <div
                                    class="flex items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('shop_online_button') border border-red-600 @enderror">

                                    <input type="text" wire:model="shop_online_button"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        placeholder="Default: Shop Online" value="{{ old('shop_online_button') }}">
                                </div>
                            </div>
                            @error('shop_online_button')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="shop_online_link"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Shop Online Link
                            </label>
                            <div class="mt-2">
                                <input wire:model="shop_online_link"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('shop_online_link') border border-red-600 @enderror"
                                    placeholder="https://www.paypal.com/paypalme/giojitsumma"
                                    value="{{ old('shop_online_link') }}">
                            </div>

                            @error('shop_online_link')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Sizes --}}
                        <div class="col-span-full" x-show="type === 'physical'">
                            <label for="sizes"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Sizes</label>
                            <div class="mt-2">
                                <input type="text" wire:model="sizesInput"
                                    placeholder="Add sizes separated by comma (S,M,L,XL)"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 sm:text-sm/6">
                            </div>
                        </div>

                        {{-- Colors --}}
                        <div class="col-span-full" x-show="type === 'physical'">
                            <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Colors</label>
                            <div class="mt-2 space-y-2">
                                @foreach ($colors as $index => $color)
                                    <div class="flex gap-2 items-center">
                                        <input type="text" placeholder="Color Name"
                                            wire:model="colors.{{ $index }}.name"
                                            class="block rounded-md bg-gray-100 px-3 py-1 text-base text-gray-900 sm:text-sm/6">
                                        <input type="color" wire:model="colors.{{ $index }}.value"
                                            class="w-10 h-10 rounded border border-gray-300">
                                        <button type="button" wire:click="removeColor({{ $index }})"
                                            class="text-red-600">Remove</button>
                                    </div>
                                @endforeach
                                <button type="button" wire:click="addColor"
                                    class="mt-2 px-3 py-1 bg-yellow-400 rounded text-black hover:bg-yellow-500">Add
                                    Color</button>
                            </div>
                        </div>

                        {{-- Styles --}}
                        <div class="col-span-full" x-show="type === 'physical'">
                            <label for="styles"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Styles</label>
                            <div class="mt-2">
                                <input type="text" wire:model="stylesInput"
                                    placeholder="Add styles separated by comma (Casual, Formal, Sport)"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 sm:text-sm/6">
                            </div>
                        </div>

                        {{-- <div class="col-span-full" x-data="() => ({
                            maxChars: 1000,
                            text: `{{ addslashes(old('description', $product['description'] ?? '')) }}`,
                            currentChar: 0,
                            updateCount() {
                                this.currentChar = this.text.length;
                            },
                            init() {
                                this.currentChar = this.text.length;
                            }
                        })">
                            <label for="description"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Description</label>
                            <div class="mt-2">
                                <textarea wire:model="description" rows="3" x-model="text" x-on:input="updateCount" :maxlength="maxChars"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('payment_link') border border-red-600 @enderror"
                                    placeholder="I'm Awesome and you know it.">{{ old('description', $product['description']) }}</textarea>
                            </div>

                            @error('description')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror

                            <p class="mt-3 text-sm/6 text-gray-600">Write a few sentences about the product.
                                (<span x-text="`${currentChar}/${maxChars}`" class="text-sm/6 text-gray-600"></span>)
                            </p>

                        </div> --}}

                        {{-- <div class="col-span-full">
                            <label for="category_id"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Category</label>
                            <div class="mt-2">
                                <select wire:model="category_id" multiple
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900">
                                    @foreach ($categories as $category)
                                        <option value="{{ $category->id }}">
                                            {{ $category->title }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            @error('category_id')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div> --}}

                        <div x-data="multiSelect({
                            options: @js($categories->map(fn($c) => ['id' => $c->id, 'label' => $c->title])),
                            selected: @entangle('category_id').live
                        })" class="relative">
                            <label class="block text-sm font-medium text-gray-900 dark:text-gray-400 mb-1">
                                Categories
                            </label>

                            <!-- Selected tags + trigger -->
                            <div @click="toggle"
                                class="min-h-[42px] flex flex-wrap items-center gap-2 rounded-md bg-gray-100 px-3 py-2 cursor-pointer border border-gray-300 focus-within:border-yellow-500">
                                <template x-if="selected.length === 0">
                                    <span class="text-gray-400 text-sm">Select categories</span>
                                </template>

                                <template x-for="item in selectedItems" :key="item.id">
                                    <span
                                        class="flex items-center gap-1 bg-yellow-400 text-black text-sm px-2 py-1 rounded-full">
                                        <span x-text="item.label"></span>
                                        <button type="button" @click.stop="remove(item.id)"
                                            class="text-black hover:text-red-600">
                                            ×
                                        </button>
                                    </span>
                                </template>
                            </div>

                            <!-- Dropdown -->
                            <div x-show="open" @click.outside="close" x-transition
                                class="absolute z-20 mt-1 w-full rounded-md bg-white shadow-lg border border-gray-200 max-h-60 overflow-auto">
                                <template x-for="option in options" :key="option.id">
                                    <div @click="toggleItem(option.id)"
                                        class="px-3 py-2 cursor-pointer flex justify-between items-center hover:bg-yellow-50">
                                        <span x-text="option.label"></span>

                                        <span x-show="selected.includes(option.id)" class="text-yellow-500 font-bold">
                                            ✓
                                        </span>
                                    </div>
                                </template>
                            </div>
                        </div>

                        {{-- <div class="col-span-full">
                            <label for="collection_id"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Collection</label>
                            <div class="mt-2">

                                <select wire:model="collection_id" multiple
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900">
                                    @foreach ($collections as $collection)
                                        <option value="{{ $collection->id }}">
                                            {{ $collection->title }}
                                        </option>
                                    @endforeach
                                </select>

                            </div>
                            @error('collection_id')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div> --}}

                        <div x-data="multiSelect({
                            options: @js($collections->map(fn($c) => ['id' => $c->id, 'label' => $c->title])),
                            selected: @entangle('collection_id').live
                        })" class="relative mt-6">
                            <label class="block text-sm font-medium text-gray-900 dark:text-gray-400 mb-1">
                                Collections
                            </label>

                            <!-- Selected tags + trigger -->
                            <div @click="toggle"
                                class="min-h-[42px] flex flex-wrap items-center gap-2 rounded-md bg-gray-100 px-3 py-2 cursor-pointer border border-gray-300 focus-within:border-yellow-500">
                                <template x-if="selected.length === 0">
                                    <span class="text-gray-400 text-sm">Select categories</span>
                                </template>

                                <template x-for="item in selectedItems" :key="item.id">
                                    <span
                                        class="flex items-center gap-1 bg-yellow-400 text-black text-sm px-2 py-1 rounded-full">
                                        <span x-text="item.label"></span>
                                        <button type="button" @click.stop="remove(item.id)"
                                            class="text-black hover:text-red-600">
                                            ×
                                        </button>
                                    </span>
                                </template>
                            </div>

                            <!-- Dropdown -->
                            <div x-show="open" @click.outside="close" x-transition
                                class="absolute z-20 mt-1 w-full rounded-md bg-white shadow-lg border border-gray-200 max-h-60 overflow-auto">
                                <template x-for="option in options" :key="option.id">
                                    <div @click="toggleItem(option.id)"
                                        class="px-3 py-2 cursor-pointer flex justify-between items-center hover:bg-yellow-50">
                                        <span x-text="option.label"></span>

                                        <span x-show="selected.includes(option.id)" class="text-yellow-500 font-bold">
                                            ✓
                                        </span>
                                    </div>
                                </template>
                            </div>
                        </div>

                        <div class="col-span-full" x-data="richTextEditor()">
                            <label for="description"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">
                                Description
                            </label>
                            <div class="mt-2" wire:ignore>
                                <textarea wire:model="description" x-ref="editor" rows="3" @change="updateCount" :maxlength="maxChars"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6">{{ old('description', $product['description']) }}</textarea>
                            </div>

                            @error('description')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror

                            <p class="mt-3 text-sm/6 text-gray-600">
                                Write a few sentences about the product.
                                (<span x-text="`${charCount}/${maxChars}`"></span>)
                            </p>
                        </div>
                    </div>
                </div>
            </div>


            <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                <button type="submit" :disabled="submitting"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">

                    <!-- Normal text -->
                    <span x-show="!submitting">Update
                        Product</span>

                    <!-- Saving text -->
                    <span x-show="submitting" class="inline-flex items-center justify-center space-x-2">
                        <span class="text-white">Saving...</span>
                        <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg"
                            fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                                stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z">
                            </path>
                        </svg>
                    </span>
                </button>
            </div>
        </form>
    </div>

</div>
