<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('customization.index') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="col-span-3 flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold ">

                <x-heroicon-o-cog-6-tooth class="size-6 inline-block" />

                &nbsp;&nbsp;Card Customization
            </p>

        </div>

    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

        <div class="px-5">
            {{-- <form wire:submit.prevent="updateCardTitle()"> --}}
            <div class="space-y-12">

                <div class="pb-10">
                    <div class="flex items-center">
                        <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Thumbnail

                        </h2>&nbsp;&nbsp;

                        {{-- <span
                            class="flex items-center rounded-full bg-yellow-100 px-1.5 py-0.5 text-[10px] font-medium text-yellow-700 ring-1 ring-pink-700/10 ring-inset">
                            New&nbsp;<x-heroicon-s-sparkles class="size-3" />
                        </span> --}}
                    </div>
                    {{-- <livewire:profile-photo-field :model="auth()->user()" /> --}}
                    <div class="mt-5 grid grid-cols-4 gap-x-6 gap-y-8">

                        <div class="col-span-full">
                            <label for="thumbnail"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400 mb-10">Your
                                profile
                                picture is the default card thumbnail. If you wish to change the thumbnail, upload
                                it
                                here.</label>
                            <div class="mt-2">
                                <livewire:thumbnail-image-field :model="auth()->user()" />
                            </div>

                            @error('thumbnail')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

        <div class="px-5">
            <form wire:submit.prevent="updateCardText()">
                <div class="space-y-12">

                    <div class="pb-10">
                        <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Card
                        </h2>
                        {{-- <livewire:profile-photo-field :model="auth()->user()" /> --}}
                        <div class="mt-5 grid grid-cols-4 gap-x-6 gap-y-8">

                            {{-- Display Name --}}
                            <div class="col-span-full">
                                <label for="card_custom_title"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Display
                                    Name</label>
                                <div class="mt-2">
                                    <input type="text" wire:model="card_custom_title"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('card_custom_title') border border-red-600 @enderror"
                                        placeholder="Default: {{ $card_custom_title }}"
                                        value="{{ old('card_custom_title', $card_custom_title) }}" />
                                </div>

                                @error('card_custom_title')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            {{-- Custom Page title --}}
                            <div class="col-span-full">
                                <label for="custom_page_title"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Page
                                    Title</label>
                                <div class="mt-2">
                                    <input type="text" wire:model="custom_page_title"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('custom_page_title') border border-red-600 @enderror"
                                        placeholder="Default: {{ $custom_page_title }}"
                                        value="{{ old('custom_page_title', $custom_page_title) }}" />
                                </div>

                                @error('custom_page_title')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            {{-- Contact --}}
                            @if ($user_type != 'Free')
                                <div class="col-span-full">
                                    <label for="contact_text"
                                        class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Contact
                                        Text</label>
                                    <div class="mt-2">
                                        <input type="text" wire:model="contact_text"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('contact_text') border border-red-600 @enderror"
                                            placeholder="Default: Contact me"
                                            value="{{ old('contact_text', $contact_text) }}" />
                                    </div>

                                    @error('contact_text')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                {{-- Follow --}}
                                <div class="col-span-full">
                                    <label for="follow_text"
                                        class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Follow
                                        Text</label>
                                    <div class="mt-2">
                                        <input type="text" wire:model="follow_text"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('follow_text') border border-red-600 @enderror"
                                            placeholder="Default: Follow me"
                                            value="{{ old('follow_text', $follow_text) }}" />
                                    </div>

                                    @error('follow_text')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                {{-- Events --}}
                                <div class="col-span-full">
                                    <label for="event_text"
                                        class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Event
                                        Text</label>
                                    <div class="mt-2">
                                        <input type="text" wire:model="event_text"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('event_text') border border-red-600 @enderror"
                                            placeholder="Default: Events"
                                            value="{{ old('event_text', $event_text) }}" />
                                    </div>

                                    @error('event_text')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                {{-- My Bio --}}
                                <div class="col-span-full">
                                    <label for="payment_text"
                                        class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Payment
                                        Text</label>
                                    <div class="mt-2">
                                        <input type="text" wire:model="payment_text"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('payment_text') border border-red-600 @enderror"
                                            placeholder="Default: My Bio"
                                            value="{{ old('payment_text', $payment_text) }}" />
                                    </div>

                                    @error('payment_text')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            @endif

                            @if (in_array($user_type, ['Gold', 'Platinum']))
                                <div class="col-span-full">
                                    <label for="shop_more"
                                        class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Shop
                                        More
                                    </label>
                                    <div class="mt-2">
                                        <input type="text" wire:model="shop_more"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('shop_more') border border-red-600 @enderror"
                                            placeholder="https://yourshop.com/" />
                                    </div>

                                    @error('shop_more')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="col-span-full">
                                    <label for="shop_text"
                                        class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Shop
                                        Button
                                        Title</label>
                                    <div class="mt-2">
                                        <input type="text" wire:model="shop_text"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('shop_text') border border-red-600 @enderror"
                                            placeholder="Default: Shop" value="{{ old('shop_text', $shop_text) }}" />
                                    </div>

                                    @error('shop_text')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="col-span-full">
                                    <label for="services_text"
                                        class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Services
                                        Button
                                        Title</label>
                                    <div class="mt-2">
                                        <input type="text" wire:model="services_text"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('services_text') border border-red-600 @enderror"
                                            placeholder="Default: Services"
                                            value="{{ old('services_text', $services_text) }}" />
                                    </div>

                                    @error('services_text')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>
                            @endif

                        </div>
                    </div>

                </div>

                <div class="flex items-center justify-end gap-x-6 gap-4">
                    <button type="submit"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 flex">
                        <x-fas-save class="w-4" />&nbsp;&nbsp;Update
                    </button>
                </div>
            </form>
        </div>
    </div>


    @if (in_array($user_type, ['Sponsored', 'Influencer', 'Gold', 'Platinum']))
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5 pb-5">

                <div class="flex items-center">
                    <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Gallery
                    </h2>
                </div>

                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Two images per
                            slide</label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="imageSlideSetting"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $gallery_two_slide ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $gallery_two_slide ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>

                </div>

            </div>
        </div>

        {{-- Click here (Videos) --}}
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5">
                <form wire:submit.prevent="updateClickVideos()">
                    <div class="space-y-12">

                        <div class="pb-10">
                            <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Click here (Videos)
                            </h2>

                            <div class="mt-5 grid grid-cols-4 gap-x-6 gap-y-8">

                                <div class="col-span-full">
                                    <label for="click_videos"
                                        class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Click here
                                        Text</label>
                                    <div class="mt-2">
                                        <input type="text" wire:model="click_videos"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('click_videos') border border-red-600 @enderror"
                                            placeholder="Default: Click here"
                                            value="{{ old('click_videos', $click_videos) }}" />
                                    </div>

                                    @error('click_videos')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="col-span-full">
                                    <label for="click_videos_link"
                                        class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Click here
                                        Link</label>
                                    <div class="mt-2">
                                        <input type="url" wire:model="click_videos_link"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('click_videos_link') border border-red-600 @enderror"
                                            value="{{ old('click_videos_link', $click_videos_link) }}" />
                                    </div>

                                    @error('click_videos_link')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                            </div>
                        </div>

                    </div>

                    <div class="flex items-center justify-end gap-x-6 gap-4">
                        <button type="submit"
                            class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 flex">
                            <x-fas-save class="w-4" />&nbsp;&nbsp;Update
                        </button>
                    </div>
                </form>
            </div>
        </div>

        {{-- Click here (Gallery) --}}
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5">
                <form wire:submit.prevent="updateClickGallery()">
                    <div class="space-y-12">

                        <div class="pb-10">
                            <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Click here
                                (Gallery)
                            </h2>

                            <div class="mt-5 grid grid-cols-4 gap-x-6 gap-y-8">

                                <div class="col-span-full">
                                    <label for="click_gallery"
                                        class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Click here
                                        Text</label>
                                    <div class="mt-2">
                                        <input type="text" wire:model="click_gallery"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('click_gallery') border border-red-600 @enderror"
                                            placeholder="Default: Click here"
                                            value="{{ old('click_gallery', $click_gallery) }}" />
                                    </div>

                                    @error('click_gallery')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="col-span-full">
                                    <label for="click_gallery_link"
                                        class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Click here
                                        Link</label>
                                    <div class="mt-2">
                                        <input type="url" wire:model="click_gallery_link"
                                            class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('click_gallery_link') border border-red-600 @enderror"
                                            value="{{ old('click_gallery_link', $click_gallery_link) }}" />
                                    </div>

                                    @error('click_gallery_link')
                                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                    @enderror
                                </div>

                            </div>
                        </div>

                    </div>

                    <div class="flex items-center justify-end gap-x-6 gap-4">
                        <button type="submit"
                            class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 flex">
                            <x-fas-save class="w-4" />&nbsp;&nbsp;Update
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif

    {{-- Footer Content --}}
    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        <div class="px-5">
            <form wire:submit.prevent="updateFooterLink()">
                <div class="space-y-12">

                    <div class="pb-10">
                        <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Footer Content
                        </h2>

                        <div class="mt-5 grid grid-cols-4 gap-x-6 gap-y-8">

                            <div class="col-span-full">
                                <label for="footer_text"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Footer Link
                                    Text</label>
                                <div class="mt-2">
                                    <input type="text" wire:model="footer_text"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('footer_text') border border-red-600 @enderror"
                                        placeholder="Get your 10k card today!"
                                        value="{{ old('footer_text', $footer_text) }}" />
                                </div>

                                @error('footer_text')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="footer_link"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Footer
                                    Link</label>
                                <div class="mt-2">
                                    <input type="url" wire:model="footer_link"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('footer_link') border border-red-600 @enderror"
                                        placeholder="https://10kcards.site"
                                        value="{{ old('footer_link', $footer_link) }}" />
                                </div>

                                @error('footer_link')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                        </div>
                    </div>

                </div>

                <div class="flex items-center justify-end gap-x-6 gap-4">
                    <button type="submit"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 flex">
                        <x-fas-save class="w-4" />&nbsp;&nbsp;Update
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">
        {{-- <h2 class="text-base/7 text-gray-900 text-center dark:text-gray-400">More settings will be added
            here in
            the future.
        </h2> --}}
    </div>
</div>
