<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.profile') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>
            <p
                class="col-span-3 flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold ">
                <x-heroicon-o-plus class="size-6 inline-block" />
                &nbsp;&nbsp;Add New Card
            </p>
        </div>
    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        {{-- <div class="mx-auto">
            <livewire:profile-photo-field :model="auth()->user()" />
        </div> --}}

        <div class="px-5">
            <form wire:submit.prevent="addNewSubCard()">
                <div class="space-y-12">

                    <div class="border-b border-gray-900/10  dark:border-gray-400 pb-12">
                        <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Account Information</h2>
                        {{-- <p class="mt-1 text-sm/6 text-gray-600">Please provide the necessary details for account
                            registration to complete the process and set up your account.</p> --}}

                        <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">

                            <div class="col-span-full">
                                <livewire:register-profile-picture-field />
                                <p
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400 text-center pt-5">
                                    Profile Picture
                                </p>
                            </div>

                            <div class="col-span-full">
                                <label for="username"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Username</label>
                                <div class="mt-2">
                                    <div
                                        class="flex  items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('username') border border-red-600 @enderror">
                                        <div class="shrink-0 font-medium text-gray-500 select-none text-sm/6">
                                            {{ $site_url }}</div>
                                        <input type="text" wire:model="username"
                                            class="block min-w-0 grow py-1.5 pr-3 pl-1 bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none text-sm/6 rounded-md"
                                            placeholder="username" value="{{ old('username') }}">
                                    </div>
                                </div>

                                @error('username')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror

                                {{-- Custom error message --}}
                                {{-- @if (session('username'))
                                    <p class="mt-1 text-sm/6 text-red-600">
                                        {{ session('username') }}
                                    </p>
                                @endif --}}
                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="firstname"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">First
                                    name</label>
                                <div class="mt-2">
                                    <input type="text" wire:model="firstname"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6 @error('firstname') border border-red-600 @enderror"
                                        value="{{ old('firstname') }}">
                                </div>

                                @error('firstname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="lastname"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Last
                                    name</label>
                                <div class="mt-2">
                                    <input type="text" wire:model="lastname"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6 @error('lastname') border border-red-600 @enderror"
                                        value="{{ old('lastname') }}">
                                </div>

                                @error('lastname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                        </div>

                    </div>

                    <div class="border-b border-gray-900/10 dark:border-gray-400 pb-12">
                        <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Personal Information
                        </h2>

                        <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">

                            <div class="col-span-full">
                                <label for="email"
                                    class="block text-sm/6 font-semibold text-gray-900 dark:text-gray-400">Email</label>
                                <div class="mt-2">
                                    <input wire:model="email" type="email"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6 @error('email') border border-red-600 @enderror"
                                        placeholder="user@website.com" value="{{ old('email') }}">
                                </div>

                                @error('email')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                                {{-- Custom error message --}}
                                {{-- @if (session('email'))
                                    <p class="mt-1 text-sm/6 text-red-600">
                                        {{ session('email') }}
                                    </p>
                                @endif --}}
                            </div>

                            <div class="col-span-full">
                                <label for="phone"
                                    class="block text-sm/6 font-semibold text-gray-900 dark:text-gray-400">Phone
                                    number</label>
                                <div class="mt-2">
                                    <input wire:model="phone" type="tel"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6 @error('phone') border border-red-600 @enderror"
                                        placeholder="1234567890" value="{{ old('phone') }}">
                                </div>

                                @error('phone')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="job_title"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Job Title
                                </label>
                                <div class="mt-2">
                                    <input wire:model="job_title"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5  text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6 @error('job_title') border border-red-600 @enderror"
                                        value="{{ old('job_title') }}">
                                </div>

                                @error('job_title')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="company"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Company
                                </label>
                                <div class="mt-2">
                                    <input wire:model="company" type="text"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6 @error('company') border border-red-600 @enderror"
                                        value="{{ old('company') }}" placeholder="(Optional)">
                                </div>

                                @error('company')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="company_website"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Company Website
                                </label>
                                <div class="mt-2">
                                    <input wire:model="company_website" type="text"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6 @error('company_website') border border-red-600 @enderror"
                                        value="{{ old('company_website') }}" placeholder="(Optional)">
                                </div>

                                @error('company_website')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror

                                {{-- Custom error message --}}
                                @if (session('company_website'))
                                    <p class="mt-1 text-sm/6 text-red-600">
                                        {{ session('company_website') }}
                                    </p>
                                @endif
                            </div>

                            <div class="col-span-full" x-data="{
                                maxChars: 200,
                                text: '{{ old('bio' ?? '') }}',
                                currentChar: '{{ old('bio' ?? '') }}'.length,
                                updateCount() {
                                    this.currentChar = this.text.length;
                                },
                            }">
                                <label for="bio"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Short
                                    Bio</label>
                                <div class="mt-2">
                                    <textarea wire:model="bio" rows="3" x-model="text" x-on:input="updateCount" :maxlength="maxChars"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6"
                                        placeholder="(Optional)">{{ old('bio') }}</textarea>
                                </div>
                                <p class="mt-3 text-sm/6 text-gray-600">Write a few sentences about yourself.
                                    (<span x-text="`${currentChar}/${maxChars}`"
                                        class="text-sm/6 text-gray-600"></span>)
                                </p>

                            </div>

                            {{-- <div class="col-span-full" x-data="{
                                maxChars: 1000,
                                text: '{{ old('bio_long' ?? '') }}',
                                currentChar: '{{ old('bio_long' ?? '') }}'.length,
                                updateCount() {
                                    this.currentChar = this.text.length;
                                },
                            }">
                                <label for="bio_long"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Long
                                    Bio (Will be displayed in Bio Page)</label>
                                <div class="mt-2">
                                    <textarea wire:model="bio_long" rows="3" x-model="text" x-on:input="updateCount" :maxlength="maxChars"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6"
                                        placeholder="(Optional)">{{ old('bio_long') }}</textarea>
                                </div>
                                <p class="mt-3 text-sm/6 text-gray-600">Write your bio.
                                    (<span x-text="`${currentChar}/${maxChars}`"
                                        class="text-sm/6 text-gray-600"></span>)
                                </p>

                            </div> --}}


                            <div class="col-span-full" x-data="richTextEditor()">
                                <label for="bio_long"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">
                                    Long Bio (Will be displayed in Bio Page)
                                </label>
                                <div class="mt-2" wire:ignore>
                                    <textarea wire:model="bio_long" x-ref="editor" rows="3" @change="updateCount" :maxlength="maxChars"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 text-sm/6"
                                        placeholder="(Optional)">{{ old('bio_long') }}</textarea>
                                </div>
                                {{-- <p class="mt-3 text-sm/6 text-gray-600">
                                    Write your bio.
                                </p> --}}

                                <p class="mt-3 text-sm/6 text-gray-600">
                                    Write your bio.
                                    (<span x-text="`${charCount}/${maxChars}`"></span>)
                                </p>
                            </div>

                        </div>
                    </div>

                </div>

                <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                    <button type="submit"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">Add
                        as New Card</button>
                </div>
            </form>
        </div>


    </div>
</div>
