<div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-4 mb-20" id="custom_bg">
    {{-- <p class="rounded-full bg-gray-300 py-1 px-2 text-[8px] text-black mx-auto w-fit">Prototype
        v0.1</p> --}}
    {{-- <div class="sticky top-0 z-10 py-2">
        <div class="relative col-span-full mb-10">

            @php
                $settings = app(\App\Settings\CardDefaultsSetting::class);
            @endphp

            @if ($settings->menu_enabled && !empty($settings->menu_items))
                <div class="absolute top-4 left-4 z-50" x-data="{ open: false }">
                    <!-- Menu Button -->
                    <button @click="open = !open"
                        class="flex items-center gap-1 rounded-md bg-white dark:bg-zinc-900 shadow px-3 py-2 text-sm font-semibold text-slate-700 dark:text-slate-200 hover:bg-gray-100 dark:hover:bg-zinc-800 transition">
                        <x-heroicon-s-bars-3 class="w-5 h-5" />
                        <span>Menu</span>
                    </button>

                    <!-- Dropdown Menu -->
                    <div x-show="open" @click.outside="open = false" x-transition
                        class="absolute mt-2 w-48 rounded-lg shadow-lg bg-white dark:bg-zinc-900 border border-gray-200 dark:border-zinc-700">
                        @foreach ($settings->menu_items as $item)
                            <a href="{{ $item['link'] ?? '#' }}" target="_blank"
                                class="block px-4 py-2 text-sm text-slate-700 dark:text-slate-200 hover:bg-gray-100 dark:hover:bg-zinc-800">
                                {{ $item['title'] ?? 'Untitled' }}
                            </a>
                        @endforeach
                    </div>
                </div>
            @endif

            <livewire:search-user />

        </div>
    </div> --}}

    <div class="sticky top-0 z-20 py-2">
        @php
            $settings = app(\App\Settings\CardDefaultsSetting::class);
        @endphp

        {{-- <div class="relative @if ($settings->menu_position_position === 'right') pt-9 @endif">

            @if ($settings->menu_enabled && !empty($settings->menu_items))
                <div x-data="{ open: false }"
                    class="@if ($settings->menu_position_position === 'left') inline-block relative w-full @else absolute top-0 right-0 @endif">
                    <!-- Menu Button -->
                    <button @click="open=!open"
                        class="flex items-center gap-2 rounded-md bg-white dark:bg-zinc-900 shadow px-3 py-2 text-sm font-semibold text-slate-700 dark:text-slate-200 hover:bg-gray-100 dark:hover:bg-zinc-800 transition"
                        type="button">
                        <x-heroicon-s-bars-3 class="w-5 h-5" />
                        <span>Menu</span>
                    </button>

                    <!-- Full-width Floating Dropdown -->
                    <div x-cloak x-show="open" @click.outside="open = false" x-transition
                        class="absolute left-0 mt-2 w-full rounded-lg shadow-lg bg-white dark:bg-zinc-900 overflow-hidden z-50">
                        @foreach ($settings->menu_items as $item)
                            <a href="{{ $item['link'] ?? '#' }}" target="_blank"
                                class="block px-5 py-3 text-sm text-slate-700 dark:text-slate-200 hover:bg-gray-100 dark:hover:bg-zinc-800">
                                {{ $item['title'] ?? 'Untitled' }}
                            </a>
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Search below menu (not affected by dropdown) -->
            <div class="mt-3">
                <livewire:search-user />
            </div>
        </div> --}}

        {{-- <div class="relative @if ($settings->menu_position_position === 'right') pt-9 @endif"> --}}

        {{-- Menu --}}
        <div class="relative">
            @if ($settings->menu_enabled && !empty($settings->menu_items))
                <div x-data="{ open: false }" class="relative w-full">

                    <!-- Button Wrapper (handles left/right alignment + order) -->
                    <div
                        class="flex
                @if ($settings->menu_position_position === 'right') justify-end @else justify-start @endif
                items-center gap-2 w-full">

                        <!-- LANGUAGE BUTTON -->
                        <button id="languageButton"
                            class="appearance-none text-sm font-semibold flex items-center gap-1 justify-center p-2 rounded-md bg-slate-100 dark:bg-white text-zinc-900 hover:shadow-lg mr-2
                    @if ($settings->menu_position_position === 'right') order-1 @else order-2 @endif">
                            <x-heroicon-o-language class="size-5" id="heroIcon" />
                            <span>Eng/Esp</span>
                        </button>

                        <!-- LANGUAGE MODAL -->
                        <div id="languageModal"
                            class="flex fixed inset-0 bg-black bg-opacity-50 items-center justify-center hidden z-[9999] notranslate"
                            translate="no">

                            <div class="rounded-2xl p-5 w-64 shadow-lg bg-white dark:bg-zinc-900 dark:text-slate-100">
                                <h2 class="text-lg font-semibold mb-4 text-center">Select Language</h2>
                                <div class="space-y-3">

                                    <button
                                        class="lang-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-slate-100 dark:hover:bg-slate-700"
                                        data-lang="en" data-flag="🇺🇸">🇺🇸 English</button>

                                    <button
                                        class="lang-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-slate-100 dark:hover:bg-slate-700"
                                        data-lang="es" data-flag="🇪🇸">🇪🇸 Español</button>

                                    <button
                                        class="lang-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-slate-100 dark:hover:bg-slate-700"
                                        data-lang="tr" data-flag="🇹🇷">🇹🇷 Türkçe</button>

                                    <button
                                        class="lang-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-slate-100 dark:hover:bg-slate-700"
                                        data-lang="fr" data-flag="🇫🇷">🇫🇷 Français</button>

                                    <button
                                        class="lang-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-slate-100 dark:hover:bg-slate-700"
                                        data-lang="ar" data-flag="🇸🇦">🇸🇦 Arabic</button>


                                    <button
                                        class="lang-option w-full flex items-center gap-2 px-3 py-2 rounded-lg hover:bg-slate-100 dark:hover:bg-slate-700"
                                        data-lang="he" data-flag="🇮🇱">🇮🇱 עברית</button>

                                </div>

                                <div class="mt-4 text-center">
                                    <button id="closeModal" class="bg-yellow-500 text-white px-4 py-2 rounded-lg">
                                        Close
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- MENU BUTTON -->
                        <button @click="open=!open"
                            class="flex items-center gap-2 rounded-md bg-white dark:bg-zinc-900 shadow px-3 py-2 text-sm font-semibold text-slate-700 dark:text-slate-200 hover:bg-gray-100 dark:hover:bg-zinc-800 transition
                    @if ($settings->menu_position_position === 'right') order-2 @else order-1 @endif">
                            <x-heroicon-s-bars-3 class="w-5 h-5" />
                            <span>Menu</span>
                        </button>

                    </div>

                    <!-- DROPDOWN MENU -->
                    <div x-cloak x-show="open" @click.outside="open = false" x-transition
                        class="@if ($settings->menu_position_position === 'right') mt-12 @else mt-2 @endif absolute left-0 right-0 rounded-lg shadow-lg bg-white dark:bg-zinc-900 overflow-hidden z-50">

                        @foreach ($settings->menu_items as $item)
                            <a href="{{ $item['link'] ?? '#' }}" target="_blank"
                                class="block px-5 py-3 text-sm text-slate-700 dark:text-slate-200 hover:bg-gray-100 dark:hover:bg-zinc-800">
                                {{ $item['title'] ?? 'Untitled' }}
                            </a>
                        @endforeach

                    </div>

                </div>
            @endif

            <!-- Search below menu -->
            <div class="mt-3">
                <livewire:search-user />
            </div>
        </div>


    </div>

    @if ($settings->landing_page_menu_enabled && !empty($settings->landing_page_menu_items))
        <div class="grid grid-cols-2 justify-center items-center">

            {{-- Mockup Image --}}
            <div
                class="@if ($settings->landing_page_menu_position === 'right') order-1 @else order-2 @endif flex items-center justify-center">
                <img src="{{ $mockup ? asset($mockup) : asset('img/mockup.png') }}"
                    class="w-full floating-animation mx-auto">
            </div>

            {{-- Menu Items --}}
            <div
                class="@if ($settings->landing_page_menu_position === 'right') order-2 text-right @else order-1 @endif flex font-semibold flex-col justify-center">

                @foreach ($settings->landing_page_menu_items as $item)
                    <a href="{{ $item['link'] ?? '#' }}" target="_blank"
                        class="text-base block py-3 text-slate-700 dark:text-slate-200">
                        {{ $item['title'] ?? 'Untitled' }}
                    </a>
                @endforeach
            </div>

        </div>
    @else
        <img src="{{ $mockup ? asset($mockup) : asset('img/mockup.png') }}" class="w-8/12 floating-animation mx-auto">
    @endif


    <h1 class="text-[40px] text-center text-slate-800 dark:text-slate-300 px-2 pt-5 font-bold"
        style="background: linear-gradient(to right, {{ $site_slogan_color_1 }} 10%, {{ $site_slogan_color_2 }} 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;">
        {{ $site_slogan }}</h1>

    {{-- <p class="text-slate-800 dark:text-slate-400 text-lg text-center py-2 px-3 sm:px-5">Effortless sharing,
        eco-friendly, and always up-to-date – <span class="font-semibold">{{ $site_name }}</span> makes
        networking
        smarter, faster, and more efficient.</p> --}}
    {{-- <p class="text-slate-800 dark:text-slate-400 text-lg text-center py-2 px-3 sm:px-5">{{ $site_desc }}</p> --}}
    <p class="text-slate-800 dark:text-slate-400 text-base text-center py-2 px-3 sm:px-5 mb-10">
        {!! strip_tags($site_desc, '<strong><em>') !!}
    </p>

    <div
        class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto p-5 bg-slate-200 dark:bg-zinc-950">
        <!-- <div class="fixed bottom-0 w-full sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto py-2 bg-white dark:bg-zinc-900 rounded-2xl"> -->
        <a href="{{ route('register') }}"
            class="block hover:shadow-lg text-center mx-auto font-bold text-sm rounded-lg px-4 py-3 w-full"
            style="background: {{ $site_button_color }} !important; color: {{ $site_button_text_color }} !important;">
            Sign Up
        </a>

        <p class="mt-2 text-center text-sm text-slate-800 dark:text-slate-400">
            Already have a card?
            <a href="{{ route('login') }}" class="font-medium"
                style="color: {{ $site_link_color }} !important;"><strong>Sign
                    in</strong></a>.
        </p>
    </div>
</div>
