<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('settings.index') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="col-span-3 flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold ">

                <x-heroicon-o-eye class="size-6 inline-block" />

                &nbsp;&nbsp;Visibility
            </p>

        </div>

    </div>

    {{-- Card Visibility --}}
    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

        <div class="px-5 pb-5">

            <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Card
            </h2>

            <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                <div class="flex items-center">
                    <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Search
                        Visibility</label>
                </div>
                <div class="grid items-center justify-items-end">
                    <span class="rounded-full text-gray-600">
                        <button wire:click.prevent="searchVisibility()"
                            class="flex w-8 flex-none cursor-pointer rounded-full {{ $searchable ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                            role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                            <span aria-hidden="true"
                                class="size-4 {{ $searchable ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                        </button>
                    </span>
                </div>
            </div>
            @if (!$checkifactive)
                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Activate
                            Card</label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="cardEnabled()"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $is_active ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $is_active ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>

                </div>
            @endif
        </div>
    </div>

    {{-- Username Handle --}}
    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

        <div class="px-5 pb-5">

            <div class="flex items-center">
                <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Username Handle

                </h2>
            </div>

            <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                <div class="flex items-center">
                    <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Visibility</label>
                </div>
                <div class="grid items-center justify-items-end">
                    <span class="rounded-full text-gray-600">
                        <button wire:click.prevent="displayUsername"
                            class="flex w-8 flex-none cursor-pointer rounded-full {{ $username_enabled ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                            role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                            <span aria-hidden="true"
                                class="size-4 {{ $username_enabled ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                        </button>
                    </span>
                </div>

            </div>

        </div>
    </div>

    {{-- Short Bio --}}
    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

        <div class="px-5 pb-5">

            <div class="flex items-center">
                <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Short Bio

                </h2>
            </div>

            <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                <div class="flex items-center">
                    <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Visibility</label>
                </div>
                <div class="grid items-center justify-items-end">
                    <span class="rounded-full text-gray-600">
                        <button wire:click.prevent="displayShortBio"
                            class="flex w-8 flex-none cursor-pointer rounded-full {{ $short_bio_enabled ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                            role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                            <span aria-hidden="true"
                                class="size-4 {{ $short_bio_enabled ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                        </button>
                    </span>
                </div>

            </div>

        </div>
    </div>

    {{-- Country Visibility --}}
    {{-- @if (in_array($user_type, ['Basic', 'Gold', 'Platinum'])) --}}
    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

        <div class="px-5 pb-5">

            <div class="flex items-center">
                <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Country

                </h2>
            </div>

            <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                <div class="flex items-center">
                    <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Visibility</label>
                </div>
                <div class="grid items-center justify-items-end">
                    <span class="rounded-full text-gray-600">
                        <button wire:click.prevent="displayCountry()"
                            class="flex w-8 flex-none cursor-pointer rounded-full {{ $country_enabled ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                            role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                            <span aria-hidden="true"
                                class="size-4 {{ $country_enabled ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                        </button>
                    </span>
                </div>

            </div>

        </div>
    </div>
    {{-- @endif --}}

    {{-- Exchange Contact Form --}}
    {{-- @if (in_array($user_type, ['Basic', 'Gold', 'Platinum', 'Influencer', 'Sponsored']))
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5 pb-5">

                <div class="flex items-center">
                    <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Exchange Contact

                    </h2>
                </div>

                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Visibility</label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="displayExchangeContact()"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $exchange_contact_enabled ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $exchange_contact_enabled ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>

                </div>

            </div>
        </div>
    @endif --}}

    {{-- Let's Connect Form visibility --}}
    @if (in_array($user_type, ['Basic', 'Gold', 'Platinum', 'Influencer', 'Sponsored']))
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5 pb-5">

                <div class="flex items-center">
                    <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Let's Connect

                    </h2>
                </div>

                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Main
                            Card</label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="enableConnectMain"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $connect_main ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $connect_main ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>

                </div>
                @if (in_array($user_type, ['Gold', 'Platinum']))
                    <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                        <div class="flex items-center">
                            <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Bio
                                Page</label>
                        </div>
                        <div class="grid items-center justify-items-end">
                            <span class="rounded-full text-gray-600">
                                <button wire:click.prevent="enableConnectBio"
                                    class="flex w-8 flex-none cursor-pointer rounded-full {{ $connect_bio ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                    role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                    <span aria-hidden="true"
                                        class="size-4 {{ $connect_bio ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                                </button>
                            </span>
                        </div>

                    </div>
                @endif
                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Icon</label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="enableConnectIcon"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $connect_icon ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $connect_icon ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>

                </div>

            </div>
        </div>
    @endif

    {{-- Click here --}}
    {{-- @if (in_array($user_type, ['Sponsored', 'Influencer', 'Gold', 'Platinum']))
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5 pb-5">

                <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Click here
                </h2>

                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Videos
                        </label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="enableClickVideos()"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $click_videos_enabled ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $click_videos_enabled ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>
                </div>

                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Gallery</label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="enableClickGallery()"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $click_gallery_enabled ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $click_gallery_enabled ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>

                </div>
            </div>
        </div>
    @endif --}}

    {{-- Feedback Form visibility --}}
    {{-- @if (in_array($user_type, ['Basic', 'Gold', 'Platinum', 'Influencer', 'Sponsored']))
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5 pb-5">

                <div class="flex items-center">
                    <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Feedback Form

                    </h2>&nbsp;&nbsp;
                </div>

                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Visibility</label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="enableFeedbackForm"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $feedback_form ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $feedback_form ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>

                </div>
            </div>
        </div>
    @endif --}}

    {{-- Gallery visibility --}}
    @if (in_array($user_type, ['Gold', 'Platinum']))
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5 pb-5">

                <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Gallery
                </h2>

                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Main Card
                        </label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="enableGalleryMain()"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $gallery_main ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $gallery_main ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>
                </div>

                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Bio
                            Page</label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="enableGalleryBio()"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $gallery_bio ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $gallery_bio ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>

                </div>
            </div>
        </div>
    @endif

    @if (in_array($user_type, ['Gold', 'Platinum']))
        {{-- Product Price Visibility --}}
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5 pb-5">

                <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Product Price
                </h2>

                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">
                            Visibility</label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="activateProductPrice"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $product_price_enabled ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $product_price_enabled ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>

                </div>

            </div>
        </div>

        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5 pb-5">

                <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Services Price
                </h2>

                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">
                            Visibility</label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="activateServicesPrice"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $services_price_enabled ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $services_price_enabled ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>

                </div>

            </div>
        </div>
    @endif

    @if (in_array($user_type, ['Gold', 'Platinum']))
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5 pb-5">

                <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">"Get a Card like this" Button
                </h2>

                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">
                            Visibility</label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="activateGetaCard()"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $getacard_enabled ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $getacard_enabled ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>

                </div>

            </div>
        </div>
    @endif

    @if (in_array($user_type, ['Sponsored', 'Influencer', 'Basic', 'Gold', 'Platinum']))
        {{-- Footer Visibility --}}
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            <div class="px-5 pb-5">

                <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Footer
                </h2>

                <div class="mt-5 grid grid-cols-2 gap-x-6 gap-y-8">

                    <div class="flex items-center">
                        <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">
                            Visibility</label>
                    </div>
                    <div class="grid items-center justify-items-end">
                        <span class="rounded-full text-gray-600">
                            <button wire:click.prevent="activateFooter()"
                                class="flex w-8 flex-none cursor-pointer rounded-full {{ $footer_enabled ? 'bg-green-400' : 'bg-gray-200' }} p-px ring-1 ring-gray-900/5 transition-colors duration-200 ease-in-out ring-inset focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-green-600"
                                role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                                <span aria-hidden="true"
                                    class="size-4 {{ $footer_enabled ? 'translate-x-3.5' : 'translate-x-0' }} transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"></span>
                            </button>
                        </span>
                    </div>

                </div>

            </div>
        </div>
    @endif

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">
        <h2 class="text-base/7 text-gray-900 text-center dark:text-gray-400">More settings will be added
            here in
            the future.
        </h2>
    </div>
</div>
