<div class="bg-slate-200 min-h-screen">
    {{-- <div class="flex flex-col justify-center px-6 py-12 lg:px-8"> --}}
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-10 flex flex-col content-center rounded-2xl text-black">

        <img class="mx-auto w-[50%] px-5" src="{{ $logo ? asset($logo) : asset('img/10kcards-black-logo.webp') }}">
        {{-- <p class="rounded-full bg-gray-300 py-1 px-2 text-[8px] text-black mx-auto w-fit mt-2">Prototype
                v0.1</p> --}}
        <h2 class="mt-10 text-center text-2xl/9 font-bold tracking-tight text-gray-900">Select Card</h2>

        <div id="plans" class="sm:mx-auto sm:w-full sm:max-w-lg">

            <p class="mt-1 text-sm/6 text-center text-gray-600">Select the card that aligns with your professional
                objectives.</p>

            <div class="flex items-center space-x-4 mx-auto w-fit mt-10">
                <span class="text-sm font-medium text-gray-700">Annual</span>

                @if ($manual_capture_mode == false || ($manual_capture_mode == true && $manual_capture_mode_annual_only == false))
                    <label class="relative inline-flex items-center cursor-pointer">
                        <input id="billingToggle" type="checkbox" class="sr-only peer" />
                        <div
                            class="w-11 h-6 bg-gray-300 peer-focus:outline-none peer-focus:ring-2 peer-focus:ring-blue-500 rounded-full peer peer-checked:bg-blue-600 transition-colors">
                        </div>
                        <div
                            class="absolute left-0.5 top-0.5 bg-white w-5 h-5 rounded-full transition-transform peer-checked:translate-x-full">
                        </div>
                    </label>

                    <span class="text-sm font-medium text-gray-700">Monthly</span>
                @endif
            </div>

            <div id="annual_plan" class="plan_selection">
                {{-- Basic Annual Plan --}}
                {{-- @if ($current_card === 'Free') --}}
                {{-- @if ($current_card === 'Free' || auth()->user()->onTrial()) --}}
                @if (in_array($current_card, ['Free', 'Sponsored', 'Influencer']) || auth()->user()->trial_ends_at != null)
                    {{-- @if ($current_card === 'Free' || auth()->user()->trial_ends_at != null) --}}
                    <div plan="basic" style="border: 4px solid #facc15;"
                        class="plan mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

                        <div class="grid grid-cols-7 mx-2">

                            <div class="flex items-center col-span-1 justify-center">
                                <x-heroicon-s-check-circle class="ml-2 size-5 text-yellow-400" id="check-icon" />
                                <x-ri-circle-line class="hidden ml-2 size-5 text-gray-400" id="circle-icon" />
                            </div>

                            <div class="flex items-center col-span-5">
                                <div>
                                    <p class="text-xl font-semibold text-gray-900">
                                        {{ $term_basic }}
                                    </p>
                                    @if ($free_trial_enabled)
                                        <p class="text-sm text-gray-500 mt-1">Includes a {{ $free_trial_duration }}-day
                                            free
                                            trial</p>
                                    @endif
                                </div>
                                {{-- <span
                                    class="currentPlan ml-5 rounded-full w-fit bg-yellow-400 py-1 px-2 text-[9px] text-black">
                                    SELECTED
                                </span> --}}

                            </div>
                            <div class="col-span-1 flex items-center justify-end pr-5">
                                <p class="text-xl font-semibold text-gray-900">
                                    $100
                                </p>

                            </div>
                        </div>

                    </div>
                @endif

                {{-- Gold Annual Plan --}}
                @if (in_array($current_card, ['Free', 'Basic', 'Sponsored', 'Influencer']))
                    <div plan="gold" style="border: 4px solid white;"
                        class="plan mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

                        <div class="grid grid-cols-7 mx-2">

                            <div class="flex items-center col-span-1 justify-center">
                                <x-heroicon-s-check-circle class="hidden ml-2 size-5 text-yellow-400" id="check-icon" />
                                <x-ri-circle-line class="ml-2 size-5 text-gray-400" id="circle-icon" />
                            </div>

                            <div class="flex items-center col-span-5">
                                <p class="text-xl font-semibold text-gray-900">
                                    {{ $term_gold }}
                                </p>

                                {{-- <span
                                    class="currentPlan hidden ml-5 rounded-full w-fit bg-yellow-400 py-1 px-2 text-[9px] text-black">
                                    SELECTED
                                </span> --}}
                            </div>
                            <div class="col-span-1 flex items-center justify-end pr-5">
                                <p class="text-xl font-semibold text-gray-900">
                                    $300
                                </p>
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Platinum Annual Plan --}}
                @if ($platinum_enabled)
                    @if (in_array($current_card, ['Free', 'Basic', 'Gold']))
                        <div plan="platinum" style="border: 4px solid white;"
                            class="plan mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

                            <div class="grid grid-cols-7 mx-2">

                                <div class="flex items-center col-span-1 justify-center">
                                    <x-heroicon-s-check-circle class="hidden ml-2 size-5 text-yellow-400"
                                        id="check-icon" />
                                    <x-ri-circle-line class="ml-2 size-5 text-gray-400" id="circle-icon" />
                                </div>

                                <div class="flex items-center col-span-5">
                                    <p class="text-xl font-semibold text-gray-900">
                                        {{ $term_platinum }}
                                    </p>

                                    {{-- <span
                                        class="currentPlan hidden ml-5 rounded-full w-fit bg-yellow-400 py-1 px-2 text-[9px] text-black">
                                        SELECTED
                                    </span> --}}
                                </div>
                                <div class="col-span-1 flex items-center justify-end pr-5">
                                    <p class="text-xl font-semibold text-gray-900">
                                        $600
                                    </p>

                                </div>
                            </div>

                        </div>
                    @endif
                @endif
            </div>

            {{-- @if ($manual_capture_mode && !$manual_capture_mode_annual_only) --}}
            {{-- @if ($manual_capture_mode == false && $manual_capture_mode_annual_only == false) --}}
            <div id="monthly_plan" class="plan_selection hidden">
                {{-- @if ($current_card === 'Free') --}}
                {{-- @if ($current_card === 'Free' || auth()->user()->trial_ends_at != null) --}}
                @if (in_array($current_card, ['Free', 'Sponsored', 'Influencer']) || auth()->user()->trial_ends_at != null)
                    {{-- @if ($current_card === 'Free' || auth()->user()->onTrial()) --}}
                    {{-- Basic Monthly Plan --}}
                    <div plan="basic_m" style="border: 4px solid #facc15;"
                        class="plan mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

                        <div class="grid grid-cols-7 mx-2">

                            <div class="flex items-center col-span-1 justify-center">
                                <x-heroicon-s-check-circle class="ml-2 size-5 text-yellow-400" id="check-icon" />
                                <x-ri-circle-line class="hidden ml-2 size-5 text-gray-400" id="circle-icon" />
                            </div>

                            <div class="flex items-center col-span-5">
                                <div>
                                    <p class="text-xl font-semibold text-gray-900">
                                        {{ $term_basic }}
                                    </p>
                                    @if ($free_trial_enabled)
                                        <p class="text-sm text-gray-500 mt-1">Includes a
                                            {{ $free_trial_duration }}-day
                                            free
                                            trial</p>
                                    @endif
                                </div>
                                {{-- <span
                                    class="currentPlan ml-5 rounded-full w-fit bg-yellow-400 py-1 px-2 text-[9px] text-black">
                                    SELECTED
                                </span> --}}
                            </div>
                            <div class="col-span-1 flex items-center justify-end pr-5">
                                <p class="text-xl font-semibold text-gray-900">
                                    $10
                                </p>

                            </div>
                        </div>

                    </div>
                @endif

                {{-- Gold Monthly Plan --}}
                {{-- @if (in_array($current_card, ['Free', 'Basic'])) --}}
                @if (in_array($current_card, ['Free', 'Basic', 'Sponsored', 'Influencer']))
                    <div plan="gold_m" style="border: 4px solid white;"
                        class="plan mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

                        <div class="grid grid-cols-7 mx-2">

                            <div class="flex items-center col-span-1 justify-center">
                                <x-heroicon-s-check-circle class="hidden ml-2 size-5 text-yellow-400" id="check-icon" />
                                <x-ri-circle-line class="ml-2 size-5 text-gray-400" id="circle-icon" />
                            </div>

                            <div class="flex items-center col-span-5">
                                <p class="text-xl font-semibold text-gray-900">
                                    {{ $term_gold }}
                                </p>

                                {{-- <span
                                    class="currentPlan hidden ml-5 rounded-full w-fit bg-yellow-400 py-1 px-2 text-[9px] text-black">
                                    SELECTED
                                </span> --}}
                            </div>
                            <div class="col-span-1 flex items-center justify-end pr-5">
                                <p class="text-xl font-semibold text-gray-900">
                                    $30
                                </p>
                            </div>
                        </div>
                    </div>
                @endif

                {{-- Platinum Monthly Plan --}}
                @if ($platinum_enabled)
                    @if (in_array($current_card, ['Free', 'Basic', 'Gold']))
                        <div plan="platinum_m" style="border: 4px solid white;"
                            class="plan mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

                            <div class="grid grid-cols-7 mx-2">

                                <div class="flex items-center col-span-1 justify-center">
                                    <x-heroicon-s-check-circle class="hidden ml-2 size-5 text-yellow-400"
                                        id="check-icon" />
                                    <x-ri-circle-line class="ml-2 size-5 text-gray-400" id="circle-icon" />
                                </div>

                                <div class="flex items-center col-span-5">
                                    <p class="text-xl font-semibold text-gray-900">
                                        {{ $term_platinum }}
                                    </p>

                                    {{-- <span
                                        class="currentPlan hidden ml-5 rounded-full w-fit bg-yellow-400 py-1 px-2 text-[9px] text-black">
                                        SELECTED
                                    </span> --}}
                                </div>
                                <div class="col-span-1 flex items-center justify-end pr-5">
                                    <p class="text-xl font-semibold text-gray-900">
                                        $60
                                    </p>

                                </div>
                            </div>

                        </div>
                    @endif
                @endif
            </div>
            {{-- @endif --}}

            <p class="mt-5 text-center text-sm/6 text-gray-600">Not sure what plan to pick? Compare plans
                <a href="{{ route('pricing.show') }}" class="font-bold text-yellow-600">here</a>.
            </p>

            {{-- <div class="mt-10 flex items-center justify-start gap-x-6 gap-4">
                <a id="proceed-button" target="_self" rel="nofollow"
                    href="{{ route('dashboard.index') }}?selected_plan=basic"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">
                    Back
                </a>
            </div>

            <div class="mt-10 flex items-center justify-end gap-x-6 gap-4">
                <a id="proceed-button" target="_self" rel="nofollow"
                    href="{{ route('checkout.upgrade') }}?selected_plan=basic"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">
                    Proceed
                </a>
            </div> --}}


            <div class="mt-10 flex justify-between items-center gap-4">
                <!-- Back button (left-aligned) -->
                <a href="{{ route('dashboard.index') }}"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">
                    Back
                </a>

                <!-- Proceed button (right-aligned) -->
                <a id="proceed-button" target="_self" rel="nofollow"
                    href="{{ route('checkout.upgrade') }}?selected_plan=basic"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">
                    Proceed
                </a>

                {{-- <a id="proceed-button" target="_self" rel="nofollow"
                    href="{{ route('checkout.upgrade') }}?selected_plan=basic"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">
                    Proceed
                </a> --}}
            </div>


        </div>
    </div>

    @push('scripts')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const billingToggle = document.getElementById('billingToggle');
                const annualPlan = document.getElementById('annual_plan');
                const monthlyPlan = document.getElementById('monthly_plan');
                const proceedButton = document.getElementById('proceed-button');

                // let selectedBasePlan = 'platinum'; // default

                let selectedBasePlan = (function() {
                    switch ("{{ $current_card }}") {
                        case 'Free':
                            return 'gold';
                        case 'Gold':
                            return 'platinum';
                        default:
                            return 'gold';
                    }
                })();

                // console.log('{{ $current_card }}');
                // console.log(selectedBasePlan);

                function getCurrentSelectedBasePlan() {
                    const selected = document.querySelector(
                        '.plan_selection:not(.hidden) .plan[style*="border: 4px solid #facc15"]');
                    return selected?.getAttribute('plan')?.replace('_m', '') ?? selectedBasePlan;
                }

                function selectPlan(planName, isMonthly) {
                    const targetContainer = isMonthly ? monthlyPlan : annualPlan;
                    const plans = targetContainer.querySelectorAll('.plan');
                    plans.forEach(p => {
                        const isTarget = p.getAttribute('plan') === `${planName}${isMonthly ? '_m' : ''}`;
                        p.style.border = isTarget ? '4px solid #facc15' : '4px solid white';

                        const currentPlanSpan = p.querySelector('span.currentPlan');
                        const checkIcon = p.querySelector('svg#check-icon');
                        const circleIcon = p.querySelector('svg#circle-icon');

                        currentPlanSpan?.classList.toggle('hidden', !isTarget);
                        checkIcon?.classList.toggle('hidden', !isTarget);
                        circleIcon?.classList.toggle('hidden', isTarget);

                        if (isTarget && proceedButton) {
                            const baseHref = "{{ route('checkout.upgrade') }}";
                            proceedButton.href = `${baseHref}?selected_plan=${p.getAttribute('plan')}`;
                        }
                    });
                }

                function initPlanSelection() {
                    const allPlans = document.querySelectorAll('.plan');

                    allPlans.forEach(plan => {
                        plan.addEventListener('click', function() {
                            const selectedPlanAttr = plan.getAttribute('plan');
                            selectedBasePlan = selectedPlanAttr.replace('_m', '');
                            // console.log(selectedBasePlan);
                            // Update UI
                            const planContainers = document.querySelectorAll('.plan_selection');
                            planContainers.forEach(container => {
                                const plans = container.querySelectorAll('.plan');
                                plans.forEach(p => {
                                    const isSelected = p === plan;
                                    p.style.border = isSelected ? '4px solid #facc15' :
                                        '4px solid white';

                                    const currentPlanSpan = p.querySelector(
                                        'span.currentPlan');
                                    const checkIcon = p.querySelector('svg#check-icon');
                                    const circleIcon = p.querySelector(
                                        'svg#circle-icon');

                                    currentPlanSpan?.classList.toggle('hidden', !
                                        isSelected);
                                    checkIcon?.classList.toggle('hidden', !isSelected);
                                    circleIcon?.classList.toggle('hidden', isSelected);
                                });
                            });

                            // Update Proceed Button
                            if (proceedButton) {
                                const baseHref = "{{ route('checkout.upgrade') }}";
                                proceedButton.href = `${baseHref}?selected_plan=${selectedPlanAttr}`;
                            }
                        });
                    });
                }

                function syncPlanOnToggle(isMonthly) {
                    selectPlan(selectedBasePlan, isMonthly);
                }

                if (@js($manual_capture_mode === false) || (@js($manual_capture_mode === true) && @js($manual_capture_mode_annual_only === false))) {

                    // Initial toggle state load
                    const savedToggle = localStorage.getItem('billingToggle') ?? 'annual';
                    const isMonthly = savedToggle === 'monthly';
                    billingToggle.checked = isMonthly;
                    monthlyPlan.classList.toggle('hidden', !isMonthly);
                    annualPlan.classList.toggle('hidden', isMonthly);

                    // Get initial selected plan base
                    selectedBasePlan = getCurrentSelectedBasePlan();
                    syncPlanOnToggle(isMonthly);

                    billingToggle.addEventListener('change', function(e) {
                        const isMonthly = e.target.checked;
                        localStorage.setItem('billingToggle', isMonthly ? 'monthly' : 'annual');

                        monthlyPlan.classList.toggle('hidden', !isMonthly);
                        annualPlan.classList.toggle('hidden', isMonthly);

                        syncPlanOnToggle(isMonthly);
                    });

                    window.addEventListener('livewire:navigated', function() {
                        if (document.querySelector('#plans')) {
                            setTimeout(initPlanSelection, 500);
                        }
                    });
                }

                initPlanSelection(); // also call on DOM ready
            });
        </script>
    @endpush
</div>
