<div>
    <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5">

        <!-- Card Colors  -->
        <li>
            <a wire:navigate href="{{ route('customize.colors') }}" class="flex justify-between gap-x-6 sm:py-3">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                        <x-solar-pallete-2-linear class="size-5" />
                    </span>
                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Customize</p>
                    </div>
                </div>

                <div class="shrink-0 sm:flex sm:flex-col sm:items-end justify-center">
                    <span class="rounded-full text-gray-600 p-2">
                        <x-bi-chevron-right class="size-4" />
                    </span>
                </div>
            </a>
        </li>

        @if ($color_presets)
            @foreach ($color_presets as $color)
                @php
                    $color->text_light = $color->text_light ?: '#1e293b';
                    $color->text_dark = $color->text_dark ?: '#cbd5e1';
                @endphp

                <li class="flex justify-between gap-x-6 sm:py-3 cursor-pointer"
                    wire:click.prevent="colorPreset({{ $color->id }})">

                    <div class="flex min-w-0 gap-x-4 items-center">
                        <span class="rounded-full dark:bg-white bg-slate-200 p-2">
                            <x-heroicon-o-paint-brush class="size-5" />
                        </span>
                        <div class="min-w-0 flex-auto">
                            <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">
                                {{ $color->title }}
                            </p>
                        </div>
                    </div>

                    <div class="shrink-0 sm:flex sm:flex-col sm:items-end">

                        <div class="flex -space-x-1.5 py-5 sm:py-0">
                            <span class="inline-block h-6 w-6 sm:h-7 sm:w-7 rounded-full ring-2 ring-white"
                                style="background-color: {{ $color->custom_button }}"></span>

                            <span class="inline-block h-6 w-6 sm:h-7 sm:w-7 rounded-full ring-2 ring-white"
                                style="background-color: {{ $color->custom_button_text }}"></span>

                            <span class="inline-block h-6 w-6 sm:h-7 sm:w-7 rounded-full ring-2 ring-white"
                                style="background-color: {{ $color->link }}"></span>

                            <span class="inline-block h-6 w-6 sm:h-7 sm:w-7 rounded-full ring-2 ring-white"
                                style="background-color: {{ $color->profile_pic_border }}"></span>

                            <span class="inline-block h-6 w-6 sm:h-7 sm:w-7 rounded-full ring-2 ring-white"
                                style="background-color: {{ $color->card_light }}"></span>

                            <span class="inline-block h-6 w-6 sm:h-7 sm:w-7 rounded-full ring-2 ring-white"
                                style="background-color: {{ $color->card_dark }}"></span>

                            <span class="inline-block h-6 w-6 sm:h-7 sm:w-7 rounded-full ring-2 ring-white"
                                style="background-color: {{ $color->text_light }}"></span>

                            <span class="inline-block h-6 w-6 sm:h-7 sm:w-7 rounded-full ring-2 ring-white"
                                style="background-color: {{ $color->text_dark }}"></span>
                        </div>
                    </div>
                </li>
            @endforeach
        @endif
    </ul>
</div>
