<!-- Action Sheet -->
<div class="z-20 fixed sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto bottom-0 left-0 right-0 bg-white dark:bg-zinc-900 shadow-lg transform translate-y-full transition-transform duration-300 rounded-t-2xl"
    :class="{ 'translate-y-full': !showSwitchActiveCardModal, 'translate-y-0': showSwitchActiveCardModal }">
    <div class="p-4">
        <div class="flex justify-between">
            <h3 class="text-lg font-bold text-slate-800 dark:text-slate-300 flex items-center">
                <x-heroicon-o-arrows-right-left class="size-6" />&nbsp;&nbsp;
                Switch Active Card
            </h3>
            <!-- Close Action Sheet -->
            <button @click="showSwitchActiveCardModal=!showSwitchActiveCardModal" class="text-gray-500 toggleActionSheet">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        <div class="mt-4 space-y-3">
            <button wire:click="setMainCardActive()"
                class="block w-full px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600 space-between text-sm"><span
                    class="font-medium">Main Card</span>&nbsp;&nbsp;

                @if ($maincard == 1)
                    <span
                        class="justify-self-end rounded-full bg-green-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-green-700">Active</span>
                @endif

            </button>
            @foreach ($subcards as $subcard)
                <button wire:click="setSubCardActive({{ $subcard->id }})"
                    class="block w-full px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600 space-between text-sm">
                    <span class="font-medium">{{ '@' . $subcard['username'] }}</span>

                    {{-- &nbsp;&nbsp;|&nbsp;&nbsp;{{ $subcard['job_title'] }} &nbsp;&nbsp; --}}
                    &nbsp;&nbsp;|&nbsp;&nbsp;Sub Card &nbsp;&nbsp;

                    @if ($subcard->active_card === 1)
                        <span
                            class="justify-self-end rounded-full bg-green-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-green-700 ring-1 ring-pink-700/10 ring-inset">Active</span>
                    @endif
                </button>
            @endforeach

            @php
                $maxCard = 0;
                $availableSlot = 0;
                $verbiage = ' Slots';

                if (auth()->user()->user_type === 'Gold') {
                    $maxCard = 3;
                }

                if (auth()->user()->user_type === 'Platinum') {
                    $maxCard = 12;
                }

                if (in_array(auth()->user()->user_type, ['Sponsored', 'Influencer'])) {
                    $maxCard = 1;
                }

                $availableSlot = $maxCard - $subcards->count();

            @endphp

            @if ($availableSlot >= 1)
                {{-- Sub Card --}}
                <a href="{{ route('card.add') }}"
                    class="flex items-center px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600 text-sm">Add
                    New Card&nbsp;&nbsp;<x-heroicon-o-plus class="size-5" /></a>
            @endif

            <button @click="showSwitchActiveCardModal=!showSwitchActiveCardModal"
                class="w-full px-4 py-2 text-left text-red-600 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 text-sm">Cancel</button>
        </div>
    </div>
</div>
