<div>
    <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5">

        {{-- <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5" x-data x-sortable
        x-on:sorted="$wire.updateOrder($event.detail)"> --}}

        @foreach ($submissions as $submission)
            <li class="bg-white dark:bg-zinc-900 grid grid-cols-6 items-center justify-between gap-x-6 py-3">

                <div class="flex min-w-0 gap-x-4 items-center col-span-3">
                    <div class="min-w-0 flex-auto">
                        <a href="{{ route('submission.show', $submission->id) }}">
                            <p class="text-sm/6 font-medium text-gray-900 dark:text-slate-300">
                                {{ $submission['firstname'] . ' ' . $submission['lastname'] }}
                            </p>
                        </a>
                    </div>
                </div>

                {{-- Edit and Delete Button --}}
                <div class="col-span-3 flex gap-5 items-center justify-end">

                    <button wire:confirm="Are you sure you want to delete this?"
                        wire:click="delete({{ $submission->id }})" class="flex rounded-full bg-red-500 p-1 text-white"
                        role="switch" aria-checked="false" aria-labelledby="switch-1-label">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-4 sm:size-5">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="m14.74 9-.346 9m-4.788 0L9.26 9m9.968-3.21c.342.052.682.107 1.022.166m-1.022-.165L18.16 19.673a2.25 2.25 0 0 1-2.244 2.077H8.084a2.25 2.25 0 0 1-2.244-2.077L4.772 5.79m14.456 0a48.108 48.108 0 0 0-3.478-.397m-12 .562c.34-.059.68-.114 1.022-.165m0 0a48.11 48.11 0 0 1 3.478-.397m7.5 0v-.916c0-1.18-.91-2.164-2.09-2.201a51.964 51.964 0 0 0-3.32 0c-1.18.037-2.09 1.022-2.09 2.201v.916m7.5 0a48.667 48.667 0 0 0-7.5 0" />
                        </svg>
                    </button>
                </div>
            </li>
        @endforeach
    </ul>
</div>
