{{-- <div wire:poll.100ms="buttonManager"> --}}
<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                {{-- <a href="{{ route('dashboard.search', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-magnifying-glass class="size-4" />
                </a> --}}

                @if (auth()->user()->user_type != 'Free')
                    <a wire:navigate href="{{ route('dashboard.links') }}"
                        class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                        <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-4">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                            </svg>
                        </span>
                    </a>
                @endif
            </div>
            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M20.25 14.15v4.25c0 1.094-.787 2.036-1.872 2.18-2.087.277-4.216.42-6.378.42s-4.291-.143-6.378-.42c-1.085-.144-1.872-1.086-1.872-2.18v-4.25m16.5 0a2.18 2.18 0 0 0 .75-1.661V8.706c0-1.081-.768-2.015-1.837-2.175a48.114 48.114 0 0 0-3.413-.387m4.5 8.006c-.194.165-.42.295-.673.38A23.978 23.978 0 0 1 12 15.75c-2.648 0-5.195-.429-7.577-1.22a2.016 2.016 0 0 1-.673-.38m0 0A2.18 2.18 0 0 1 3 12.489V8.706c0-1.081.768-2.015 1.837-2.175a48.111 48.111 0 0 1 3.413-.387m7.5 0V5.25A2.25 2.25 0 0 0 13.5 3h-3a2.25 2.25 0 0 0-2.25 2.25v.894m7.5 0a48.667 48.667 0 0 0-7.5 0M12 12.75h.008v.008H12v-.008Z" />
                </svg>

                &nbsp;&nbsp;Services
            </p>

            <div class="flex items-center col-span-1 place-content-end">
                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a> --}}

                <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>
        </div>

        @if ($services)
            <div class="grid grid-cols-3 mt-5 gap-4">

                <div class="h-fit col-span-2">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Add New
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">Add a new service</p>
                </div>

                <div class="flex items-center col-span-1 place-content-end">
                    <a wire:navigate href="{{ route('service.add') }}"
                        class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="size-6">
                                <path fill-rule="evenodd"
                                    d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                    clip-rule="evenodd" />
                            </svg>
                        </span>
                    </a>
                </div>
            </div>
        @endif
    </div>

    @if (!$services)
        <div class="flex justify-center my-20">
            <a wire:navigate href="{{ route('service.add') }}"
                class="flex items-center mx-auto bg-blue-500 text-white px-3.5 py-1.5 text-base rounded-md">Add
                Service(s) &nbsp;
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-4">
                    <path fill-rule="evenodd"
                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                        clip-rule="evenodd" />
                </svg>
            </a>

        </div>
    @endif

    @if ($services)
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">
            <p class="text-slate-600 dark:text-slate-500 text-sm text-center mb-10">Drag the element to rearrange.</p>
            {{-- Display Sortable service here --}}
            <livewire:sortable-service />
        </div>
    @endif
</div>
