<div>
    @if ($user && $service)
        @guest
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl my-5">
            @endguest
            @auth
                <div id="custom_bg"
                    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl mb-20 mt-5">
                @endauth
                <div class="grid grid-cols-2 gap-4 mb-5">
                    <!-- back -->
                    <div class="ml-5  flex items-center">
                        <a href="{{ route('card.services', $user->username) }}"
                            class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-chevron-left class="size-4" />
                        </a>
                    </div>

                    <!-- Share Card -->
                    <div class="mr-5 flex items-center place-content-end" x-data="{
                        urlTitle: `{{ $service_title }} | {{ $page_title ?: $card_title }}`,
                        shareUrl: '{{ route('service.show', [$username, $id]) }}',
                        shareCard() {
                            if (navigator.share) {
                                navigator.share({
                                    title: this.urlTitle,
                                    url: this.shareUrl,
                                }).then(() => {
                                    console.log('Thanks for sharing!');
                                }).catch(console.error);
                            } else {
                                console.log('Web Share API not supported');
                            }
                        }
                    }">

                        <button type="button" @click="showQRCode=!showQRCode"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                            <x-heroicon-o-qr-code class="size-5" />
                        </button>

                        <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-arrow-up-tray class="size-5" />
                        </a>
                    </div>
                </div>

                <img src="{{ $service->service_image ? asset($service->service_image) : asset('/img/product-placeholder.jpg') }}"
                    alt="{{ $service->title }}" class="rounded-t-md">

                <h1 class="text-xl md:text-2xl font-medium text-center mt-5 px-5">
                    {{ $service->title }}</h1>

                <div class="mt-5 px-5">
                    <div class="">
                        <span>{!! Purifier::clean($service->description) !!}</span>
                    </div>
                </div>

                <a class="w-11/12 block p-1.5 sm:p-2 @if ($button_style === 'squared') rounded-md @else rounded-full @endif text-black text-center mx-auto mt-5 mb-2 text-xs sm:text-sm font-semibold"
                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                    href="{{ $service['payment_link'] }}" target="_blank">Buy Now
                    @if ($services_price_enabled == true)
                        <span>
                            ${{ $service->price }}
                        </span>
                    @endif
                </a>

                @if ($contacts)
                    <p class="flex items-center justify-center text-center pt-5">
                        Contact me
                    </p>

                    <div class="pt-2 container mx-auto flex items-center justify-center">
                        {{-- Other contact points here --}}

                        <livewire:contact-points-component :username="$user->username" />

                    </div>
                @endif
                {{-- PAY WITH PAYPAL --}}
                {{-- <form action="https://www.paypal.com/cgi-bin/webscr" method="post"
                    class="w-11/12 block bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 p-1.5 sm:p-2 rounded-full text-black text-center mx-auto mt-5 mb-2 text-xs sm:text-sm font-semibold">
                    <input type="hidden" name="cmd" value="_xclick">
                    <input type="hidden" name="business" value="contact@giobrasileno.com">
                    <input type="hidden" name="item_name" value="{{ $service->title }}">
                    <input type="hidden" name="amount" value="{{ $product->price }}">
                    <input type="submit" value="Pay with PayPal">
                </form> --}}

                {{-- CUSTOM FOOTER will be displayed here --}}

            </div>
        </div>
    @else
        <div class="h-screen flex justify-center items-center">
            <div>
                <p class="mx-auto text-yellow-500 text-center text-l p-10">
                    <x-ionicon-warning-sharp class=" size-32 sm:size-40" />
                </p>
                <p class="mx-auto font-bold text-center text-2xl">Service not found
                </p>
                {{-- <p class="flex items-center justify-center text-center text-l py-1">
                    Get your&nbsp;<a href="https://10kcards.com" target="_blank" class="text-yellow-600">10k
                        card</a>&nbsp;today!
                </p> --}}
            </div>
        </div>
    @endif
</div>
