<div class="bg-slate-200 min-h-screen">
    <div class="flex flex-col justify-center px-6 py-12 lg:px-8">

        <img class="mx-auto w-60" src="{{ $logo ? asset($logo) : asset('img/10kcards-black-logo.webp') }}">
        {{-- <p class="rounded-full bg-gray-300 py-1 px-2 text-[8px] text-black mx-auto w-fit mt-2">Prototype
                v0.1</p> --}}
        <h2 class="mt-10 text-center text-2xl/9 font-bold tracking-tight text-gray-900">Select Card</h2>

        <div id="plans" class="sm:mx-auto sm:w-full sm:max-w-lg">

            <p class="mt-1 text-sm/6 text-center text-gray-600">Select the card that aligns with your professional
                objectives.</p>

            <div class="flex items-center space-x-4 mx-auto w-fit mt-10">
                <span class="text-sm font-medium text-gray-700">Annual</span>

                <label class="relative inline-flex items-center cursor-pointer">
                    <input id="billingToggle" type="checkbox" class="sr-only peer" />
                    <div
                        class="w-11 h-6 bg-gray-300 peer-focus:outline-none peer-focus:ring-2 peer-focus:ring-blue-500 rounded-full peer peer-checked:bg-blue-600 transition-colors">
                    </div>
                    <div
                        class="absolute left-0.5 top-0.5 bg-white w-5 h-5 rounded-full transition-transform peer-checked:translate-x-full">
                    </div>
                </label>

                <span class="text-sm font-medium text-gray-700">Monthly</span>
            </div>

            <div id="annual_plan" class="plan_selection">
                {{-- Basic Annual Plan --}}
                <div plan="basic" style="border: 4px solid #facc15;"
                    class="plan mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

                    <div class="grid grid-cols-7 mx-2">

                        <div class="flex items-center col-span-1 justify-center">
                            <x-heroicon-s-check-circle class="ml-2 size-5 text-yellow-400" id="check-icon" />
                            <x-ri-circle-line class="hidden ml-2 size-5 text-gray-400" id="circle-icon" />
                        </div>

                        <div class="flex items-center col-span-5">
                            <div>
                                <p class="text-xl font-semibold text-gray-900">
                                    {{ $term_basic }}
                                </p>
                                @if ($free_trial_enabled)
                                    <p class="text-sm text-gray-500 mt-1">Includes a {{ $free_trial_duration }}-day free
                                        trial</p>
                                @endif
                            </div>
                            {{-- <span
                                class="currentPlan ml-5 rounded-full w-fit bg-yellow-400 py-1 px-2 text-[9px] text-black">
                                SELECTED
                            </span> --}}
                        </div>
                        <div class="col-span-1 flex items-center justify-end pr-5">
                            <p class="text-xl font-semibold text-gray-900">
                                $100
                            </p>

                        </div>
                    </div>

                </div>

                {{-- Gold Annual Plan --}}
                <div plan="gold" style="border: 4px solid white;"
                    class="plan mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

                    <div class="grid grid-cols-7 mx-2">

                        <div class="flex items-center col-span-1 justify-center">
                            <x-heroicon-s-check-circle class="hidden ml-2 size-5 text-yellow-400" id="check-icon" />
                            <x-ri-circle-line class="ml-2 size-5 text-gray-400" id="circle-icon" />
                        </div>

                        <div class="flex items-center col-span-5">
                            <p class="text-xl font-semibold text-gray-900">
                                {{ $term_gold }}
                            </p>

                            {{-- <span
                                class="currentPlan hidden ml-5 rounded-full w-fit bg-yellow-400 py-1 px-2 text-[9px] text-black">
                                SELECTED
                            </span> --}}
                        </div>
                        <div class="col-span-1 flex items-center justify-end pr-5">
                            <p class="text-xl font-semibold text-gray-900">
                                $300
                            </p>
                        </div>
                    </div>
                </div>

                @if ($platinum_enabled)
                    {{-- Platinum Annual Plan --}}
                    <div plan="platinum" style="border: 4px solid white;"
                        class="plan mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

                        <div class="grid grid-cols-7 mx-2">

                            <div class="flex items-center col-span-1 justify-center">
                                <x-heroicon-s-check-circle class="hidden ml-2 size-5 text-yellow-400" id="check-icon" />
                                <x-ri-circle-line class="ml-2 size-5 text-gray-400" id="circle-icon" />
                            </div>

                            <div class="flex items-center col-span-5">
                                <p class="text-xl font-semibold text-gray-900">
                                    {{ $term_platinum }}
                                </p>

                                {{-- <span
                                    class="currentPlan hidden ml-5 rounded-full w-fit bg-yellow-400 py-1 px-2 text-[9px] text-black">
                                    SELECTED
                                </span> --}}
                            </div>
                            <div class="col-span-1 flex items-center justify-end pr-5">
                                <p class="text-xl font-semibold text-gray-900">
                                    $600
                                </p>

                            </div>
                        </div>

                    </div>
                @endif
            </div>


            <div id="monthly_plan" class="plan_selection hidden">
                {{-- Basic Monthly Plan --}}
                <div plan="basic_m" style="border: 4px solid #facc15;"
                    class="plan mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

                    <div class="grid grid-cols-7 mx-2">

                        <div class="flex items-center col-span-1 justify-center">
                            <x-heroicon-s-check-circle class="ml-2 size-5 text-yellow-400" id="check-icon" />
                            <x-ri-circle-line class="hidden ml-2 size-5 text-gray-400" id="circle-icon" />
                        </div>

                        <div class="flex items-center col-span-5">
                            <div>
                                <p class="text-xl font-semibold text-gray-900">
                                    {{ $term_basic }}
                                </p>
                                @if ($free_trial_enabled)
                                    <p class="text-sm text-gray-500 mt-1">Includes a {{ $free_trial_duration }}-day free
                                        trial</p>
                                @endif
                            </div>
                            {{-- <span
                                class="currentPlan ml-5 rounded-full w-fit bg-yellow-400 py-1 px-2 text-[9px] text-black">
                                SELECTED
                            </span> --}}
                        </div>

                        <div class="col-span-1 flex items-center justify-end pr-5">
                            <p class="text-xl font-semibold text-gray-900">
                                $10
                            </p>

                        </div>
                    </div>

                </div>

                {{-- Gold Monthly Plan --}}
                <div plan="gold_m" style="border: 4px solid white;"
                    class="plan mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

                    <div class="grid grid-cols-7 mx-2">

                        <div class="flex items-center col-span-1 justify-center">
                            <x-heroicon-s-check-circle class="hidden ml-2 size-5 text-yellow-400" id="check-icon" />
                            <x-ri-circle-line class="ml-2 size-5 text-gray-400" id="circle-icon" />
                        </div>

                        <div class="flex items-center col-span-5">
                            <p class="text-xl font-semibold text-gray-900">
                                {{ $term_gold }}
                            </p>

                            {{-- <span
                                class="currentPlan hidden ml-5 rounded-full w-fit bg-yellow-400 py-1 px-2 text-[9px] text-black">
                                SELECTED
                            </span> --}}
                        </div>
                        <div class="col-span-1 flex items-center justify-end pr-5">
                            <p class="text-xl font-semibold text-gray-900">
                                $30
                            </p>
                        </div>
                    </div>
                </div>

                @if ($platinum_enabled)
                    {{-- Platinum Monthly Plan --}}
                    <div plan="platinum_m" style="border: 4px solid white;"
                        class="plan mt-5 mx-auto py-5 bg-white flex flex-col content-center rounded-2xl mb-5">

                        <div class="grid grid-cols-7 mx-2">

                            <div class="flex items-center col-span-1 justify-center">
                                <x-heroicon-s-check-circle class="hidden ml-2 size-5 text-yellow-400" id="check-icon" />
                                <x-ri-circle-line class="ml-2 size-5 text-gray-400" id="circle-icon" />
                            </div>

                            <div class="flex items-center col-span-5">
                                <p class="text-xl font-semibold text-gray-900">
                                    {{ $term_platinum }}
                                </p>

                                {{-- <span
                                    class="currentPlan hidden ml-5 rounded-full w-fit bg-yellow-400 py-1 px-2 text-[9px] text-black">
                                    SELECTED
                                </span> --}}
                            </div>
                            <div class="col-span-1 flex items-center justify-end pr-5">
                                <p class="text-xl font-semibold text-gray-900">
                                    $60
                                </p>

                            </div>
                        </div>

                    </div>
                @endif
            </div>

            <p class="mt-5 text-center text-sm/6 text-gray-600">Not sure what plan to pick? Compare plans
                <a href="{{ route('pricing.show') }}" class="font-bold text-yellow-600">here</a>.
            </p>

            {{-- <div class="mt-10 flex items-center justify-start gap-x-6 gap-4">
                <a id="proceed-button" target="_self" rel="nofollow"
                    href="{{ route('dashboard.index') }}?selected_plan=basic"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">
                    Back
                </a>
            </div>

            <div class="mt-10 flex items-center justify-end gap-x-6 gap-4">
                <a id="proceed-button" target="_self" rel="nofollow"
                    href="{{ route('checkout.upgrade') }}?selected_plan=basic"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">
                    Proceed
                </a>
            </div> --}}

            <div class="mt-10 flex items-center justify-end gap-x-6 gap-4">
                <a id="proceed-button" target="_self" rel="nofollow"
                    href="{{ route('checkout') }}?selected_plan=basic"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">
                    Proceed
                </a>
            </div>

        </div>
    </div>

    {{-- @push('scripts')
        <script>
            document.getElementById('billingToggle').addEventListener('change', function(e) {

                const selectedPlan = document.getElementsByClassName('plan_selection');

                if (e.target.checked) {
                    console.log('Monthly selected');
                    document.getElementById('annual_plan').classList.add('hidden');
                    document.getElementById('monthly_plan').classList.remove('hidden');

                } else {
                    console.log('Annual selected');
                    document.getElementById('annual_plan').classList.remove('hidden');
                    document.getElementById('monthly_plan').classList.add('hidden');
                }
            });

            window.addEventListener('livewire:navigated', function() {
                if (document.querySelector('#plans')) {
                    setTimeout(initPlanSelection, 500);
                }
            });

            function initPlanSelection() {
                const plans = document.getElementsByClassName('plan');

                Array.from(plans).forEach(plan => {

                    plan.addEventListener('click', function(e) {
                        // Reset styles on all plans
                        Array.from(plans).forEach(p => {
                            p.style.border = '4px solid white';
                            const currentPlanSpan = p.querySelector('span.currentPlan');
                            if (currentPlanSpan) currentPlanSpan.classList.add('hidden');
                            const checkIcon = p.querySelector('svg#check-icon');
                            if (checkIcon) checkIcon.classList.add('hidden');
                            const circleIcon = p.querySelector('svg#circle-icon');
                            if (circleIcon) circleIcon.classList.remove('hidden');
                        });

                        // Style the selected plan
                        plan.style.border = '4px solid #facc15';
                        const currentPlanSpan = plan.querySelector('span.currentPlan');
                        if (currentPlanSpan) currentPlanSpan.classList.remove('hidden');
                        const checkIcon = plan.querySelector('svg#check-icon');
                        if (checkIcon) checkIcon.classList.remove('hidden');
                        const circleIcon = plan.querySelector('svg#circle-icon');
                        if (circleIcon) circleIcon.classList.add('hidden');

                        // Get selected plan and price id
                        const planSelected = plan.getAttribute('plan');

                        // Update proceed button href
                        const proceedButton = document.getElementById('proceed-button');
                        if (proceedButton) {
                            const baseHref = "{{ route('checkout.upgrade') }}";
                            proceedButton.href =
                                `${baseHref}?selected_plan=${planSelected}`;
                        }
                    });
                });
            }
        </script>
    @endpush --}}

    @push('scripts')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const billingToggle = document.getElementById('billingToggle');
                const annualPlan = document.getElementById('annual_plan');
                const monthlyPlan = document.getElementById('monthly_plan');
                const proceedButton = document.getElementById('proceed-button');

                let selectedBasePlan = 'basic'; // default

                function getCurrentSelectedBasePlan() {
                    const selected = document.querySelector(
                        '.plan_selection:not(.hidden) .plan[style*="border: 4px solid #facc15"]');
                    return selected?.getAttribute('plan')?.replace('_m', '') ?? 'basic';
                }

                function selectPlan(planName, isMonthly) {
                    const targetContainer = isMonthly ? monthlyPlan : annualPlan;
                    const plans = targetContainer.querySelectorAll('.plan');
                    plans.forEach(p => {
                        const isTarget = p.getAttribute('plan') === `${planName}${isMonthly ? '_m' : ''}`;
                        p.style.border = isTarget ? '4px solid #facc15' : '4px solid white';

                        const currentPlanSpan = p.querySelector('span.currentPlan');
                        const checkIcon = p.querySelector('svg#check-icon');
                        const circleIcon = p.querySelector('svg#circle-icon');

                        currentPlanSpan?.classList.toggle('hidden', !isTarget);
                        checkIcon?.classList.toggle('hidden', !isTarget);
                        circleIcon?.classList.toggle('hidden', isTarget);

                        if (isTarget && proceedButton) {
                            const baseHref = "{{ route('checkout') }}";
                            proceedButton.href = `${baseHref}?selected_plan=${p.getAttribute('plan')}`;
                        }
                    });
                }

                function initPlanSelection() {
                    const allPlans = document.querySelectorAll('.plan');

                    allPlans.forEach(plan => {
                        plan.addEventListener('click', function() {
                            const selectedPlanAttr = plan.getAttribute('plan');
                            selectedBasePlan = selectedPlanAttr.replace('_m', '');

                            // Update UI
                            const planContainers = document.querySelectorAll('.plan_selection');
                            planContainers.forEach(container => {
                                const plans = container.querySelectorAll('.plan');
                                plans.forEach(p => {
                                    const isSelected = p === plan;
                                    p.style.border = isSelected ? '4px solid #facc15' :
                                        '4px solid white';

                                    const currentPlanSpan = p.querySelector(
                                        'span.currentPlan');
                                    const checkIcon = p.querySelector('svg#check-icon');
                                    const circleIcon = p.querySelector(
                                        'svg#circle-icon');

                                    currentPlanSpan?.classList.toggle('hidden', !
                                        isSelected);
                                    checkIcon?.classList.toggle('hidden', !isSelected);
                                    circleIcon?.classList.toggle('hidden', isSelected);
                                });
                            });

                            // Update Proceed Button
                            if (proceedButton) {
                                const baseHref = "{{ route('checkout') }}";
                                proceedButton.href = `${baseHref}?selected_plan=${selectedPlanAttr}`;
                            }
                        });
                    });
                }

                function syncPlanOnToggle(isMonthly) {
                    selectPlan(selectedBasePlan, isMonthly);
                }

                // Initial toggle state load
                const savedToggle = localStorage.getItem('billingToggle') ?? 'annual';
                const isMonthly = savedToggle === 'monthly';
                billingToggle.checked = isMonthly;
                monthlyPlan.classList.toggle('hidden', !isMonthly);
                annualPlan.classList.toggle('hidden', isMonthly);

                // Get initial selected plan base
                selectedBasePlan = getCurrentSelectedBasePlan();
                syncPlanOnToggle(isMonthly);

                billingToggle.addEventListener('change', function(e) {
                    const isMonthly = e.target.checked;
                    localStorage.setItem('billingToggle', isMonthly ? 'monthly' : 'annual');

                    monthlyPlan.classList.toggle('hidden', !isMonthly);
                    annualPlan.classList.toggle('hidden', isMonthly);

                    syncPlanOnToggle(isMonthly);
                });

                window.addEventListener('livewire:navigated', function() {
                    if (document.querySelector('#plans')) {
                        setTimeout(initPlanSelection, 500);
                    }
                });

                initPlanSelection(); // also call on DOM ready
            });
        </script>
    @endpush

</div>
