<div x-data="{ openResults: false }" @click.outside="openResults = false">
    {{-- Search bar --}}
    <div class="top-0 z-40 py-2">
        {{-- <div class="relative col-span-full mb-5 mx-5"> --}}
        <div class="relative col-span-full mb-5">
            <div class="mt-2">
                <div
                    class="flex items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('keyword') border border-red-600 @enderror">
                    <div class="shrink-0 text-sm/6 font-medium text-gray-500 select-none sm:text-sm/6">
                        <x-heroicon-s-magnifying-glass class="size-7" />
                    </div>

                    <input type="text" wire:model="keyword" wire:keyup="searchUsers" @focus="openResults=true"
                        inputmode="search" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false"
                        name="search"
                        class="block min-w-0 grow py-1.5 pr-3 pl-1 bg-gray-100 text-gray-900 placeholder:text-gray-400 focus:outline-none text-base rounded-md"
                        placeholder="Search User">
                </div>
            </div>

            @error('keyword')
                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
            @enderror

            <!-- Search Results -->
            @if (!empty($keyword))
                <div x-show="openResults" x-transition
                    class="absolute z-30 w-full bg-white dark:bg-zinc-900 rounded-md shadow-lg mt-1 max-h-80 overflow-y-auto"
                    @click="openResults = false">
                    @if ($results->isNotEmpty())
                        <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600">
                            @foreach ($results as $result)
                                <li>
                                    <a href="{{ route('card.show', $result->username) }}"
                                        class="block py-3 px-4 hover:bg-gray-100 dark:hover:bg-zinc-800">
                                        <div class="flex min-w-0 gap-x-4">
                                            <img class="size-12 flex-none rounded-full bg-gray-50"
                                                src="{{ $result->profile_pic ? asset($result->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                                                alt="{{ $result->firstname . ' ' . $result->lastname }}">
                                            <div class="min-w-0 flex-auto">
                                                <p
                                                    class="flex text-sm/6 font-semibold text-gray-900 dark:text-slate-300 items-center">
                                                    {{ $result->firstname . ' ' . $result->lastname }}
                                                    @if ($result->user_type == 'Gold')
                                                        <x-gmdi-verified class="size-4 ml-1 inline text-yellow-400" />
                                                    @elseif($result->user_type == 'Platinum')
                                                        <x-gmdi-verified class="size-4 ml-1 inline text-blue-500" />
                                                    @endif
                                                </p>
                                                <p class="truncate text-xs/5 text-gray-500">
                                                    {{ '@' . $result->username ?? '—' }}
                                                </p>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <h1 class="text-base py-3 px-4 text-slate-800 dark:text-slate-300">
                            No result(s) found.
                        </h1>
                    @endif
                </div>
            @endif
        </div>
    </div>
</div>
