<div wire:ignore x-data="gallery(@js($images), '{{ $user->username }}', '{{ $product_id }}')" x-cloak x-init="init" @touchstart="startTouch($event)"
    @touchmove="moveTouch($event)" @touchend="endTouch($event)" class="w-full mx-auto flex flex-col content-center px-5">

    <!-- Outer wrapper: fixed width & hides overflow -->
    <div class="relative overflow-hidden w-full">
        <!-- Slide track -->
        <div class="flex transition-transform duration-500 ease-in-out"
            :style="`transform: translateX(-${activeIndex * 100 - dragOffset}%)`">

            <!-- Each slide -->
            {{-- <template x-for="(image, index) in images" :key="index">
                <div class="w-full flex-shrink-0 flex flex-col items-center justify-center">

                    <!-- Image -->
                    <div class="relative overflow-hidden w-full aspect-[1/1] rounded-xl mt-5"
                        style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
                        <a :href="image.shop_online_link" target="_blank">
                            <img :src="'/storage/' + image.image_path" class="w-full h-full object-cover select-none"
                                draggable="false" />
                        </a>
                    </div>

                    <h1 class="text-xl font-medium text-center mt-5 px-2" x-text="image.product_name">
                    </h1>

                    <p class="mx-auto text-center text-base py-1 px-2" x-text="image.description">
                    </p>

                    <!-- Buttons -->
                    <div class="flex mt-3 gap-5">
                        <!-- Cash & Carry (correct format: /{username}/sales/{sales}/cash-and-carry/{sales_images}) -->
                        <a :href="`/${encodeURIComponent(username)}/sales/${encodeURIComponent(sales_id)}/cash-and-carry/${encodeURIComponent(image.id)}`"
                            class="text-sm inline-flex mt-3 px-5 py-3 rounded-md font-bold items-center justify-center"
                            style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                            Cash & Carry
                        </a>

                        <!-- Shop Online -->
                        <template x-if="image.shop_online_link">
                            <a :href="image.shop_online_link" target="_blank"
                                class="text-sm inline-flex mt-3 px-5 py-3 rounded-md font-bold items-center justify-center"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                <span x-text="image.shop_online_button ? image.shop_online_button : 'Shop'"></span>
                            </a>
                        </template>
                    </div>

                    <div class="flex justify-center mt-5">
                        <div class="flex items-center gap-2">
                            <span class="font-bold text-base mr-5">Add to Cart</span>
                            <div class="flex items-center border rounded-md overflow-hidden">
                                <button type="button" class="px-2 py-1 text-lg font-bold"
                                    onclick="updateQuantity('{{ image . id }}', -1)">-</button>

                                <input type="number" value="0" min="0" data-type="image"
                                    id="quantity-{{ image . id }}"
                                    class="w-12 text-center border-black focus:ring-0 focus:outline-none text-black"
                                    oninput="saveToCart('{{ image . id }}', '{{ image . type ?? 'image' }}')">

                                <button type="button" class="px-2 py-1 text-lg font-bold"
                                    onclick="updateQuantity('{{ image . id }}', 1)">+</button>
                            </div>
                        </div>
                    </div>

                </div>
            </template> --}}

            <template x-for="(image, index) in images" :key="image.id">
                <div class="w-full flex-shrink-0 flex flex-col items-center justify-center">

                    <!-- Image -->
                    <div class="relative overflow-hidden w-full aspect-[1/1] rounded-xl mt-5"
                        style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
                        <a :href="image.shop_online_link" target="_blank">
                            <img :src="'/storage/' + image.path" class="w-full h-full object-cover select-none"
                                draggable="false" />
                        </a>
                    </div>

                    <h1 class="text-xl font-medium text-center mt-5 px-2" x-text="image.product_name"></h1>

                    {{-- <p class="text-base font-medium text-center px-2">
                        Price: <span x-text="image.price"></span> | Stock: <span x-text="image.stock"></span></p>

                    <p class="mx-auto mt-5 text-center text-base py-1 px-2" x-text="image.description"></p> --}}

                    <!-- Buttons -->
                    {{-- <div class="flex mt-3 gap-5">

                        <template x-if="image.shop_online_link">
                            <a :href="image.shop_online_link" target="_blank"
                                class="text-sm inline-flex mt-3 px-5 py-3 rounded-md font-bold items-center justify-center"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                <span x-text="image.shop_online_button ? image.shop_online_button : 'Shop'"></span>
                            </a>
                        </template>
                    </div> --}}

                    <!-- Add to Cart -->
                    {{-- <div class="flex justify-center mt-5">
                        <div class="flex items-center gap-2">
                            <span class="font-bold text-base mr-5">Add to Cart</span>
                            <div class="flex items-center border rounded-md overflow-hidden">
                                <button type="button" class="px-2 py-1 text-lg font-bold"
                                    @click="updateQuantity(image.id, -1, 'image')">-</button>

                                <input type="number" value="0" min="0" :id="`quantity-${image.id}`"
                                    :data-type="'image'" :data-price="image.price" :data-name="image.product_name"
                                    class="w-12 text-center border-black focus:ring-0 focus:outline-none text-black"
                                    @input="saveToCart(image.id, 'image')">

                                <button type="button" class="px-2 py-1 text-lg font-bold"
                                    @click="updateQuantity(image.id, 1, 'image')">+</button>
                            </div>
                        </div>
                    </div> --}}

                </div>
            </template>

        </div>
    </div>

    <!-- Pagination dots -->
    <template x-if="images.length > 1">
        <div class="flex justify-center mt-5 gap-2">
            <template x-for="(image, index) in images" :key="'dot-' + index">
                <button class="w-[18px] h-[18px] rounded-full mx-[4px] focus:outline-none"
                    :style="activeIndex === index ?
                        'background-color: {{ $color_settings_profile_pic_border }} !important' :
                        'background-color: gray !important; opacity: 0.2;'"
                    @click="goTo(index)">
                </button>
            </template>
        </div>
    </template>

    @push('scripts')
        <script>
            function gallery(images, username, sales_id) {
                return {
                    images,
                    username,
                    sales_id,
                    activeIndex: 0,
                    timer: null,
                    startX: 0,
                    currentX: 0,
                    dragOffset: 0,
                    isDragging: false,

                    init() {
                        this.resetTimer();
                    },

                    resetTimer() {
                        if (this.timer) clearInterval(this.timer);
                        this.timer = setInterval(() => this.next(), 10000);
                    },

                    next() {
                        this.activeIndex = (this.activeIndex + 1) % this.images.length;
                    },

                    prev() {
                        this.activeIndex = (this.activeIndex - 1 + this.images.length) % this.images.length;
                    },

                    goTo(index) {
                        this.activeIndex = index;
                        this.resetTimer();
                    },

                    startTouch(e) {
                        this.startX = e.touches[0].clientX;
                        this.currentX = this.startX;
                        this.isDragging = true;
                        this.dragOffset = 0;
                        clearInterval(this.timer);
                    },

                    moveTouch(e) {
                        if (!this.isDragging) return;
                        this.currentX = e.touches[0].clientX;
                        const moved = this.currentX - this.startX;
                        this.dragOffset = (moved / window.innerWidth) * 100;
                    },

                    endTouch(e) {
                        if (!this.isDragging) return;
                        this.isDragging = false;

                        if (this.dragOffset > 20) {
                            if (this.activeIndex === 0) {
                                this.activeIndex = this.images.length - 1;
                            } else {
                                this.prev();
                            }
                        } else if (this.dragOffset < -20) {
                            if (this.activeIndex === this.images.length - 1) {
                                this.activeIndex = 0;
                            } else {
                                this.next();
                            }
                        }

                        this.dragOffset = 0;
                        this.resetTimer();
                    },
                }
            }
        </script>
    @endpush
</div>
