<div class="max-w-xl mx-auto mt-10 p-6 bg-white rounded-xl shadow-md space-y-6">
    @if (session()->has('message'))
        <div class="p-4 bg-green-100 text-green-700 rounded">
            {{ session('message') }}
        </div>
    @endif

    {{-- Step Indicators --}}
    <div class="flex justify-center space-x-2">
        @foreach ([1, 2, 3] as $s)
            <div class="w-4 h-4 rounded-full {{ $step === $s ? 'bg-blue-600' : 'bg-gray-300' }}"></div>
        @endforeach
    </div>

    {{-- Step 1: Account Info --}}
    @if ($step === 1)
        <div class="space-y-4">
            <input wire:model="email" type="email" placeholder="Email" class="w-full border p-2 rounded" />
            <input wire:model="username" type="text" placeholder="Username" class="w-full border p-2 rounded" />
            <input wire:model="password" type="password" placeholder="Password" class="w-full border p-2 rounded" />
            <input wire:model="password_confirmation" type="password" placeholder="Confirm Password"
                class="w-full border p-2 rounded" />
        </div>
    @endif

    {{-- Step 2: Personal Info --}}
    @if ($step === 2)
        <div class="space-y-4">
            <input wire:model="full_name" type="text" placeholder="Full Name" class="w-full border p-2 rounded" />
            <input wire:model="birthdate" type="date" class="w-full border p-2 rounded" />
            <select wire:model="gender" class="w-full border p-2 rounded">
                <option value="">Select Gender (Optional)</option>
                <option>Male</option>
                <option>Female</option>
                <option>Other</option>
            </select>
            <input wire:model="phone" type="text" placeholder="Phone (Optional)" class="w-full border p-2 rounded" />
            <input wire:model="location" type="text" placeholder="Location" class="w-full border p-2 rounded" />
        </div>
    @endif

    {{-- Step 3: Profile Picture --}}
    @if ($step === 3)
        <div class="space-y-4">
            <input wire:model="profile_picture" type="file" class="w-full" />
            @if ($profile_picture)
                <img src="{{ $profile_picture->temporaryUrl() }}" class="h-32 w-32 object-cover rounded-full" />
            @endif
        </div>
    @endif

    {{-- Navigation Buttons --}}
    <div class="flex justify-between mt-6">
        @if ($step > 1)
            <button wire:click="previousStep" class="bg-gray-300 px-4 py-2 rounded">Back</button>
        @endif

        @if ($step < 3)
            <button wire:click="nextStep" class="bg-blue-600 text-white px-4 py-2 rounded">Next</button>
        @else
            <button wire:click="submit" class="bg-green-600 text-white px-4 py-2 rounded">Submit</button>
        @endif
    </div>
</div>
