<!-- Action Sheet -->
<div class="z-20 fixed sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto bottom-0 left-0 right-0 bg-white dark:bg-zinc-900 shadow-lg transform translate-y-full transition-transform duration-300 rounded-t-2xl"
    :class="{ 'translate-y-full': !showProfilePicLayoutModal, 'translate-y-0': showProfilePicLayoutModal }">
    <div class="p-4">
        <div class="flex justify-between">
            <h3 class="text-lg font-bold text-slate-800 dark:text-slate-300 flex items-center">
                <x-radix-layout class="size-6" />&nbsp;&nbsp;
                Available Layouts
            </h3>
            <!-- Close Action Sheet -->
            <button @click="showProfilePicLayoutModal=!showProfilePicLayoutModal" class="text-gray-500 toggleActionSheet">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        <div class="mt-4 space-y-3">

            {{-- Default Profile Layout --}}
            <button wire:click="setLayout('default')"
                class="block w-full px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600 space-between text-sm"><span
                    class="font-medium">Default (Circular)</span>&nbsp;&nbsp;

                @if ($set_layout == 'default')
                    <span
                        class="justify-self-end rounded-full bg-green-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-green-700">Active</span>
                @endif

            </button>

            {{-- Rounded Profile Layout --}}
            <button wire:click="setLayout('rounded')"
                class="block w-full px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600 space-between text-sm"><span
                    class="font-medium">Rounded</span>&nbsp;&nbsp;

                @if ($set_layout == 'rounded')
                    <span
                        class="justify-self-end rounded-full bg-green-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-green-700">Active</span>
                @endif

            </button>

            {{-- Default with Cover Photo --}}
            <button wire:click="setLayout('default_cover')"
                class="block w-full px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600 space-between text-sm"><span
                    class="font-medium">With cover photo</span>&nbsp;&nbsp;

                @if ($set_layout == 'default_cover')
                    <span
                        class="justify-self-end rounded-full bg-green-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-green-700">Active</span>
                @endif

            </button>

            {{-- Full width profile photo --}}
            <button wire:click="setLayout('full_width')"
                class="block w-full px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600 space-between text-sm"><span
                    class="font-medium">Full width profile photo</span>&nbsp;&nbsp;

                @if ($set_layout == 'full_width')
                    <span
                        class="justify-self-end rounded-full bg-green-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-green-700">Active</span>
                @endif

            </button>


            {{-- Cover photo only --}}
            <button wire:click="setLayout('cover_only')"
                class="block w-full px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600 space-between text-sm"><span
                    class="font-medium">Cover photo only</span>&nbsp;&nbsp;

                @if ($set_layout == 'cover_only')
                    <span
                        class="justify-self-end rounded-full bg-green-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-green-700">Active</span>
                @endif

            </button>

            {{-- <button wire:click="setMainCardActive"
                class="block w-full px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600 space-between text-sm"><span
                    class="font-medium">Default (Circular)</span>&nbsp;&nbsp;

                @if ($maincard == 1)
                    <span
                        class="justify-self-end rounded-full bg-green-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-green-700">Active</span>
                @endif

            </button>

            <button wire:click="setMainCardActive"
                class="block w-full px-4 py-2 text-left text-slate-800 dark:text-slate-300 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 hover:text-blue-600 space-between text-sm"><span
                    class="font-medium">Default (Circular)</span>&nbsp;&nbsp;

                @if ($maincard == 1)
                    <span
                        class="justify-self-end rounded-full bg-green-100 px-2 py-1 my-5 sm:my-0 text-[10px] font-medium text-green-700">Active</span>
                @endif

            </button> --}}

            <button @click="showProfilePicLayoutModal=!showProfilePicLayoutModal"
                class="w-full px-4 py-2 text-left text-red-600 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 text-sm">Cancel</button>
        </div>
    </div>
</div>
