<div x-cloak class="m-0 p-0">
    <livewire:card-view-tracker :username="$user->username" />
    @if ($ads_top->count() > 0)
        <div wire:ignore x-data="carouselData_top()" x-cloak x-init="init" @touchstart.window="startTouch($event)"
            @touchend.window="endTouch($event)"
            class="sticky top-0 left-0 right-0 sm:w-7/12 md:w-6/12 lg:w-4/12 w-full m-0 p-0 mx-auto flex flex-col content-center rounded-2xl z-50"
            style="margin-top: 0 !important; padding-top: 0 !important;">

            <!-- Carousel -->
            @if ($ad_banner_w && $ad_banner_h)
                <div class="relative overflow-hidden w-full"
                    style="padding-top: {{ ($ad_banner_h / $ad_banner_w) * 100 }}%;">

                    <livewire:ad-component x-cloak :ads="$ads_top" :username="$user->username" />

                </div>
            @endif
        </div>

        <!-- Alpine Component -->
        @push('scripts')
            <script>
                function carouselData_top() {
                    return {
                        activeIndex: 0,
                        ads: @js($ads_top),
                        timer: null,
                        startX: 0,

                        next() {
                            this.activeIndex = (this.activeIndex + 1) % this.ads.length;
                        },

                        prev() {
                            this.activeIndex = (this.activeIndex - 1 + this.ads.length) % this.ads.length;
                        },

                        goTo(index) {
                            this.activeIndex = index;
                        },

                        init() {
                            if (this.timer) clearInterval(this.timer);
                            this.timer = setInterval(() => this.next(), 5000);
                        },

                        startTouch(event) {
                            this.startX = event.touches[0].clientX;
                        },

                        endTouch(event) {
                            let endX = event.changedTouches[0].clientX;
                            let diffX = this.startX - endX;

                            if (Math.abs(diffX) > 50) {
                                if (diffX > 0) {
                                    this.next(); // swipe left
                                } else {
                                    this.prev(); // swipe right
                                }
                            }
                        }
                    }
                }
            </script>
        @endpush
    @endif


    <div id="custom_bg"
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin && count($ads_bottom) < 1 ? 'mb-20' : 'mb-2' }}">

        {{-- Top Navigation --}}
        <div
            class="grid grid-cols-4 gap-4 mb-5 pt-5 z-10 {{ $profile_layout == 'default_cover' || $profile_layout == 'cover_only' || $profile_layout == 'full_width' ? 'absolute top-0 left-0 w-full' : '' }}">
            <div class="ml-5 flex items-center col-span-2">
                <a href="{{ route('card.show', $user->username) }}"
                    class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                    <x-heroicon-o-home class="size-5" />
                </a>
            </div>

            <div class="mr-5 flex items-center col-span-2 place-content-end" x-data="{
                urlTitle: `{{ $page_title }}`,
                shareUrl: '{{ route('page.show', [$user->username, $slug]) }}',
                shareCard() {
                    if (navigator.share) {
                        navigator.share({
                            title: this.urlTitle,
                            url: this.shareUrl,
                        }).catch(console.error);
                    } else {
                        console.log('Web Share API not supported');
                    }
                }
            }">
                <button type="button" @click="showQRCode=!showQRCode"
                    class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                    <x-heroicon-o-qr-code class="size-5" />
                </button>

                <a href="#" x-on:click.prevent="shareCard"
                    class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                    <x-heroicon-o-arrow-up-tray class="size-5" />
                </a>
            </div>
        </div>

        {{-- Display Profile Picture --}}
        {{-- cover photo --}}
        @if ($profile_layout == 'default_cover')
            <img loading="lazy"
                src="{{ $user->cover_pic ? asset($user->cover_pic) : asset('/img/cover-placeholder.jpg') }}"
                alt="{{ $firstname . ' ' . $lastname }}" class="w-full rounded-t-2xl mx-auto ">

            <img loading="lazy"
                src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                alt="{{ $firstname . ' ' . $lastname }}" class="rounded-full w-6/12 mx-auto -mt-28"
                style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
        @endif

        {{-- Cover Only --}}
        @if ($profile_layout == 'cover_only')
            <img loading="lazy"
                src="{{ $user->cover_pic ? asset($user->cover_pic) : asset('/img/cover-placeholder.jpg') }}"
                alt="{{ $firstname . ' ' . $lastname }}" class="w-full rounded-t-2xl mx-auto ">
        @endif

        {{-- circled profile pic --}}
        @if ($profile_layout == 'default')
            <img loading="lazy"
                src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                alt="{{ $firstname . ' ' . $lastname }}" class="rounded-full w-6/12 mx-auto p-2 static"
                style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
        @endif

        {{-- rounded profile pic --}}
        @if ($profile_layout == 'rounded')
            <img loading="lazy"
                src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                alt="{{ $firstname . ' ' . $lastname }}" class="w-6/12 mx-auto p-2 static"
                style="border: 2px solid {{ $color_settings_profile_pic_border }} !important; border-radius: 50px;">
        @endif

        {{-- full width profile pic --}}
        @if ($profile_layout == 'full_width')
            <img loading="lazy"
                src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                alt="{{ $firstname . ' ' . $lastname }}" class="w-full rounded-t-2xl mx-auto ">
        @endif

        <h1 class="flex items-center justify-center text-2xl md:text-3xl font-medium text-center mt-5 mx-5">
            <span>
                {{ isset($card_title) ? $card_title : $firstname . ' ' . $lastname }}
                @if ($user->user_type == 'Gold')
                    {{-- <x-gmdi-verified class="size-4 inline text-yellow-400" /> --}}
                    <x-gmdi-verified class="size-4 inline" style="color: #0053db !important;" />
                @elseif($user->user_type == 'Platinum')
                    <x-gmdi-verified class="size-4 inline text-blue-500" />
                @endif
            </span>
        </h1>

        {{-- Display Bio --}}
        @if ($bio && $short_bio_enabled == true)
            <p class="mx-auto w-10/12 text-center text-l py-1">
                {{ $bio }}
            </p>
        @endif

        {{-- Display Job Title --}}
        @if (!empty($user->job_title) && empty($user->company))
            <p class="text-center text-base py-1 mx-8">
                <span class="inline-flex items-start gap-2">
                    <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                    <span>{{ $user->job_title }}</span>
                </span>
            </p>
        @endif

        {{-- Display Job Title and company --}}
        @if (!empty($user->job_title) && !empty($user->company))

            <p class="text-center text-base py-1 mx-8">
                <span class="inline-flex items-start gap-2">
                    <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                    <span>{{ $user->job_title }}

                        @if (!empty($user->company_website))
                            at <a
                                href="{{ filter_var($user->company_website, FILTER_VALIDATE_URL) ? $user->company_website : '#' }}"
                                class="font-medium"
                                style="color: {{ $color_settings_link }} !important;">{{ $user->company }}</a>
                        @else
                            at <span class="font-medium">{{ $user->company }}</span>
                        @endif

                    </span>
                </span>
            </p>
        @endif

        @if (($user->address || $user->country) && $display_country)
            <p class="flex items-center justify-center text-center text-l py-1 space-x-2">
                <x-heroicon-o-map-pin class="size-5" />
                <x-country-flag :country="$user->country" />
            </p>
        @endif

        @if ($contacts || $user->user_type != 'Free')
            <p class="flex items-center justify-center text-center pt-5">
                {{ $contact_text }}
            </p>
        @endif

        <div class="pt-2 container mx-auto flex flex-wrap items-center justify-center">

            @if (in_array($user->user_type, ['Basic', 'Sponsored', 'Influencer', 'Gold', 'Platinum']) && $connect_icon == true)
                <a wire:navigate href="{{ route('card.exchange', $user->username) }}">
                    <x-fas-handshake class="size-6 mx-2 my-2" />
                </a>
            @endif

            @if (in_array($user->user_type, ['Free', 'Basic', 'Sponsored', 'Influencer', 'Gold', 'Platinum']) && $communities)
                <button @click="openCommunitiesModal=!openCommunitiesModal">
                    <x-fas-users class="size-6 mx-2 my-2" />
                </button>
            @endif

            @if (in_array($user->user_type, ['Sponsored', 'Gold', 'Platinum']) && $directions)
                <button @click="openDrivingDirectionModal=!openDrivingDirectionModal">
                    <x-fas-map-location-dot class="size-6 mx-2 my-2" />
                </button>
            @endif

            {{-- Other contact points here --}}
            @if ($contacts)
                @foreach ($contacts as $contact)
                    @if ($contact['type'] === 'sms')
                        <a href="sms:{{ $contact['link'] }}" target="_blank">
                            <x-fas-sms class="size-6 mx-2 my-2" />
                        </a>
                    @elseif ($contact['type'] === 'phone')
                        <a href="tel:{{ $contact['link'] }}" target="_blank">
                            <x-heroicon-s-phone class="size-6 mx-2 my-2" />
                        </a>
                    @elseif ($contact['type'] === 'email')
                        <a href="mailto:{{ $contact['link'] }}" target="_blank">
                            <x-fas-envelope class="size-6 mx-2 my-2" />
                        </a>
                    @elseif ($contact['type'] === 'whatsapp')
                        <a href="{{ $contact['link'] }}" target="_blank">
                            <x-ri-whatsapp-fill class="size-6 mx-2 my-2" />
                        </a>
                    @elseif ($contact['type'] === 'wechat')
                        <a href="{{ $contact['link'] }}" target="_blank">
                            <x-ri-wechat-fill class="size-6 mx-2 my-2" />
                        </a>
                    @elseif ($contact['type'] === 'zalo')
                        <a href="{{ $contact['link'] }}" target="_blank">
                            <x-si-zalo class="size-6 mx-2 my-2" />
                        </a>
                    @elseif ($contact['type'] === 'telegram')
                        <a href="{{ $contact['link'] }}" target="_blank">
                            <x-fileicon-telegram class="size-6 mx-2 my-2" />
                        </a>
                    @elseif ($contact['type'] === 'zoom')
                        <a href="{{ $contact['link'] }}" target="_blank">
                            {{-- <x-bxl-zoom class="size-6 mx-2 my-2" /> --}}
                            <x-si-zoom class="size-12 mx-2 my-2" />
                        </a>
                    @elseif ($contact['type'] === 'community')
                        <a href="{{ $contact['link'] }}" target="_blank">
                            <x-fas-users class="size-6 mx-2 my-2" />
                        </a>
                    @endif
                @endforeach
            @endif
        </div>

        @if ($socials)
            <p class="flex items-center justify-center text-center pt-5">
                {{ $follow_text }}
            </p>

            <!-- Social Media Buttons -->
            <div class="pt-2 container mx-auto flex  flex-wrap items-center justify-center">
                @foreach ($socials as $social)
                    {{-- @php
                            dd($social->id);
                        @endphp --}}
                    <livewire:social-icon-component :username="$user->username" :social_id="$social->id" :link="$social->link"
                        :social_type="$social->type" />
                @endforeach
            </div>

        @endif

        <div class="items-center mt-5 space-y-6">

            @if ($page && is_array($page->contents))
                @foreach ($page->contents as $element)
                    {{-- Button --}}
                    @if ($element['type'] === 'button')
                        <a href="{{ $element['value'] }}" target="_blank"
                            class="block p-3 rounded-md mx-5 text-black text-center my-5 text-l font-bold"
                            style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                            {{ $element['title'] }}
                        </a>

                        {{-- Heading --}}
                    @elseif ($element['type'] === 'heading')
                        <div class="prose prose-invert px-5">
                            <h1 class="text-xl text-center text-black dark:text-white">
                                {!! Purifier::clean($element['value']) !!}
                            </h1>
                        </div>

                        {{-- HTML --}}
                    @elseif ($element['type'] === 'html')
                        <div class="text-center prose prose-invert max-w-none text-black dark:text-white px-5">
                            {!! Purifier::clean($element['value']) !!}
                        </div>

                        {{-- Image --}}
                    @elseif ($element['type'] === 'image')
                        <div class="w-full px-5">
                            <img src="{{ asset('storage/' . $element['value']) }}"
                                class="object-cover rounded-xl w-full"
                                style="border: 2px solid {{ $color_settings_profile_pic_border }};"
                                draggable="false">
                        </div>

                        @if ($element['call_to_action'])
                            <div class="flex justify-center">
                                <a href="{{ $element['call_to_action'] }}" target="_blank"
                                    class="inline-flex px-4 py-3 rounded-md text-center text-l font-bold items-center justify-center max-w-[83.333333%]"
                                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                    {{-- {{ $video->button_title ? $video->button_title : 'Click here' }} --}}
                                    Click here
                                </a>
                            </div>
                        @endif

                        {{-- Video --}}
                    @elseif ($element['type'] === 'video')
                        @php
                            $videoUrl = $element['value'];
                            $videoId = null;
                            $videoHash = null;

                            $isVimeo = false;
                            $isInstagram = false;
                            $isTikTok = false;
                            $instagramType = null;

                            // -----------------------------
                            // YOUTUBE
                            // -----------------------------
                            if (preg_match('#youtu\.be/([a-zA-Z0-9_-]+)#', $videoUrl, $matches)) {
                                $videoId = $matches[1];
                            } elseif (preg_match('#youtube\.com/watch\?v=([a-zA-Z0-9_-]+)#', $videoUrl, $matches)) {
                                $videoId = $matches[1];
                            } elseif (preg_match('#youtube\.com/shorts/([a-zA-Z0-9_-]{11})#', $videoUrl, $matches)) {
                                $videoId = $matches[1];
                            }

                            // -----------------------------
                            // VIMEO (any format)
                            // -----------------------------
                            // if (str_contains($videoUrl, 'vimeo.com')) {
                            //     $isVimeo = true;

                            //     $clean = preg_replace(
                            //         ['#https?://(www\.)?vimeo\.com/#', '#https?://player\.vimeo\.com/video/#'],
                            //         '',
                            //         $videoUrl,
                            //     );

                            //     $parts = explode('/', $clean);
                            //     $videoId = $parts[0] ?? null;

                            //     if (isset($parts[1]) && !str_contains($parts[1], '?')) {
                            //         $videoHash = $parts[1];
                            //     }

                            //     if (str_contains($videoUrl, '?h=')) {
                            //         parse_str(parse_url($videoUrl, PHP_URL_QUERY), $query);
                            //         $videoHash = $query['h'] ?? $videoHash;
                            //     }
                            // }

                            if (str_contains($videoUrl, 'vimeo.com')) {
                                $isVimeo = true;

                                // 1) Extract ID
                                if (preg_match('#vimeo\.com/(?:video/)?(\d+)#', $videoUrl, $m)) {
                                    $videoId = $m[1];
                                }

                                // 2) Extract hash from path
                                if (preg_match('#vimeo\.com/\d+/([a-zA-Z0-9]+)#', $videoUrl, $m)) {
                                    $videoHash = $m[1];
                                }

                                // 3) Extract hash from ?h= query
                                parse_str(parse_url($videoUrl, PHP_URL_QUERY) ?? '', $query);
                                if (isset($query['h'])) {
                                    $videoHash = $query['h'];
                                }
                            }

                            // -----------------------------
                            // INSTAGRAM – reels, posts, IGTV
                            // -----------------------------
                            if (str_contains($videoUrl, 'instagram.com')) {
                                if (preg_match('#instagram\.com/(reel|reels|p|tv)/([^/?]+)/?#', $videoUrl, $matches)) {
                                    // $instagramType = $matches[1];
                                    $instagramType = $matches[1] === 'reels' ? 'reel' : $matches[1];
                                    $videoId = $matches[2];
                                    $isInstagram = true;
                                }
                            }

                            // -----------------------------
                            // TIKTOK
                            // -----------------------------
                            if (str_contains($videoUrl, 'tiktok.com')) {
                                if (preg_match('#/video/(\d+)#', $videoUrl, $matches)) {
                                    $videoId = $matches[1];
                                    $isTikTok = true;
                                }
                            }

                            // -----------------------------
                            // Aspect ratio control
                            // -----------------------------
                            $padding = '56.25%'; // default 16:9

                            if ($isInstagram) {
                                $padding = '130%'; // tall vertical layout
                            }

                            if ($isTikTok) {
                                $padding = '135%'; // taller vertical layout
                            }
                        @endphp

                        <div class="w-full px-5">
                            <div class="relative rounded-xl overflow-hidden block"
                                style="width: 100%; padding-bottom: {{ $padding }}; border: 2px solid {{ $color_settings_profile_pic_border }} !important;">

                                @if ($isVimeo)
                                    <iframe
                                        src="https://player.vimeo.com/video/{{ $videoId }}{{ $videoHash ? '?h=' . $videoHash : '' }}"
                                        class="absolute top-0 left-0 w-full h-full rounded-xl"
                                        allow="autoplay; fullscreen; picture-in-picture" frameborder="0"
                                        allowfullscreen>
                                    </iframe>
                                @elseif ($isInstagram)
                                    <iframe class="absolute top-0 left-0 w-full h-full rounded-xl"
                                        src="https://www.instagram.com/{{ $instagramType }}/{{ $videoId }}/embed"
                                        frameborder="0" allowfullscreen>
                                    </iframe>
                                @elseif ($isTikTok)
                                    <iframe class="absolute top-0 left-0 w-full h-full rounded-xl"
                                        src="https://www.tiktok.com/embed/{{ $videoId }}" frameborder="0"
                                        allowfullscreen>
                                    </iframe>
                                @else
                                    {{-- Default YouTube --}}
                                    <iframe class="absolute top-0 left-0 w-full h-full rounded-xl"
                                        src="https://www.youtube.com/embed/{{ $videoId }}?enablejsapi=1"
                                        frameborder="0"
                                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                        allowfullscreen>
                                    </iframe>
                                @endif

                            </div>
                        </div>
                    @endif
                @endforeach
            @endif

        </div>
    </div>

    @if ($ads_bottom->count() > 0)
        <div wire:ignore x-data="carouselData_bottom()" x-init="init" @touchstart.window="startTouch($event)"
            @touchend.window="endTouch($event)" {{-- class="left-0 right-0 sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto flex flex-col content-center rounded-2xl relative {{ auth()->user() ? 'mb-20' : 'mb-5' }}" --}}
            class="top-0 left-0 right-0 sm:w-7/12 md:w-6/12 lg:w-4/12 w-full m-0 p-0 mx-auto flex flex-col content-center rounded-2xl z-50 {{ auth()->user() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}"
            style="margin-top: 0 !important; padding-top: 0 !important;">

            <!-- Carousel -->
            @if ($ad_banner_w && $ad_banner_h)
                {{-- <div class="relative overflow-hidden aspect-[{{ $ad_banner_w . '/' . $ad_banner_h }}]"> --}}
                <div class="relative overflow-hidden w-full"
                    style="padding-top: {{ ($ad_banner_h / $ad_banner_w) * 100 }}%;">

                    <livewire:ad-component x-cloak :ads="$ads_bottom" :username="$user->username" />
                </div>
            @endif

        </div>

        <!-- Alpine Component -->
        @push('scripts')
            <script>
                function carouselData_bottom() {
                    return {
                        activeIndex: 0,
                        ads: @js($ads_bottom),
                        timer: null,
                        startX: 0,

                        next() {
                            this.activeIndex = (this.activeIndex + 1) % this.ads.length;
                        },

                        prev() {
                            this.activeIndex = (this.activeIndex - 1 + this.ads.length) % this.ads.length;
                        },

                        goTo(index) {
                            this.activeIndex = index;
                        },

                        init() {
                            // this.timer = setInterval(() => {
                            //     this.next();
                            // }, 3000);

                            if (this.timer) clearInterval(this.timer);
                            this.timer = setInterval(() => this.next(), 5000);
                        },

                        startTouch(event) {
                            this.startX = event.touches[0].clientX;
                        },

                        endTouch(event) {
                            let endX = event.changedTouches[0].clientX;
                            let diffX = this.startX - endX;

                            if (Math.abs(diffX) > 50) {
                                if (diffX > 0) {
                                    this.next(); // swipe left
                                } else {
                                    this.prev(); // swipe right
                                }
                            }
                        }
                    }
                }
            </script>
        @endpush
    @endif
</div>
