<div x-cloak class="m-0 p-0">
    @if ($user && $is_active && $user->user_type != null)
        <livewire:card-view-tracker :username="$user->username" />
        <div id="custom_bg"
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}">

            {{-- Top Navigation --}}
            <div
                class="grid grid-cols-4 gap-4 mb-5 pt-5 z-10 {{ $profile_layout == 'default_cover' || $profile_layout == 'cover_only' || $profile_layout == 'full_width' ? 'absolute top-0 left-0 w-full' : '' }}">
                <div class="ml-5 flex items-center col-span-2">
                    <a href="{{ route('card.show', $user->username) }}"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-home class="size-5" />
                    </a>
                </div>

                <div class="mr-5 flex items-center col-span-2 place-content-end" x-data="{
                    urlTitle: `Payments | {{ $page_title ?: $card_title }}`,
                    shareUrl: '{{ route('card.pay', $user->username) }}',
                    shareCard() {
                        if (navigator.share) {
                            navigator.share({
                                title: this.urlTitle,
                                url: this.shareUrl,
                            }).catch(console.error);
                        } else {
                            console.log('Web Share API not supported');
                        }
                    }
                }">
                    <button type="button" @click="showQRCode=!showQRCode"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                        <x-heroicon-o-qr-code class="size-5" />
                    </button>
                    <a href="#" x-on:click.prevent="shareCard"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-arrow-up-tray class="size-5" />
                    </a>
                </div>
            </div>

            {{-- Profile Layouts --}}
            @if ($profile_layout == 'default_cover')
                <img loading="lazy"
                    src="{{ $user['cover_pic'] ? asset($user['cover_pic']) : asset('/img/cover-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto">
                <img loading="lazy"
                    src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}"
                    class="rounded-full w-6/12 mx-auto -mt-28 border-2"
                    style="border-color: {{ $color_settings_profile_pic_border }} !important;">
            @elseif ($profile_layout == 'cover_only')
                <img loading="lazy"
                    src="{{ $user['cover_pic'] ? asset($user['cover_pic']) : asset('/img/cover-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto">
            @elseif ($profile_layout == 'default')
                <img loading="lazy"
                    src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}"
                    class="rounded-full w-6/12 mx-auto p-2 border-2"
                    style="border-color: {{ $color_settings_profile_pic_border }} !important;">
            @elseif ($profile_layout == 'rounded')
                <img loading="lazy"
                    src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}"
                    class="w-6/12 mx-auto p-2 border-2 rounded-[50px]"
                    style="border-color: {{ $color_settings_profile_pic_border }} !important;">
            @elseif ($profile_layout == 'full_width')
                <img loading="lazy"
                    src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto">
            @endif

            {{-- Display Full Name --}}
            <h1 class="flex items-center justify-center text-2xl md:text-3xl font-medium text-center mt-5 mx-5">
                <span>
                    {{ isset($card_title) ? $card_title : $firstname . ' ' . $lastname }}
                    @if ($user->user_type == 'Gold')
                        {{-- <x-gmdi-verified class="size-4 inline text-yellow-400" /> --}}
                        <x-gmdi-verified class="size-4 inline" style="color: #0053db !important;" />
                    @elseif($user->user_type == 'Platinum')
                        <x-gmdi-verified class="size-4 inline text-blue-500" />
                    @endif
                </span>
            </h1>

            @if ($username_enabled == true)
                <p class="rounded-full bg-yellow-400 py-1 px-2 text-[10px] text-black mx-auto w-fit my-2">
                    {{ '@' . $user->username }}
                </p>
            @endif

            {{-- Display Bio --}}
            @if ($bio && $short_bio_enabled == true)
                <p class="mx-auto w-10/12 text-center text-l py-1">
                    {{ $bio }}
                </p>
            @endif

            {{-- Display Job Title --}}
            @if (!empty($user->job_title) && empty($user->company))
                <p class="text-center text-base py-1 mx-8">
                    <span class="inline-flex items-start gap-2">
                        <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                        <span>{{ $user->job_title }}</span>
                    </span>
                </p>
            @endif

            {{-- Display Job Title and company --}}
            @if (!empty($user->job_title) && !empty($user->company))

                <p class="text-center text-base py-1 mx-8">
                    <span class="inline-flex items-start gap-2">
                        <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                        <span>{{ $user->job_title }}

                            @if (!empty($user->company_website))
                                at <a
                                    href="{{ filter_var($user->company_website, FILTER_VALIDATE_URL) ? $user->company_website : '#' }}"
                                    class="font-medium"
                                    style="color: {{ $color_settings_link }} !important;">{{ $user->company }}</a>
                            @else
                                at <span class="font-medium">{{ $user->company }}</span>
                            @endif

                        </span>
                    </span>
                </p>
            @endif

            @if (($user->address || $user->country) && $display_country)
                <p class="flex items-center justify-center text-center text-l py-1 space-x-2">
                    <x-heroicon-o-map-pin class="size-5" />
                    <x-country-flag :country="$user->country" :state="$user->state" />
                </p>
            @endif

            {{-- <div class="items-center mt-5"> --}}
            <div
                class="items-center {{ in_array($user->user_type, ['Free', 'Basic', 'Sponsored', 'Influencer']) ? 'pt-5' : '' }}">

                @if ($payments)
                    @foreach ($payments as $button)
                        @php $type = $button['type']; @endphp

                        @if ($type === 'zelle')
                            <a class="flex cursor-pointer items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                @click.prevent="openPaymentLinkModal=!openPaymentLinkModal;button_zelle=true;payment_value='{{ $button['link'] }}'">
                                <x-si-zelle class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button['title'] }}</a>
                            @continue
                        @endif

                        {{-- APPLE PAY --}}
                        @if ($type === 'apple_pay')
                            <a class="flex cursor-pointer items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                @click.prevent="openPaymentLinkModal=!openPaymentLinkModal;button_apple_pay=true;payment_value='{{ $button['link'] }}'">
                                <x-fab-apple class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button['title'] }}</a>
                            @continue
                        @endif

                        {{-- PAYPAL EMAIL --}}
                        @if ($type === 'paypal_email')
                            <a class="flex cursor-pointer items-center justify-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                                @click.prevent="openPaymentLinkModal=!openPaymentLinkModal;button_paypal_email=true;payment_value='{{ $button['link'] }}'">
                                <x-fab-paypal class="size-4 inline" />
                                &nbsp;&nbsp;
                                {{ $button['title'] }}
                            </a>
                            @continue
                        @endif

                        {{-- FALLBACK BUTTON (for all other types) --}}
                        <livewire:button-component :username="$user->username" :link="$button->link" :button_id="$button->id"
                            :button_type="$button->type" :title="$button->title" />
                    @endforeach
                @endif


            </div>

        </div>


</div>
</div>
@else
<div class="h-screen flex justify-center items-center">
    <div>
        <p class="mx-auto text-yellow-500 text-center text-l p-10">
            <x-ionicon-warning-sharp class=" size-32 sm:size-40" />
        </p>
        <p class="mx-auto font-bold text-center text-2xl text-gray-500 dark:text-white">User not found.
        </p>
    </div>
</div>


@endif
</div>
