<div class="w-full relative mx-auto px-5 mt-10" style="z-index: 60; position: relative;">
    <script>
        document.addEventListener('DOMContentLoaded', function() {

            document.querySelectorAll('[data-video-index]').forEach((block) => {
                const iframe = block.querySelector('iframe');
                const thumbOverlay = block.querySelector('.thumbnail-overlay');
                const playButton = block.querySelector('.play-button');

                if (!iframe || !playButton || !thumbOverlay) return;

                playButton.addEventListener('click', () => {

                    // Hide thumbnail
                    thumbOverlay.style.display = 'none';

                    // YouTube player
                    if (iframe.src.includes('youtube')) {
                        iframe.contentWindow.postMessage(JSON.stringify({
                            event: 'command',
                            func: 'playVideo',
                            args: []
                        }), '*');
                    }

                    // Vimeo player
                    if (iframe.src.includes('vimeo')) {
                        const player = new Vimeo.Player(iframe);
                        player.play().catch(() => {});
                    }
                });
            });

        });
    </script>

    <script src="https://www.youtube.com/iframe_api"></script>
    <script src="https://player.vimeo.com/api/player.js"></script>

    <div class="space-y-10"> {{-- Stack videos vertically --}}
        {{-- @foreach ($videos as $index => $video) --}}
        @foreach ($showOnlyFirstVideo ? $videos->take(1) : $videos as $index => $video)
            @php
                $videoUrl = $video['link'];
                $videoId = null;
                $videoHash = null;
                $isVimeo = false;

                if (
                    preg_match('#(?:https?://)?(?:www\.)?youtube\.com/watch\?v=([a-zA-Z0-9_-]+)#', $videoUrl, $matches)
                ) {
                    $videoId = $matches[1];
                } elseif (
                    preg_match('#(?:https?://)?(?:www\.)?youtube\.com/shorts/([a-zA-Z0-9_-]{11})#', $videoUrl, $matches)
                ) {
                    $videoId = $matches[1];
                } elseif (preg_match('#(?:https?://)?(?:www\.)?youtu\.be/([a-zA-Z0-9_-]+)#', $videoUrl, $matches)) {
                    $videoId = $matches[1];
                } elseif (
                    preg_match('#(?:https?://)?(?:www\.)?m\.youtube\.com/v/([a-zA-Z0-9_-]+)#', $videoUrl, $matches)
                ) {
                    $videoId = $matches[1];
                } elseif (preg_match('#vimeo\.com/(?:video/)?(\d+)(?:/([a-zA-Z0-9]+))?#', $videoUrl, $matches)) {
                    $videoId = $matches[1];
                    $videoHash = $matches[2] ?? null;
                    $isVimeo = true;
                }

            @endphp

            <div class="w-full rounded-xl" data-video-index="{{ $index }}">
                <div class="rounded-xl relative w-full"
                    style="height: 0; padding-bottom: 56.25%; border: 2px solid {{ $color_settings_profile_pic_border }} !important;">

                    {{-- Vimeo --}}
                    @if ($isVimeo)
                        <iframe id="vimeo-player-{{ $index }}" class="absolute w-full h-full rounded-xl"
                            src="https://player.vimeo.com/video/{{ $videoId }}{{ $videoHash ? '?h=' . $videoHash : '' }}"
                            title="{{ $video['title'] }}" frameborder="0"
                            allow="autoplay; fullscreen; picture-in-picture" allowfullscreen></iframe>

                        {{-- YouTube --}}
                    @else
                        <iframe id="youtube-player-{{ $index }}" class="absolute w-full h-full rounded-xl"
                            src="https://www.youtube.com/embed/{{ $videoId }}?enablejsapi=1"
                            title="{{ $video['title'] }}" frameborder="0"
                            allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                            referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    @endif

                    {{-- THUMBNAIL OVERLAY --}}
                    <div class="absolute w-full h-full rounded-xl thumbnail-overlay"
                        style="
                            background-image: url('{{ $video->thumbnail }}');
                            background-size: cover;
                            background-position: center;
                            z-index: 1;
                        ">
                        {{-- Play Button --}}
                        <div class="absolute w-full h-full flex justify-center items-center play-button-container">
                            <svg width="60" height="60" viewBox="0 0 60 60" fill="none"
                                xmlns="http://www.w3.org/2000/svg" class="play-button">
                                <circle cx="30" cy="30" r="30" fill="#fff" />
                                <path d="M25 20L40 30L25 40V20Z" fill="#333" />
                            </svg>
                        </div>
                    </div>
                </div>

                {{-- CUSTOM BUTTON (if exists) --}}
                @if ($video->button_link)
                    <div class="flex justify-center">
                        <a href="{{ $video->button_link }}" target="_blank"
                            class="inline-flex my-5 px-4 py-3 {{ $button_style === 'squared' ? 'rounded-md' : 'rounded-full' }} text-center text-l font-bold items-center justify-center max-w-[83.333333%]"
                            style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                            {{ $video->button_title ?: 'Click here' }}
                        </a>
                    </div>
                @endif
            </div>
        @endforeach
    </div>
</div>
