<div x-data="{ showToast: false }">
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                {{-- <a wire:navigate href="{{ route('dashboard.profile') }}"
                        class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                        <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                stroke-width="1.5" stroke="currentColor" class="size-4">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                            </svg>
                        </span>
                    </a> --}}
            </div>
            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <x-heroicon-o-users class="size-6 inline-block" />

                &nbsp;&nbsp;My Network
            </p>
            <div class="flex items-center col-span-1 place-content-end">
                {{-- <a href="{{ route('card.show', auth()->user()->username) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a> --}}

                {{-- <a href="{{ route('card.show', auth()->user()->username) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-xs font-semibold shadow-xs flex bg-white text-black items-center">
                    View&nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" />
                </a> --}}

                <a href="{{ route('card.show', auth()->user()->username) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>

        </div>

        @if (in_array($user_type, ['Basic', 'Gold', 'Platinum']))
            <div class="grid grid-cols-3 mt-5 gap-4">

                <div class="h-fit col-span-2">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Add New Contact
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">There are three ways to save a contact:
                        tapping the bookmark on the card, manual entry, or via form submissions.</p>
                </div>

                <div class="flex items-center col-span-1 place-content-end">
                    <a wire:navigate href="{{ route('network.add') }}"
                        class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <x-heroicon-o-plus class="size-6" />
                        </span>
                    </a>
                </div>
            </div>
        @endif
    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 sm:py-10 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        <div class="flex justify-between mb-4 border-b border-gray-200">
            {{-- <button id="recent-tab" class="tab-btn active">Recent</button> --}}
            <button id="saved-tab" class="tab-btn active" x-cloak>Saved</button>
            <button id="added-tab" class="tab-btn" x-cloak>Added</button>
            <button id="submission-tab" class="tab-btn" x-cloak>Form</button>
            <button id="feedback-tab" class="tab-btn" x-cloak>Feedback</button>
        </div>

        <div class="relative w-full overflow-hidden">
            <div id="tab-slider" class="flex w-full">
                <div id="saved" class="tab-content active w-full flex-shrink-0 block" x-cloak>
                    @if ($saved->count())
                        <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5">
                            @foreach ($saved as $contact)
                                <li>
                                    <a href="{{ route('card.show', $contact['username']) }}"
                                        class="flex justify-between gap-x-6 py-1 sm:py-3 items-center">
                                        <div class="flex min-w-0 gap-x-4">
                                            <img class="size-12 flex-none rounded-full bg-gray-50"
                                                src="{{ $contact->profile_pic ? asset($contact->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                                                alt="{{ $contact->firstname . ' ' . $contact->lastname }}">
                                            <div class="min-w-0 flex-auto">
                                                <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">
                                                    {{ $contact->firstname . ' ' . $contact->lastname }}
                                                </p>
                                                <p class="truncate text-xs/5 text-gray-500">{{ $contact->job_title }}
                                                </p>
                                            </div>
                                        </div>

                                        <div class="shrink-0 sm:flex sm:flex-col sm:items-end">
                                            <span class="rounded-full text-gray-600 p-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                    viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                    class="size-4">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        d="m8.25 4.5 7.5 7.5-7.5 7.5" />
                                                </svg>

                                            </span>
                                        </div>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <div class=" justify-center items-center my-20">
                            <p class="text-center text-slate-600 dark:text-slate-500 text-base mb-2"> No
                                saved/bookmarked
                                contact(s).
                            </p>
                            <a wire:navigate href="{{ route('dashboard.search') }}"
                                class="w-fit flex items-center mx-auto bg-blue-500 text-white px-3.5 py-1.5 text-base rounded-md">Search
                                Contact &nbsp;
                                <x-heroicon-o-magnifying-glass class="size-4" />
                            </a>
                        </div>
                    @endif

                    {{-- {{ $submission->links() }} --}}
                </div>

                <div id="added" class="tab-content active w-full flex-shrink-0 hidden" x-cloak>
                    {{-- All contacts added manually will be posted here  --}}

                    @php
                        if ($checkifactive > 0) {
                            $submission = \App\Models\LetsConnect::where('user_id', auth()->user()->id)
                                ->whereNull('page_id')
                                ->where('type', 'added')
                                ->orderBy('firstname', 'desc')
                                ->simplePaginate(10);
                        } else {
                            $submission = \App\Models\LetsConnect::where('page_id', $page_id)
                                ->where('type', 'added')
                                ->orderBy('firstname', 'desc')
                                ->simplePaginate(10);
                        }
                    @endphp

                    @if ($submission->count() > 0)
                        <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5">
                            @foreach ($submission->items() as $contact)
                                {{-- {{ dd($contact->id) }} --}}
                                <li>
                                    <a href="{{ route('contact.view', $contact['id']) }}"
                                        class="flex justify-between gap-x-6 py-1 sm:py-3 items-center">
                                        <div class="flex min-w-0 gap-x-4">
                                            <img class="size-12 flex-none rounded-full bg-gray-50"
                                                src="{{ $contact->profile_pic ? asset($contact->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                                                alt="{{ $contact->firstname . ' ' . $contact->lastname }}">
                                            <div class="min-w-0 flex-auto">
                                                <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">
                                                    {{ $contact->firstname . ' ' . $contact->lastname }}
                                                </p>
                                                <p class="truncate text-xs/5 text-gray-500">{{ $contact->job_title }}
                                                </p>
                                            </div>
                                        </div>

                                        <div class="shrink-0 sm:flex sm:flex-col sm:items-end">

                                            <span class="rounded-full text-gray-600 p-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                    viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                    class="size-4">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        d="m8.25 4.5 7.5 7.5-7.5 7.5" />
                                                </svg>

                                            </span>
                                        </div>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <div class="justify-center items-center my-20">
                            <p class="text-center text-slate-600 dark:text-slate-500 text-base mb-2 px-5"> No manually
                                added contact(s).
                            </p>
                            <a wire:navigate href="{{ route('network.add') }}"
                                class="w-fit flex items-center mx-auto bg-blue-500 text-white px-3.5 py-1.5 text-base rounded-md">Add
                                Contact
                                &nbsp;
                                <x-heroicon-o-plus class="size-4" />
                            </a>
                        </div>
                    @endif
                </div>

                <div id="submission" class="tab-content active w-full flex-shrink-0 hidden" x-cloak>

                    @php
                        if ($checkifactive > 0) {
                            $submission = \App\Models\LetsConnect::where('user_id', auth()->user()->id)
                                ->whereNull('page_id')
                                ->where('type', 'submission')
                                ->orderBy('created_at', 'desc')
                                ->simplePaginate(10);
                        } else {
                            $submission = \App\Models\LetsConnect::where('page_id', $page_id)
                                ->where('type', 'submission')
                                ->orderBy('created_at', 'desc')
                                ->simplePaginate(10);
                        }
                    @endphp

                    @if ($submission->count() > 0)
                        <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5">
                            @foreach ($submission->items() as $contact)
                                {{-- {{ dd($contact->id) }} --}}
                                <li>
                                    <a href="{{ route('contact.view', $contact['id']) }}"
                                        class="flex justify-between gap-x-6 py-1 sm:py-3 items-center">
                                        <div class="flex min-w-0 gap-x-4">
                                            <img class="size-12 flex-none rounded-full bg-gray-50"
                                                src="{{ $contact->profile_pic ? asset($contact->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                                                alt="{{ $contact->firstname . ' ' . $contact->lastname }}">
                                            <div class="min-w-0 flex-auto">
                                                <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">
                                                    {{ $contact->firstname . ' ' . $contact->lastname }}
                                                </p>
                                                <p class="truncate text-xs/5 text-gray-500">{{ $contact->email }}
                                                </p>
                                            </div>
                                        </div>

                                        <div class="shrink-0 sm:flex sm:flex-col sm:items-end">

                                            <span class="rounded-full text-gray-600 p-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                    viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                    class="size-4">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        d="m8.25 4.5 7.5 7.5-7.5 7.5" />
                                                </svg>

                                            </span>
                                        </div>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <div class="justify-center items-center my-20">
                            <p class="text-center text-slate-600 dark:text-slate-500 text-base mb-2 px-5"> No
                                form submission. Send them your connect form.
                            </p>
                            <button type="button"
                                @click="navigator.clipboard.writeText('{{ $site_url . auth()->user()->username . '/connect' }}');showToast=true;setTimeout(()=>showToast=false,2000);"
                                class="w-fit flex items-center mx-auto bg-blue-500 text-white px-3.5 py-1.5 text-base rounded-md"><x-fas-copy
                                    class="w-4" />&nbsp;&nbsp;Copy
                                form link
                            </button>
                        </div>
                    @endif

                    {{-- {{ $submission->links() }} --}}

                </div>

                <div id="feedback" class="tab-content active w-full flex-shrink-0 hidden" x-cloak>

                    @php
                        if ($checkifactive > 0) {
                            $feedbacks = \App\Models\FeedbackForm::where('user_id', auth()->user()->id)
                                ->whereNull('page_id')
                                ->orderBy('created_at', 'desc')
                                ->simplePaginate(10);
                        } else {
                            $feedbacks = \App\Models\FeedbackForm::where('page_id', $page_id)
                                ->orderBy('created_at', 'desc')
                                ->simplePaginate(10);
                        }
                    @endphp

                    @if ($feedbacks->count() > 0)
                        <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5">
                            @foreach ($feedbacks->items() as $feedback)
                                <li>
                                    <a @click="showFeedbackModal=!showFeedbackModal"
                                        wire:click.prevent="getFeedback({{ $feedback->id }})"
                                        class="flex justify-between gap-x-6 py-1 sm:py-3 items-center cursor-pointer">

                                        <div class="flex min-w-0 gap-x-4">
                                            <img class="size-12 flex-none rounded-full bg-gray-50"
                                                src="{{ $feedback->profile_pic ? asset($feedback->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                                                alt="{{ $feedback->firstname . ' ' . $feedback->lastname }}">
                                            <div class="min-w-0 flex-auto">
                                                <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">
                                                    {{ $feedback->firstname . ' ' . $feedback->lastname }}
                                                </p>
                                                <p class="truncate text-xs/5 text-gray-500">{{ $feedback->email }}
                                                </p>
                                            </div>
                                        </div>

                                        <div class="shrink-0 sm:flex sm:flex-col sm:items-end">

                                            <span class="rounded-full text-gray-600 p-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none"
                                                    viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"
                                                    class="size-4">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                        d="m8.25 4.5 7.5 7.5-7.5 7.5" />
                                                </svg>

                                            </span>
                                        </div>
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <div class="justify-center items-center my-20">
                            <p class="text-center text-slate-600 dark:text-slate-500 text-base mb-2 px-5"> No
                                feedback submission. Send them your feedback form.
                            </p>
                            <button type="button"
                                @click="navigator.clipboard.writeText('{{ $site_url . auth()->user()->username . '/feedback' }}');showToast=true;setTimeout(()=>showToast=false,2000);"
                                class="w-fit flex items-center mx-auto bg-blue-500 text-white px-3.5 py-1.5 text-base rounded-md"><x-fas-copy
                                    class="w-4" />&nbsp;&nbsp;Copy
                                form link
                            </button>
                        </div>
                    @endif

                    {{-- {{ $submission->links() }} --}}

                </div>
            </div>
        </div>

        <!-- Toast Notification -->
        <div x-show="showToast" x-cloak x-transition:enter="transition transform ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-2" x-transition:enter-end="opacity-100 translate-y-0"
            x-transition:leave="transition transform ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0" x-transition:leave-end="opacity-0 translate-y-2"
            class="fixed bottom-5 left-1/2 transform -translate-x-1/2 bg-green-500 text-white text-sm font-semibold px-4 py-2 rounded-md shadow-lg z-50"
            style="z-index: 99999px">
            Copied to clipboard.
        </div>

    </div>

    {{-- @endif --}}

    @push('scripts')
        <script>
            window.currentTabIndex ??= 0;
            window.tabsInitialized ??= false;
            window.touchTarget ??= null;

            function initTabs() {
                // console.log('initTabs called');

                const tabButtons = document.querySelectorAll('.tab-btn');
                const tabSlider = document.getElementById('tab-slider');

                // Wait for the DOM to render tab buttons
                if (!tabButtons.length || !tabSlider) {
                    // console.log('Tab elements not found yet, retrying in 50ms');
                    setTimeout(initTabs, 50);
                    return;
                }

                if (window.tabsInitialized) {
                    // console.log('Tabs already initialized, skipping');
                    return;
                }

                window.tabsInitialized = true;
                // console.log('Tabs initialized now', tabButtons.length);

                function updateTabSlider(useTransition = false) {
                    if (useTransition) {
                        tabSlider.style.transition = 'transform 300ms ease-in-out';
                    } else {
                        tabSlider.style.transition = 'none';
                    }
                    tabSlider.style.transform = `translateX(-${currentTabIndex * 100}%)`;
                }

                function updateTabButtons() {
                    tabButtons.forEach((button, index) => {
                        button.classList.toggle('active', index === currentTabIndex);
                    });
                }

                tabButtons.forEach((button, index) => {
                    button.addEventListener('click', () => {
                        // console.log('Tab clicked', index);
                        currentTabIndex = index;
                        updateTabSlider(false);
                        updateTabButtons();
                    });
                });

                let touchstartX = 0;
                let touchendX = 0;

                document.addEventListener('touchstart', e => {
                    touchstartX = e.changedTouches[0].screenX;
                    touchTarget = e.target.closest('.tab-btn');
                });

                document.addEventListener('touchend', e => {
                    touchendX = e.changedTouches[0].screenX;
                    const swipeDistance = touchendX - touchstartX;
                    if (Math.abs(swipeDistance) < 30) return;

                    if (swipeDistance < 0 && currentTabIndex < tabButtons.length - 1) currentTabIndex++;
                    else if (swipeDistance > 0 && currentTabIndex > 0) currentTabIndex--;
                    else return;

                    updateTabSlider(true);
                    updateTabButtons();
                });

                // Initial setup
                updateTabSlider(false);
                updateTabButtons();
            }

            // Run after Livewire fully loads
            document.addEventListener('livewire:load', () => {
                // console.log('livewire:load event');
                initTabs();
            });

            // Run again after Livewire navigation
            window.addEventListener('livewire:navigated', function() {
                // console.log('livewire:navigated event');
                setTimeout(initTabs, 300);
            });
        </script>
    @endpush

</div>
