<div>
    <livewire:card-view-tracker :username="$username" />

    @guest
        <div id="custom_bg"
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-10 sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}">

        @endguest

        @auth
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-10 sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}">

            @endauth
            <div class="grid grid-cols-2 gap-4 mb-5 pt-5">
                <!-- back -->
                <div class="ml-5 flex items-center">
                    <a href="{{ route('card.show', $username) }}"
                        class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-chevron-left class="size-4" />
                    </a>
                </div>

                <!-- Share Card -->
                <div class="mr-5 flex items-center place-content-end" x-data="{
                    urlTitle: `{{ $form->title }} |  {{ $page_title ?: $card_title }}`,
                    shareUrl: '{{ route('form.show', [$user->username, $form->slug]) }}',
                    shareCard() {
                        if (navigator.share) {
                            navigator.share({
                                title: this.urlTitle,
                                url: this.shareUrl,
                            }).then(() => {
                                console.log('Thanks for sharing!');
                            }).catch(console.error);
                        } else {
                            console.log('Web Share API not supported');
                        }
                    }
                }">

                    <button type="button" @click="showQRCode=!showQRCode"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                        <x-heroicon-o-qr-code class="size-5" />
                    </button>

                    <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-arrow-up-tray class="size-5" />
                    </a>
                </div>
            </div>

            <h1 class="text-xl md:text-2xl font-medium text-center mt-5 px-2">
                {{ $form->title }}</h1>

            {{-- @if ($form->description)
                <div class="px-5 mt-5">
                    <div
                        class="text-center prose dark:prose-invert max-w-none text-black dark:text-white [&_strong]:text-black dark:[&_strong]:text-white">
                        {!! Purifier::clean($form->description) !!}
                    </div>
                </div>
            @endif --}}

            @if ($form->image && $form->active_image)
                <div class="mt-5 px-5">
                    <img src="{{ $form->image ? asset($form->image) : asset('/img/product-placeholder.jpg') }}"
                        alt="{{ $form->title }}" class="rounded-md"
                        style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
                </div>
            @endif

            {{-- @if ($form->video && $form->active_video)
                <div class="w-full relative mx-auto px-5 mt-10" style="z-index: 0; position: relative;"
                    x-data="initSwiper()">

                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            document.querySelectorAll('.swiper-slide').forEach((slide) => {
                                const iframe = slide.querySelector('iframe');
                                const playButton = slide.querySelector('.play-button');
                                const thumbnailOverlay = slide.querySelector('.thumbnail-overlay');

                                if (playButton) {
                                    playButton.addEventListener('click', () => {
                                        if (iframe.src.includes('youtube')) {
                                            iframe.contentWindow.postMessage(JSON.stringify({
                                                event: 'command',
                                                func: 'playVideo',
                                                args: []
                                            }), '*');
                                        } else if (iframe.src.includes('vimeo')) {
                                            const player = new Vimeo.Player(iframe);
                                            player.play();
                                        }

                                        if (thumbnailOverlay) thumbnailOverlay.style.display = 'none';
                                    });
                                }
                            });
                        });

                        function initSwiper() {
                            return {
                                swiper: null,

                                pauseAllVideos() {
                                    // Pause HTML5 videos
                                    document.querySelectorAll('.default-carousel video').forEach(v => {
                                        try {
                                            v.pause();
                                        } catch {}
                                    });

                                    // Pause Vimeo videos
                                    if (typeof Vimeo !== 'undefined') {
                                        document.querySelectorAll('.default-carousel iframe[src*="vimeo.com"]').forEach(iframe => {
                                            try {
                                                new Vimeo.Player(iframe).pause();
                                            } catch {}
                                        });
                                    }

                                    // Pause YouTube videos
                                    document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                        try {
                                            iframe.contentWindow.postMessage(
                                                JSON.stringify({
                                                    event: 'command',
                                                    func: 'pauseVideo',
                                                    args: []
                                                }),
                                                "https://www.youtube.com"
                                            );
                                        } catch {}
                                    });
                                },

                                init() {
                                    const self = this;
                                    const isLoop = {{ $video_count > 1 ? 'true' : 'false' }};

                                    // ============= VIDEO EVENT LISTENERS =============
                                    // HTML5 videos
                                    document.querySelectorAll('.default-carousel video').forEach(video => {
                                        video.addEventListener('play', () => {}, {
                                            passive: true
                                        });
                                        video.addEventListener('pause', () => {}, {
                                            passive: true
                                        });
                                        video.addEventListener('ended', () => {}, {
                                            passive: true
                                        });
                                    });

                                    // Ensure YouTube enablejsapi is set
                                    document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                        try {
                                            const src = iframe.getAttribute('src') || '';
                                            if (!/enablejsapi=1/.test(src)) {
                                                const sep = src.includes('?') ? '&' : '?';
                                                iframe.setAttribute('src', src + sep + 'enablejsapi=1');
                                            }
                                        } catch {}
                                    });

                                    // Vimeo events
                                    if (typeof Vimeo !== 'undefined') {
                                        document.querySelectorAll('.default-carousel iframe[src*="vimeo.com"]').forEach(iframe => {
                                            try {
                                                const player = new Vimeo.Player(iframe);
                                                player.on('play', () => {});
                                                player.on('pause', () => {});
                                                player.on('ended', () => {});
                                            } catch {}
                                        });
                                    }

                                    // YouTube events
                                    const buildYT = () => {
                                        document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                            try {
                                                new YT.Player(iframe, {
                                                    events: {
                                                        onStateChange: (e) => {
                                                            // No autoplay logic needed anymore
                                                        }
                                                    }
                                                });
                                            } catch {}
                                        });
                                    };
                                    if (window.YT && YT.Player) buildYT();
                                    else window.onYouTubeIframeAPIReady = buildYT;

                                    // ============= SWIPER INIT (no autoplay) =============
                                    this.swiper = new Swiper('.default-carousel', {
                                        loop: isLoop,
                                        pagination: {
                                            el: '.swiper-pagination',
                                            clickable: true,
                                            dynamicBullets: false,
                                        },
                                        on: {
                                            init() {
                                                updatePaginationActive(this);
                                            },
                                            slideChange() {
                                                self.pauseAllVideos();
                                                updatePaginationActive(this);
                                            }
                                        }
                                    });

                                    // Fix pagination handler
                                    function updatePaginationActive(swiper) {
                                        if (!swiper || !swiper.pagination || !swiper.pagination.el) return;
                                        const bullets = Array.from(swiper.pagination.el.querySelectorAll('.swiper-pagination-bullet'));
                                        const activeIndex = swiper.realIndex ?? swiper.activeIndex ?? 0;

                                        bullets.forEach((bullet, i) => {
                                            bullet.classList.toggle('swiper-pagination-bullet-active', i === activeIndex);
                                        });
                                    }

                                    const paginationEl = this.swiper.pagination && this.swiper.pagination.el;
                                    if (paginationEl) {
                                        paginationEl.addEventListener('click', (e) => {
                                            const bullet = e.target.closest('.swiper-pagination-bullet');
                                            if (!bullet) return;

                                            const bullets = Array.from(paginationEl.querySelectorAll('.swiper-pagination-bullet'));
                                            const index = bullets.indexOf(bullet);
                                            if (index === -1) return;

                                            try {
                                                self.swiper.slideToLoop(index);
                                            } catch {}
                                            updatePaginationActive(self.swiper);
                                        }, {
                                            passive: true
                                        });
                                    }
                                }
                            };
                        }
                    </script>

                    <script src="https://www.youtube.com/iframe_api"></script>
                    <script src="https://player.vimeo.com/api/player.js"></script>


                    <div class="swiper default-carousel mb-5" x-init="init()">
                        <div class="swiper-wrapper {{ $video_count > 1 ? 'mb-12' : 'mb-5' }}">

                            @php
                                if (!function_exists('vimeo_aspect_ratio')) {
                                    function vimeo_aspect_ratio(string $videoId, ?string $videoHash = null): string
                                    {
                                        $cacheKey = 'vimeo_oembed_ar_' . $videoId . '_' . ($videoHash ?? 'nohash');

                                        return cache()->remember($cacheKey, 86400, function () use (
                                            $videoId,
                                            $videoHash,
                                        ) {
                                            try {
                                                $playerUrl =
                                                    'https://player.vimeo.com/video/' .
                                                    $videoId .
                                                    ($videoHash ? '?h=' . $videoHash : '');
                                                $oembedUrl =
                                                    'https://vimeo.com/api/oembed.json?url=' . urlencode($playerUrl);

                                                $resp = \Illuminate\Support\Facades\Http::timeout(5)
                                                    ->retry(2, 100)
                                                    ->get($oembedUrl);
                                                if ($resp->ok()) {
                                                    $data = $resp->json();
                                                    if (!empty($data['width']) && !empty($data['height'])) {
                                                        return $data['height'] > $data['width'] ? '9/16' : '16/9';
                                                    }
                                                }
                                            } catch (\Throwable $e) {
                                                // fallback
                                            }
                                            return '16/9';
                                        });
                                    }
                                }
                            @endphp

                            @foreach ($videos as $index => $video)
                                @php
                                    $videoUrl = $video;
                                    $videoId = null;
                                    $videoHash = null;

                                    $isVimeo = false;
                                    $isInstagram = false;
                                    $isTikTok = false;
                                    $isShorts = false;
                                    $instagramType = null;

                                    $aspectRatio = '16/9';
                                    $maxWidth = '800px';

                                    // -----------------------------
                                    // YOUTUBE
                                    // -----------------------------
                                    if (preg_match('#youtu\.be/([a-zA-Z0-9_-]+)#', $videoUrl, $m)) {
                                        $videoId = $m[1];
                                    } elseif (preg_match('#youtube\.com/watch\?v=([a-zA-Z0-9_-]+)#', $videoUrl, $m)) {
                                        $videoId = $m[1];
                                    } elseif (preg_match('#youtube\.com/shorts/([a-zA-Z0-9_-]{11})#', $videoUrl, $m)) {
                                        $videoId = $m[1];
                                        $isShorts = true;
                                    } elseif (preg_match('#youtu\.be/([a-zA-Z0-9_-]{11})#', $videoUrl, $m)) {
                                        $videoId = $m[1];
                                    }

                                    if ($isShorts) {
                                        $aspectRatio = '9/16';
                                        $maxWidth = '450px';
                                    }

                                    // -----------------------------
                                    // VIMEO (all formats)
                                    // -----------------------------
                                    if (str_contains($videoUrl, 'vimeo.com')) {
                                        $isVimeo = true;

                                        if (preg_match('#vimeo\.com/(?:video/)?(\d+)#', $videoUrl, $m)) {
                                            $videoId = $m[1];
                                        }

                                        if (preg_match('#vimeo\.com/\d+/([a-zA-Z0-9]+)#', $videoUrl, $m)) {
                                            $videoHash = $m[1];
                                        }

                                        parse_str(parse_url($videoUrl, PHP_URL_QUERY) ?? '', $q);
                                        if (!empty($q['h'])) {
                                            $videoHash = $q['h'];
                                        }

                                        // Aspect ratio helper (your existing function)
                                        if ($videoId) {
                                            $aspectRatio = vimeo_aspect_ratio($videoId, $videoHash);
                                            if ($aspectRatio === '9/16') {
                                                $maxWidth = '450px';
                                            }
                                        }
                                    }

                                    // -----------------------------
                                    // INSTAGRAM (reels, posts, IGTV)
                                    // -----------------------------
                                    if (str_contains($videoUrl, 'instagram.com')) {
                                        if (preg_match('#instagram\.com/(reel|p|tv)/([^/?]+)#', $videoUrl, $m)) {
                                            $instagramType = $m[1];
                                            $videoId = $m[2];

                                            $isInstagram = true;
                                            $aspectRatio = '9/16';
                                            $maxWidth = '450px';
                                        }
                                    }

                                    // -----------------------------
                                    // TIKTOK
                                    // -----------------------------
                                    if (str_contains($videoUrl, 'tiktok.com')) {
                                        if (preg_match('#/video/(\d+)#', $videoUrl, $m)) {
                                            $videoId = $m[1];

                                            $isTikTok = true;
                                            $aspectRatio = '9/16';
                                            $maxWidth = '450px';
                                        }
                                    }

                                @endphp

                                <div class="swiper-slide w-full rounded-xl" data-slide-index="{{ $index }}">
                                    <div class="rounded-xl flex justify-center items-center bg-black"
                                        style="width:100%; border: 2px solid {{ $color_settings_profile_pic_border }} !important;">

                                        @if ($isVimeo && $videoId)
                                            <iframe
                                                src="https://player.vimeo.com/video/{{ $videoId }}{{ $videoHash ? '?h=' . $videoHash : '' }}"
                                                class="rounded-xl" allow="autoplay; fullscreen; picture-in-picture"
                                                frameborder="0" allowfullscreen
                                                style="width:100%; aspect-ratio: {{ $aspectRatio }}; max-width: {{ $maxWidth }};">
                                            </iframe>
                                        @elseif ($isInstagram && $videoId)
                                            <iframe
                                                src="https://www.instagram.com/{{ $instagramType }}/{{ $videoId }}/embed"
                                                class="rounded-xl" frameborder="0" allowfullscreen
                                                style="width:100%; aspect-ratio: {{ $aspectRatio }}; max-width: {{ $maxWidth }};">
                                            </iframe>
                                        @elseif ($isTikTok && $videoId)
                                            <iframe src="https://www.tiktok.com/embed/{{ $videoId }}"
                                                class="rounded-xl" frameborder="0" allowfullscreen
                                                style="width:100%; aspect-ratio: {{ $aspectRatio }}; max-width: {{ $maxWidth }};">
                                            </iframe>
                                        @elseif ($videoId)
                                            <iframe
                                                src="https://www.youtube.com/embed/{{ $videoId }}?enablejsapi=1"
                                                class="rounded-xl" frameborder="0"
                                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                                allowfullscreen
                                                style="width:100%; aspect-ratio: {{ $aspectRatio }}; max-width: {{ $maxWidth }};">
                                            </iframe>
                                        @endif

                                    </div>
                                </div>
                            @endforeach

                        </div>

                        <div class="swiper-pagination"></div>
                    </div>

                </div>
            @endif --}}

            @if ($form->video && $form->active_video)
                @php
                    $videoUrl = $form->video;
                    $videoId = null;
                    $videoHash = null;

                    $isVimeo = false;
                    $isInstagram = false;
                    $isTikTok = false;
                    $isShorts = false;

                    $aspectRatio = '16/9';
                    $maxWidth = '800px';

                    // --- YouTube + Shorts ---
                    if (preg_match('#youtu\.be/([a-zA-Z0-9_-]+)#', $videoUrl, $m)) {
                        $videoId = $m[1];
                    } elseif (preg_match('#youtube\.com/watch\?v=([a-zA-Z0-9_-]+)#', $videoUrl, $m)) {
                        $videoId = $m[1];
                    } elseif (preg_match('#youtube\.com/shorts/([a-zA-Z0-9_-]{11})#', $videoUrl, $m)) {
                        $videoId = $m[1];
                        $isShorts = true;
                    }

                    if ($isShorts) {
                        $aspectRatio = '9/16';
                        $maxWidth = '450px';
                    }

                    // --- Vimeo ---
                    if (str_contains($videoUrl, 'vimeo.com')) {
                        $isVimeo = true;

                        if (preg_match('#vimeo\.com/(?:video/)?(\d+)#', $videoUrl, $m)) {
                            $videoId = $m[1];
                        }

                        if (preg_match('#vimeo\.com/\d+/([a-zA-Z0-9]+)#', $videoUrl, $m)) {
                            $videoHash = $m[1];
                        }

                        parse_str(parse_url($videoUrl, PHP_URL_QUERY) ?? '', $q);
                        if (!empty($q['h'])) {
                            $videoHash = $q['h'];
                        }

                        $aspectRatio = '16/9';
                    }

                    // --- Instagram ---
                    if (str_contains($videoUrl, 'instagram.com')) {
                        if (preg_match('#instagram\.com/(reel|p|tv)/([^/?]+)#', $videoUrl, $m)) {
                            $isInstagram = true;
                            $instagramType = $m[1];
                            $videoId = $m[2];

                            $aspectRatio = '9/16';
                            $maxWidth = '450px';
                        }
                    }

                    // --- TikTok ---
                    if (str_contains($videoUrl, 'tiktok.com') && preg_match('#/video/(\d+)#', $videoUrl, $m)) {
                        $videoId = $m[1];
                        $isTikTok = true;
                        $aspectRatio = '9/16';
                        $maxWidth = '450px';
                    }
                @endphp

                <div class="w-full mx-auto px-5 mt-10 flex justify-center">
                    <div class="rounded-xl bg-black p-1"
                        style="border: 2px solid {{ $color_settings_profile_pic_border }}; width:100%; max-width: {{ $maxWidth }};">

                        {{-- Vimeo --}}
                        @if ($isVimeo && $videoId)
                            <iframe
                                src="https://player.vimeo.com/video/{{ $videoId }}{{ $videoHash ? '?h=' . $videoHash : '' }}"
                                class="rounded-xl" allow="autoplay; fullscreen"
                                style="width:100%; aspect-ratio: {{ $aspectRatio }};" frameborder="0"></iframe>

                            {{-- Instagram --}}
                        @elseif ($isInstagram && $videoId)
                            <iframe src="https://www.instagram.com/{{ $instagramType }}/{{ $videoId }}/embed"
                                class="rounded-xl" style="width:100%; aspect-ratio: {{ $aspectRatio }};"
                                frameborder="0"></iframe>

                            {{-- TikTok --}}
                        @elseif ($isTikTok && $videoId)
                            <iframe src="https://www.tiktok.com/embed/{{ $videoId }}" class="rounded-xl"
                                style="width:100%; aspect-ratio: {{ $aspectRatio }};" frameborder="0"></iframe>

                            {{-- YouTube + Shorts --}}
                        @elseif ($videoId)
                            <iframe src="https://www.youtube.com/embed/{{ $videoId }}?enablejsapi=1"
                                class="rounded-xl" allow="autoplay; encrypted-media; fullscreen"
                                style="width:100%; aspect-ratio: {{ $aspectRatio }};" frameborder="0"></iframe>
                        @endif
                    </div>
                </div>
            @endif

            <div class="px-5">

                @if ($form->description)
                    <div class="px-5 mt-5">
                        <div
                            class="text-center prose dark:prose-invert max-w-none text-black dark:text-white [&_strong]:text-black dark:[&_strong]:text-white">
                            {!! Purifier::clean($form->description) !!}
                        </div>
                    </div>
                @endif

                {{-- form here --}}
                <form wire:submit.prevent="formSubmit" class="w-full">


                    <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">

                        <div class="col-span-full sm:col-span-2">
                            <label for="email" class="block text-sm/6 font-medium">Email
                                address</label>
                            <div class="mt-2">
                                <input id="email" type="email" wire:model="email"
                                    class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 {{ session('email') ? 'border border-red-600' : '' }} @error('email') border border-red-600 @enderror"
                                    placeholder="(Required)">
                            </div>
                            @error('email')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror

                            {{-- Custom error message --}}
                            @if (session('email'))
                                <p class="mt-1 text-sm/6 text-red-600">
                                    {{ session('email') }}
                                </p>
                            @endif
                        </div>

                        <div class="col-span-full sm:col-span-2">
                            <label for="phone" class="block text-sm/6 font-semibold">Phone
                                number</label>
                            <div class="mt-2">
                                <input id="phone" type="tel" wire:model="phone"
                                    class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('phone') border border-red-600 @enderror"
                                    placeholder="(Required)">
                            </div>

                            @error('phone')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full sm:col-span-2">
                            <label for="firstname" class="block text-sm/6 font-medium">First
                                name</label>
                            <div class="mt-2">
                                <input type="text" id="firstname" wire:model="firstname"
                                    class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('firstname') border border-red-600 @enderror"
                                    placeholder="(Required)">
                            </div>

                            @error('firstname')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full sm:col-span-2">
                            <label for="lastname" class="block text-sm/6 font-medium">Last
                                name</label>
                            <div class="mt-2">
                                <input type="text" id="lastname" wire:model="lastname"
                                    class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('lastname') border border-red-600 @enderror"
                                    placeholder="(Required)">
                            </div>

                            @error('lastname')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="referrer" class="block text-sm/6 font-medium">Who invited you to the
                                call?</label>
                            <div class="mt-2">
                                <input type="text" id="referrer" wire:model="referrer"
                                    class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('lastname') border border-red-600 @enderror"
                                    placeholder="(Optional)">
                            </div>

                            @error('referrer')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- <div class="col-span-full" x-data="{
                            maxChars: 500,
                            currentChar: 0,
                            text: `{{ addslashes(old('feedback')) }}`,
                            updateCount() {
                                this.currentChar = this.text.length;
                            }
                        }">
                            <label for="feedback" class="block text-sm/6 font-medium">Feedback</label>
                            <div class="mt-2">
                                <textarea id="feedback" rows="3" x-model="text" x-on:input="updateCount" wire:model="feedback"
                                    :maxlength="maxChars"
                                    class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600"
                                    placeholder="(Required)">{{ old('feedback') }}</textarea>
                            </div>
                            <p class="mt-3 text-sm/6 text-gray-400">Please write your feedback.
                                (<span x-text="`${currentChar}/${maxChars}`" class="text-sm/6 text-gray-400"></span>)
                            </p>

                            @error('feedback')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div> --}}
                    </div>


                    <div class="mt-10">
                        <button type="submit"
                            class="w-full rounded-md px-3 py-2 text-sm font-semibold shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 "
                            style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">Submit</button>
                    </div>

                </form>
            </div>

            {{-- @if ($event->button_link)
                <div class="w-full px-5">
                    <a href="{{ $event->button_link }}" target="_blank"
                        class="customButton block p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-full text-black text-center mx-auto mt-5 text-l font-bold"
                        style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                        {{ $event->button_title }}
                    </a>
                </div>
            @endif --}}

        </div>

    </div>

</div>
