<div class="bg-slate-200 h-screen">
    <div
        class="absolute inset-0 -z-10 h-full w-full bg-white bg-[linear-gradient(to_right,#f0f0f0_1px,transparent_1px),linear-gradient(to_bottom,#f0f0f0_1px,transparent_1px)] bg-[size:6rem_4rem]">
    </div>

    <div class="flex min-h-full flex-col justify-center px-6 py-12 lg:px-8">
        <div class="sm:mx-auto sm:w-full sm:max-w-sm">
            <img class="mx-auto w-sm" src="{{ asset('/img/10kcards-black-logo.webp') }}" alt="Your Company">
            <h2 class="mt-10 text-center text-2xl/9 font-bold tracking-tight text-gray-900">Forgot Password</h2>
        </div>

        <div class="mt-10 sm:mx-auto sm:w-full sm:max-w-sm">
            @if (session()->has('error'))
                <div class="p-4 mb-4 text-sm text-white text-center rounded bg-red-500">
                    {{ session('error') }}
                </div>
            @endif

            @if (session()->has('success'))
                <div class="p-4 mb-4 text-sm text-white text-center rounded bg-green-500">
                    {{ session('success') }}
                </div>
            @endif

            <p class="text-center text-sm/6 text-gray-900 font-medium">
                Enter the email address you used to register and we'll send you a link to reset your password.
            </p>

            <form wire:submit.prevent="sendResetLink" class="space-y-6 mt-10">
                <div>
                    <label for="email" class="block text-sm/6 font-medium text-gray-500">Email address</label>
                    <div class="mt-2">
                        <input type="email" id="email" wire:model.defer="email"
                            class="block w-full rounded-md bg-white px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 border border-yellow-600 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6">
                    </div>
                    @error('email')
                        <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <button type="submit"
                        class="flex w-full justify-center rounded-md px-3 py-1.5 text-sm/6 font-semibold text-black shadow-xs bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-yellow-600">
                        Send Reset Link
                    </button>
                </div>
            </form>

            <p class="mt-10 text-center text-sm/6 text-gray-500">Back to
                <a href="{{ route('login') }}" class="font-semibold text-yellow-600 hover:text-yellow-500">Login</a>
            </p>
        </div>
    </div>
</div>
