<!-- Action Sheet -->
<div class="z-20 fixed sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto bottom-0 left-0 right-0 bg-white dark:bg-zinc-900 shadow-lg transform translate-y-full transition-transform duration-300 rounded-t-2xl"
    :class="{ 'translate-y-full': !showFeedbackModal, 'translate-y-0': showFeedbackModal }">
    <div class="p-4">
        <div class="flex justify-between">
            <h3 class="text-lg font-bold text-slate-800 dark:text-slate-300 flex items-center">
                <x-ri-feedback-fill class="size-6" />&nbsp;&nbsp;
                Feedback
            </h3>
            <!-- Close Action Sheet -->
            <button @click="showFeedbackModal=!showFeedbackModal" class="text-gray-500 toggleActionSheet">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        <div class="mt-4 space-y-3">

            <img loading="lazy" src="{{ asset($feedback?->profile_pic ?: '/img/profile-placeholder.jpg') }}"
                alt="{{ $feedback?->firstname . ' ' . $feedback?->lastname }}"
                class="mt-10 rounded-full w-6/12 mx-auto border-2 border-yellow-600 p-2 static">

            {{-- Display Full Name --}}
            <h1
                class="flex items-center justify-center text-2xl md:text-3xl font-medium text-center text-slate-800 dark:text-slate-300 mt-5">
                {{ $feedback?->firstname . ' ' . $feedback?->lastname }}
            </h1>

            {{-- <p class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center pt-5">
                Contact me
            </p> --}}

            <div class="pt-2 container mx-auto flex items-center justify-center">
                <a href="mailto:{{ $feedback?->email }}" target="_blank" class="text-slate-800 dark:text-slate-300">
                    <x-fas-envelope class="size-6 mx-2" />
                </a>
                <a href="tel:{{ $feedback?->phone }}" target="_blank" class="text-slate-800 dark:text-slate-300">
                    <x-heroicon-s-phone class="size-6 mx-2" />
                </a>
                <a href="sms:{{ $feedback?->phone }}" target="_blank" class="text-slate-800 dark:text-slate-300">
                    <x-fas-sms class="size-6 mx-2" />
                </a>
            </div>

            <p class="mx-auto w-10/12 text-slate-800 dark:text-slate-300 text-center text-l"
                style="margin-top: 30px !important; margin-bottom: 30px !important;">
                {{ $feedback?->feedback }}
            </p>

            {{-- <div class="grid grid-cols-5 mx-2">
                <div class="col-span-1">
                    <div class="relative">
                        <img src="{{ asset($feedback?->profile_pic ?: '/img/profile-placeholder.jpg') }}"
                            class="rounded-full p-2 w-full z-0">
                    </div>
                </div>
                <div class="col-span-4 flex flex-col justify-center mx-2">
                    <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">
                        {{ $feedback?->firstname . ' ' . $feedback?->lastname }}
                    </p>
                    <p class="py-1 mt-0.5 text-xs text-white">
                        {{ $feedback?->email }} | {{ $feedback?->phone }}
                    </p>
                    <p class="py-1 mt-0.5 text-xs text-white">
                        Date: {{ $feedback?->created_at }}
                    </p>
                </div>
            </div>
            <p class="my-10 text-sm/6 font-normal text-gray-900 dark:text-slate-300">
                <q>{{ $feedback?->feedback }}</q>
            </p> --}}

            <button @click="showFeedbackModal=!showFeedbackModal"
                class="w-full px-4 py-2 text-red-600 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 text-sm text-center">Close</button>
        </div>
    </div>
</div>
