<div>

    @if ($user)
        @guest
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5  flex flex-col content-center rounded-2xl my-5">
            @endguest
            @auth
                <div id="custom_bg"
                    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl mb-20 mt-5">
                @endauth
                <div class="grid grid-cols-2 gap-4 mb-5">
                    <!-- Download VCF -->
                    <div class="ml-5 flex items-center">
                        <a wire:navigate href="{{ route('card.show', $user->username) }}"
                            class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">

                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                stroke="currentColor" class="size-5">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                            </svg>
                        </a>
                    </div>

                    <!-- Share Card -->
                    <div class="mr-5 flex items-center place-content-end" x-data="{
                        urlTitle: `Exchange Contacts | {{ $page_title ?: $card_title }}`,
                        shareUrl: '{{ route('card.exchange', $user->username) }}',
                        shareCard() {
                            if (navigator.share) {
                                navigator.share({
                                    title: this.urlTitle,
                                    url: this.shareUrl,
                                }).then(() => {
                                    console.log('Thanks for sharing!');
                                }).catch(console.error);
                            } else {
                                console.log('Web Share API not supported');
                            }
                        }
                    }">

                        <button type="button" @click="showQRCode=!showQRCode"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                            <x-heroicon-o-qr-code class="size-5" />
                        </button>

                        <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-arrow-up-tray class="size-5" />
                        </a>
                    </div>
                </div>

                <div class="px-5">
                    <h1 class="text-xl md:text-2xl font-medium text-center mt-5">
                        {{ $exchange_button }}</h1>
                    {{-- form here --}}
                    <form wire:submit.prevent="connectForm" x-data="{ optionalFields: false }" class="w-full">

                        <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">

                            <div class="col-span-full sm:col-span-2">
                                <label for="firstname" class="block text-sm/6 font-medium">First
                                    name</label>
                                <div class="mt-2">
                                    <input type="text" id="firstname" wire:model="firstname"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('firstname') border border-red-600 @enderror"
                                        value="{{ old('firstname') }}">
                                </div>

                                @error('firstname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="lastname" class="block text-sm/6 font-medium">Last
                                    name</label>
                                <div class="mt-2">
                                    <input type="text" id="lastname" wire:model="lastname"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('lastname') border border-red-600 @enderror"
                                        value="{{ old('lastname') }}">
                                </div>

                                @error('lastname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full" x-data="{
                                maxChars: 200,
                                currentChar: 0,
                                text: `{{ addslashes(old('we_met_at')) }}`,
                                updateCount() {
                                    this.currentChar = this.text.length;
                                }
                            }">
                                <label for="we_met_at" class="block text-sm/6 font-medium">We met
                                    at</label>
                                <div class="mt-2">
                                    <textarea id="we_met_at" rows="3" x-model="text" x-on:input="updateCount" wire:model="we_met_at"
                                        :maxlength="maxChars"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600"
                                        placeholder="(Required)">{{ old('we_met_at') }}</textarea>
                                </div>
                                <p class="mt-3 text-sm/6 text-gray-400">Please remind me where we met!
                                    (<span x-text="`${currentChar}/${maxChars}`"
                                        class="text-sm/6 text-gray-400"></span>)
                                </p>

                                @error('we_met_at')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <div>
                            <button type="submit"
                                class="mt-5 w-full rounded-md px-3 py-2 text-sm font-semibold shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 "
                                style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">Send</button>
                        </div>
                    </form>
                </div>

                @if ($contacts)
                    <p class="flex items-center justify-center text-center pt-10">
                        Contact me
                    </p>

                    <div class="pt-2 container mx-auto flex items-center justify-center">

                        {{-- @if ($user['email'])
                        <a href="mailto:{{ $user['email'] }}" target="_blank">
                            <x-fas-envelope class="size-6 mx-2" />
                        </a>
                    @endif

                    <a href="tel:{{ $user['phone'] }}" target="_blank">
                        <x-heroicon-s-phone class="size-6 mx-2" />
                    </a>
                    <a href="sms:{{ $user['phone'] }}" target="_blank">
                        <x-fas-sms class="size-6 mx-2" />
                    </a> --}}

                        {{-- Other contact points here --}}

                        <livewire:contact-points-component :username="$user->username" />

                    </div>
                @endif

                {{-- check if footer is enabled, has custom footer and is basic, gold or platinum --}}
                {{-- @if ($footer_enabled && $customFooter && in_array($user->user_type, ['Basic', 'Gold', 'Platinum']))
                    <p class="flex items-center justify-center text-center text-l pt-5 py-1">
                        <a href="{{ $footer_link }}" target="_blank"
                            style="color: {{ $color_settings_link }} !important;">{{ $footer_text }}</a>
                    </p>

                @elseif ($footer_enabled && !$customFooter && $default_footer_text && $default_footer_link)
                    <p class="flex items-center justify-center text-center text-l pt-5 py-1">
                        <a href="{{ $default_footer_link }}" target="_blank"
                            style="color: {{ $color_settings_link }} !important;">{{ $default_footer_text }}</a>
                    </p>
                @elseif ((!$footer_enabled && in_array($user->user_type, ['Basic', 'Gold', 'Platinum'])) || !$footer_enabled)
                    <p> </p>
                @else
                    <p class="flex items-center justify-center text-center text-l pt-5 py-1">
                        <a href="{{ $site_url }}" target="_blank"
                            style="color: {{ $color_settings_link }} !important;">Get your card
                            today!</a>
                    </p>
                @endif --}}

            </div>
        </div>
    @else
        <div class="h-screen flex justify-center items-center">
            <div>
                <p class="mx-auto text-yellow-500 text-center text-l p-10">
                    <x-ionicon-warning-sharp class=" size-32 sm:size-40" />
                </p>
                <p class="mx-auto font-bold text-center text-2xl">Page not found.
                </p>
                <p class="flex items-center justify-center text-center text-l py-1">
                    Get your&nbsp;<a href="https://10kcards.com" target="_blank"
                        style="color: {{ $color_settings_link }} !important;">10k
                        card</a>&nbsp;today!
                </p>
            </div>
        </div>
    @endif

    {{-- @push('scripts')
        <script>
            document.addEventListener('livewire:init', () => {
                Livewire.on('connectFormSubmitted', ({
                    smsUrl
                }) => {
                    window.location.href = smsUrl;
                });
            });
        </script>
    @endpush --}}
</div>
