<div x-data="{ contactActive: @entangle('contact_active'), submitting: false }" x-on:set-submitting.window="submitting = $event.detail.value">
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.event') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">
                <x-heroicon-o-calendar-days class="size-6 inline-block" />
                &nbsp;&nbsp;Update Event
            </p>
        </div>
    </div>


    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        <form wire:submit.prevent="updateEvent()" class="px-5" @submit="submitting=true">
            <div class="space-y-12">

                <div class="border-b border-gray-900/10  dark:border-gray-400 pb-12">

                    <div class="grid gap-x-6 gap-y-8">

                        <div>
                            <livewire:event-image-field :event_image="$event_image" />

                            @error('image')
                                <p class="text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div x-data="{ posterActive: @entangle('poster_active') }">
                            <label for="poster_active"
                                class="text-sm/6 font-medium text-gray-900 dark:text-gray-400">Poster Visible on
                                Page</label>
                            <span class="rounded-full text-gray-600">
                                <button type="button" id="poster_active" @click="posterActive =!posterActive"
                                    class="mt-2 flex w-8 flex-none cursor-pointer rounded-full"
                                    :class="posterActive ? 'bg-green-400' : 'bg-gray-200'" role="switch"
                                    aria-checked="false" aria-labelledby="switch-1-label">
                                    <span aria-hidden="true"
                                        class="size-4 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"
                                        :class="posterActive ? 'translate-x-3.5' : 'translate-x-0'"></span>
                                </button>
                            </span>
                        </div>

                        {{-- Event Title --}}
                        <div class="col-span-full">
                            <label for="title"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Event
                                Title</label>
                            <div class="mt-2">
                                <div
                                    class="flex items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('title') border border-red-600 @enderror">

                                    <input type="text" wire:model="title" id="title"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900 placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        placeholder="ex: Pacquiao vs Barrior Watch Party">
                                </div>
                            </div>
                            @error('title')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div x-data="{ titleActive: @entangle('title_active') }">
                            <label for="title_active"
                                class="text-sm/6 font-medium text-gray-900 dark:text-gray-400">Title Visible on
                                Page</label>
                            <span class="rounded-full text-gray-600">
                                <button type="button" id="title_active" @click="titleActive =!titleActive"
                                    class="mt-2 flex w-8 flex-none cursor-pointer rounded-full"
                                    :class="titleActive ? 'bg-green-400' : 'bg-gray-200'" role="switch"
                                    aria-checked="false" aria-labelledby="switch-1-label">
                                    <span aria-hidden="true"
                                        class="size-4 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"
                                        :class="titleActive ? 'translate-x-3.5' : 'translate-x-0'"></span>
                                </button>
                            </span>
                        </div>

                        <div x-data="{ adActive: @entangle('ad_active') }">
                            <label for="ad_active" class="text-sm/6 font-medium text-gray-900 dark:text-gray-400">Ad
                                Visible on
                                Page</label>
                            <span class="rounded-full text-gray-600">
                                <button type="button" id="ad_active" @click="adActive=!adActive"
                                    class="mt-2 flex w-8 flex-none cursor-pointer rounded-full"
                                    :class="adActive ? 'bg-green-400' : 'bg-gray-200'" role="switch"
                                    aria-checked="false" aria-labelledby="switch-1-label">
                                    <span aria-hidden="true"
                                        class="size-4 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"
                                        :class="adActive ? 'translate-x-3.5' : 'translate-x-0'"></span>
                                </button>
                            </span>
                        </div>

                        {{-- Event Date --}}
                        <div class="col-span-full">
                            <label for="start_datetime"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Event
                                Date</label>
                            <div class="mt-2">
                                <div
                                    class="flex items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('start_datetime') border border-red-600 @enderror">
                                    <input type="date" wire:model="start_datetime" min="{{ now()->toDateString() }}"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md">
                                </div>
                            </div>
                            @error('start_datetime')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full" x-data="richTextEditor()">
                            <label for="description"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">
                                Description
                            </label>
                            <div class="mt-2" wire:ignore>
                                <textarea wire:model="description" x-ref="editor" rows="3" @change="updateCount" :maxlength="maxChars"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6"></textarea>
                            </div>

                            @error('description')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror

                            <p class="mt-3 text-sm/6 text-gray-600">
                                Write a few sentences about the event.
                                (<span x-text="`${charCount}/${maxChars}`"></span>)
                            </p>
                        </div>

                        {{-- Video Links --}}
                        <div class="col-span-full">
                            <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Video
                                Links</label>

                            @foreach ($event_video_link as $index => $link)
                                <div class="flex items-center mt-2 gap-2">
                                    <input wire:model="event_video_link.{{ $index }}" type="url"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 @error('event_video_link.' . $index) border border-red-600 @enderror"
                                        placeholder="Youtube, Vimeo, Tiktok or Instagram video">
                                    @if ($index > 0)
                                        <button type="button" wire:click="removeVideoLink({{ $index }})"
                                            class="text-red-600 hover:text-red-800 font-bold px-2">✕</button>
                                    @endif
                                </div>
                                @error('event_video_link.' . $index)
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            @endforeach

                            <button type="button" wire:click="addVideoLink"
                                class="mt-3 inline-flex items-center gap-1 rounded-md bg-green-500 px-3 py-1 text-white text-sm hover:bg-green-600">
                                ➕ Add another
                            </button>
                        </div>

                        {{-- Button Title --}}
                        <div class="col-span-full">
                            <label for="button_title"
                                class="block text-sm/6 font-semibold text-gray-900 dark:text-gray-400">Button
                                Title</label>
                            <div class="mt-2">
                                <input wire:model="button_title" type="text" id="button_title"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('button_title') border border-red-600 @enderror"
                                    placeholder="Click here">
                            </div>
                            @error('button_title')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Button Link --}}
                        <div class="col-span-full">
                            <label for="button_link"
                                class="block text-sm/6 font-semibold text-gray-900 dark:text-gray-400">Button
                                Link</label>
                            <div class="mt-2">
                                <input wire:model="button_link" type="text" id="button_link"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('button_link') border border-red-600 @enderror"
                                    placeholder="https://event.com">
                            </div>
                            @error('button_link')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Optional CTA --}}
                        <div class="col-span-full" x-cloak>
                            {{-- <div class="col-span-full mt-8" x-show="hasPackages" x-cloak> --}}
                            <label class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Optional Call
                                to Action Buttons</label>

                            @foreach ($optional_cta as $index => $option)
                                <div class="mt-6 p-5 border rounded-2xl bg-gray-50 dark:bg-zinc-800 relative">

                                    {{-- Remove Button --}}
                                    {{-- @if ($index > 0) --}}
                                    <button type="button" wire:click="removeCTA({{ $index }})"
                                        class="absolute top-3 right-3 text-red-600 hover:text-red-800 font-bold text-lg">✕</button>
                                    {{-- @endif --}}

                                    {{-- Title --}}
                                    <div class="col-span-full">
                                        <label for="optional_cta.{{ $index }}.title"
                                            class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Title</label>
                                        <div class="mt-2">
                                            <input wire:model="optional_cta.{{ $index }}.title"
                                                class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('optional_cta.' . $index . '.title') border border-red-600 @enderror">
                                        </div>
                                        @error('optional_cta.' . $index . '.title')
                                            <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                        @enderror
                                    </div>

                                    {{-- Link --}}
                                    <div class="col-span-full mt-4">
                                        <label for="optional_cta.{{ $index }}.link"
                                            class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Link</label>
                                        <div class="mt-2">
                                            <input wire:model="optional_cta.{{ $index }}.link"
                                                class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('optional_cta.' . $index . '.link') border border-red-600 @enderror">
                                        </div>
                                        @error('optional_cta.' . $index . '.link')
                                            <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                            @endforeach

                            {{-- Add More Button --}}
                            <button type="button" wire:click="addCTA"
                                class="mt-5 inline-flex items-center gap-2 rounded-md bg-green-500 px-3 py-2 text-white text-sm font-semibold hover:bg-green-600">
                                ➕ Add another
                            </button>
                        </div>

                        {{-- Partner Link --}}
                        <div class="col-span-full">
                            <label for="partner_link"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Partnership
                                Link (Optional)</label>
                            <div class="mt-2">
                                <input wire:model="partner_link"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 @error('partner_link') border border-red-600 @enderror"
                                    placeholder="Your partnership link">
                            </div>

                            @error('partner_link')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Shop Link --}}
                        <div class="col-span-full">
                            <label for="shop_link"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Shop Link
                                (Optional)</label>
                            <div class="mt-2">
                                <input wire:model="shop_link"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 @error('shop_link') border border-red-600 @enderror"
                                    placeholder="Enter your external shop link">
                            </div>

                            <p class="mt-1 text-sm/6 text-gray-900 dark:text-gray-400">*Shop page by default</p>

                            @error('shop_link')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div x-data="{ shopActive: @entangle('shop_active') }">
                            <label for="shop_active"
                                class="text-sm/6 font-medium text-gray-900 dark:text-gray-400">Shop Button Visible
                                on
                                Page</label>
                            <span class="rounded-full text-gray-600">
                                <button type="button" id="shop_active" @click="shopActive =!shopActive"
                                    class="mt-2 flex w-8 flex-none cursor-pointer rounded-full"
                                    :class="shopActive ? 'bg-green-400' : 'bg-gray-200'" role="switch"
                                    aria-checked="false" aria-labelledby="switch-1-label">
                                    <span aria-hidden="true"
                                        class="size-4 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"
                                        :class="shopActive ? 'translate-x-3.5' : 'translate-x-0'"></span>
                                </button>
                            </span>
                        </div>

                        <div>
                            <label for="contact_active"
                                class="text-sm/6 font-medium text-gray-900 dark:text-gray-400">Contact Points Visible
                                on
                                Page</label>
                            <span class="rounded-full text-gray-600">
                                <button type="button" id="contact_active" @click="contactActive =!contactActive"
                                    class="mt-2 flex w-8 flex-none cursor-pointer rounded-full"
                                    :class="contactActive ? 'bg-green-400' : 'bg-gray-200'" role="switch"
                                    aria-checked="false" aria-labelledby="switch-1-label">
                                    <span aria-hidden="true"
                                        class="size-4 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"
                                        :class="contactActive ? 'translate-x-3.5' : 'translate-x-0'"></span>
                                </button>
                            </span>
                        </div>

                        <div x-show="contactActive" class="col-span-full space-y-4">
                            <label class="block text-sm font-medium text-gray-900 dark:text-gray-400">
                                Contact Points
                            </label>
                            <div class="grid grid-cols-2 gap-4">
                                @foreach ($contacts as $contact)
                                    <div wire:key="contact-{{ $contact->id }}"
                                        class="flex flex-col justify-between p-3 bg-gray-100 dark:bg-zinc-800 rounded-lg"
                                        x-data="{ active: @entangle('contact_settings.' . $contact->id) }">
                                        <!-- Contact Title + Link -->
                                        <div>
                                            <span class="text-sm font-medium text-gray-900 dark:text-gray-300">
                                                {{ $contact->title }}
                                            </span>
                                            <span class="truncate text-sm text-gray-600 dark:text-gray-400 block mt-1">
                                                {{ $contact->link }}
                                            </span>
                                        </div>

                                        <!-- Toggle Button -->
                                        <div class="flex mt-4">
                                            <button type="button" @click="active=!active"
                                                class="relative inline-flex w-8 items-center rounded-full transition"
                                                :class="active ? 'bg-green-400' : 'bg-gray-300'">
                                                {{-- <span
                                                    class="inline-block size-4 transform rounded-full bg-white shadow transition"
                                                    :class="active ? 'translate-x-6' : 'translate-x-1'"></span> --}}

                                                <span aria-hidden="true"
                                                    class="size-4 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"
                                                    :class="active ? 'translate-x-3.5' : 'translate-x-0'"></span>
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>

                    </div>

                </div>

            </div>

            <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                <button type="submit" :disabled="submitting"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">

                    <!-- Normal text -->
                    <span x-show="!submitting"> Update Event
                    </span>

                    <!-- Saving text -->
                    <span x-show="submitting" class="inline-flex items-center justify-center space-x-2">
                        <span class="text-white">Saving...</span>
                        <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg"
                            fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                                stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z">
                            </path>
                        </svg>
                    </span>
                </button>
            </div>
        </form>
    </div>
</div>
