<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('dashboard.sales') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M15.75 10.5V6a3.75 3.75 0 1 0-7.5 0v4.5m11.356-1.993 1.263 12c.07.665-.45 1.243-1.119 1.243H4.25a1.125 1.125 0 0 1-1.12-1.243l1.264-12A1.125 1.125 0 0 1 5.513 7.5h12.974c.576 0 1.059.435 1.119 1.007ZM8.625 10.5a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm7.5 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z" />
                </svg>

                &nbsp;&nbsp;Update Sales Page
            </p>
        </div>
    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

        <form wire:submit.prevent="updateSales()" class="px-5">
            <div class="space-y-12">

                <div class="border-b border-gray-900/10  dark:border-gray-400 pb-12">

                    <div class="mt-10 grid gap-x-6 gap-y-8">

                        {{-- Event Image Field --}}
                        <div>
                            <livewire:sales-page-thumbnail-field :sales_thumbnail="$sales_thumbnail" />

                            @error('image')
                                <p class="text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="title"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Title
                            </label>
                            <div class="mt-2">
                                <div
                                    class="flex  items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('title') border border-red-600 @enderror">

                                    <input type="text" wire:model="title"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        placeholder="ex: Gym Equipments Sale"
                                        value="{{ old('title', $sales['title']) }}">
                                </div>
                            </div>
                            @error('title')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full" x-data="{
                            maxChars: 2000,
                            text: @js(old('description', $sales['description'] ?? '')),
                            currentChar: @js(old('description', $sales['description'] ?? ''))?.length || 0,
                            updateCount() {
                                this.currentChar = this.text.length;
                            },
                        }">
                            <label for="description"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Description</label>

                            <div class="mt-2">
                                <textarea id="description" wire:model="description" x-model="text" x-on:input="updateCount" :maxlength="maxChars"
                                    rows="3"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1
                -outline-offset-1 outline-gray-300 placeholder:text-gray-400
                focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600
                sm:text-sm/6 @error('description') border border-red-600 @enderror"></textarea>
                            </div>

                            @error('description')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror

                            <p class="mt-3 text-sm/6 text-gray-600">
                                Write a few sentences about this page. Max character 2000.
                                (<span x-text="`${currentChar}/${maxChars}`" class="text-sm/6 text-gray-600"></span>)
                            </p>
                        </div>


                        <div x-data="{ isActive: @entangle('is_active') }">
                            <label for="is_active" class="text-sm/6 font-medium text-gray-900 dark:text-gray-400">Sales
                                Page Active</label>
                            <span class="rounded-full text-gray-600">
                                <button type="button" id="is_active" @click="isActive =!isActive"
                                    class="mt-2 flex w-8 flex-none cursor-pointer rounded-full"
                                    :class="isActive ? 'bg-green-400' : 'bg-gray-200'" role="switch"
                                    aria-checked="false" aria-labelledby="switch-1-label">
                                    <span aria-hidden="true"
                                        class="size-4 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"
                                        :class="isActive ? 'translate-x-3.5' : 'translate-x-0'"></span>
                                </button>
                            </span>
                        </div>


                    </div>

                </div>

            </div>


            <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                <button type="submit"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">Update
                </button>
            </div>
        </form>
    </div>

    {{-- @if ($sales_videos->count() < 10)
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5 px-5">

            <div class="grid grid-cols-3 mt-5 gap-4">
                <div class="h-fit col-span-2">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Add New Video
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">Add a new video with CTA</p>
                </div>

                <div class="flex items-center col-span-1 place-content-end">
                    <a wire:navigate href="{{ route('salesvideo.add', $sales['id']) }}"
                        class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="size-6">
                                <path fill-rule="evenodd"
                                    d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                    clip-rule="evenodd" />
                            </svg>
                        </span>
                    </a>
                </div>
            </div>
        </div>
    @endif --}}

    {{-- @if (!$sales_videos)
        <div class="flex justify-center my-20">
            <a wire:navigate href="{{ route('salesvideo.add', $sales['id']) }}"
                class="flex items-center mx-auto bg-blue-500 text-white px-3.5 py-1.5 text-base rounded-md">Add
                Sales Page(s) &nbsp;
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="size-4">
                    <path fill-rule="evenodd"
                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                        clip-rule="evenodd" />
                </svg>
            </a>

        </div>
    @endif --}}

    @if ($sales_videos)
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 sm:py-10 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

            @if ($sales_videos->count() < 10)
                <div class="grid grid-cols-3 gap-4 px-5 @if ($sales_videos->count() > 0) mb-10 @endif">
                    <div class="h-fit col-span-2">
                        <h1 class="text-xl text-slate-800 dark:text-slate-300">Add New Video
                        </h1>
                        <p class="text-slate-600 dark:text-slate-500 text-sm">Add a new video with CTA</p>
                    </div>

                    <div class="flex items-center col-span-1 place-content-end">
                        <a wire:navigate href="{{ route('salesvideo.add', $sales['id']) }}"
                            class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                            <span class="text-zinc-900">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-6">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>
                            </span>
                        </a>
                    </div>
                </div>
            @endif

            @if ($sales_videos->count() > 1)
                {{-- Display all sortable sales here --}}
                <p class="text-slate-600 dark:text-slate-500 text-sm text-center mb-10">Drag the element to rearrange.
                </p>
            @endif

            @if ($sales_videos->count() > 0)
                <livewire:sortable-sales-video :sale_id="$sales_id" />
            @endif
        </div>
    @endif

    @if ($sales_images)
        <div
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 sm:py-10 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

            @if ($sales_images->count() < 10)
                <div class="grid grid-cols-3 gap-4 px-5 @if ($sales_images->count() > 0) mb-10 @endif">
                    <div class="h-fit col-span-2">
                        <h1 class="text-xl text-slate-800 dark:text-slate-300">Add New Image
                        </h1>
                        <p class="text-slate-600 dark:text-slate-500 text-sm">Add a new image with CTA</p>
                    </div>

                    <div class="flex items-center col-span-1 place-content-end">
                        <a wire:navigate href="{{ route('salesimage.add', $sales['id']) }}"
                            class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                            <span class="text-zinc-900">
                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                    class="size-6">
                                    <path fill-rule="evenodd"
                                        d="M12 3.75a.75.75 0 0 1 .75.75v6.75h6.75a.75.75 0 0 1 0 1.5h-6.75v6.75a.75.75 0 0 1-1.5 0v-6.75H4.5a.75.75 0 0 1 0-1.5h6.75V4.5a.75.75 0 0 1 .75-.75Z"
                                        clip-rule="evenodd" />
                                </svg>
                            </span>
                        </a>
                    </div>
                </div>
            @endif

            @if ($sales_images->count() > 1)
                {{-- Display all sortable sales here --}}
                <p class="text-slate-600 dark:text-slate-500 text-sm text-center mb-10">Drag the element to rearrange.
                </p>
            @endif

            @if ($sales_images->count() > 0)
                <livewire:sortable-sales-image :sale_id="$sales_id" />
            @endif

        </div>
    @endif
</div>
