<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('sales.edit', $sales_id) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <x-heroicon-o-photo class="size-6 inline-block" />

                &nbsp;&nbsp;Update Image
            </p>
        </div>
    </div>


    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        <form wire:submit.prevent="updateImage" class="px-5">
            <div class="space-y-12">

                <div class="border-b border-gray-900/10 dark:border-gray-400 pb-12">

                    <div class="mt-10 grid gap-x-6 gap-y-8">

                        {{-- Event Image Field --}}
                        <div>
                            <livewire:sales-image-field :sales_image="$sales_image" />

                            @error('image')
                                <p class="text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="product_name"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Product Name
                            </label>
                            <div class="mt-2">
                                <div
                                    class="flex  items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('product_name') border border-red-600 @enderror">

                                    <input type="text" wire:model="product_name"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        value="{{ old('product_name') }}">
                                </div>
                            </div>
                            @error('product_name')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full" x-data="() => ({
                            maxChars: 300,
                            text: `{{ addslashes(old('description', $description)) }}`,
                            currentChar: 0,
                            updateCount() {
                                this.currentChar = this.text.length;
                            },
                            init() {
                                this.currentChar = this.text.length;
                            }
                        })">
                            <label for="description"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Product
                                Description</label>
                            <div class="mt-2">
                                <textarea wire:model="description" rows="3" x-model="text" x-on:input="updateCount" :maxlength="maxChars"
                                    class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6"
                                    placeholder="(Optional)">{{ old('description', $description) }}</textarea>
                            </div>
                            <p class="mt-3 text-sm/6 text-gray-600">Write a few sentences about the product.
                                (<span x-text="`${currentChar}/${maxChars}`" class="text-sm/6 text-gray-600"></span>)
                            </p>
                        </div>

                        <div class="col-span-full">
                            <label for="price"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Price
                            </label>
                            <div class="mt-2">
                                <div
                                    class="flex items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('price') border border-red-600 @enderror">

                                    <input type="text" wire:model="price"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        value="{{ old('price') }}">
                                </div>
                            </div>
                            @error('price')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="stock"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Stock
                            </label>
                            <div class="mt-2">
                                <div
                                    class="flex items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('stock') border border-red-600 @enderror">

                                    <input type="number" min="1" max="999" wire:model="stock"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        value="{{ old('stock') }}">
                                </div>
                            </div>
                            @error('stock')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="shop_online_button"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Shop Button Text
                            </label>
                            <div class="mt-2">
                                <div
                                    class="flex items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('shop_online_button') border border-red-600 @enderror">

                                    <input type="text" wire:model="shop_online_button"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        placeholder="Default: Shop" value="{{ old('shop_online_button') }}">
                                </div>
                            </div>
                            @error('shop_online_button')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="col-span-full">
                            <label for="shop_online_link"
                                class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Shop Button Link
                            </label>
                            <div class="mt-2">
                                <div
                                    class="flex  items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 @error('shop_online_link') border border-red-600 @enderror">

                                    <input type="text" wire:model="shop_online_link"
                                        class="block min-w-0 grow py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900  placeholder:text-gray-400 focus:outline-none sm:text-sm/6 rounded-md"
                                        value="{{ old('shop_online_link') }}">
                                </div>
                            </div>
                            @error('shop_online_link')
                                <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div x-data="{ isActive: @entangle('is_active') }">
                            <label for="is_active" class="text-sm/6 font-medium text-gray-900 dark:text-gray-400">Image
                                Active</label>
                            <span class="rounded-full text-gray-600">
                                <button type="button" id="is_active" @click="isActive =!isActive"
                                    class="mt-2 flex w-8 flex-none cursor-pointer rounded-full"
                                    :class="isActive ? 'bg-green-400' : 'bg-gray-200'" role="switch"
                                    aria-checked="false" aria-labelledby="switch-1-label">
                                    <span aria-hidden="true"
                                        class="size-4 transform rounded-full bg-white ring-1 shadow-xs ring-gray-900/5 transition duration-200 ease-in-out"
                                        :class="isActive ? 'translate-x-3.5' : 'translate-x-0'"></span>
                                </button>
                            </span>
                        </div>

                    </div>
                </div>
            </div>


            <div class="mt-6 flex items-center justify-end gap-x-6 gap-4">
                <button type="submit"
                    class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">
                    Update</button>
            </div>
        </form>
    </div>

</div>
