<div class="z-20 fixed sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto bottom-0 left-0 right-0 bg-white dark:bg-zinc-800 shadow-lg transform translate-y-full transition-transform duration-300 px-8 py-10 rounded-t-2xl"
    :class="{ 'translate-y-full': !openDrivingDirectionModal, 'translate-y-0': openDrivingDirectionModal }"
    x-data="{ showToast: false }" id="driving_direction_modal">

    <h3 class="text-xl font-bold font-sans text-slate-800 dark:text-slate-300 text-center py-2">
        Driving Directions:
    </h3>

    <div wire:ignore x-data="drivingDirection()" x-cloak x-init="init" @touchstart="startTouch($event)"
        @touchmove="moveTouch($event)" @touchend="endTouch($event)"
        class="w-full mx-auto flex flex-col content-center px-5">

        <div class="relative overflow-hidden w-full mt-5 rounded-xl">

            {{-- <div class="relative overflow-hidden w-full mt-5 rounded-xl"
            style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;"> --}}

            <div class="flex transition-transform duration-500 ease-in-out h-full"
                :style="`transform: translateX(-${activeIndex * 100 - dragOffset}%)`">

                <!-- Slides -->
                <template x-for="(direction, index) in directions" :key="index">
                    <div class="w-full flex-shrink-0 h-full px-4 flex flex-col justify-between">

                        <!-- 3 Map Boxes -->
                        <div class="flex flex-wrap justify-center gap-4 text-center mt-5">
                            <!-- Google Maps -->
                            <template x-if="direction.google_map">
                                <a :href="direction.google_map" target="_blank"
                                    class="flex flex-col items-center justify-center p-4 rounded-xl shadow-md hover:bg-gray-100 dark:hover:bg-zinc-700">
                                    <x-fab-google class="w-8 h-8 text-red-500" />
                                    <span class="text-black dark:text-white mt-2 text-sm font-semibold">Google</span>
                                </a>
                            </template>

                            <!-- Apple Maps -->
                            <template x-if="direction.apple_map">
                                <a :href="direction.apple_map" target="_blank"
                                    class="flex flex-col items-center justify-center p-4 rounded-xl shadow-md hover:bg-gray-100 dark:hover:bg-zinc-700">
                                    <x-fab-apple class="w-8 h-8 text-slate-800 dark:text-slate-200" />
                                    <span class="text-black dark:text-white mt-2 text-sm font-semibold">Apple</span>
                                </a>
                            </template>

                            <!-- Waze -->
                            <template x-if="direction.waze">
                                <a :href="direction.waze" target="_blank"
                                    class="flex flex-col items-center justify-center p-4 rounded-xl shadow-md hover:bg-gray-100 dark:hover:bg-zinc-700">
                                    <x-fab-waze class="w-8 h-8 text-blue-500" />
                                    <span class="text-black dark:text-white mt-2 text-sm font-semibold">Waze</span>
                                </a>
                            </template>
                        </div>


                        <!-- Address -->
                        <p class="mt-5 text-center text-base font-medium" x-text="direction.address"
                            style="color: {{ $color_settings_link }} !important;"></p>

                        <!-- Copy Button + Toast -->
                        <div class="mx-auto mt-5 mb-5">
                            <button type="button"
                                @click="navigator.clipboard.writeText(direction.address);showToast=true;setTimeout(()=> showToast = false, 2000);"
                                class="flex rounded-md bg-yellow-400 px-3.5 py-2.5 text-sm font-semibold shadow-xs hover:bg-yellow-500 focus-visible:outline-2 focus-visible:outline-offset-2 focus-visible:outline-yellow-400 text-black mx-auto w-full justify-center">
                                <x-fas-copy class="w-4" />&nbsp;&nbsp;Copy to clipboard
                            </button>
                        </div>
                    </div>
                </template>
            </div>
        </div>

        <!-- Dots -->
        <template x-if="directions.length > 1">
            <div class="flex justify-center mt-5 gap-2">
                <template x-for="(direction, index) in directions" :key="'dot-' + index">
                    <button
                        :style="activeIndex === index ?
                            'background-color: {{ $color_settings_profile_pic_border }} !important' :
                            'background-color: gray !important; opacity: 0.3;'"
                        class="w-[14px] h-[14px] rounded-full mx-[4px]" @click="goTo(index)">
                    </button>
                </template>
            </div>
        </template>

        <!-- Toast Notification -->
        <div x-show="showToast" x-transition:enter="transition transform ease-out duration-300"
            x-transition:enter-start="opacity-0 translate-y-2" x-transition:enter-end="opacity-100 translate-y-0"
            x-transition:leave="transition transform ease-in duration-200"
            x-transition:leave-start="opacity-100 translate-y-0" x-transition:leave-end="opacity-0 translate-y-2"
            class="fixed bottom-20 left-1/2 transform -translate-x-1/2 bg-green-500 text-white text-sm font-semibold px-4 py-2 rounded-md shadow-lg">
            Copied to clipboard.
        </div>

        @push('scripts')
            <script>
                function drivingDirection() {
                    return {
                        directions: @js($directions),
                        activeIndex: 0,
                        timer: null,
                        startX: 0,
                        currentX: 0,
                        dragOffset: 0,
                        isDragging: false,

                        init() {
                            this.resetTimer();
                        },
                        resetTimer() {
                            if (this.timer) clearInterval(this.timer);
                            this.timer = setInterval(() => this.next(), 10000);
                        },
                        next() {
                            this.activeIndex = (this.activeIndex + 1) % this.directions.length;
                        },
                        prev() {
                            this.activeIndex = (this.activeIndex - 1 + this.directions.length) % this.directions.length;
                        },
                        goTo(index) {
                            this.activeIndex = index;
                            this.resetTimer();
                        },
                        startTouch(e) {
                            this.startX = e.touches[0].clientX;
                            this.currentX = this.startX;
                            this.isDragging = true;
                            this.dragOffset = 0;
                            clearInterval(this.timer);
                        },
                        moveTouch(e) {
                            if (!this.isDragging) return;
                            this.currentX = e.touches[0].clientX;
                            const moved = this.currentX - this.startX;
                            this.dragOffset = (moved / window.innerWidth) * 100;
                        },
                        endTouch() {
                            if (!this.isDragging) return;
                            this.isDragging = false;

                            if (this.dragOffset > 20) {
                                this.prev();
                            } else if (this.dragOffset < -20) {
                                this.next();
                            }

                            this.dragOffset = 0;
                            this.resetTimer();
                        },
                    }
                }
            </script>
        @endpush
    </div>
</div>
