<div>
    <livewire:card-view-tracker :username="$user->username" />

    @guest
        <div id="custom_bg"
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-10 sm:mx-auto ml-2 mr-2 relative mb-20">

        @endguest
        @auth
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-10 sm:mx-auto ml-2 mr-2 relative mb-20">

            @endauth
            <div
                class="grid grid-cols-2 gap-4 mb-5 pt-5 {{ $profile_layout == 'default_cover' || $profile_layout == 'full_width' ? 'absolute top-0 left-0 w-full' : '' }}">
                <!-- back -->
                <div class="ml-5 flex items-center">
                    <a href="{{ route('card.show', $user->username) }}"
                        class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-chevron-left class="size-4" />
                    </a>
                </div>

                <!-- Share Card -->
                <div class="mr-5 flex items-center place-content-end" x-data="{
                    urlTitle: `{{ $zoom_page_title }} | {{ $page_title ?: $card_title }}`,
                    shareUrl: '{{ route('card.zoomreplay', $user->username) }}',
                    shareCard() {
                        if (navigator.share) {
                            navigator.share({
                                title: this.urlTitle,
                                url: this.shareUrl,
                            }).then(() => {
                                console.log('Thanks for sharing!');
                            }).catch(console.error);
                        } else {
                            console.log('Web Share API not supported');
                        }
                    }
                }">

                    <button type="button" @click="showQRCode=!showQRCode"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                        <x-heroicon-o-qr-code class="size-5" />
                    </button>

                    <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-arrow-up-tray class="size-5" />
                    </a>
                </div>
            </div>


            {{-- Display Profile Picture --}}
            {{-- cover photo --}}
            @if ($profile_layout == 'default_cover')
                <img loading="lazy"
                    src="{{ $user->cover_pic ? asset($user->cover_pic) : asset('/img/cover-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto ">

                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="rounded-full w-6/12 mx-auto -mt-28"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
            @endif

            {{-- Cover Only --}}
            @if ($profile_layout == 'cover_only')
                <img loading="lazy"
                    src="{{ $user->cover_pic ? asset($user->cover_pic) : asset('/img/cover-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto ">
            @endif

            {{-- circled profile pic --}}
            @if ($profile_layout == 'default')
                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="rounded-full w-6/12 mx-auto p-2 static"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
            @endif

            {{-- rounded profile pic --}}
            @if ($profile_layout == 'rounded')
                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-6/12 mx-auto p-2 static"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important; border-radius: 50px;">
            @endif

            {{-- full width profile pic --}}
            @if ($profile_layout == 'full_width')
                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto ">
            @endif

            {{-- Display Full Name --}}
            {{-- <h1 class="flex items-center justify-center text-2xl md:text-3xl font-medium text-center mt-5 mx-5">
                <span>
                    {{ isset($card_title) ? $card_title : $firstname . ' ' . $lastname }}
                    @if ($user->user_type == 'Gold')
                        <x-gmdi-verified class="size-4 inline" style="color: #0053db !important;" />
                    @elseif($user->user_type == 'Platinum')
                        <x-gmdi-verified class="size-4 inline text-blue-500" />
                    @endif
                </span>
            </h1> --}}

            {{-- @if ($username_enabled == true)
                <p class="rounded-full bg-yellow-400 py-1 px-2 text-[10px] text-black mx-auto w-fit my-2">
                    {{ '@' . $user->username }}
                </p>
            @endif --}}

            {{-- Display Bio --}}
            {{-- @if ($user->bio && $short_bio_enabled == true)
                <p class="mx-auto w-10/12 text-center text-l py-1">
                    {{ $user->bio }}
                </p>
            @endif --}}

            {{-- Display Job Title --}}
            {{-- @if (!empty($user->job_title) && empty($user->company))
                <p class="text-center text-base py-1 mx-8">
                    <span class="inline-flex items-start gap-2">
                        <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                        <span>{{ $user->job_title }}</span>
                    </span>
                </p>
            @endif --}}

            {{-- Display Job Title and company --}}
            {{-- @if (!empty($user->job_title) && !empty($user->company))

                <p class="text-center text-base py-1 mx-8">
                    <span class="inline-flex items-start gap-2">
                        <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                        <span>{{ $user->job_title }}

                            @if (!empty($user->company_website))
                                at <a
                                    href="{{ filter_var($user->company_website, FILTER_VALIDATE_URL) ? $user->company_website : '#' }}"
                                    class="font-medium"
                                    style="color: {{ $color_settings_link }} !important;">{{ $user->company }}</a>
                            @else
                                at <span class="font-medium">{{ $user->company }}</span>
                            @endif

                        </span>
                    </span>
                </p>
            @endif --}}

            {{-- @if (($user->address || $user->country) && $display_country)
                <p class="flex items-center justify-center text-center text-l py-1 space-x-2">
                    <x-heroicon-o-map-pin class="size-5" />
                    <x-country-flag :country="$user->country" />
                </p>
            @endif --}}

            @if ($zoom_page_title)
                <h1 class="text-xl md:text-2xl font-medium text-center mt-5 px-2">
                    {{ $zoom_page_title }}</h1>
            @endif

            @if ($replays)
                <div class="w-full px-5">
                    @foreach ($replays as $button)
                        <a href="{{ $button['link'] }}" target="_blank"
                            class="customButton block p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-full text-black text-center mx-auto mt-5 text-l font-bold"
                            style="color: white !important; background-color: #2d8cff !important;">
                            {{ $button['title'] }}
                        </a>

                        {{-- <a href="{{ $button['link'] }}" target="_blank"
                            class="customButton block p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-full text-black text-center mx-auto mt-5 text-l font-bold"
                            style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                            {{ $button['title'] }}
                        </a> --}}
                    @endforeach
                </div>
            @endif


            {{-- @if ($contacts && $event->contact_active)
                <p class="flex items-center justify-center text-center pt-5">
                    Contact me
                </p>

                <div class="pt-2 container mx-auto flex items-center justify-center mb-3">

                    @foreach ($contacts as $contact)
                        @if ($contact_settings[$contact->id] ?? false)
                            @switch($contact->type)
                                @case('sms')
                                    <a href="sms:{{ $contact->link }}" target="_blank">
                                        <x-fas-sms class="size-6 mx-2" />
                                    </a>
                                @break

                                @case('phone')
                                    <a href="tel:{{ $contact->link }}" target="_blank">
                                        <x-heroicon-s-phone class="size-6 mx-2" />
                                    </a>
                                @break

                                @case('email')
                                    <a href="mailto:{{ $contact->link }}" target="_blank">
                                        <x-fas-envelope class="size-6 mx-2" />
                                    </a>
                                @break

                                @case('whatsapp')
                                    <a href="{{ $contact->link }}" target="_blank">
                                        <x-ri-whatsapp-fill class="size-6 mx-2" />
                                    </a>
                                @break

                                @case('telegram')
                                    <a href="{{ $contact->link }}" target="_blank">
                                        <x-fileicon-telegram class="size-6 mx-2" />
                                    </a>
                                @break

                                @case('zoom')
                                    <a href="{{ $contact->link }}" target="_blank">
                                        <x-si-zoom class="size-12 mx-2" />
                                    </a>
                                @break

                                @case('wechat')
                                    <a href="{{ $contact->link }}" target="_blank">
                                        <x-ri-wechat-fill class="size-6 mx-2 my-2" />
                                    </a>
                                @break

                                @case('zalo')
                                    <a href="{{ $contact->link }}" target="_blank">
                                        <x-si-zalo class="size-6 mx-2 my-2" />
                                    </a>
                                @break
                            @endswitch
                        @endif
                    @endforeach
                </div>

            @endif --}}

        </div>
    </div>

</div>
