<div id="custom_bg"
    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative
        {{ auth()->check() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}">

    <div
        class="grid grid-cols-4 gap-4 pt-5 mb-5 z-10 {{ in_array($profile_layout, ['default_cover', 'full_width']) || $team->thumbnail ? 'absolute top-0 left-0 w-full' : '' }}">

        <div class="ml-5 flex items-center col-span-2">
            <a href="{{ route('card.show', $user->username) }}"
                class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-5">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                </svg>
            </a>
        </div>

        <!-- Share Card -->
        <div class="mr-5 flex items-center col-span-2 place-content-end" x-data="{
            urlTitle: `{{ $team->title }} | {{ $page_title ?: $card_title }}`,
            shareUrl: '{{ route('card.team', [$user->username, $team_id]) }}',
            shareCard() {
                if (navigator.share) {
                    navigator.share({ title: this.urlTitle, url: this.shareUrl })
                        .then(() => console.log('Thanks for sharing!'))
                        .catch(console.error);
                } else {
                    console.log('Web Share API not supported');
                }
            }
        }">
            <button type="button" @click="showQRCode=!showQRCode"
                class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                <x-heroicon-o-qr-code class="size-5" />
            </button>

            <a href="#" x-on:click.prevent="shareCard"
                class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                <x-heroicon-o-arrow-up-tray class="size-5" />
            </a>
        </div>
    </div>

    {{-- Profile Layout --}}
    @php
        $profilePic = $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg');
        $coverPic = $user->cover_pic ? asset($user->cover_pic) : asset('/img/cover-placeholder.jpg');
    @endphp

    @if (!$team->thumbnail)
        @if ($profile_layout == 'default_cover')
            <img loading="lazy" src="{{ $coverPic }}" alt="{{ $fullname }}"
                class="w-full rounded-t-2xl mx-auto">
            <img loading="lazy" src="{{ $profilePic }}" alt="{{ $fullname }}"
                class="rounded-full w-6/12 mx-auto -mt-28"
                style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
        @elseif ($profile_layout == 'default')
            <img loading="lazy" src="{{ $profilePic }}" alt="{{ $fullname }}"
                class="rounded-full w-6/12 mx-auto p-2 static"
                style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
        @elseif ($profile_layout == 'rounded')
            <img loading="lazy" src="{{ $profilePic }}" alt="{{ $fullname }}" class="w-6/12 mx-auto p-2 static"
                style="border: 2px solid {{ $color_settings_profile_pic_border }} !important; border-radius: 50px;">
        @elseif ($profile_layout == 'full_width')
            <img loading="lazy" src="{{ $profilePic }}" alt="{{ $fullname }}"
                class="w-full rounded-t-2xl mx-auto">
        @endif
    @else
        <img loading="lazy" src="{{ asset($team->thumbnail) }}" alt="{{ $fullname }}"
            class="w-full rounded-t-2xl mx-auto">
    @endif

    <h1 class="text-2xl font-medium mt-10 px-10 text-center">{{ $team->title }}</h1>

    {{-- Search --}}
    <div
        class="my-5 mx-5 flex items-center rounded-md bg-gray-100 pl-3 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600">
        <div class="shrink-0 text-sm/6 font-medium text-gray-500 select-none sm:text-sm/6">
            <x-heroicon-s-magnifying-glass class="size-7" />
        </div>

        <input type="text" wire:model.debounce.400ms="keyword" wire:input.debounce.500ms="onKeywordUpdated"
            class="block py-1.5 pr-3 pl-1 text-base bg-gray-100 text-gray-900 placeholder:text-gray-400 focus:outline-none text-sm rounded-md w-full"
            placeholder="name, company, job title, state or country" />

    </div>

    {{-- Members List --}}
    <div x-data="{
        loading: false,
        observe() {
            let observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting && !this.loading) {
                        this.loading = true;
                        $wire.loadMore().then(() => this.loading = false);
                    }
                });
            });
            observer.observe(this.$refs.infiniteScrollTrigger);
        }
    }" x-init="observe">

        <div class="grid gap-4 mt-10 px-5 transition-opacity duration-200" wire:loading.class="opacity-50">
            @forelse ($members as $member)
                <a href="{{ $member->custom_card_link ?: route('card.show', $member->username) }}">
                    <div
                        class="grid grid-cols-12 gap-4 bg-slate-100 dark:bg-zinc-800 rounded-md p-6 transition-all duration-300 hover:shadow-md">
                        <div class="col-span-3 flex justify-center items-start">
                            <img src="{{ asset($member->profile_pic) }}"
                                alt="{{ $member->firstname . ' ' . $member->lastname }}"
                                class="rounded-md w-16 h-16 object-cover">
                        </div>
                        <div class="col-span-9 px-2">
                            {{-- <h1 class="text-xl font-medium truncate">{{ $member->firstname . ' ' . $member->lastname }}
                            </h1> --}}

                            <h1 class="text-xl font-medium truncate">
                                {{ $member->card_custom_title ?: $member->firstname . ' ' . $member->lastname }}
                            </h1>

                            @if ($member->bio)
                                <p class="text-base text-gray-600 dark:text-gray-300 mt-1">{{ $member->bio }}</p>
                            @endif
                            @if (!empty($member->job_title))
                                <p class="text-sm text-gray-700 dark:text-gray-400 py-1">
                                    {{ $member->job_title }}
                                    @if (!empty($member->company))
                                        at <span class="font-medium">{{ $member->company }}</span>
                                    @endif
                                </p>
                            @endif
                            @if ($member->country)
                                <p class="flex items-center gap-2 text-sm text-gray-700 dark:text-gray-400 mt-2">
                                    {{-- <x-country-flag :country="$member->country" /> --}}
                                    <x-country-flag :country="$member->country" :state="$member->state" />
                                </p>
                            @endif
                        </div>
                    </div>
                </a>
            @empty
                <div class="text-center text-gray-500 dark:text-gray-300 py-10 col-span-12">
                    No result(s) found.
                </div>
            @endforelse
        </div>

        {{-- Infinite Scroll Trigger --}}
        <div x-ref="infiniteScrollTrigger" class="mt-10 flex justify-center items-center">
            @if ($members?->hasMorePages())
                <span class="text-gray-500 dark:text-gray-300" wire:loading.remove>Loading more...</span>
            @endif
        </div>

        {{-- Loading Spinner --}}
        <div wire:loading.flex wire:target="loadMore" class="justify-center py-5">
            <svg class="animate-spin h-6 w-6 text-yellow-500" xmlns="http://www.w3.org/2000/svg" fill="none"
                viewBox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4">
                </circle>
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v8z"></path>
            </svg>
        </div>
    </div>
</div>
