<div>
    @if ($user && $sales)
        @guest
            {{-- <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl my-5"> --}}

            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative my-5">
            @endguest

            @auth
                {{-- <div id="custom_bg"
                    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl mb-20 mt-5"> --}}

                {{-- <div id="custom_bg"
                    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5  sm:mx-auto ml-2 mr-2 relative"> --}}

                <div id="custom_bg"
                    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5  sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}">
                @endauth

                <div
                    class="grid grid-cols-4 gap-4 mb-5 pt-5 z-10 {{ $profile_layout == 'default_cover' || $profile_layout == 'full_width' ? 'absolute top-0 left-0 w-full' : '' }} ">

                    <div class="ml-5 flex items-center col-span-2">
                        <a href="{{ route('card.show', $user->username) }}"
                            class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">

                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                                stroke="currentColor" class="size-5">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="m2.25 12 8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25" />
                            </svg>
                        </a>
                    </div>

                    <!-- Share Card -->
                    <div class="mr-5 flex items-center col-span-2 place-content-end" x-data="{
                        urlTitle: `{{ $user->firstname }} {{ $user->lastname }} | {{ $user['job_title'] }}`,
                        shareUrl: '{{ $site_url . $user['username'] }}',
                        shareCard() {
                            if (navigator.share) {
                                navigator.share({
                                    title: this.urlTitle,
                                    url: this.shareUrl,
                                }).then(() => {
                                    console.log('Thanks for sharing!');
                                }).catch(console.error);
                            } else {
                                console.log('Web Share API not supported');
                            }
                        }
                    }">

                        <button type="button" @click="showQRCode=!showQRCode"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                            <x-heroicon-o-qr-code class="size-5" />
                        </button>

                        <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-arrow-up-tray class="size-5" />
                        </a>
                    </div>
                </div>

                {{-- <img src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user['firstname'] . ' ' . $user['lastname'] }}"
                    class="rounded-full w-6/12 mx-auto p-2 z-10 static"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;"> --}}

                {{-- Display Profile Picture --}}
                {{-- cover photo --}}
                {{-- @if ($profile_layout == 'default_cover')
                    <img loading="lazy"
                        src="{{ $user['cover_pic'] ? asset($user['cover_pic']) : asset('/img/cover-placeholder.jpg') }}"
                        alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto ">

                    <img loading="lazy"
                        src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                        alt="{{ $user->firstname . ' ' . $user->lastname }}" class="rounded-full w-6/12 mx-auto -mt-28"
                        style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
                @endif --}}

                {{-- circled profile pic --}}
                {{-- @if ($profile_layout == 'default')
                    <img loading="lazy"
                        src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                        alt="{{ $user->firstname . ' ' . $user->lastname }}"
                        class="rounded-full w-6/12 mx-auto p-2 static"
                        style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
                @endif --}}

                {{-- rounded profile pic --}}
                {{-- @if ($profile_layout == 'rounded')
                    <img loading="lazy"
                        src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                        alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-6/12 mx-auto p-2 static"
                        style="border: 2px solid {{ $color_settings_profile_pic_border }} !important; border-radius: 50px;">
                @endif --}}

                {{-- full width profile pic --}}
                {{-- @if ($profile_layout == 'full_width')
                    <img loading="lazy"
                        src="{{ $user['profile_pic'] ? asset($user['profile_pic']) : asset('/img/profile-placeholder.jpg') }}"
                        alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto ">
                @endif --}}

                {{-- <h1 class="text-xl md:text-2xl font-medium text-center mt-5">
                    {{ $shop_title }}</h1> --}}

                <h1 class="text-xl md:text-2xl font-medium text-center mt-20">
                    {{ $shop_title }}</h1>

                <!-- Products -->
                <div class="grid grid-cols-2 gap-4 mt-10 px-5">
                    @if ($sales)
                        @foreach ($sales as $sale)
                            @php
                                if (!preg_match('/^https?:\/\//', $sale['payment_link'])) {
                                    $sale['payment_link'] = 'https://' . $sale['payment_link'];
                                }
                            @endphp

                            <a href="{{ route('sales.content', ['username' => $user->username, 'sales' => $sale]) }}">
                                <div class="bg-slate-100 dark:bg-zinc-800 rounded-md">
                                    <img src="{{ $sale->thumbnail ? asset($sale->thumbnail) : asset('/img/product-placeholder.jpg') }}"
                                        alt=" {{ $sale->title }}" class="rounded-t-md">
                                    <div class="px-3 py-2">
                                        <h1 class="text-sm font-medium text-center truncate">
                                            {{ $sale->title }}
                                        </h1>

                                        {{-- @if ($product_price_enabled == true)
                                            <h1 class="text-sm font-medium text-center"
                                                style="color: {{ $color_settings_link }} !important;">
                                                ${{ $sale->price }}
                                            </h1>
                                        @endif --}}
                                    </div>
                                </div>
                            </a>
                        @endforeach
                    @endif


                    {{-- @if ($payments)
                        <p class="flex items-center justify-center text-center pt-5">
                            Payment links
                        </p>

                        <div class="pt-2 container mx-auto flex flex-wrap items-center justify-center">
                            @foreach ($payments as $payment)
                                @if ($payment['type'] === 'credit')
                                    <a href="{{ $payment['link'] }}" target="_blank">
                                        <x-heroicon-s-credit-card class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif($payment['type'] == 'zelle')
                                    <button
                                        @click="openPaymentLinkModal=!openPaymentLinkModal;button_zelle=true;payment_value='{{ $payment['link'] }}'">
                                        <x-si-zelle class="size-7 mx-2 my-2" />
                                    </button>
                                @elseif($payment['type'] == 'apple_pay')
                                    <button
                                        @click="openPaymentLinkModal=!openPaymentLinkModal;button_apple_pay=true;payment_value='{{ $payment['link'] }}'">
                                        <x-fab-apple class="size-7 mx-2 my-2" />
                                    </button>
                                @elseif($payment['type'] == 'venmo')
                                    <a href="{{ $payment['link'] }}" target="_blank">
                                        <x-bxl-venmo class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif($payment['type'] == 'cashapp')
                                    <a href="{{ $payment['link'] }}" target="_blank">
                                        <x-si-cashapp class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif($payment['type'] == 'paypal_email')
                                    <button
                                        @click="openPaymentLinkModal=!openPaymentLinkModal;button_paypal_email=true;payment_value='{{ $payment['link'] }}'">
                                        <x-fab-paypal class="size-7 mx-2 my-2" />
                                    </button>
                                @elseif($payment['type'] == 'paypal_link')
                                    <a href="{{ $payment['link'] }}" target="_blank">
                                        <x-fab-paypal class="size-7 mx-2 my-2" />
                                    </a>
                                @endif
                            @endforeach
                        </div>

                    @endif --}}

                </div>

                {{-- check if footer is enabled, has custom footer and is basic, gold or platinum --}}
                {{-- @if ($footer_enabled && $customFooter && in_array($user->user_type, ['Basic', 'Gold', 'Platinum']))
                    <p class="flex items-center justify-center text-center text-l pt-5 py-1">
                        <a href="{{ $footer_link }}" target="_blank"
                            style="color: {{ $color_settings_link }} !important;">{{ $footer_text }}</a>
                    </p>

                @elseif ($footer_enabled && !$customFooter && $default_footer_text && $default_footer_link)
                    <p class="flex items-center justify-center text-center text-l pt-5 py-1">
                        <a href="{{ $default_footer_link }}" target="_blank"
                            style="color: {{ $color_settings_link }} !important;">{{ $default_footer_text }}</a>
                    </p>

                @elseif ((!$footer_enabled && in_array($user->user_type, ['Basic', 'Gold', 'Platinum'])) || !$footer_enabled)
                    <p> </p>
                @else
                    <p class="flex items-center justify-center text-center text-l pt-5 py-1">
                        <a href="{{ $site_url }}" target="_blank"
                            style="color: {{ $color_settings_link }} !important;">Get your card
                            today!</a>
                    </p>
                @endif --}}

            </div>
        </div>
    @else
        {{-- <div class="h-screen flex justify-center items-center"> --}}
        <div id="custom_bg"
            class="h-screen flex justify-center items-center sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 rounded-2xl mt-2 pb-5 sm:mx-auto mb-20">
            <div>
                <p class="mx-auto text-yellow-500 text-center text-l p-10">
                    <x-ionicon-warning-sharp class=" size-32 sm:size-40" />
                </p>
                <p class="mx-auto font-bold text-center text-2xl">Page not found.
                </p>
                <p class="flex items-center justify-center text-center text-l py-1">
                    {{-- Get your&nbsp;<a href="https://10kcards.com" target="_blank"
                        style="color: {{ $color_settings_link }} !important;">10k
                        card</a>&nbsp;today!
                </p> --}}
            </div>
        </div>
    @endif
</div>
