<div x-cloak class="m-0 p-0">
    <livewire:card-view-tracker :username="$user->username" />
    @guest
        <div id="custom_bg"
            class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative my-5 mb-20">
        @endguest

        @auth
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}">
            @endauth

            {{-- Top Navigation --}}
            <div
                class="grid grid-cols-4 gap-4 mb-5 pt-5 z-10 {{ $profile_layout == 'default_cover' || $profile_layout == 'cover_only' || $profile_layout == 'full_width' ? 'absolute top-0 left-0 w-full' : '' }}">
                <div class="ml-5 flex items-center col-span-2">
                    <a href="{{ route('card.show', $user->username) }}"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-home class="size-5" />
                    </a>
                </div>

                <div class="mr-5 flex items-center col-span-2 place-content-end" x-data="{
                    urlTitle: `{{ $reviews_page_title }} | {{ $page_title ?: $card_title }}`,
                    shareUrl: '{{ route('card.reviews', $user->username) }}',
                    shareCard() {
                        if (navigator.share) {
                            navigator.share({
                                title: this.urlTitle,
                                url: this.shareUrl,
                            }).catch(console.error);
                        } else {
                            console.log('Web Share API not supported');
                        }
                    }
                }">
                    <button type="button" @click="showQRCode=!showQRCode"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                        <x-heroicon-o-qr-code class="size-5" />
                    </button>

                    <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                        class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                        <x-heroicon-o-arrow-up-tray class="size-5" />
                    </a>
                </div>
            </div>

            {{-- Display Profile Picture --}}
            {{-- cover photo --}}
            @if ($profile_layout == 'default_cover')
                <img loading="lazy"
                    src="{{ $user->cover_pic ? asset($user->cover_pic) : asset('/img/cover-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto ">

                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="rounded-full w-6/12 mx-auto -mt-28"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
            @endif

            {{-- Cover Only --}}
            @if ($profile_layout == 'cover_only')
                <img loading="lazy"
                    src="{{ $user->cover_pic ? asset($user->cover_pic) : asset('/img/cover-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto ">
            @endif

            {{-- circled profile pic --}}
            @if ($profile_layout == 'default')
                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="rounded-full w-6/12 mx-auto p-2 static"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important;">
            @endif

            {{-- rounded profile pic --}}
            @if ($profile_layout == 'rounded')
                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-6/12 mx-auto p-2 static"
                    style="border: 2px solid {{ $color_settings_profile_pic_border }} !important; border-radius: 50px;">
            @endif

            {{-- full width profile pic --}}
            @if ($profile_layout == 'full_width')
                <img loading="lazy"
                    src="{{ $user->profile_pic ? asset($user->profile_pic) : asset('/img/profile-placeholder.jpg') }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto ">
            @endif

            {{-- <h1 class="flex items-center justify-center text-2xl md:text-3xl font-medium text-center mt-5 mx-5">
                <span>
                    {{ isset($card_title) ? $card_title : $firstname . ' ' . $lastname }}
                    @if ($user->user_type == 'Gold')
                        <x-gmdi-verified class="size-4 inline" style="color: #0053db !important;" />
                    @elseif($user->user_type == 'Platinum')
                        <x-gmdi-verified class="size-4 inline text-blue-500" />
                    @endif
                </span>
            </h1> --}}

            {{-- Display Bio --}}
            {{-- @if ($bio && $short_bio_enabled == true)
                <p class="mx-auto w-10/12 text-center text-l py-1">
                    {{ $bio }}
                </p>
            @endif --}}

            {{-- Display Job Title --}}
            {{-- @if (!empty($user->job_title) && empty($user->company))
                <p class="text-center text-base py-1 mx-8">
                    <span class="inline-flex items-start gap-2">
                        <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                        <span>{{ $user->job_title }}</span>
                    </span>
                </p>
            @endif --}}

            {{-- Display Job Title and company --}}
            {{-- @if (!empty($user->job_title) && !empty($user->company))

                <p class="text-center text-base py-1 mx-8">
                    <span class="inline-flex items-start gap-2">
                        <x-heroicon-o-briefcase class="size-5 shrink-0 mt-0.5" />
                        <span>{{ $user->job_title }}

                            @if (!empty($user->company_website))
                                at <a
                                    href="{{ filter_var($user->company_website, FILTER_VALIDATE_URL) ? $user->company_website : '#' }}"
                                    class="font-medium"
                                    style="color: {{ $color_settings_link }} !important;">{{ $user->company }}</a>
                            @else
                                at <span class="font-medium">{{ $user->company }}</span>
                            @endif

                        </span>
                    </span>
                </p>
            @endif --}}

            {{-- @if (($user->address || $user->country) && $display_country)
                <p class="flex items-center justify-center text-center text-l py-1 space-x-2">
                    <x-heroicon-o-map-pin class="size-5" />
                    <x-country-flag :country="$user->country" />
                </p>
            @endif --}}

            <div class="items-center mt-5 space-y-6">

                @if ($reviews_page_title)
                    <h1 class="text-xl md:text-2xl font-medium text-center mt-5 px-2">
                        {{ $reviews_page_title }}</h1>
                @endif

                @if ($reviews)
                    @foreach ($reviews as $review)
                        @php
                            $videoUrl = $review['video_link'];
                            $videoId = null;
                            $videoHash = null;

                            $isVimeo = false;
                            $isInstagram = false;
                            $isTikTok = false;
                            $instagramType = null;

                            // -----------------------------
                            // YOUTUBE
                            // -----------------------------
                            if (preg_match('#youtu\.be/([a-zA-Z0-9_-]+)#', $videoUrl, $matches)) {
                                $videoId = $matches[1];
                            } elseif (preg_match('#youtube\.com/watch\?v=([a-zA-Z0-9_-]+)#', $videoUrl, $matches)) {
                                $videoId = $matches[1];
                            } elseif (preg_match('#youtube\.com/shorts/([a-zA-Z0-9_-]{11})#', $videoUrl, $matches)) {
                                $videoId = $matches[1];
                            }

                            // -----------------------------
                            // VIMEO (any format)
                            // -----------------------------
                            if (str_contains($videoUrl, 'vimeo.com')) {
                                $isVimeo = true;

                                $clean = preg_replace(
                                    ['#https?://(www\.)?vimeo\.com/#', '#https?://player\.vimeo\.com/video/#'],
                                    '',
                                    $videoUrl,
                                );

                                $parts = explode('/', $clean);
                                $videoId = $parts[0] ?? null;

                                if (isset($parts[1]) && !str_contains($parts[1], '?')) {
                                    $videoHash = $parts[1];
                                }

                                if (str_contains($videoUrl, '?h=')) {
                                    parse_str(parse_url($videoUrl, PHP_URL_QUERY), $query);
                                    $videoHash = $query['h'] ?? $videoHash;
                                }
                            }

                            // -----------------------------
                            // INSTAGRAM – reels, posts, IGTV
                            // -----------------------------
                            if (str_contains($videoUrl, 'instagram.com')) {
                                if (preg_match('#instagram\.com/(reel|reels|p|tv)/([^/?]+)/?#', $videoUrl, $matches)) {
                                    $instagramType = $matches[1] === 'reels' ? 'reel' : $matches[1];
                                    $videoId = $matches[2];
                                    $isInstagram = true;
                                }
                            }

                            // -----------------------------
                            // TIKTOK
                            // -----------------------------
                            if (str_contains($videoUrl, 'tiktok.com')) {
                                if (preg_match('#/video/(\d+)#', $videoUrl, $matches)) {
                                    $videoId = $matches[1];
                                    $isTikTok = true;
                                }
                            }

                            // -----------------------------
                            // Aspect ratio control
                            // -----------------------------
                            $padding = '56.25%'; // default 16:9

                            if ($isInstagram) {
                                $padding = '130%'; // tall vertical layout
                            }

                            if ($isTikTok) {
                                $padding = '135%'; // taller vertical layout
                            }
                        @endphp

                        <div class="w-full px-5">
                            <div class="relative rounded-xl overflow-hidden block"
                                style="width: 100%; padding-bottom: {{ $padding }}; border: 2px solid {{ $color_settings_profile_pic_border }} !important;">

                                @if ($isVimeo)
                                    <iframe class="absolute top-0 left-0 w-full h-full rounded-xl"
                                        src="https://player.vimeo.com/video/{{ $videoId }}{{ $videoHash ? '?h=' . $videoHash : '' }}"
                                        frameborder="0" allow="autoplay; fullscreen; picture-in-picture"
                                        allowfullscreen>
                                    </iframe>
                                @elseif ($isInstagram)
                                    <iframe class="absolute top-0 left-0 w-full h-full rounded-xl"
                                        src="https://www.instagram.com/{{ $instagramType }}/{{ $videoId }}/embed"
                                        frameborder="0" allowfullscreen>
                                    </iframe>
                                @elseif ($isTikTok)
                                    <iframe class="absolute top-0 left-0 w-full h-full rounded-xl"
                                        src="https://www.tiktok.com/embed/{{ $videoId }}" frameborder="0"
                                        allowfullscreen>
                                    </iframe>
                                @else
                                    {{-- Default YouTube --}}
                                    <iframe class="absolute top-0 left-0 w-full h-full rounded-xl"
                                        src="https://www.youtube.com/embed/{{ $videoId }}?enablejsapi=1"
                                        frameborder="0"
                                        allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                        allowfullscreen>
                                    </iframe>
                                @endif

                            </div>
                        </div>

                        @if ($review['review_text'])
                            <div class="px-5 mt-5">
                                <div class="max-w-none text-black dark:text-white">
                                    {{ $review['review_text'] }}
                                </div>
                            </div>
                        @endif

                        @if ($review['cta_link'] && $review['cta_text'])
                            <div class="w-full px-5 pb-10">
                                <a href="{{ $review['cta_link'] }}" target="_blank"
                                    class="customButton block p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-full text-black text-center mx-auto mt-5 text-l font-bold"
                                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">
                                    {{ $review['cta_text'] }}
                                </a>
                            </div>
                        @endif
                    @endforeach
                @endif

            </div>
        </div>
    </div>
</div>
