<div>
    @if ($products)
        @guest
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative my-5">
            @endguest

            @auth
                <div id="custom_bg"
                    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-12/12 flex flex-col content-center rounded-2xl mt-2 pb-5 sm:mx-auto ml-2 mr-2 relative {{ auth()->user() && !auth()->user()->is_admin ? 'mb-20' : 'mb-2' }}">
                @endauth

                <div class="grid grid-cols-4 gap-4 mb-5 pt-5 z-10 absolute top-0 left-0 w-full">
                    <div class="ml-5 flex items-center col-span-2">
                        <!-- back -->
                        <a href="{{ route('card.products', $user->username) }}"
                            class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-chevron-left class="size-4" />
                        </a>
                    </div>

                    <div class="mr-5 flex items-center col-span-2 place-content-end" x-data="{
                        urlTitle: `{{ $product_collection->title }} | {{ $page_title ?: $card_title }}`,
                        shareUrl: '{{ route('card.collection', [$user->username, $collection_id]) }}',
                        shareCard() {
                            if (navigator.share) {
                                navigator.share({
                                    title: this.urlTitle,
                                    url: this.shareUrl,
                                }).catch(console.error);
                            } else {
                                console.log('Web Share API not supported');
                            }
                        }
                    }">
                        <button type="button" @click="showQRCode=!showQRCode"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                            <x-heroicon-o-qr-code class="size-5" />
                        </button>
                        <a href="#" x-on:click.prevent="shareCard"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-arrow-up-tray class="size-5" />
                        </a>
                    </div>
                </div>

                <img loading="lazy" src="{{ asset($product_collection->image) }}"
                    alt="{{ $user->firstname . ' ' . $user->lastname }}" class="w-full rounded-t-2xl mx-auto">

                <h1 class="text-2xl font-medium text-center mt-5">{{ $product_collection->title }}</h1>

                <div class="max-w-none px-5 text-center">
                    {{ $product_collection->description }}
                </div>

                {{-- Categories --}}
                @if ($product_collection)
                    <div>
                        {{-- <h2 class="text-xl font-medium text-center mt-10">{{ $product_collection->title }}</h2> --}}
                        {{-- <div class="grid grid-cols-2 gap-4 mt-10 px-5 mb-10 items-stretch"> --}}
                        <div class="flex flex-wrap justify-center gap-4 mt-5 mx-auto">
                            {{-- @foreach ($products as $product)
                                @php
                                    if (!preg_match('/^https?:\/\//', $product['payment_link'])) {
                                        $product['payment_link'] = 'https://' . $product['payment_link'];
                                    }
                                @endphp
                                <div class="bg-slate-100 dark:bg-zinc-800 rounded-md flex flex-col h-full">
                                    <a
                                        href="{{ route('product.show', ['username' => $user->username, 'id' => $product->id]) }}">
                                        <img loading="lazy"
                                            src="{{ $product->featured_image ? asset($product->featured_image) : asset('/img/product-placeholder.jpg') }}"
                                            alt="{{ $product->product_name }}"
                                            class="rounded-t-md w-full h-auto aspect-[4/3] object-cover">
                                    </a>
                                    <div class="px-3 py-2 flex flex-col justify-between flex-1">
                                        <a
                                            href="{{ route('product.show', ['username' => $user->username, 'id' => $product->id]) }}">
                                            <h1 class="text-sm font-medium text-center truncate">
                                                {{ $product->product_name }}
                                            </h1>
                                            @if ($product_price_enabled)
                                                <h1 class="text-sm font-medium text-center"
                                                    style="color: {{ $color_settings_link }} !important;">
                                                    ${{ $product->price }}
                                                </h1>
                                            @endif
                                        </a>
                                        <div class="flex justify-center mt-5">
                                            <div class="flex items-center border rounded-md overflow-hidden">
                                                <button type="button" class="px-2 py-1 text-lg font-bold"
                                                    onclick="updateQuantity('{{ $product->id }}', -1)">-</button>
                                                <input type="number" value="0" min="0"
                                                    data-name="{{ $product->product_name }}"
                                                    data-price="{{ $product->price }}"
                                                    data-image="{{ $product->featured_image ?? '' }}"
                                                    data-username="{{ $card->username ?? request()->segment(1) }}"
                                                    id="quantity-{{ $product->id }}"
                                                    class="w-12 text-center border-black focus:ring-0 focus:outline-none text-black"
                                                    oninput="saveToCart('{{ $product->id }}', this.value, this.dataset.name, parseFloat(this.dataset.price), this.dataset.image, this.dataset.username)">
                                                <button type="button" class="px-2 py-1 text-lg font-bold"
                                                    onclick="updateQuantity('{{ $product->id }}', 1)">+</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach --}}

                            @foreach ($products as $product)
                                <div class="mx-1 bg-slate-100 dark:bg-zinc-800 rounded-md h-full w-[45%]">
                                    <div class="relative">
                                        <a
                                            href="{{ route('product.show', ['username' => $user->username, 'id' => $product->id]) }}">
                                            <img loading="lazy"
                                                src="{{ $product->featured_image ? asset($product->featured_image) : asset('/img/product-placeholder.jpg') }}"
                                                alt="{{ $product->product_name }}"
                                                class="rounded-t-md w-full h-auto aspect-[4/3] object-cover">
                                        </a>

                                        {{-- Discount Badge --}}
                                        @if ($product->discount_percentage && $product->is_deal_active)
                                            <span
                                                class="absolute top-2 left-2 bg-red-500 text-white text-xs font-bold px-2 py-1 rounded">
                                                {{ round($product->discount_percentage) }}% OFF
                                            </span>
                                        @endif
                                    </div>

                                    <div class="px-3 py-2 flex flex-col justify-between flex-1">
                                        <a
                                            href="{{ route('product.show', ['username' => $user->username, 'id' => $product->id]) }}">
                                            <h1 class="text-sm font-medium text-center truncate">
                                                {{ $product->product_name }}</h1>

                                            <h1 class="font-medium text-center">
                                                @if ($product->is_on_deal && $product->is_deal_active)
                                                    <span class="text-sm text-gray-400 line-through inline-block">
                                                        ${{ $product->price }}
                                                    </span>
                                                @endif
                                                <span class="text-base font-bold"
                                                    style="color: {{ $color_settings_link }}">
                                                    ${{ $product->final_price }}
                                                </span>
                                            </h1>
                                        </a>

                                        {{-- Quantity selector, etc. --}}
                                        <div class="flex justify-center mt-5">
                                            <div class="flex items-center border rounded-md overflow-hidden">
                                                <button type="button" class="px-2 py-1 text-lg font-bold"
                                                    onclick="updateQuantity('{{ $product->id }}', -1)">-</button>
                                                <input type="number" value="0" min="0"
                                                    data-name="{{ $product->product_name }}"
                                                    data-price="{{ $product->final_price }}"
                                                    data-image="{{ $product->featured_image ?? '' }}"
                                                    data-username="{{ $card->username ?? request()->segment(1) }}"
                                                    id="quantity-{{ $product->id }}"
                                                    class="w-12 text-center border-black focus:ring-0 focus:outline-none text-black"
                                                    oninput="saveToCart('{{ $product->id }}', this.value, this.dataset.name, parseFloat(this.dataset.final_price), this.dataset.image, this.dataset.username)">
                                                <button type="button" class="px-2 py-1 text-lg font-bold"
                                                    onclick="updateQuantity('{{ $product->id }}', 1)">+</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                        </div>
                    </div>
                @endif

            </div>

            <div id="cart-footer"
                class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 shadow-lg p-4 flex justify-between items-center z-50 hidden">
                <a href="{{ route('sales.cart', $user->username) }}"
                    class="bg-blue-600 text-white font-bold px-4 py-3 rounded-lg hover:bg-blue-700 transition">
                    Checkout
                </a>
                <span class="font-bold text-lg">Total: $<span id="cart-total">0.00</span></span>
            </div>
        @else
            <div id="custom_bg" class="h-screen flex justify-center items-center">
                <div>
                    {{-- <p class="mx-auto text-yellow-500 text-center text-l p-10">
                        <x-ionicon-warning-sharp class="size-32 sm:size-40" />
                    </p> --}}
                    <p class="mx-auto font-medium text-center text-2xl">No product(s) found</p>
                </div>
            </div>
    @endif
</div>
