<div class="mb-20">
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('customize.themes') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="col-span-3 flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold ">
                <x-solar-pallete-2-linear class="size-6 inline-block" />
                &nbsp;&nbsp;Customize Colors
            </p>

        </div>
    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-5">

        {{-- <div class="flex items-center">
                <h2 class="text-base/7 font-semibold text-gray-900  dark:text-gray-400">Custom Button
                </h2>&nbsp;&nbsp;

                <span
                    class="flex items-center rounded-full bg-yellow-100 px-1.5 py-0.5 text-[10px] font-medium text-yellow-700 ring-1 ring-pink-700/10 ring-inset">
                    New&nbsp;<x-heroicon-s-sparkles class="size-3" />
                </span>
            </div> --}}


        <ul role="list" class="divide-y divide-gray-100 dark:divide-gray-600 px-5">
            {{-- Custom Button --}}
            <li class="flex justify-between py-3 cursor-pointer"
                @click="showColorPicker=!showColorPicker;color_settings_custom_button=true;selected_color_setting='color_settings_custom_button'">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Custom Button</p>
                    </div>
                </div>
                <div class="flex items-center">
                    <span style="background-color: {{ $color_settings_custom_button }};"
                        class="rounded-full w-5 h-5 border-2 border-slate-300 dark:border-white"></span>
                </div>
            </li>

            {{-- Custom Button Text --}}
            <li class="flex justify-between py-3 cursor-pointer"
                @click="showColorPicker=!showColorPicker;color_settings_custom_button_text=true;selected_color_setting='color_settings_custom_button_text'">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Button Text</p>
                    </div>
                </div>
                <div class="flex items-center">
                    <span style="background-color: {{ $color_settings_custom_button_text }};"
                        class="rounded-full w-5 h-5 border-2 bborder-slate-300 dark:border-white"></span>
                </div>
            </li>

            {{-- Link --}}
            <li class="flex justify-between py-3 cursor-pointer"
                @click="showColorPicker=!showColorPicker;color_settings_link=true;selected_color_setting='color_settings_link'">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Link</p>
                    </div>
                </div>
                <div class="flex items-center">
                    <span style="background-color: {{ $color_settings_link }};"
                        class="rounded-full w-5 h-5 border-2 border-slate-300 dark:border-white"></span>
                </div>
            </li>


            {{-- Profile Picture Border --}}
            <li class="flex justify-between py-3 cursor-pointer"
                @click="showColorPicker=!showColorPicker;color_settings_profile_pic_border=true;selected_color_setting='color_settings_profile_pic_border'">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Border | Paginations
                        </p>
                    </div>
                </div>
                <div class="flex items-center">
                    <span style="background-color: {{ $color_settings_profile_pic_border }};"
                        class="rounded-full w-5 h-5 border-2 border-slate-300 dark:border-white"></span>
                </div>
            </li>

            {{-- Text (Light Mode) --}}
            <li class="flex justify-between py-3 cursor-pointer"
                @click="showColorPicker=!showColorPicker;color_settings_text_light=true;selected_color_setting='color_settings_text_light'">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Text (Light Mode)</p>
                    </div>
                </div>
                <div class="flex items-center">
                    <span style="background-color: {{ $color_settings_text_light }};"
                        class="rounded-full w-5 h-5 border-2 border-slate-300 dark:border-white"></span>
                </div>
            </li>

            {{-- Text (Dark Mode) --}}
            <li class="flex justify-between py-3 cursor-pointer"
                @click="showColorPicker=!showColorPicker;color_settings_text_dark=true;selected_color_setting='color_settings_text_dark'">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Text (Dark Mode)</p>
                    </div>
                </div>
                <div class="flex items-center">
                    <span style="background-color: {{ $color_settings_text_dark }};"
                        class="rounded-full w-5 h-5 border-2 border-slate-300 dark:border-white"></span>
                </div>
            </li>

            {{-- Card (Dark Mode) --}}
            <li class="flex justify-between py-3 cursor-pointer"
                @click="showColorPicker=!showColorPicker;color_settings_card_light=true;selected_color_setting='color_settings_card_light'">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Card (Light Mode)</p>
                    </div>
                </div>
                <div class="flex items-center">
                    <span style="background-color: {{ $color_settings_card_light }};"
                        class="rounded-full w-5 h-5 border-2 border-slate-300 dark:border-white"></span>
                </div>
            </li>

            {{-- Card (Dark Mode) --}}
            <li class="flex justify-between py-3 cursor-pointer"
                @click="showColorPicker=!showColorPicker;color_settings_card_dark=true;selected_color_setting='color_settings_card_dark'">
                <div class="flex min-w-0 gap-x-4 items-center">
                    <div class="min-w-0 flex-auto">
                        <p class="text-sm/6 font-semibold text-gray-900 dark:text-slate-300">Card (Dark Mode)</p>
                    </div>
                </div>
                <div class="flex items-center">
                    <span style="background-color: {{ $color_settings_card_dark }};"
                        class="rounded-full w-5 h-5 border-2 border-slate-300 dark:border-white"></span>
                </div>
            </li>
        </ul>
    </div>

    <livewire:color-picker-modal />
</div>
