<div class="z-20 fixed sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto bottom-0 left-0 right-0
    bg-white dark:bg-zinc-800 shadow-lg transform translate-y-full transition-transform duration-300
    rounded-t-2xl flex flex-col"
    :class="{ 'translate-y-full': !openCommunitiesModal, 'translate-y-0': openCommunitiesModal }">

    {{-- Header (fixed height, doesn’t scroll) --}}
    <div class="px-8 py-6 shrink-0">
        <span class="rounded-full bg-red-500 text-white p-5 flex w-fit mx-auto">
            <x-fas-users class="size-10" />
        </span>
        <h3 class="text-lg font-sans text-slate-800 dark:text-slate-300 text-center py-2">
            Communities
        </h3>
    </div>

    @if ($communities)
        {{-- Scrollable content (respects 40vh, scrolls when overflowing) --}}
        <div class="px-8 pb-10 overflow-y-auto grow space-y-5">
            @foreach ($communities as $community)
                <a wire:navigate
                    class="flex my-5 items-center justify-center mx-center gap-2 p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto text-sm font-bold"
                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                    href="{{ $community['link'] }}" target="_blank">

                    @if ($community['type'] == 'telegram_community')
                        <x-fileicon-telegram class="size-4 inline" />
                    @elseif ($community['type'] == 'facebook_community')
                        <x-fab-facebook class="size-4 inline" />
                    @elseif ($community['type'] == 'whatsapp_community')
                        <x-ri-whatsapp-fill class="size-4 inline" />
                    @elseif ($community['type'] === 'discord_community')
                        <x-fab-discord class="size-4" />
                    @elseif ($community['type'] === 'skool_community')
                        <skool-icon-mono class="size-6 inline"></skool-icon-mono>
                    @endif

                    &nbsp;&nbsp;
                    {{ $community->title }}

                </a>
            @endforeach
        </div>
    @endif
</div>
