<div class="z-20 fixed sm:w-7/12 md:w-6/12 lg:w-4/12 mx-auto bottom-0 left-0 right-0 bg-white dark:bg-zinc-900 shadow-lg transform translate-y-full transition-transform duration-300 rounded-t-2xl"
    :class="{ 'translate-y-full': !showColorPicker, 'translate-y-0': showColorPicker }" x-init="$watch('showColorPicker', value => {
        if (value) {
            setTimeout(initColorPicker, 100);
        }
    })">

    <div class="p-4">
        <div class="flex justify-between items-center">
            <h3 class="text-lg font-bold text-slate-800 dark:text-slate-300 flex items-center">
                <x-solar-pallete-2-linear class="size-6" />
                &nbsp;&nbsp;
                <span x-show="color_settings_custom_button">Custom Button</span>
                <span x-show="color_settings_custom_button_text">Button Text</span>
                <span x-show="color_settings_link">Link</span>
                <span x-show="color_settings_profile_pic_border">Border | Paginations</span>
                <span x-show="color_settings_card_light">Card (Light Mode)</span>
                <span x-show="color_settings_card_dark">Card (Dark Mode)</span>
                <span x-show="color_settings_text_light">Text (Light Mode)</span>
                <span x-show="color_settings_text_dark">Text (Dark Mode)</span>
            </h3>
            <!-- Close Action Sheet -->
            <button
                @click="showColorPicker=!showColorPicker;selected_color_setting='';color_settings_custom_button=false;color_settings_custom_button_text=false;color_settings_link=false;color_settings_profile_pic_border=false;color_settings_card_light=false;color_settings_card_dark=false;"
                class="text-gray-500">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none"
                    stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                    <path d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>

        <div class="mt-4 space-y-3">
            <div class="pt-10 px-10">

                <form wire:submit.prevent="save_custom_colors">

                    <input type="hidden" id="selected_color_setting" wire:model="selected_color_setting"
                        x-model="selected_color_setting">

                    <input type="hidden" id="color_settings_custom_button" wire:model="color_settings_custom_button">
                    <input type="hidden" id="color_settings_custom_button_text"
                        wire:model="color_settings_custom_button_text">
                    <input type="hidden" id="color_settings_link" wire:model="color_settings_link">
                    <input type="hidden" id="color_settings_profile_pic_border"
                        wire:model="color_settings_profile_pic_border">

                    <input type="hidden" id="color_settings_card_light" wire:model="color_settings_card_light">
                    <input type="hidden" id="color_settings_card_dark" wire:model="color_settings_card_dark">

                    <input type="hidden" id="color_settings_text_light" wire:model="color_settings_text_light">
                    <input type="hidden" id="color_settings_text_dark" wire:model="color_settings_text_dark">

                    <div wire:ignore class="mx-auto flex justify-center">
                        <div id="picker"></div>
                    </div>

                    <div class="swatchGrid flex justify-center mt-2" id="swatch-grid">

                        {{-- currently used colors --}}
                        <div class="swatch border-2 border-slate-200"
                            data-color="{{ $color_settings_custom_button_text }}"
                            style="background: {{ $color_settings_custom_button_text }}">
                        </div>

                        <div class="swatch border-2 border-slate-200" data-color="{{ $color_settings_custom_button }}"
                            style="background: {{ $color_settings_custom_button }}">
                        </div>

                        <div class="swatch border-2 border-slate-200" data-color="{{ $color_settings_link }}"
                            style="background: {{ $color_settings_link }}">
                        </div>

                        <div class="swatch border-2 border-slate-200"
                            data-color="{{ $color_settings_profile_pic_border }}"
                            style="background: {{ $color_settings_profile_pic_border }}">
                        </div>

                        <div class="swatch border-2 border-slate-200" data-color="{{ $color_settings_card_light }}"
                            style="background: {{ $color_settings_card_light }}">
                        </div>

                        <div class="swatch border-2 border-slate-200" data-color="{{ $color_settings_card_dark }}"
                            style="background: {{ $color_settings_card_dark }}">
                        </div>


                        <div class="swatch border-2 border-slate-200" data-color="{{ $color_settings_text_light }}"
                            style="background: {{ $color_settings_text_light }}">
                        </div>

                        <div class="swatch border-2 border-slate-200" data-color="{{ $color_settings_text_dark }}"
                            style="background: {{ $color_settings_text_dark }}">
                        </div>

                        {{-- 2nd row --}}
                        <div class="swatch border-2 border-slate-200" data-color="#00b894" style="background: #00b894">
                        </div>
                        <div class="swatch border-2 border-slate-200" data-color="#7d5fff" style="background: #7d5fff">
                        </div>
                        <div class="swatch border-2 border-slate-200" data-color="#0984e3" style="background: #0984e3">
                        </div>
                        <div class="swatch border-2 border-slate-200" data-color="#6c5ce7" style="background: #6c5ce7">
                        </div>
                        <div class="swatch border-2 border-slate-200" data-color="#b2bec3" style="background: #b2bec3">
                        </div>
                        <div class="swatch border-2 border-slate-200" data-color="#fdcb6e" style="background: #fdcb6e">
                        </div>
                        <div class="swatch border-2 border-slate-200" data-color="#e17055"
                            style="background: #e17055">
                        </div>

                        {{-- 3rd Row --}}

                        <div class="swatch border-2 border-slate-200" data-color="#d63031"
                            style="background: #d63031">
                        </div>
                        <div class="swatch border-2 border-slate-200" data-color="#e84393"
                            style="background: #e84393">
                        </div>
                        <div class="swatch border-2 border-slate-200" data-color="#2d3436"
                            style="background: #2d3436">
                        </div>
                        <div class="swatch border-2 border-slate-200" data-color="#574b90"
                            style="background: #574b90">
                        </div>
                        <div class="swatch border-2 border-slate-200" data-color="#f78fb3"
                            style="background: #f78fb3">
                        </div>
                        <div class="swatch border-2 border-slate-200" data-color="#546de5"
                            style="background: #546de5">
                        </div>
                        <div class="swatch border-2 border-slate-200" data-color="#3dc1d3"
                            style="background: #3dc1d3">
                        </div>

                        {{-- 4th Row --}}

                        <div class="swatch border-2 border-slate-200" data-color="#78e08f"
                            style="background: #78e08f">
                        </div>

                        <div class="swatch border-2 border-slate-200" data-color="#facc15"
                            style="background: #facc15">
                        </div>

                        <div class="swatch border-2 border-slate-200" data-color="#ca8a04"
                            style="background: #ca8a04">
                        </div>

                        <div class="swatch border-2 border-slate-200" data-color="#18181b"
                            style="background: #18181b">
                        </div>

                        <div class="swatch border-2 border-slate-200" data-color="#b71540"
                            style="background: #b71540">
                        </div>

                        <div class="swatch border-2 border-slate-200" data-color="#0c2461"
                            style="background: #0c2461">
                        </div>
                        {{-- White --}}
                        <div class="swatch border-2 border-slate-200" data-color="#ffffff"
                            style="background: #ffffff">
                        </div>
                        {{-- Black --}}
                        <div class="swatch border-2 border-slate-200" data-color="#000000"
                            style="background: #000000">
                        </div>
                    </div>

                    <div
                        class="mt-2 mx-auto flex items-center rounded-full bg-gray-100 dark:bg-white px-5 outline-1 -outline-offset-1 outline-gray-300 focus-within:outline-2 focus-within:-outline-offset-2 focus-within:outline-yellow-600 w-[250px]">
                        <input type="text" name="title" id="hexInput"
                            class="block min-w-0 grow py-2 text-base text-gray-900 bg-gray-100 dark:bg-white placeholder:text-gray-400 focus:outline-none rounded-full"
                            placeholder="Hex Value">
                    </div>
                    <br>
                    <button type="submit"
                        class="mt-2 flex w-full justify-center rounded-md px-3 py-1.5 text-sm/6 font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700 focus-visible:outline-yellow-600"
                        x-cloak>Update Color</button>

                    <button type="button"
                        @click="showColorPicker=!showColorPicker;selected_color_setting='';color_settings_custom_button=false;color_settings_custom_button_text=false;color_settings_link=false;color_settings_profile_pic_border=false;color_settings_card_light=false;color_settings_card_dark=false;color_settings_text_light=false;color_settings_text_dark=false;"
                        class="w-full px-4 py-2 text-red-600 rounded-md hover:bg-gray-100 dark:hover:bg-zinc-950 text-center">
                        Cancel
                    </button>
                </form>

                @push('scripts')
                    <script>
                        let colorPicker; // Declare globally so it can be reused or destroyed

                        window.addEventListener('livewire:navigated', function() {
                            if (document.querySelector('#picker')) {
                                setTimeout(initColorPicker, 500);
                            }
                        });

                        function initColorPicker() {
                            // Clean up existing picker if it exists
                            if (colorPicker) {
                                colorPicker.off(); // remove all event listeners
                                colorPicker = null;
                                document.getElementById("picker").innerHTML = ""; // Clear old picker UI
                            }

                            const selected_color_setting = document.getElementById("selected_color_setting");

                            const color_settings_custom_button = document.getElementById("color_settings_custom_button");
                            const color_settings_custom_button_text = document.getElementById("color_settings_custom_button_text");
                            const color_settings_link = document.getElementById("color_settings_link");
                            const color_settings_profile_pic_border = document.getElementById("color_settings_profile_pic_border");
                            const color_settings_card_light = document.getElementById("color_settings_card_light");
                            const color_settings_card_dark = document.getElementById("color_settings_card_dark");

                            const color_settings_text_light = document.getElementById("color_settings_text_light");
                            const color_settings_text_dark = document.getElementById("color_settings_text_dark");

                            var hexInput = document.getElementById("hexInput");

                            let default_color = "#ff0000"; // fallback color

                            switch (selected_color_setting.value) {
                                case 'color_settings_custom_button':
                                    default_color = color_settings_custom_button.value;
                                    hexInput.value = default_color;
                                    break;
                                case 'color_settings_custom_button_text':
                                    default_color = color_settings_custom_button_text.value;
                                    hexInput.value = default_color;
                                    break;
                                case 'color_settings_link':
                                    default_color = color_settings_link.value;
                                    hexInput.value = default_color;
                                    break;
                                case 'color_settings_profile_pic_border':
                                    default_color = color_settings_profile_pic_border.value;
                                    hexInput.value = default_color;
                                    break;
                                case 'color_settings_card_light':
                                    default_color = color_settings_card_light.value;
                                    hexInput.value = default_color;
                                    break;
                                case 'color_settings_card_dark':
                                    default_color = color_settings_card_dark.value;
                                    hexInput.value = default_color;
                                    break;
                                case 'color_settings_text_light':
                                    default_color = color_settings_text_light.value;
                                    hexInput.value = default_color;
                                    break;
                                case 'color_settings_text_dark':
                                    default_color = color_settings_text_dark.value;
                                    hexInput.value = default_color;
                                    break;
                            }

                            // Initialize new picker
                            // colorPicker = new iro.ColorPicker("#picker", {
                            //     width: 200,
                            //     color: default_color,
                            // });

                            colorPicker = new iro.ColorPicker("#picker", {
                                width: 250,
                                color: default_color,
                                borderWidth: 1,
                                borderColor: "#fff",
                                layout: [{
                                        component: iro.ui.Box,
                                    },
                                    {
                                        component: iro.ui.Slider,
                                        options: {
                                            id: 'hue-slider',
                                            sliderType: 'hue'
                                        }
                                    }
                                ]
                            });

                            // hexInput.addEventListener('keyup', function() {
                            //     colorPicker.color.hexString = this.value;
                            // });

                            hexInput.addEventListener('blur', function() {
                                const hex = this.value.trim();
                                const isValidHex = /^#([0-9A-F]{3}){1,2}$/i.test(hex);
                                if (isValidHex) {
                                    colorPicker.color.hexString = hex;
                                }
                            });

                            var swatchGrid = document.getElementById('swatch-grid');

                            swatchGrid.addEventListener('click', function(e) {
                                var clickTarget = e.target;
                                // read data-color attribute
                                if (clickTarget.dataset.color) {
                                    // update the color picker
                                    colorPicker.color.set(clickTarget.dataset.color);
                                }
                            });

                            // Optional: attach colorPicker access to window if needed externally
                            window.getColorHex = () => colorPicker?.color.hexString;

                            colorPicker.on('color:change', function(color) {
                                let hex = color.hexString;
                                const selectedSetting = document.getElementById('selected_color_setting');

                                hexInput.value = color.hexString;

                                function updateInput(id) {

                                    const el = document.getElementById(id);
                                    if (el) {
                                        el.value = hex;
                                        el.dispatchEvent(new Event('input', {
                                            bubbles: true
                                        }));
                                    }
                                }

                                Livewire.dispatch('selected_color_setting', {
                                    value: selected_color_setting.value
                                });

                                Livewire.dispatch('set_color', {
                                    value: hex
                                });

                            });
                        }
                    </script>
                @endpush

            </div>

        </div>
    </div>

</div>
