<div>
    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pb-5">

        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a wire:navigate href="{{ route('settings.index') }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <span class="text-zinc-900"> <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke-width="1.5" stroke="currentColor" class="size-4">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 19.5 8.25 12l7.5-7.5" />
                        </svg>
                    </span>
                </a>
            </div>

            <p
                class="col-span-3 flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold ">

                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M16.5 10.5V6.75a4.5 4.5 0 1 0-9 0v3.75m-.75 11.25h10.5a2.25 2.25 0 0 0 2.25-2.25v-6.75a2.25 2.25 0 0 0-2.25-2.25H6.75a2.25 2.25 0 0 0-2.25 2.25v6.75a2.25 2.25 0 0 0 2.25 2.25Z" />
                </svg>

                &nbsp;&nbsp;Change Password
            </p>
        </div>
    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-20">

        <div class="px-5">
            <form wire:submit.prevent="updatePassword()">
                <div class="space-y-12">

                    <div class="pb-12">

                        <div class="grid grid-cols-4 gap-x-6 gap-y-8">

                            <div class="col-span-full">
                                <label for="old_password"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Old
                                    Password</label>
                                <div class="mt-2">
                                    <input type="password" wire:model="old_password"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('old_password') border border-red-600 @enderror"
                                        placeholder="Enter Old Password"
                                        value="{{ old('old_password', $old_password) }}" />
                                </div>

                                @error('old_password')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="password"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">New Password
                                </label>
                                <div class="mt-2">
                                    <input type="password" wire:model="password"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('password') border border-red-600 @enderror"
                                        placeholder="Enter New Password" value="{{ old('password', $password) }}" />
                                </div>

                                @error('password')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="password_confirmation"
                                    class="block text-sm/6 font-medium text-gray-900 dark:text-gray-400">Retype New
                                    Password
                                </label>
                                <div class="mt-2">
                                    <input type="password" wire:model="password_confirmation"
                                        class="block w-full rounded-md bg-gray-100 px-3 py-1.5 text-base text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 sm:text-sm/6 @error('password_confirmation') border border-red-600 @enderror"
                                        placeholder="Retype New Password"
                                        value="{{ old('password_confirmation', $password_confirmation) }}" />
                                </div>

                                @error('password_confirmation')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                        </div>
                    </div>

                </div>

                <div class="flex items-center justify-end gap-x-6 gap-4">
                    <button type="submit"
                        class="rounded-md px-3 py-2 text-sm font-semibold text-black shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 bg-gradient-to-b from-yellow-400 to-yellow-400 hover:from-yellow-400 hover:to-yellow-700">Update
                        Password</button>
                </div>
            </form>
        </div>

    </div>

</div>
