<div>
    @if ($user && $sale_video)
        @guest
            <div id="custom_bg"
                class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl my-5">
            @endguest
            @auth
                <div id="custom_bg"
                    class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 flex flex-col content-center rounded-2xl mb-20 mt-5">
                @endauth
                <div class="grid grid-cols-2 gap-4 mb-5">
                    <!-- back -->
                    <div class="ml-5  flex items-center">
                        <a href="{{ route('sales.content', ['username' => $user->username, 'sales' => $sales_id]) }}"
                            class="rounded-full bg-slate-100
                            dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-chevron-left class="size-4" />
                        </a>
                    </div>

                    <!-- Share Card -->
                    <div class="mr-5 flex items-center place-content-end" x-data="{
                        urlTitle: `{{ $user['firstname'] }} {{ $user['lastname'] }} | {{ $user['job_title'] }}`,
                        shareUrl: '{{ $site_url . $user['username'] }}',
                        shareCard() {
                            if (navigator.share) {
                                navigator.share({
                                    title: this.urlTitle,
                                    url: this.shareUrl,
                                }).then(() => {
                                    console.log('Thanks for sharing!');
                                }).catch(console.error);
                            } else {
                                console.log('Web Share API not supported');
                            }
                        }
                    }">

                        <button type="button" @click="showQRCode=!showQRCode"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg mr-3">
                            <x-heroicon-o-qr-code class="size-5" />
                        </button>

                        <a href="#" id="share_my_card" x-on:click.prevent="shareCard"
                            class="rounded-full bg-slate-100 dark:bg-white p-2.5 text-zinc-900 hover:shadow-lg">
                            <x-heroicon-o-arrow-up-tray class="size-5" />
                        </a>
                    </div>
                </div>

                {{-- <img src="{{ $sale_video->image_path ? asset($sale_video->image_path) : asset('/img/product-placeholder.jpg') }}"
                    class="rounded-t-md"> --}}

                @if ($sale_video->video_link)
                    <div class="w-full relative mx-auto px-5 mt-10" style="z-index: 0; position: relative;"
                        x-data="initSwiper()">

                        <script>
                            document.addEventListener('DOMContentLoaded', function() {
                                document.querySelectorAll('.swiper-slide').forEach((slide) => {
                                    const iframe = slide.querySelector('iframe');
                                    const playButton = slide.querySelector('.play-button');
                                    const thumbnailOverlay = slide.querySelector('.thumbnail-overlay');

                                    playButton.addEventListener('click', () => {
                                        if (iframe.src.includes('youtube')) {
                                            iframe.contentWindow.postMessage(JSON.stringify({
                                                event: 'command',
                                                func: 'playVideo',
                                                args: []
                                            }), '*');
                                        } else if (iframe.src.includes('vimeo')) {
                                            const player = new Vimeo.Player(iframe);
                                            player.play();
                                        }

                                        // Hide the thumbnail overlay after clicking the play button
                                        thumbnailOverlay.style.display = 'none';
                                    });
                                });
                            });

                            function initSwiper() {
                                return {
                                    swiper: null,
                                    videoIsPlaying: false,
                                    userPausedByInteraction: false,
                                    awaitingPlayFromInteraction: false,
                                    autoplayDelay: 5000,
                                    _autoplayTimer: null,
                                    _awaitTimer: null,
                                    lastIndex: 0,
                                    _resumeTimer: null,

                                    _pauseAutoplayFor(ms = 5000) {
                                        this._stopAutoplayNow();
                                        this.userPausedByInteraction = true;

                                        if (this._resumeTimer) {
                                            clearTimeout(this._resumeTimer);
                                            this._resumeTimer = null;
                                        }

                                        this._resumeTimer = setTimeout(() => {
                                            this.userPausedByInteraction = false;
                                            this._scheduleAutoplay();
                                        }, ms);
                                    },
                                    _stopAutoplayNow() {
                                        if (this._autoplayTimer) {
                                            clearTimeout(this._autoplayTimer);
                                            this._autoplayTimer = null;
                                        }
                                    },

                                    _scheduleAutoplay() {
                                        this._stopAutoplayNow();
                                        if (this.videoIsPlaying || this.userPausedByInteraction) return;
                                        const self = this;
                                        this._autoplayTimer = setTimeout(() => {
                                            if (!self.videoIsPlaying && !self.userPausedByInteraction && self.swiper) {
                                                try {
                                                    self.swiper.slideNext();
                                                } catch {}
                                            }
                                            self._scheduleAutoplay();
                                        }, this.autoplayDelay);
                                    },

                                    _clearAwaiting() {
                                        if (this._awaitTimer) {
                                            clearTimeout(this._awaitTimer);
                                            this._awaitTimer = null;
                                        }
                                        this.awaitingPlayFromInteraction = false;
                                    },

                                    pauseAllVideos() {
                                        // Pause HTML5 videos
                                        document.querySelectorAll('.default-carousel video').forEach(v => {
                                            try {
                                                v.pause();
                                            } catch {}
                                        });

                                        // Pause Vimeo videos via SDK
                                        if (typeof Vimeo !== 'undefined') {
                                            document.querySelectorAll('.default-carousel iframe[src*="vimeo.com"]').forEach(iframe => {
                                                try {
                                                    new Vimeo.Player(iframe).pause();
                                                } catch {}
                                            });
                                        }

                                        // Pause YouTube videos via postMessage
                                        document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                            try {
                                                iframe.contentWindow.postMessage(
                                                    JSON.stringify({
                                                        event: 'command',
                                                        func: 'pauseVideo',
                                                        args: []
                                                    }),
                                                    "https://www.youtube.com" // ✅ correct target origin
                                                );
                                            } catch {}
                                        });
                                    },

                                    init() {
                                        const self = this;

                                        const container = document.querySelector('.default-carousel');
                                        if (!container) {
                                            console.warn('initSwiper: .default-carousel not found');
                                        }

                                        // ⬇️ interaction handler — updated here
                                        const onMediaInteraction = (ev) => {
                                            const slide = ev.target && ev.target.closest ? ev.target.closest('.swiper-slide') : null;
                                            if (!slide) return;

                                            if (slide.querySelector('video, iframe')) {
                                                self.userPausedByInteraction = true;
                                                self.awaitingPlayFromInteraction = true;
                                                self._clearAwaiting();
                                                self._stopAutoplayNow();
                                            }
                                        };

                                        document.addEventListener('pointerdown', onMediaInteraction, true);
                                        document.addEventListener('touchstart', onMediaInteraction, true);
                                        document.addEventListener('mousedown', onMediaInteraction, true);
                                        document.addEventListener('click', onMediaInteraction, true);
                                        document.addEventListener('focusin', onMediaInteraction, true);

                                        // === Video event listeners ===
                                        document.querySelectorAll('.default-carousel video').forEach(video => {
                                            video.addEventListener('play', () => {
                                                self._clearAwaiting();
                                                self.videoIsPlaying = true;
                                                self.userPausedByInteraction = true;
                                                self._stopAutoplayNow();
                                            }, {
                                                passive: true
                                            });

                                            video.addEventListener('pause', () => {
                                                self.videoIsPlaying = false;
                                                self.userPausedByInteraction = false;
                                                self._clearAwaiting();
                                                self._scheduleAutoplay();
                                            }, {
                                                passive: true
                                            });

                                            video.addEventListener('ended', () => {
                                                self.videoIsPlaying = false;
                                                self.userPausedByInteraction = false;
                                                self._clearAwaiting();
                                                try {
                                                    self.swiper.slideNext();
                                                } catch {}
                                                self._scheduleAutoplay();
                                            }, {
                                                passive: true
                                            });
                                        });

                                        // YouTube: ensure enablejsapi=1
                                        document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                            try {
                                                const src = iframe.getAttribute('src') || '';
                                                if (!/enablejsapi=1/.test(src)) {
                                                    const sep = src.includes('?') ? '&' : '?';
                                                    iframe.setAttribute('src', src + sep + 'enablejsapi=1');
                                                }
                                            } catch {}
                                        });

                                        // Vimeo API events
                                        if (typeof Vimeo !== 'undefined') {
                                            document.querySelectorAll('.default-carousel iframe[src*="vimeo.com"]').forEach(iframe => {
                                                try {
                                                    const player = new Vimeo.Player(iframe);
                                                    player.on('play', () => {
                                                        self._clearAwaiting();
                                                        self.videoIsPlaying = true;
                                                        self.userPausedByInteraction = true;
                                                        self._stopAutoplayNow();
                                                    });
                                                    player.on('pause', () => {
                                                        self.videoIsPlaying = false;
                                                        self.userPausedByInteraction = false;
                                                        self._scheduleAutoplay();
                                                    });
                                                    player.on('ended', () => {
                                                        self.videoIsPlaying = false;
                                                        self.userPausedByInteraction = false;
                                                        try {
                                                            self.swiper.slideNext();
                                                        } catch {}
                                                        self._scheduleAutoplay();
                                                    });
                                                } catch {}
                                            });
                                        }

                                        // YouTube API events
                                        const buildYT = () => {
                                            document.querySelectorAll('.default-carousel iframe[src*="youtube.com"]').forEach(iframe => {
                                                try {
                                                    new YT.Player(iframe, {
                                                        events: {
                                                            onStateChange: (e) => {
                                                                if (e.data === YT.PlayerState.PLAYING || e.data === YT
                                                                    .PlayerState.BUFFERING) {
                                                                    self._clearAwaiting();
                                                                    self.videoIsPlaying = true;
                                                                    self.userPausedByInteraction = true;
                                                                    self._stopAutoplayNow();
                                                                } else if (e.data === YT.PlayerState.PAUSED) {
                                                                    self.videoIsPlaying = false;
                                                                    self.userPausedByInteraction = false;
                                                                    self._scheduleAutoplay();
                                                                } else if (e.data === YT.PlayerState.ENDED) {
                                                                    self.videoIsPlaying = false;
                                                                    self.userPausedByInteraction = false;
                                                                    try {
                                                                        self.swiper.slideNext();
                                                                    } catch {}
                                                                    self._scheduleAutoplay();
                                                                }
                                                            }
                                                        }
                                                    });
                                                } catch {}
                                            });
                                        };
                                        if (window.YT && YT.Player) buildYT();
                                        else window.onYouTubeIframeAPIReady = buildYT;

                                        // Swiper init
                                        this.swiper = new Swiper('.default-carousel', {

                                            pagination: {
                                                el: '.swiper-pagination',
                                                clickable: true,
                                                dynamicBullets: false,
                                            },
                                            on: {
                                                init() {
                                                    updatePaginationActive(this);
                                                },
                                                slideChange() {
                                                    self.pauseAllVideos();
                                                    self._stopAutoplayNow();

                                                    if (!self.userPausedByInteraction && !self.videoIsPlaying) {
                                                        self._scheduleAutoplay();
                                                    }

                                                    updatePaginationActive(this);
                                                }
                                            }
                                        });

                                        // ✅ Fixed pagination handler
                                        function updatePaginationActive(swiper) {
                                            if (!swiper || !swiper.pagination || !swiper.pagination.el) return;
                                            const bullets = Array.from(swiper.pagination.el.querySelectorAll('.swiper-pagination-bullet'));
                                            const activeIndex = (typeof swiper.realIndex !== 'undefined') ? swiper.realIndex : (swiper
                                                .activeIndex || 0);
                                            bullets.forEach((bullet, i) => {
                                                bullet.classList.toggle('swiper-pagination-bullet-active', i === activeIndex);
                                            });
                                        }

                                        const paginationEl = this.swiper.pagination && this.swiper.pagination.el;
                                        if (paginationEl) {
                                            paginationEl.addEventListener('click', (e) => {
                                                const bullet = e.target.closest('.swiper-pagination-bullet');
                                                if (!bullet) return;

                                                const bullets = Array.from(paginationEl.querySelectorAll('.swiper-pagination-bullet'));
                                                const index = bullets.indexOf(bullet);
                                                if (index === -1) return;

                                                try {
                                                    self.swiper.slideToLoop(index);
                                                } catch {}

                                                updatePaginationActive(self.swiper);
                                                self._pauseAutoplayFor(5000);
                                            }, {
                                                passive: true
                                            });
                                        }

                                        this._scheduleAutoplay();
                                    }

                                };
                            }
                        </script>

                        <script src="https://www.youtube.com/iframe_api"></script>
                        <script src="https://player.vimeo.com/api/player.js"></script>

                        <div class="swiper default-carousel  mb-5" x-init="init()">
                            <div class="swiper-wrapper mb-5">

                                @php
                                    if (!function_exists('vimeo_aspect_ratio')) {
                                        function vimeo_aspect_ratio(string $videoId, ?string $videoHash = null): string
                                        {
                                            $cacheKey = 'vimeo_oembed_ar_' . $videoId . '_' . ($videoHash ?? 'nohash');

                                            return cache()->remember($cacheKey, 86400, function () use (
                                                $videoId,
                                                $videoHash,
                                            ) {
                                                try {
                                                    // Use the exact player URL (hash-aware) for oEmbed
                                                    $playerUrl =
                                                        'https://player.vimeo.com/video/' .
                                                        $videoId .
                                                        ($videoHash ? '?h=' . $videoHash : '');
                                                    $oembedUrl =
                                                        'https://vimeo.com/api/oembed.json?url=' .
                                                        urlencode($playerUrl);

                                                    $resp = \Illuminate\Support\Facades\Http::timeout(5)
                                                        ->retry(2, 100)
                                                        ->get($oembedUrl);
                                                    if ($resp->ok()) {
                                                        $data = $resp->json();
                                                        if (!empty($data['width']) && !empty($data['height'])) {
                                                            return $data['height'] > $data['width'] ? '9/16' : '16/9';
                                                        }
                                                    }
                                                } catch (\Throwable $e) {
                                                    // swallow and fall back
                                                }
                                                return '16/9'; // safe default
                                            });
                                        }
                                    }
                                @endphp

                                @php
                                    $videoUrl = $sale_video->video_link;
                                    $videoId = null;
                                    $videoHash = null;
                                    $isVimeo = false;
                                    $isShorts = false;
                                    $aspectRatio = '16/9'; // default
                                    $maxWidth = '800px'; // default

                                    // --- YouTube detections ---
                                    if (
                                        preg_match(
                                            '#(?:https?://)?(?:www\.)?youtube\.com/watch\?v=([a-zA-Z0-9_-]+)#',
                                            $videoUrl,
                                            $m,
                                        )
                                    ) {
                                        $videoId = $m[1];
                                    } elseif (
                                        preg_match(
                                            '#(?:https?://)?(?:www\.)?youtube\.com/shorts/([a-zA-Z0-9_-]{11})#',
                                            $videoUrl,
                                            $m,
                                        )
                                    ) {
                                        $videoId = $m[1];
                                        $isShorts = true;
                                    } elseif (
                                        preg_match(
                                            '#(?:https?://)?(?:www\.)?youtu\.be/([a-zA-Z0-9_-]+)#',
                                            $videoUrl,
                                            $m,
                                        )
                                    ) {
                                        $videoId = $m[1];
                                    } elseif (
                                        preg_match(
                                            '#(?:https?://)?(?:www\.)?m\.youtube\.com/v/([a-zA-Z0-9_-]+)#',
                                            $videoUrl,
                                            $m,
                                        )
                                    ) {
                                        $videoId = $m[1];
                                    }
                                    // --- Vimeo detection ---
                                    elseif (preg_match('#vimeo\.com/(?:video/)?([0-9]+)#', $videoUrl, $m)) {
                                        $videoId = $m[1];
                                        $isVimeo = true;

                                        // parse ?h= for private/hash-protected videos
                                        $query = parse_url($videoUrl, PHP_URL_QUERY);
                                        if ($query) {
                                            parse_str($query, $params);
                                            if (!empty($params['h'])) {
                                                $videoHash = $params['h'];
                                            }
                                        }

                                        // server-side aspect detection via oEmbed (cached)
                                        $aspectRatio = vimeo_aspect_ratio($videoId, $videoHash);
                                    }

                                    // Decide max width
                                    if ($isVimeo && $aspectRatio === '9/16') {
                                        $maxWidth = '450px';
                                    } elseif ($isShorts) {
                                        $aspectRatio = '9/16';
                                        $maxWidth = '450px';
                                    }
                                @endphp

                                <div class="swiper-slide w-full rounded-xl">
                                    {{-- Center + border + dark bg; NO absolute-fill (lets aspect-ratio work) --}}
                                    <div class="rounded-xl flex justify-center items-center bg-black"
                                        style="width:100%; border: 2px solid {{ $color_settings_profile_pic_border }} !important;">

                                        @if ($isVimeo)
                                            <iframe id="vimeo-player" class="rounded-xl"
                                                src="https://player.vimeo.com/video/{{ $videoId }}{{ $videoHash ? '?h=' . $videoHash : '' }}"
                                                frameborder="0" allow="autoplay; fullscreen" allowfullscreen
                                                style="width:100%; aspect-ratio: {{ $aspectRatio }}; max-width: {{ $maxWidth }};">
                                            </iframe>
                                        @else
                                            <iframe id="youtube-player" class="rounded-xl"
                                                src="https://www.youtube.com/embed/{{ $videoId }}?enablejsapi=1"
                                                frameborder="0"
                                                allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
                                                referrerpolicy="strict-origin-when-cross-origin" allowfullscreen
                                                style="width:100%; aspect-ratio: {{ $aspectRatio }}; max-width: {{ $maxWidth }};">
                                            </iframe>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="swiper-pagination"></div>
                        </div>
                    </div>
                @endif

                {{-- <img src="{{ $sale_image->image_path ? asset($sale_image->image_path) : asset('/img/product-placeholder.jpg') }}"
                    alt="{{ $sale_image->title }}" class="rounded-t-md"> --}}

                {{-- <h1 class="text-xl md:text-2xl font-medium text-center mt-5">
                    {{ $sale_image->title }}</h1> --}}

                {{-- <div class="mt-5 px-5">
                    <div class="">
                        <span>{!! Purifier::clean($sale_image->description) !!}</span>
                    </div>
                </div> --}}

                {{-- <a class="w-11/12 block p-1.5 sm:p-2 rounded-full text-black text-center mx-auto mt-5 mb-2 text-xs sm:text-sm font-semibold"
                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;"
                    href="{{ $sale_image['payment_link'] }}" target="_blank">Buy Now
                    @if ($product_price_enabled == true)
                        <span>
                            ${{ $product->price }}
                        </span>
                    @endif
                </a> --}}

                @if ($payments)
                    <p class="flex items-center justify-center text-center pt-5">
                        Payment links
                    </p>

                    <div class="pt-2 container mx-auto flex flex-wrap items-center justify-center">
                        @foreach ($payments as $payment)
                            @if ($payment['type'] === 'credit')
                                <a href="{{ $payment['link'] }}" target="_blank">
                                    <x-heroicon-s-credit-card class="size-7 mx-2 my-2" />
                                </a>
                            @elseif($payment['type'] == 'zelle')
                                <button
                                    @click="openPaymentLinkModal=!openPaymentLinkModal;button_zelle=true;payment_value='{{ $payment['link'] }}'">
                                    <x-si-zelle class="size-7 mx-2 my-2" />
                                </button>
                            @elseif($payment['type'] == 'apple_pay')
                                <button
                                    @click="openPaymentLinkModal=!openPaymentLinkModal;button_apple_pay=true;payment_value='{{ $payment['link'] }}'">
                                    <x-fab-apple class="size-7 mx-2 my-2" />
                                </button>
                            @elseif($payment['type'] == 'venmo')
                                <a href="{{ $payment['link'] }}" target="_blank">
                                    <x-bxl-venmo class="size-7 mx-2 my-2" />
                                </a>
                            @elseif($payment['type'] == 'cashapp')
                                <a href="{{ $payment['link'] }}" target="_blank">
                                    <x-si-cashapp class="size-7 mx-2 my-2" />
                                </a>
                            @elseif($payment['type'] == 'paypal_email')
                                <button
                                    @click="openPaymentLinkModal=!openPaymentLinkModal;button_paypal_email=true;payment_value='{{ $payment['link'] }}'">
                                    <x-fab-paypal class="size-7 mx-2 my-2" />
                                </button>
                            @elseif($payment['type'] == 'paypal_link')
                                <a href="{{ $payment['link'] }}" target="_blank">
                                    <x-fab-paypal class="size-7 mx-2 my-2" />
                                </a>
                            @endif
                        @endforeach
                    </div>

                @endif

                <div class="px-5">
                    <form wire:submit.prevent="cashCarryForm" class="w-full">

                        <div class="mt-10 grid grid-cols-4 gap-x-6 gap-y-8">

                            <div class="col-span-full sm:col-span-2">
                                <label for="firstname" class="block text-sm/6 font-medium">First
                                    name</label>
                                <div class="mt-2">
                                    <input type="text" id="firstname" wire:model="firstname"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('firstname') border border-red-600 @enderror"
                                        value="{{ old('firstname') }}">
                                </div>

                                @error('firstname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full sm:col-span-2">
                                <label for="lastname" class="block text-sm/6 font-medium">Last
                                    name</label>
                                <div class="mt-2">
                                    <input type="text" id="lastname" wire:model="lastname"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('lastname') border border-red-600 @enderror"
                                        value="{{ old('lastname') }}">
                                </div>

                                @error('lastname')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            {{-- <div class="col-span-full">

                                <label for="lastname" class="block text-sm/6 font-medium">Last
                                    name</label>
                                <div>
                                    <div class="mt-2">
                                        <select id="event_type" x-model="type" name="event_type" wire:model="event_type"
                                            class="col-start-1 row-start-1 w-full appearance-none rounded-md bg-white py-1.5 pr-8 pl-3">
                                            <option value="">Select Type</option>
                                            <option value="Photo">Photo</option>
                                            <option value="Video">Video</option>
                                        </select>
                                    </div>
                                </div>
                            </div> --}}

                            <div class="col-span-full">

                                <label for="phone" class="block text-sm/6 font-medium">Phone
                                </label>

                                <div class="mt-2">
                                    <input type="text" id="phone" wire:model="phone"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('phone') border border-red-600 @enderror"
                                        value="{{ old('phone') }}">
                                </div>

                                @error('phone')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">

                                <label for="phone" class="block text-sm/6 font-medium">Email
                                </label>

                                <div class="mt-2">
                                    <input type="text" id="sender_email" wire:model="sender_email"
                                        class="block w-full rounded-md dark:bg-white bg-slate-100 px-3 py-1.5 text-sm/6 text-gray-900 outline-1 -outline-offset-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:-outline-offset-2 focus:outline-yellow-600 @error('sender_email') border border-red-600 @enderror"
                                        value="{{ old('sender_email') }}">
                                </div>

                                @error('sender_email')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <label for="receipt" class="block text-sm/6 font-medium">After Payment, Upload
                                    Receipt</label>
                                <div class="mt-2">
                                    <input type="file" id="receipt" wire:model="receipt"
                                        class="block w-full text-sm text-gray-900 border border-gray-300 rounded-md cursor-pointer bg-slate-100 focus:outline-none focus:ring-2 focus:ring-yellow-600 @error('receipt') border-red-600 @enderror">
                                </div>

                                @error('receipt')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror

                                <!-- Livewire upload progress -->
                                <div wire:loading wire:target="receipt" class="text-sm text-gray-500 mt-1">
                                    Uploading receipt...
                                </div>
                            </div>

                            <div class="col-span-full">
                                <label class="block text-sm/6 font-medium">What’s your best way to connect?</label>
                                <div class="mt-3 space-y-2">
                                    <label class="flex items-center space-x-2">
                                        <input type="radio" wire:model="preferred_contact" value="Text" checked
                                            class="h-4 w-4 text-yellow-600 focus:ring-yellow-600 border-gray-300">
                                        <span class="text-sm">Text</span>
                                    </label>

                                    <label class="flex items-center space-x-2">
                                        <input type="radio" wire:model="preferred_contact" value="WhatsApp"
                                            class="h-4 w-4 text-yellow-600 focus:ring-yellow-600 border-gray-300">
                                        <span class="text-sm">WhatsApp</span>
                                    </label>

                                    <label class="flex items-center space-x-2">
                                        <input type="radio" wire:model="preferred_contact" value="Email"
                                            class="h-4 w-4 text-yellow-600 focus:ring-yellow-600 border-gray-300">
                                        <span class="text-sm">Email</span>
                                    </label>
                                </div>
                                @error('preferred_contact')
                                    <p class="mt-1 text-sm/6 text-red-600">{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="col-span-full">
                                <button type="submit"
                                    class="mt-5 w-full rounded-md px-3 py-2 text-sm font-semibold shadow-xs  focus-visible:outline-2 focus-visible:outline-offset-2 "
                                    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">Send</button>
                            </div>
                        </div>
                    </form>
                </div>

                {{-- Direction Links --}}
                @if (in_array($user['user_type'], ['Basic', 'Gold', 'Platinum', 'Influencer', 'Sponsored']))
                    @if ($directions)
                        <p class="flex items-center justify-center text-center pt-10">
                            Driving Directions
                        </p>

                        <div class="pt-2 container mx-auto flex flex-wrap items-center justify-center">
                            @foreach ($directions as $direction)
                                @if ($direction['type'] == 'google_map')
                                    <a href="{{ $direction['link'] }}" target="_blank">
                                        <x-mdi-google-maps class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif($direction['type'] == 'apple_map')
                                    <a href="{{ $direction['link'] }}" target="_blank">
                                        <x-fab-apple class="size-7 mx-2 my-2" />
                                    </a>
                                @elseif($direction['type'] == 'waze')
                                    <a href="{{ $direction['link'] }}" target="_blank">
                                        <x-fab-waze class="size-7 mx-2 my-2" />
                                    </a>
                                @endif
                            @endforeach
                        </div>

                    @endif
                @endif

            </div>
        @else
            <div class="h-screen flex justify-center items-center">
                <div>
                    <p class="mx-auto text-yellow-500 text-center text-l p-10">
                        <x-ionicon-warning-sharp class=" size-32 sm:size-40" />
                    </p>
                    <p class="mx-auto font-bold text-center text-2xl">Product not found
                    </p>
                    {{-- <p class="flex items-center justify-center text-center text-l py-1">
                    Get your&nbsp;<a href="https://10kcards.com" target="_blank" class="text-yellow-600">10k
                        card</a>&nbsp;today!
                </p> --}}
                </div>
            </div>
    @endif
</div>
