@php
    if ($button_type === 'sms') {
        $link = 'sms:' . $link;
    } elseif ($button_type === 'phone') {
        $link = 'tel:' . $link;
    } elseif ($button_type === 'email') {
        $link = 'mailto:' . $link;
    }

@endphp

<a href="{{ $link }}" target="_blank" data-button-id="{{ $button_id }}" data-title="{{ $title }}"
    class="customButton cursor-pointer block p-3 @if ($button_style === 'squared') rounded-md @else rounded-full @endif w-10/12 text-black text-center mx-auto my-5 text-l font-bold"
    style="color: {{ $color_settings_custom_button_text }} !important; background-color: {{ $color_settings_custom_button }} !important;">

    @if ($button_type == 'telegram')
        <x-fileicon-telegram class="size-4 inline" />
    @elseif ($button_type == 'podcast')
        <x-heroicon-s-microphone class="size-4 inline" />
    @elseif ($button_type == 'chime')
        <chime-icon class="size-4"></chime-icon>
    @elseif ($button_type == 'square')
        <x-si-square class="size-4 inline" />
    @elseif ($button_type == 'sms')
        <x-fas-sms class="size-4 inline" />
    @elseif ($button_type == 'phone')
        <x-heroicon-s-phone class="size-4 inline" />
    @elseif ($button_type == 'email')
        <x-fas-envelope class="size-4 inline" />
    @elseif ($button_type == 'whatsapp')
        <x-ri-whatsapp-fill class="size-4 inline" />
    @elseif ($button_type == 'zoom')
        <x-bxl-zoom class="size-4 inline" />
    @elseif ($button_type == 'facebook')
        <x-fab-facebook class="size-4 inline" />
    @elseif ($button_type == 'snapchat')
        <x-fab-snapchat-ghost class="size-4 inline" />
    @elseif ($button_type == 'fanbase')
        <fanbase-icon class="size-4 inline" />
    @elseif ($button_type == 'clubhouse')
        <x-si-clubhouse class="size-4 inline" />
    @elseif ($button_type == 'threads')
        <x-fab-threads class="size-4 inline" />
    @elseif ($button_type == 'tiktok')
        <x-fab-tiktok class="size-4 inline" />
    @elseif ($button_type == 'linkedin')
        <x-fab-linkedin class="size-4 inline" />
    @elseif ($button_type == 'x')
        <x-ri-twitter-x-fill class="size-4 inline" />
    @elseif ($button_type == 'instagram')
        <x-fab-instagram class="size-4 inline" />
    @elseif ($button_type == 'youtube')
        <x-fab-youtube class="size-4 inline" />
    @elseif ($button_type == 'credit')
        <x-heroicon-s-credit-card class="size-4 inline" />
    @elseif ($button_type == 'venmo')
        <x-bxl-venmo class="size-4 inline" />
    @elseif ($button_type == 'cashapp')
        <x-si-cashapp class="size-4 inline" />
    @elseif ($button_type == 'paypal_link')
        <x-fab-paypal class="size-4 inline" />
    @elseif ($button_type == 'vcf')
        <x-heroicon-s-arrow-down-tray class="size-4 inline" />
    @elseif ($button_type == 'help')
        <x-fas-handshake class="size-4 inline" />
    @elseif ($button_type == 'exchange')
        <x-fas-handshake class="size-4 inline" />
    @elseif ($button_type == 'feedback')
        <x-ri-feedback-fill class="size-4 inline" />
    @elseif ($button_type == 'bio')
        <x-heroicon-s-user class="size-4 inline" />
    @elseif ($button_type == 'shop')
        <x-heroicon-s-shopping-bag class="size-4 inline" />
    @elseif ($button_type == 'services')
        <x-heroicon-s-briefcase class="size-4 inline" />
    @elseif ($button_type == 'community')
        <x-fas-users class="size-4 inline" />
    @elseif ($button_type == 'form')
        <x-heroicon-s-pencil-square class="size-4 inline" />
    @elseif ($button_type == 'amazon_shop')
        <x-fab-amazon class="size-4 inline" />
    @endif

    &nbsp;&nbsp; {{ $title }}
</a>

@push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            function getDeviceType() {
                const ua = navigator.userAgent;
                if (/mobile/i.test(ua)) return "Mobile";
                if (/tablet/i.test(ua)) return "Tablet";
                if (/iPad|Android(?!.*Mobile)/i.test(ua)) return "Tablet";
                return "Desktop";
            }

            const deviceType = getDeviceType();

            fetch('https://get.geojs.io/v1/ip/geo.json')
                .then(res => res.json())
                .then(data => {
                    const location = {
                        city: data.city,
                        region: data.region,
                        country: data.country,
                        ip: data.ip
                    };

                    const buttons = document.getElementsByClassName('customButton');
                    Array.from(buttons).forEach(button => {
                        button.addEventListener('click', function(e) {
                            const buttonId = this.getAttribute('data-button-id');
                            const title = this.getAttribute('data-title');

                            @this.buttonClicked(buttonId, deviceType, location);
                        });
                    });
                })
                .catch(() => {
                    const buttons = document.getElementsByClassName('customButton');
                    Array.from(buttons).forEach(button => {
                        button.addEventListener('click', function(e) {
                            const buttonId = this.getAttribute('data-button-id');
                            const title = this.getAttribute('data-title');

                            @this.buttonClicked(buttonId, deviceType, null);
                        });
                    });
                });
        });
    </script>
@endpush
