<div class="mb-20">

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">
        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a href="{{ route('dashboard.search', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-magnifying-glass class="size-4" />
                </a>
            </div>
            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                    stroke="currentColor" class="size-6 inline-block">
                    <path stroke-linecap=" round" stroke-linejoin="round"
                        d="M3 13.125C3 12.504 3.504 12 4.125 12h2.25c.621 0 1.125.504 1.125 1.125v6.75C7.5 20.496 6.996 21 6.375 21h-2.25A1.125 1.125 0 0 1 3 19.875v-6.75ZM9.75 8.625c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125v11.25c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 0 1-1.125-1.125V8.625ZM16.5 4.125c0-.621.504-1.125 1.125-1.125h2.25C20.496 3 21 3.504 21 4.125v15.75c0 .621-.504 1.125-1.125 1.125h-2.25a1.125 1.125 0 0 1-1.125-1.125V4.125Z" />
                </svg>

                &nbsp;&nbsp;Analytics
            </p>

            <div class="flex items-center col-span-1 place-content-end">
                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a> --}}

                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-xs font-semibold shadow-xs flex bg-white text-black items-center">
                    View&nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" />
                </a> --}}

                <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>
        </div>
    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-4">

        <h1
            class="flex items-center justify-center text-2xl font-medium text-center text-slate-800 dark:text-slate-300">
            Overview
        </h1>
        <p class="text-slate-600 dark:text-slate-500 text-sm py-5 px-5 text-center">The data below highlights the total
            number of
            clicks your social profiles and shared links have received, giving you a clear view of how your audience is
            interacting with your content.</p>
        <br>
        <div class="mx-5">
            <canvas id="myChart"></canvas>
        </div>
    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-4">
        <h1
            class="flex items-center justify-center text-2xl font-medium text-center text-slate-800 dark:text-slate-300">
            Card Visits
        </h1>
        <p class="text-slate-600 dark:text-slate-500 text-sm py-5 px-5 text-center">For the last 7 days</p>
        <br>
        <div class="mx-5">
            <canvas id="cardViewsChart"></canvas>
        </div>
    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-4">
        <h1
            class="flex items-center justify-center text-2xl font-medium text-center text-slate-800 dark:text-slate-300">
            Links Clicks
        </h1>
        <p class="text-slate-600 dark:text-slate-500 text-sm py-5 px-5 text-center">For the last 7 days</p>
        <br>
        <div class="mx-5">
            <canvas id="linksClicksChart"></canvas>
        </div>
    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-4">
        <h1
            class="flex items-center justify-center text-2xl font-medium text-center text-slate-800 dark:text-slate-300">
            Social Media Clicks
        </h1>
        <p class="text-slate-600 dark:text-slate-500 text-sm py-5 px-5 text-center">For the last 7 days</p>
        <br>
        <div class="mx-5">
            <canvas id="socialsClicksChart"></canvas>
        </div>
    </div>

    <div
        class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto py-5 bg-white dark:bg-zinc-900 flex flex-col content-center rounded-2xl mb-4">
        <h1
            class="flex items-center justify-center text-2xl font-medium text-center text-slate-800 dark:text-slate-300">
            Ad Clicks
        </h1>
        <p class="text-slate-600 dark:text-slate-500 text-sm py-5 px-5 text-center">For the last 7 days</p>
        <br>
        <div class="mx-5">
            <canvas id="adsClicksChart"></canvas>
        </div>
    </div>


    @push('scripts')
        <script>
            document.addEventListener('livewire:navigated', () => {
                const component = Livewire.find(document.querySelector('[wire\\:id]')?.getAttribute('wire:id'));
                if (!component) return;

                const chartEl = document.getElementById('myChart');
                const cardViewsChartEl = document.getElementById('cardViewsChart');
                const linksClicksChartEl = document.getElementById('linksClicksChart');
                const socialsClicksChartEl = document.getElementById('socialsClicksChart');
                const adsClicksChartEl = document.getElementById('adsClicksChart');

                const button_analytics_by_month = component.button_analytics_by_month;
                const links_view_count_7_days = component.links_view_count_7_days;

                const card_view_analytics_by_month = component.card_view_analytics_by_month;
                const card_view_analytics_7_days = component.card_view_analytics_7_days;

                const socials_view_analytics_by_month = component.socials_view_analytics_by_month;
                const socials_view_analytics_7_days = component.socials_view_analytics_7_days;

                const ads_view_analytics_by_month = component.ads_view_analytics_by_month;
                const ads_view_analytics_7_days = component.ads_view_analytics_7_days;

                const months = component.months;
                const days = component.days;

                let myChart;
                let cardViewsChart;
                let linksClicksChart;
                let socialsClicksChart;
                let adsClicksChart;

                if (!chartEl) return;
                if (!cardViewsChartEl) return;
                if (!linksClicksChartEl) return;
                if (!socialsClicksChartEl) return;
                if (!adsClicksChartEl) return;

                const ctx = chartEl.getContext('2d');
                const ctx_2 = cardViewsChartEl.getContext('2d');
                const ctx_3 = linksClicksChartEl.getContext('2d');
                const ctx_4 = socialsClicksChartEl.getContext('2d');
                const ctx_5 = adsClicksChartEl.getContext('2d');

                if (window.myChart instanceof Chart) {
                    window.myChart.destroy();
                }

                if (window.cardViewsChart instanceof Chart) {
                    window.cardViewsChart.destroy();
                }

                if (window.linksClicksChart instanceof Chart) {
                    window.linksClicksChart.destroy();
                }

                if (window.socialsClicksChart instanceof Chart) {
                    window.socialsClicksChart.destroy();
                }

                if (window.adsClicksChart instanceof Chart) {
                    window.adsClicksChart.destroy();
                }

                window.myChart = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: months,
                        datasets: [{
                                label: 'Card Visits',
                                data: card_view_analytics_by_month,
                                borderWidth: 1
                            },
                            {
                                label: 'Links',
                                data: button_analytics_by_month,
                                borderWidth: 1
                            },
                            {
                                label: 'SocMed',
                                data: socials_view_analytics_by_month,
                                borderWidth: 1
                            },

                        ]
                    },
                    options: {
                        scales: {
                            y: {
                                beginAtZero: true,
                                // ticks: {
                                //     stepSize: 1
                                // }
                            }
                        }
                    }
                });

                // Card Views for the last 7 days (Monday to Sunday)
                window.cardViewsChart = new Chart(ctx_2, {
                    type: 'line',
                    data: {
                        labels: days,
                        datasets: [{
                            // label: 'Card Visits',
                            data: card_view_analytics_7_days,
                            borderWidth: 1
                        }, ]
                    },
                    options: {
                        plugins: {
                            legend: {
                                display: false // ⬅️ This removes the label/legend
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                // ticks: {
                                //     stepSize: 1
                                // }
                            }
                        }
                    }
                });

                // Card Views for the last 7 days (Monday to Sunday)
                window.linksClicksChart = new Chart(ctx_3, {
                    type: 'line',
                    data: {
                        labels: days,
                        datasets: [{
                            // label: 'Card Visits',
                            data: links_view_count_7_days,
                            borderWidth: 1
                        }, ]
                    },
                    options: {
                        plugins: {
                            legend: {
                                display: false // ⬅️ This removes the label/legend
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                // ticks: {
                                //     stepSize: 1
                                // }
                            }
                        }
                    }
                });

                // Socials for the last 7 days (Monday to Sunday)
                window.socialsClicksChart = new Chart(ctx_4, {
                    type: 'line',
                    data: {
                        labels: days,
                        datasets: [{
                            // label: 'Card Visits',
                            data: socials_view_analytics_7_days,
                            borderWidth: 1
                        }, ]
                    },
                    options: {
                        plugins: {
                            legend: {
                                display: false // ⬅️ This removes the label/legend
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                // ticks: {
                                //     stepSize: 1
                                // }
                            }
                        }
                    }
                });

                // Ads for the last 7 days (Monday to Sunday)
                window.adsClicksChart = new Chart(ctx_5, {
                    type: 'line',
                    data: {
                        labels: days,
                        datasets: [{
                            // label: 'Card Visits',
                            data: ads_view_analytics_7_days,
                            borderWidth: 1
                        }, ]
                    },
                    options: {
                        plugins: {
                            legend: {
                                display: false // ⬅️ This removes the label/legend
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                // ticks: {
                                //     stepSize: 1
                                // }
                            }
                        }
                    }
                });
            });
        </script>
    @endpush
</div>
