<div class="mb-20">

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">
        <div class="grid grid-cols-5 gap-4">
            {{-- Back Button to Profile Page --}}
            <div class="flex items-center col-span-1">
                <a href="{{ route('dashboard.search', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-magnifying-glass class="size-4" />
                </a>
            </div>
            <p
                class="flex items-center justify-center text-slate-800 dark:text-slate-300 text-center text-l py-1 my-5 font-bold col-span-3">

                <x-heroicon-o-plus class="size-6 inline-block" />

                &nbsp;&nbsp;Contents
            </p>

            <div class="flex items-center col-span-1 place-content-end">
                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="rounded-full bg-white dark:g-slate-100 p-2 hover:shadow-lg">
                    <x-heroicon-o-arrow-top-right-on-square class="size-4" />
                </a> --}}

                {{-- <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-xs font-semibold shadow-xs flex bg-white text-black items-center">
                    View&nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" />
                </a> --}}

                <a href="{{ route('card.show', $user['username']) }}"
                    class="w-fit rounded-md px-2 py-1.5 text-[9px] font-semibold shadow-xs flex bg-white text-black items-center">
                    View Card
                    {{-- &nbsp;<x-heroicon-o-arrow-top-right-on-square class="size-3" /> --}}
                </a>
            </div>
        </div>
    </div>

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5">
        <div class="grid grid-cols-4">

            <div class="flex items-center col-span-1">
                <div class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                    <span class="text-zinc-900">
                        <x-heroicon-s-link class="size-6" />
                    </span>
                </div>
            </div>

            <div class="h-fit col-span-3">
                <h1 class="text-xl text-slate-800 dark:text-slate-300">Links/Buttons
                </h1>
                <p class="text-slate-600 dark:text-slate-500 text-sm">Add links to your card! Portfolio, shop, or
                    social accounts—sky’s the limit!</p>
            </div>
        </div>
    </div>

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto">
        <div class="grid grid-cols-2 gap-4 height-auto">
            <div class="flex flex-col">
                <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                    <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                        Custom Links
                    </p>
                    <div class="grid grid-cols-3">
                        <div class="col-span-1">
                            <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">{{ $button_count }}
                            </h1>
                        </div>
                        <div class="col-span-2 grid justify-end">
                            <a wire:navigate href="{{ route('dashboard.button') }}"
                                class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                @if ($button_count)
                                    Manage
                                    &nbsp;
                                    <x-gmdi-manage-accounts-r class="size-3 inline" />
                                @else
                                    Add &nbsp;
                                    <x-heroicon-o-plus class="size-3 inline" />
                                @endif
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex flex-col">
                <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                    <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                        Socials
                    </p>

                    <div class="grid grid-cols-3">
                        <div class="col-span-1">
                            <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">{{ $social_count }}
                            </h1>
                        </div>
                        <div class="col-span-2 grid justify-end">
                            <a wire:navigate href="{{ route('dashboard.social') }}"
                                class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                @if ($social_count)
                                    Manage
                                    &nbsp;
                                    <x-gmdi-manage-accounts-r class="size-3 inline" />
                                @else
                                    Add &nbsp;
                                    <x-heroicon-o-plus class="size-3 inline" />
                                @endif
                            </a>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pt-4">
        <div class="grid grid-cols-2 gap-4 height-auto">
            <div class="flex flex-col">
                <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                    <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                        Contact Points
                    </p>
                    <div class="grid grid-cols-3">
                        <div class="col-span-1">
                            <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">{{ $contact_count }}
                            </h1>
                        </div>
                        <div class="col-span-2 grid justify-end">
                            <a wire:navigate href="{{ route('contacts.index') }}"
                                class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                @if ($contact_count)
                                    Manage
                                    &nbsp;
                                    <x-gmdi-manage-accounts-r class="size-3 inline" />
                                @else
                                    Add &nbsp;
                                    <x-heroicon-o-plus class="size-3 inline" />
                                @endif
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            @if ($user->user_type != 'Free')
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Payment Links
                        </p>

                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">{{ $payment_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('payments.index') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($payment_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>

                    </div>
                </div>
            @endif
        </div>
    </div>


    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto pt-4">
        <div class="grid grid-cols-2 gap-4 height-auto">
            <div class="flex flex-col">
                <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                    <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                        Direction Links
                    </p>
                    <div class="grid grid-cols-3">
                        <div class="col-span-1">
                            <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                {{ $direction_count }}
                            </h1>
                        </div>
                        <div class="col-span-2 grid justify-end">
                            <a wire:navigate href="{{ route('directions.index') }}"
                                class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                @if ($direction_count)
                                    Manage
                                    &nbsp;
                                    <x-gmdi-manage-accounts-r class="size-3 inline" />
                                @else
                                    Add &nbsp;
                                    <x-heroicon-o-plus class="size-3 inline" />
                                @endif
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            @if (in_array($user->user_type, ['Basic', 'Sponsored', 'Influencer', 'Gold', 'Platinum']))
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Communities
                        </p>

                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $communities_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('communities.index') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($communities_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>

                    </div>
                </div>
            @endif

            {{-- Zoom Replays --}}
            @if ($replays_functionality && in_array($user->user_type, ['Gold', 'Platinum']))
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Zoom Replays
                        </p>

                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $replays_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('zoomreplay.index') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($replays_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>

                    </div>
                </div>
            @endif

            {{-- Form --}}
            @if (in_array($user->user_type, ['Gold', 'Platinum']))
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Lead Capture Form
                        </p>

                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $forms_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.form') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($forms_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>

                    </div>
                </div>
            @endif

        </div>
    </div>

    {{-- Presentation Page --}}
    @if (in_array($user->user_type, ['Gold', 'Platinum']))
        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5 pt-12">
            <div class="grid grid-cols-4">

                <div class="flex items-center col-span-1">
                    <div class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <x-heroicon-o-document class="size-6" />
                        </span>
                    </div>
                </div>

                <div class="h-fit col-span-3">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Presentation Page
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">Add a new page on your
                        card!
                    </p>
                </div>
            </div>
        </div>

        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5">
            <div class="grid grid-cols-2 gap-4 height-auto">
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Pages
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $pages_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.pages') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($pages_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    @if (in_array($user->user_type, ['Gold', 'Platinum', 'Sponsored', 'Influencer', 'Basic']))
        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5 pt-12">
            <div class="grid grid-cols-4">

                <div class="flex items-center col-span-1">
                    <div class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <x-heroicon-o-photo class="size-6" />
                        </span>
                    </div>
                </div>

                <div class="h-fit col-span-3">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Media
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">Add a photo or video slide on your
                        card!
                    </p>
                </div>
            </div>
        </div>
    @endif

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5">
        <div class="grid grid-cols-2 gap-4 height-auto">
            @if (in_array($user->user_type, ['Gold', 'Sponsored', 'Platinum']))
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Images
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $images_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.images') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($images_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            @endif

            @if (in_array($user->user_type, ['Gold', 'Sponsored', 'Influencer', 'Platinum', 'Basic']))
                {{-- @if ($user['user_type'] == 'Platinum') --}}
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Videos
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">{{ $video_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.video') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($video_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

            @endif

            @if (in_array($user->user_type, ['Gold', 'Platinum']))
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Testimonial Video
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $reviews_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.testimonial') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($reviews_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            @endif
        </div>
    </div>

    @if (in_array($user->user_type, ['Gold', 'Platinum']))
        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5 pt-12">
            <div class="grid grid-cols-4">

                <div class="flex items-center col-span-1">
                    <div class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <x-heroicon-o-currency-dollar class="size-6" />
                        </span>
                    </div>
                </div>

                <div class="h-fit col-span-3">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Product/Service
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">Earn by selling products or services on your
                        card!
                    </p>
                </div>
            </div>
        </div>
    @endif

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5">
        <div class="grid grid-cols-2 gap-4 height-auto">
            @if (in_array($user['user_type'], ['Gold', 'Platinum']))
                {{-- Products --}}
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Products
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $product_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.product') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($product_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>

                </div>

                {{-- Collections --}}
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Collections
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $product_collections_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.productcollection') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($product_collections_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>

                </div>

                {{-- Categories --}}
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Categories
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $product_categories_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.productcategory') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($product_categories_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>

                </div>

                {{-- Daily Deals --}}
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Daily Deals
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $subscription_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.subscriptions') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($subscription_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>

                </div>

                {{-- Subscriptions --}}
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Subscriptions
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $subscription_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.subscriptions') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($subscription_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>

                </div>

                {{-- Services --}}
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Services
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $services_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.service') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($services_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>

                </div>

            @endif
        </div>
    </div>

    {{-- Events --}}
    @if (in_array($user->user_type, ['Basic', 'Gold', 'Platinum']))
        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5 pt-12">
            <div class="grid grid-cols-4">

                <div class="flex items-center col-span-1">
                    <div class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <x-heroicon-o-calendar-days class="size-6" />
                        </span>
                    </div>
                </div>

                <div class="h-fit col-span-3">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Events
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">Post events and reach your audience.
                    </p>
                </div>
            </div>
        </div>

        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5">
            <div class="grid grid-cols-2 gap-4 height-auto">
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Events
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $events_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.event') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($events_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

    @endif

    {{-- Sales Page --}}
    {{-- @if (in_array($user->user_type, ['Gold', 'Platinum']))
        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5 pt-12">
            <div class="grid grid-cols-4">

                <div class="flex items-center col-span-1">
                    <div class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <x-heroicon-o-shopping-bag class="size-6" />
                        </span>
                    </div>
                </div>

                <div class="h-fit col-span-3">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Add Sale Page(s)
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">Post images and videos with payment links.
                    </p>
                </div>
            </div>
        </div>

        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5">
            <div class="grid grid-cols-2 gap-4 height-auto">
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Sales Page
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $sales_page_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.sales') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($sales_page_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

    @endif --}}

    {{-- Team Page --}}
    @if (in_array($user->user_type, ['Gold', 'Platinum']))
        <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5 pt-12">
            <div class="grid grid-cols-4">

                <div class="flex items-center col-span-1">
                    <div class="rounded-full bg-white dark:g-slate-100 p-3.5 hover:shadow-lg">
                        <span class="text-zinc-900">
                            <x-heroicon-o-users class="size-6" />
                        </span>
                    </div>
                </div>

                <div class="h-fit col-span-3">
                    <h1 class="text-xl text-slate-800 dark:text-slate-300">Teams
                    </h1>
                    <p class="text-slate-600 dark:text-slate-500 text-sm">Manage all your teams here.
                    </p>
                </div>
            </div>
        </div>
    @endif

    <div class="sm:w-7/12 md:w-6/12 lg:w-4/12 w-11/12 mx-auto mb-5">
        <div class="grid grid-cols-2 gap-4 height-auto">
            @if (in_array($user->user_type, ['Gold', 'Platinum']))
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Teams
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $team_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.team') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($team_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            @endif

            @if ($user->user_type == 'Platinum')
                <div class="flex flex-col">
                    <div class="h-full bg-white dark:bg-zinc-900 flex flex-col rounded-2xl p-5">
                        <p class="flex items-center text-slate-600 mb-3 dark:text-slate-500 font-bold text-sm">
                            Trusted Network
                        </p>
                        <div class="grid grid-cols-3">
                            <div class="col-span-1">
                                <h1 class="text-xl text-slate-800 dark:text-slate-300 font-medium">
                                    {{ $trusted_network_count }}
                                </h1>
                            </div>
                            <div class="col-span-2 grid justify-end">
                                <a wire:navigate href="{{ route('dashboard.trustednetwork') }}"
                                    class="text-blue-600 hover:text-blue-500 text-xs flex items-center py-0.5">
                                    @if ($trusted_network_count)
                                        Manage
                                        &nbsp;
                                        <x-gmdi-manage-accounts-r class="size-3 inline" />
                                    @else
                                        Add &nbsp;
                                        <x-heroicon-o-plus class="size-3 inline" />
                                    @endif
                                </a>
                            </div>
                        </div>
                    </div>

                </div>
            @endif
        </div>
    </div>
</div>
